package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TipOrigenProdService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipOrigenProd;

/**
 *  * TipOrigenProdController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/tiporigenprod")

public class TipOrigenProdController  {

	private static final Logger logger = LoggerFactory.getLogger(TipOrigenProdController.class);

	@Autowired
	private TipOrigenProdService tipOrigenProdService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tiporigenprod", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  topcodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{topcodigo}", method = RequestMethod.GET)
	public @ResponseBody TipOrigenProd getById(@PathVariable String topcodigo) {
		try{
            TipOrigenProd tipOrigenProd = new TipOrigenProd();
			tipOrigenProd.setTopcodigo(topcodigo);
            tipOrigenProd = this.tipOrigenProdService.find(tipOrigenProd);
            if (tipOrigenProd == null) {
                throw new Exception(topcodigo.toString());
            }
            return tipOrigenProd;
		}catch (Exception e){
		    throw new ResourceNotFoundException(topcodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  topcodigo String
	 *@param	  topnombre String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "topcodigo", required = false) String topcodigo,
	@RequestParam(value = "topnombre", required = false) String topnombre,
			HttpServletRequest request) {
			try{
				TipOrigenProd filterTipOrigenProd = new TipOrigenProd(topcodigo, topnombre);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<TipOrigenProd> tipOrigenProds =  this.tipOrigenProdService.findAll(filterTipOrigenProd, pagination);

     			    if (tipOrigenProds == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterTipOrigenProd, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(tipOrigenProds);
				    return data;
				}else{
				    List<TipOrigenProd> tipOrigenProds =  this.tipOrigenProdService.findAll(filterTipOrigenProd, pagination);
					if (tipOrigenProds == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return tipOrigenProds;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterTipOrigenProd TipOrigenProd 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "tipOrigenProd", required = false) TipOrigenProd  filterTipOrigenProd, HttpServletRequest request) {
	    try {
			return tipOrigenProdService
					.findAllCount(filterTipOrigenProd != null ? filterTipOrigenProd
							: new TipOrigenProd ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param tipOrigenProd TipOrigenProd 
	 * @param response HttpServletResponse
	 * @return TipOrigenProd
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TipOrigenProd edit(@RequestBody TipOrigenProd tipOrigenProd, HttpServletResponse response) {		
		try {
            TipOrigenProd tipOrigenProdAux  = this.tipOrigenProdService.update(tipOrigenProd);
			logger.info("Entity correctly inserted!");
            return tipOrigenProdAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param tipOrigenProd TipOrigenProd 
	 * @return TipOrigenProd
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipOrigenProd add(@RequestBody TipOrigenProd tipOrigenProd) {		
        try {
            TipOrigenProd tipOrigenProdAux = this.tipOrigenProdService.add(tipOrigenProd);
            logger.info("Entity correctly inserted!");
        	return tipOrigenProdAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  topcodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{topcodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String topcodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            TipOrigenProd tipOrigenProd = new TipOrigenProd();
            tipOrigenProd.setTopcodigo(topcodigo);
            this.tipOrigenProdService.remove(tipOrigenProd);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  topcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  tipOrigenProdIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> tipOrigenProdIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<TipOrigenProd> tipOrigenProdList = new ArrayList<TipOrigenProd>();
        try{		    
            for (ArrayList<String> tipOrigenProdId:tipOrigenProdIds) {
			    Iterator<String> iterator = tipOrigenProdId.iterator();
				    TipOrigenProd tipOrigenProd = new TipOrigenProd();
			        tipOrigenProd.setTopcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    tipOrigenProdList.add(tipOrigenProd);
		    }
            this.tipOrigenProdService.removeMultiple(tipOrigenProdList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipOrigenProdService'.
	 *
	 * @return TipOrigenProdService
	 */
	protected TipOrigenProdService getTipOrigenProdService() {
		return this.tipOrigenProdService;
	}

	/**
	 * Method 'setTipOrigenProdService'.
	 *
	 * @param tipOrigenProdService  TipOrigenProdService
	 * @return
	 */
	public void setTipOrigenProdService(TipOrigenProdService tipOrigenProdService) {
		this.tipOrigenProdService = tipOrigenProdService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
