package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TipDepoMuestraService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipDepoMuestra;

/**
 *  * TipDepoMuestraController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/tipdepomuestra")

public class TipDepoMuestraController  {

	private static final Logger logger = LoggerFactory.getLogger(TipDepoMuestraController.class);

	@Autowired
	private TipDepoMuestraService tipDepoMuestraService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tipdepomuestra", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  tdmcodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{tdmcodigo}", method = RequestMethod.GET)
	public @ResponseBody TipDepoMuestra getById(@PathVariable String tdmcodigo) {
		try{
            TipDepoMuestra tipDepoMuestra = new TipDepoMuestra();
			tipDepoMuestra.setTdmcodigo(tdmcodigo);
            tipDepoMuestra = this.tipDepoMuestraService.find(tipDepoMuestra);
            if (tipDepoMuestra == null) {
                throw new Exception(tdmcodigo.toString());
            }
            return tipDepoMuestra;
		}catch (Exception e){
		    throw new ResourceNotFoundException(tdmcodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  tdmcodigo String
	 *@param	  tdmnombre String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "tdmcodigo", required = false) String tdmcodigo,
	@RequestParam(value = "tdmnombre", required = false) String tdmnombre,
			HttpServletRequest request) {
			try{
				TipDepoMuestra filterTipDepoMuestra = new TipDepoMuestra(tdmcodigo, tdmnombre);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<TipDepoMuestra> tipDepoMuestras =  this.tipDepoMuestraService.findAll(filterTipDepoMuestra, pagination);

     			    if (tipDepoMuestras == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterTipDepoMuestra, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(tipDepoMuestras);
				    return data;
				}else{
				    List<TipDepoMuestra> tipDepoMuestras =  this.tipDepoMuestraService.findAll(filterTipDepoMuestra, pagination);
					if (tipDepoMuestras == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return tipDepoMuestras;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterTipDepoMuestra TipDepoMuestra 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "tipDepoMuestra", required = false) TipDepoMuestra  filterTipDepoMuestra, HttpServletRequest request) {
	    try {
			return tipDepoMuestraService
					.findAllCount(filterTipDepoMuestra != null ? filterTipDepoMuestra
							: new TipDepoMuestra ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param tipDepoMuestra TipDepoMuestra 
	 * @param response HttpServletResponse
	 * @return TipDepoMuestra
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TipDepoMuestra edit(@RequestBody TipDepoMuestra tipDepoMuestra, HttpServletResponse response) {		
		try {
            TipDepoMuestra tipDepoMuestraAux  = this.tipDepoMuestraService.update(tipDepoMuestra);
			logger.info("Entity correctly inserted!");
            return tipDepoMuestraAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param tipDepoMuestra TipDepoMuestra 
	 * @return TipDepoMuestra
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipDepoMuestra add(@RequestBody TipDepoMuestra tipDepoMuestra) {		
        try {
            TipDepoMuestra tipDepoMuestraAux = this.tipDepoMuestraService.add(tipDepoMuestra);
            logger.info("Entity correctly inserted!");
        	return tipDepoMuestraAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  tdmcodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{tdmcodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String tdmcodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            TipDepoMuestra tipDepoMuestra = new TipDepoMuestra();
            tipDepoMuestra.setTdmcodigo(tdmcodigo);
            this.tipDepoMuestraService.remove(tipDepoMuestra);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  tdmcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  tipDepoMuestraIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> tipDepoMuestraIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<TipDepoMuestra> tipDepoMuestraList = new ArrayList<TipDepoMuestra>();
        try{		    
            for (ArrayList<String> tipDepoMuestraId:tipDepoMuestraIds) {
			    Iterator<String> iterator = tipDepoMuestraId.iterator();
				    TipDepoMuestra tipDepoMuestra = new TipDepoMuestra();
			        tipDepoMuestra.setTdmcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    tipDepoMuestraList.add(tipDepoMuestra);
		    }
            this.tipDepoMuestraService.removeMultiple(tipDepoMuestraList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipDepoMuestraService'.
	 *
	 * @return TipDepoMuestraService
	 */
	protected TipDepoMuestraService getTipDepoMuestraService() {
		return this.tipDepoMuestraService;
	}

	/**
	 * Method 'setTipDepoMuestraService'.
	 *
	 * @param tipDepoMuestraService  TipDepoMuestraService
	 * @return
	 */
	public void setTipDepoMuestraService(TipDepoMuestraService tipDepoMuestraService) {
		this.tipDepoMuestraService = tipDepoMuestraService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
