package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TipCaracMuestraService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipCaracMuestra;

/**
 *  * TipCaracMuestraController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/tipcaracmuestra")

public class TipCaracMuestraController  {

	private static final Logger logger = LoggerFactory.getLogger(TipCaracMuestraController.class);

	@Autowired
	private TipCaracMuestraService tipCaracMuestraService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tipcaracmuestra", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  tctcodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{tctcodigo}", method = RequestMethod.GET)
	public @ResponseBody TipCaracMuestra getById(@PathVariable String tctcodigo) {
		try{
            TipCaracMuestra tipCaracMuestra = new TipCaracMuestra();
			tipCaracMuestra.setTctcodigo(tctcodigo);
            tipCaracMuestra = this.tipCaracMuestraService.find(tipCaracMuestra);
            if (tipCaracMuestra == null) {
                throw new Exception(tctcodigo.toString());
            }
            return tipCaracMuestra;
		}catch (Exception e){
		    throw new ResourceNotFoundException(tctcodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  tctcodigo String
	 *@param	  tctnombre String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "tctcodigo", required = false) String tctcodigo,
	@RequestParam(value = "tctnombre", required = false) String tctnombre,
			HttpServletRequest request) {
			try{
				TipCaracMuestra filterTipCaracMuestra = new TipCaracMuestra(tctcodigo, tctnombre);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<TipCaracMuestra> tipCaracMuestras =  this.tipCaracMuestraService.findAll(filterTipCaracMuestra, pagination);

     			    if (tipCaracMuestras == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterTipCaracMuestra, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(tipCaracMuestras);
				    return data;
				}else{
				    List<TipCaracMuestra> tipCaracMuestras =  this.tipCaracMuestraService.findAll(filterTipCaracMuestra, pagination);
					if (tipCaracMuestras == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return tipCaracMuestras;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterTipCaracMuestra TipCaracMuestra 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "tipCaracMuestra", required = false) TipCaracMuestra  filterTipCaracMuestra, HttpServletRequest request) {
	    try {
			return tipCaracMuestraService
					.findAllCount(filterTipCaracMuestra != null ? filterTipCaracMuestra
							: new TipCaracMuestra ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param tipCaracMuestra TipCaracMuestra 
	 * @param response HttpServletResponse
	 * @return TipCaracMuestra
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TipCaracMuestra edit(@RequestBody TipCaracMuestra tipCaracMuestra, HttpServletResponse response) {		
		try {
            TipCaracMuestra tipCaracMuestraAux  = this.tipCaracMuestraService.update(tipCaracMuestra);
			logger.info("Entity correctly inserted!");
            return tipCaracMuestraAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param tipCaracMuestra TipCaracMuestra 
	 * @return TipCaracMuestra
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipCaracMuestra add(@RequestBody TipCaracMuestra tipCaracMuestra) {		
        try {
            TipCaracMuestra tipCaracMuestraAux = this.tipCaracMuestraService.add(tipCaracMuestra);
            logger.info("Entity correctly inserted!");
        	return tipCaracMuestraAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  tctcodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{tctcodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String tctcodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            TipCaracMuestra tipCaracMuestra = new TipCaracMuestra();
            tipCaracMuestra.setTctcodigo(tctcodigo);
            this.tipCaracMuestraService.remove(tipCaracMuestra);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  tctcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  tipCaracMuestraIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> tipCaracMuestraIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<TipCaracMuestra> tipCaracMuestraList = new ArrayList<TipCaracMuestra>();
        try{		    
            for (ArrayList<String> tipCaracMuestraId:tipCaracMuestraIds) {
			    Iterator<String> iterator = tipCaracMuestraId.iterator();
				    TipCaracMuestra tipCaracMuestra = new TipCaracMuestra();
			        tipCaracMuestra.setTctcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    tipCaracMuestraList.add(tipCaracMuestra);
		    }
            this.tipCaracMuestraService.removeMultiple(tipCaracMuestraList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipCaracMuestraService'.
	 *
	 * @return TipCaracMuestraService
	 */
	protected TipCaracMuestraService getTipCaracMuestraService() {
		return this.tipCaracMuestraService;
	}

	/**
	 * Method 'setTipCaracMuestraService'.
	 *
	 * @param tipCaracMuestraService  TipCaracMuestraService
	 * @return
	 */
	public void setTipCaracMuestraService(TipCaracMuestraService tipCaracMuestraService) {
		this.tipCaracMuestraService = tipCaracMuestraService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
