package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TipAlertaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipAlerta;

/**
 *  * TipAlertaController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/tipalerta")

public class TipAlertaController  {

	private static final Logger logger = LoggerFactory.getLogger(TipAlertaController.class);

	@Autowired
	private TipAlertaService tipAlertaService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tipalerta", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  tcacodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{tcacodigo}", method = RequestMethod.GET)
	public @ResponseBody TipAlerta getById(@PathVariable String tcacodigo) {
		try{
            TipAlerta tipAlerta = new TipAlerta();
			tipAlerta.setTcacodigo(tcacodigo);
            tipAlerta = this.tipAlertaService.find(tipAlerta);
            if (tipAlerta == null) {
                throw new Exception(tcacodigo.toString());
            }
            return tipAlerta;
		}catch (Exception e){
		    throw new ResourceNotFoundException(tcacodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  tcacodigo String
	 *@param	  tcanombre String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "tcacodigo", required = false) String tcacodigo,
	@RequestParam(value = "tcanombre", required = false) String tcanombre,
			HttpServletRequest request) {
			try{
				TipAlerta filterTipAlerta = new TipAlerta(tcacodigo, tcanombre);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<TipAlerta> tipAlertas =  this.tipAlertaService.findAll(filterTipAlerta, pagination);

     			    if (tipAlertas == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterTipAlerta, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(tipAlertas);
				    return data;
				}else{
				    List<TipAlerta> tipAlertas =  this.tipAlertaService.findAll(filterTipAlerta, pagination);
					if (tipAlertas == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return tipAlertas;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterTipAlerta TipAlerta 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "tipAlerta", required = false) TipAlerta  filterTipAlerta, HttpServletRequest request) {
	    try {
			return tipAlertaService
					.findAllCount(filterTipAlerta != null ? filterTipAlerta
							: new TipAlerta ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param tipAlerta TipAlerta 
	 * @param response HttpServletResponse
	 * @return TipAlerta
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TipAlerta edit(@RequestBody TipAlerta tipAlerta, HttpServletResponse response) {		
		try {
            TipAlerta tipAlertaAux  = this.tipAlertaService.update(tipAlerta);
			logger.info("Entity correctly inserted!");
            return tipAlertaAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param tipAlerta TipAlerta 
	 * @return TipAlerta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipAlerta add(@RequestBody TipAlerta tipAlerta) {		
        try {
            TipAlerta tipAlertaAux = this.tipAlertaService.add(tipAlerta);
            logger.info("Entity correctly inserted!");
        	return tipAlertaAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  tcacodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{tcacodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String tcacodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            TipAlerta tipAlerta = new TipAlerta();
            tipAlerta.setTcacodigo(tcacodigo);
            this.tipAlertaService.remove(tipAlerta);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  tcacodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  tipAlertaIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> tipAlertaIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<TipAlerta> tipAlertaList = new ArrayList<TipAlerta>();
        try{		    
            for (ArrayList<String> tipAlertaId:tipAlertaIds) {
			    Iterator<String> iterator = tipAlertaId.iterator();
				    TipAlerta tipAlerta = new TipAlerta();
			        tipAlerta.setTcacodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    tipAlertaList.add(tipAlerta);
		    }
            this.tipAlertaService.removeMultiple(tipAlertaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipAlertaService'.
	 *
	 * @return TipAlertaService
	 */
	protected TipAlertaService getTipAlertaService() {
		return this.tipAlertaService;
	}

	/**
	 * Method 'setTipAlertaService'.
	 *
	 * @param tipAlertaService  TipAlertaService
	 * @return
	 */
	public void setTipAlertaService(TipAlertaService tipAlertaService) {
		this.tipAlertaService = tipAlertaService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
