package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.TipActuacionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.TipActuacion;

/**
 *  * TipActuacionController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/tipactuacion")

public class TipActuacionController  {

	private static final Logger logger = LoggerFactory.getLogger(TipActuacionController.class);

	@Autowired
	private TipActuacionService tipActuacionService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("tipactuacion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  ttacodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{ttacodigo}", method = RequestMethod.GET)
	public @ResponseBody TipActuacion getById(@PathVariable String ttacodigo) {
		try{
            TipActuacion tipActuacion = new TipActuacion();
			tipActuacion.setTtacodigo(ttacodigo);
            tipActuacion = this.tipActuacionService.find(tipActuacion);
            if (tipActuacion == null) {
                throw new Exception(ttacodigo.toString());
            }
            return tipActuacion;
		}catch (Exception e){
		    throw new ResourceNotFoundException(ttacodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  ttacodigo String
	 *@param	  ttanombre String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "ttacodigo", required = false) String ttacodigo,
	@RequestParam(value = "ttanombre", required = false) String ttanombre,
			HttpServletRequest request) {
			try{
				TipActuacion filterTipActuacion = new TipActuacion(ttacodigo, ttanombre);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<TipActuacion> tipActuacions =  this.tipActuacionService.findAll(filterTipActuacion, pagination);

     			    if (tipActuacions == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterTipActuacion, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(tipActuacions);
				    return data;
				}else{
				    List<TipActuacion> tipActuacions =  this.tipActuacionService.findAll(filterTipActuacion, pagination);
					if (tipActuacions == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return tipActuacions;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterTipActuacion TipActuacion 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "tipActuacion", required = false) TipActuacion  filterTipActuacion, HttpServletRequest request) {
	    try {
			return tipActuacionService
					.findAllCount(filterTipActuacion != null ? filterTipActuacion
							: new TipActuacion ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param tipActuacion TipActuacion 
	 * @param response HttpServletResponse
	 * @return TipActuacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody TipActuacion edit(@RequestBody TipActuacion tipActuacion, HttpServletResponse response) {		
		try {
            TipActuacion tipActuacionAux  = this.tipActuacionService.update(tipActuacion);
			logger.info("Entity correctly inserted!");
            return tipActuacionAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param tipActuacion TipActuacion 
	 * @return TipActuacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody TipActuacion add(@RequestBody TipActuacion tipActuacion) {		
        try {
            TipActuacion tipActuacionAux = this.tipActuacionService.add(tipActuacion);
            logger.info("Entity correctly inserted!");
        	return tipActuacionAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  ttacodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{ttacodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String ttacodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            TipActuacion tipActuacion = new TipActuacion();
            tipActuacion.setTtacodigo(ttacodigo);
            this.tipActuacionService.remove(tipActuacion);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  ttacodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  tipActuacionIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> tipActuacionIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<TipActuacion> tipActuacionList = new ArrayList<TipActuacion>();
        try{		    
            for (ArrayList<String> tipActuacionId:tipActuacionIds) {
			    Iterator<String> iterator = tipActuacionId.iterator();
				    TipActuacion tipActuacion = new TipActuacion();
			        tipActuacion.setTtacodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    tipActuacionList.add(tipActuacion);
		    }
            this.tipActuacionService.removeMultiple(tipActuacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getTipActuacionService'.
	 *
	 * @return TipActuacionService
	 */
	protected TipActuacionService getTipActuacionService() {
		return this.tipActuacionService;
	}

	/**
	 * Method 'setTipActuacionService'.
	 *
	 * @param tipActuacionService  TipActuacionService
	 * @return
	 */
	public void setTipActuacionService(TipActuacionService tipActuacionService) {
		this.tipActuacionService = tipActuacionService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
