package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.service.SolicitudArbitrajeService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.SolicitudArbitraje;

/**
 *  * SolicitudArbitrajeController generated by UDA, 22-feb-2012 17:30:45.
 *  
 */
 
@Controller
@RequestMapping (value = "/solicitudarbitraje")

public class SolicitudArbitrajeController  {

	private static final Logger logger = LoggerFactory.getLogger(SolicitudArbitrajeController.class);

	@Autowired
	private SolicitudArbitrajeService solicitudArbitrajeService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("solicitudarbitraje", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  sacodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{sacodigo}", method = RequestMethod.GET)
	public @ResponseBody SolicitudArbitraje getById(@PathVariable String sacodigo) {
		try{
            SolicitudArbitraje solicitudArbitraje = new SolicitudArbitraje();
			solicitudArbitraje.setSacodigo(sacodigo);
            solicitudArbitraje = this.solicitudArbitrajeService.find(solicitudArbitraje);
            if (solicitudArbitraje == null) {
                throw new Exception(sacodigo.toString());
            }
            return solicitudArbitraje;
		}catch (Exception e){
		    throw new ResourceNotFoundException(sacodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  sacodigo String
	 *@param	  hechoDenunciadoHdcodigo String
	 *@param	  solicitudArbitrajeSACOSAAC String
	 *@param	  sacoja String
	 *@param	  sanror Integer
	 *@param	  sanran Long
	 *@param	  safesoli Date
	 *@param	  sacot4 String
	 *@param	  sacoxj String
	 *@param	  sanodidc String
	 *@param	  sacolodc String
	 *@param	  sanolodc String
	 *@param	  sacopvdc String
	 *@param	  sacomudc String
	 *@param	  sanrcpdc String
	 *@param	  sainacuo String
	 *@param	  sacoorpr String
	 *@param	  sacosere String
	 *@param	  sacotti String
	 *@param	  saintiso String
	 *@param	  sacnrecl BigDecimal
	 *@param	  sateobrc String
	 *@param	  safeinad Date
	 *@param	  sacot5 String
	 *@param	  sateinad String
	 *@param	  safereit Date
	 *@param	  safetras Date
	 *@param	  sacoortr String
	 *@param	  saferett Date
	 *@param	  saferets Date
	 *@param	  safemedi Date
	 *@param	  sainreme String
	 *@param	  saferemt Date
	 *@param	  safedesi Date
	 *@param	  saferedt Date
	 *@param	  safenoco Date
	 *@param	  saferear Date
	 *@param	  safedeco Date
	 *@param	  sacoarpt String
	 *@param	  sainmencpt String
	 *@param	  sainrencpt String
	 *@param	  sacoarps String
	 *@param	  sainmencps String
	 *@param	  sainrencps String
	 *@param	  sacoartt String
	 *@param	  sainmenctt String
	 *@param	  sainrenctt String
	 *@param	  sacoarts String
	 *@param	  sainmencts String
	 *@param	  sainrencts String
	 *@param	  sacoccco String
	 *@param	  sacoardt String
	 *@param	  sainmencdt String
	 *@param	  sainrencdt String
	 *@param	  sacoards String
	 *@param	  sainmencds String
	 *@param	  sainrencds String
	 *@param	  sacooeco String
	 *@param	  sacoset String
	 *@param	  sainmencst String
	 *@param	  sainrencst String
	 *@param	  sacoses String
	 *@param	  sainmencss String
	 *@param	  sainrencss String
	 *@param	  sainmenct String
	 *@param	  sainrenct String
	 *@param	  safeciau Date
	 *@param	  sahrciau String
	 *@param	  sanolura String
	 *@param	  sanodira String
	 *@param	  sacoloa String
	 *@param	  sanrcpa String
	 *@param	  sainsopr String
	 *@param	  saininpr String
	 *@param	  sateobpr String
	 *@param	  sacope1 String
	 *@param	  sacneupr1 BigDecimal
	 *@param	  sacope2 String
	 *@param	  sacneupr2 BigDecimal
	 *@param	  safenopr Date
	 *@param	  sainmenp1 String
	 *@param	  sainrenp1 String
	 *@param	  sainmenp2 String
	 *@param	  sainrenp2 String
	 *@param	  sainmenpt String
	 *@param	  sainrenpt String
	 *@param	  sanolup String
	 *@param	  sanodirp String
	 *@param	  sacolop String
	 *@param	  sanrcopop String
	 *@param	  sanopvp String
	 *@param	  sanrtelp String
	 *@param	  sanrfaxp String
	 *@param	  saferepr Date
	 *@param	  sahrrepr String
	 *@param	  sacoarpt2 String
	 *@param	  sainmencpt2 String
	 *@param	  sainrencpt2 String
	 *@param	  sacoarps2 String
	 *@param	  sainmencps2 String
	 *@param	  sainrencps2 String
	 *@param	  sacoartt2 String
	 *@param	  sainmenctt2 String
	 *@param	  sainrenctt2 String
	 *@param	  sacoarts2 String
	 *@param	  sainmencts2 String
	 *@param	  sainrencts2 String
	 *@param	  sacoccco2 String
	 *@param	  sacoardt2 String
	 *@param	  sainmencdt2 String
	 *@param	  sainrencdt2 String
	 *@param	  sacoards2 String
	 *@param	  sainmencds2 String
	 *@param	  sainrencds2 String
	 *@param	  sacooeco2 String
	 *@param	  sacoset2 String
	 *@param	  sainmencst2 String
	 *@param	  sainrencst2 String
	 *@param	  sacoses2 String
	 *@param	  sainmencss2 String
	 *@param	  sainrencss2 String
	 *@param	  sainmenct2 String
	 *@param	  sainrenct2 String
	 *@param	  safeciau2 Date
	 *@param	  sahrciau2 String
	 *@param	  sanolura2 String
	 *@param	  sanodira2 String
	 *@param	  sacoloa2 String
	 *@param	  sanrcpa2 String
	 *@param	  safelaud Date
	 *@param	  sateobre String
	 *@param	  satemore String
	 *@param	  sacneuil BigDecimal
	 *@param	  sainfdla String
	 *@param	  sainvola String
	 *@param	  sainarnl String
	 *@param	  sacot7 String
	 *@param	  safenolt Date
	 *@param	  sainmelt String
	 *@param	  sainpubo String
	 *@param	  sacota1 String
	 *@param	  safesera Date
	 *@param	  sainfdra String
	 *@param	  safepeex Date
	 *@param	  sainrain String
	 *@param	  sainefin String
	 *@param	  safeinef Date
	 *@param	  safear Date
	 *@param	  safenode Date
	 *@param	  saferelt Date
	 *@param	  safenoca Date
	 *@param	  safenoca2 Date
	 *@param	  safenoar Date
	 *@param	  sacocccos String
	 *@param	  sacoccco2s String
	 *@param	  sacooecos String
	 *@param	  sacooeco2s String
	 *@param	  safesoac Date
	 *@param	  safeenac Date
	 *@param	  safenoac Date
	 *@param	  satefpr1 String
	 *@param	  satefpr2 String
	 *@param	  safefpr1 Date
	 *@param	  safefpr2 Date
	 *@param	  sanrbopl String
	 *@param	  safeenin Date
	 *@param	  sacotmd String
	 *@param	  safeoppe Date
	 *@param	  safeopla Date
	 *@param	  safereco Date
	 *@param	  safenola Date
	 *@param	  safenona Date
	 *@param	  saferena Date
	 *@param	  safecona Date
	 *@param	  sapub String
	 *@param	  saintica String
	 *@param	  sacotir String
	 *@param	  sacops String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "sacodigo", required = false) String sacodigo,
	@RequestParam(value = "hechoDenunciadoHdcodigo", required = false) String hechoDenunciadoHdcodigo,
	@RequestParam(value = "solicitudArbitrajeSACOSAAC", required = false) String solicitudArbitrajeSACOSAAC,
	@RequestParam(value = "sacoja", required = false) String sacoja,
	@RequestParam(value = "sanror", required = false) Integer sanror,
	@RequestParam(value = "sanran", required = false) Long sanran,
	@RequestParam(value = "safesoli", required = false) Date safesoli,
	@RequestParam(value = "sacot4", required = false) String sacot4,
	@RequestParam(value = "sacoxj", required = false) String sacoxj,
	@RequestParam(value = "sanodidc", required = false) String sanodidc,
	@RequestParam(value = "sacolodc", required = false) String sacolodc,
	@RequestParam(value = "sanolodc", required = false) String sanolodc,
	@RequestParam(value = "sacopvdc", required = false) String sacopvdc,
	@RequestParam(value = "sacomudc", required = false) String sacomudc,
	@RequestParam(value = "sanrcpdc", required = false) String sanrcpdc,
	@RequestParam(value = "sainacuo", required = false) String sainacuo,
	@RequestParam(value = "sacoorpr", required = false) String sacoorpr,
	@RequestParam(value = "sacosere", required = false) String sacosere,
	@RequestParam(value = "sacotti", required = false) String sacotti,
	@RequestParam(value = "saintiso", required = false) String saintiso,
	@RequestParam(value = "sacnrecl", required = false) BigDecimal sacnrecl,
	@RequestParam(value = "sateobrc", required = false) String sateobrc,
	@RequestParam(value = "safeinad", required = false) Date safeinad,
	@RequestParam(value = "sacot5", required = false) String sacot5,
	@RequestParam(value = "sateinad", required = false) String sateinad,
	@RequestParam(value = "safereit", required = false) Date safereit,
	@RequestParam(value = "safetras", required = false) Date safetras,
	@RequestParam(value = "sacoortr", required = false) String sacoortr,
	@RequestParam(value = "saferett", required = false) Date saferett,
	@RequestParam(value = "saferets", required = false) Date saferets,
	@RequestParam(value = "safemedi", required = false) Date safemedi,
	@RequestParam(value = "sainreme", required = false) String sainreme,
	@RequestParam(value = "saferemt", required = false) Date saferemt,
	@RequestParam(value = "safedesi", required = false) Date safedesi,
	@RequestParam(value = "saferedt", required = false) Date saferedt,
	@RequestParam(value = "safenoco", required = false) Date safenoco,
	@RequestParam(value = "saferear", required = false) Date saferear,
	@RequestParam(value = "safedeco", required = false) Date safedeco,
	@RequestParam(value = "sacoarpt", required = false) String sacoarpt,
	@RequestParam(value = "sainmencpt", required = false) String sainmencpt,
	@RequestParam(value = "sainrencpt", required = false) String sainrencpt,
	@RequestParam(value = "sacoarps", required = false) String sacoarps,
	@RequestParam(value = "sainmencps", required = false) String sainmencps,
	@RequestParam(value = "sainrencps", required = false) String sainrencps,
	@RequestParam(value = "sacoartt", required = false) String sacoartt,
	@RequestParam(value = "sainmenctt", required = false) String sainmenctt,
	@RequestParam(value = "sainrenctt", required = false) String sainrenctt,
	@RequestParam(value = "sacoarts", required = false) String sacoarts,
	@RequestParam(value = "sainmencts", required = false) String sainmencts,
	@RequestParam(value = "sainrencts", required = false) String sainrencts,
	@RequestParam(value = "sacoccco", required = false) String sacoccco,
	@RequestParam(value = "sacoardt", required = false) String sacoardt,
	@RequestParam(value = "sainmencdt", required = false) String sainmencdt,
	@RequestParam(value = "sainrencdt", required = false) String sainrencdt,
	@RequestParam(value = "sacoards", required = false) String sacoards,
	@RequestParam(value = "sainmencds", required = false) String sainmencds,
	@RequestParam(value = "sainrencds", required = false) String sainrencds,
	@RequestParam(value = "sacooeco", required = false) String sacooeco,
	@RequestParam(value = "sacoset", required = false) String sacoset,
	@RequestParam(value = "sainmencst", required = false) String sainmencst,
	@RequestParam(value = "sainrencst", required = false) String sainrencst,
	@RequestParam(value = "sacoses", required = false) String sacoses,
	@RequestParam(value = "sainmencss", required = false) String sainmencss,
	@RequestParam(value = "sainrencss", required = false) String sainrencss,
	@RequestParam(value = "sainmenct", required = false) String sainmenct,
	@RequestParam(value = "sainrenct", required = false) String sainrenct,
	@RequestParam(value = "safeciau", required = false) Date safeciau,
	@RequestParam(value = "sahrciau", required = false) String sahrciau,
	@RequestParam(value = "sanolura", required = false) String sanolura,
	@RequestParam(value = "sanodira", required = false) String sanodira,
	@RequestParam(value = "sacoloa", required = false) String sacoloa,
	@RequestParam(value = "sanrcpa", required = false) String sanrcpa,
	@RequestParam(value = "sainsopr", required = false) String sainsopr,
	@RequestParam(value = "saininpr", required = false) String saininpr,
	@RequestParam(value = "sateobpr", required = false) String sateobpr,
	@RequestParam(value = "sacope1", required = false) String sacope1,
	@RequestParam(value = "sacneupr1", required = false) BigDecimal sacneupr1,
	@RequestParam(value = "sacope2", required = false) String sacope2,
	@RequestParam(value = "sacneupr2", required = false) BigDecimal sacneupr2,
	@RequestParam(value = "safenopr", required = false) Date safenopr,
	@RequestParam(value = "sainmenp1", required = false) String sainmenp1,
	@RequestParam(value = "sainrenp1", required = false) String sainrenp1,
	@RequestParam(value = "sainmenp2", required = false) String sainmenp2,
	@RequestParam(value = "sainrenp2", required = false) String sainrenp2,
	@RequestParam(value = "sainmenpt", required = false) String sainmenpt,
	@RequestParam(value = "sainrenpt", required = false) String sainrenpt,
	@RequestParam(value = "sanolup", required = false) String sanolup,
	@RequestParam(value = "sanodirp", required = false) String sanodirp,
	@RequestParam(value = "sacolop", required = false) String sacolop,
	@RequestParam(value = "sanrcopop", required = false) String sanrcopop,
	@RequestParam(value = "sanopvp", required = false) String sanopvp,
	@RequestParam(value = "sanrtelp", required = false) String sanrtelp,
	@RequestParam(value = "sanrfaxp", required = false) String sanrfaxp,
	@RequestParam(value = "saferepr", required = false) Date saferepr,
	@RequestParam(value = "sahrrepr", required = false) String sahrrepr,
	@RequestParam(value = "sacoarpt2", required = false) String sacoarpt2,
	@RequestParam(value = "sainmencpt2", required = false) String sainmencpt2,
	@RequestParam(value = "sainrencpt2", required = false) String sainrencpt2,
	@RequestParam(value = "sacoarps2", required = false) String sacoarps2,
	@RequestParam(value = "sainmencps2", required = false) String sainmencps2,
	@RequestParam(value = "sainrencps2", required = false) String sainrencps2,
	@RequestParam(value = "sacoartt2", required = false) String sacoartt2,
	@RequestParam(value = "sainmenctt2", required = false) String sainmenctt2,
	@RequestParam(value = "sainrenctt2", required = false) String sainrenctt2,
	@RequestParam(value = "sacoarts2", required = false) String sacoarts2,
	@RequestParam(value = "sainmencts2", required = false) String sainmencts2,
	@RequestParam(value = "sainrencts2", required = false) String sainrencts2,
	@RequestParam(value = "sacoccco2", required = false) String sacoccco2,
	@RequestParam(value = "sacoardt2", required = false) String sacoardt2,
	@RequestParam(value = "sainmencdt2", required = false) String sainmencdt2,
	@RequestParam(value = "sainrencdt2", required = false) String sainrencdt2,
	@RequestParam(value = "sacoards2", required = false) String sacoards2,
	@RequestParam(value = "sainmencds2", required = false) String sainmencds2,
	@RequestParam(value = "sainrencds2", required = false) String sainrencds2,
	@RequestParam(value = "sacooeco2", required = false) String sacooeco2,
	@RequestParam(value = "sacoset2", required = false) String sacoset2,
	@RequestParam(value = "sainmencst2", required = false) String sainmencst2,
	@RequestParam(value = "sainrencst2", required = false) String sainrencst2,
	@RequestParam(value = "sacoses2", required = false) String sacoses2,
	@RequestParam(value = "sainmencss2", required = false) String sainmencss2,
	@RequestParam(value = "sainrencss2", required = false) String sainrencss2,
	@RequestParam(value = "sainmenct2", required = false) String sainmenct2,
	@RequestParam(value = "sainrenct2", required = false) String sainrenct2,
	@RequestParam(value = "safeciau2", required = false) Date safeciau2,
	@RequestParam(value = "sahrciau2", required = false) String sahrciau2,
	@RequestParam(value = "sanolura2", required = false) String sanolura2,
	@RequestParam(value = "sanodira2", required = false) String sanodira2,
	@RequestParam(value = "sacoloa2", required = false) String sacoloa2,
	@RequestParam(value = "sanrcpa2", required = false) String sanrcpa2,
	@RequestParam(value = "safelaud", required = false) Date safelaud,
	@RequestParam(value = "sateobre", required = false) String sateobre,
	@RequestParam(value = "satemore", required = false) String satemore,
	@RequestParam(value = "sacneuil", required = false) BigDecimal sacneuil,
	@RequestParam(value = "sainfdla", required = false) String sainfdla,
	@RequestParam(value = "sainvola", required = false) String sainvola,
	@RequestParam(value = "sainarnl", required = false) String sainarnl,
	@RequestParam(value = "sacot7", required = false) String sacot7,
	@RequestParam(value = "safenolt", required = false) Date safenolt,
	@RequestParam(value = "sainmelt", required = false) String sainmelt,
	@RequestParam(value = "sainpubo", required = false) String sainpubo,
	@RequestParam(value = "sacota1", required = false) String sacota1,
	@RequestParam(value = "safesera", required = false) Date safesera,
	@RequestParam(value = "sainfdra", required = false) String sainfdra,
	@RequestParam(value = "safepeex", required = false) Date safepeex,
	@RequestParam(value = "sainrain", required = false) String sainrain,
	@RequestParam(value = "sainefin", required = false) String sainefin,
	@RequestParam(value = "safeinef", required = false) Date safeinef,
	@RequestParam(value = "safear", required = false) Date safear,
	@RequestParam(value = "safenode", required = false) Date safenode,
	@RequestParam(value = "saferelt", required = false) Date saferelt,
	@RequestParam(value = "safenoca", required = false) Date safenoca,
	@RequestParam(value = "safenoca2", required = false) Date safenoca2,
	@RequestParam(value = "safenoar", required = false) Date safenoar,
	@RequestParam(value = "sacocccos", required = false) String sacocccos,
	@RequestParam(value = "sacoccco2s", required = false) String sacoccco2s,
	@RequestParam(value = "sacooecos", required = false) String sacooecos,
	@RequestParam(value = "sacooeco2s", required = false) String sacooeco2s,
	@RequestParam(value = "safesoac", required = false) Date safesoac,
	@RequestParam(value = "safeenac", required = false) Date safeenac,
	@RequestParam(value = "safenoac", required = false) Date safenoac,
	@RequestParam(value = "satefpr1", required = false) String satefpr1,
	@RequestParam(value = "satefpr2", required = false) String satefpr2,
	@RequestParam(value = "safefpr1", required = false) Date safefpr1,
	@RequestParam(value = "safefpr2", required = false) Date safefpr2,
	@RequestParam(value = "sanrbopl", required = false) String sanrbopl,
	@RequestParam(value = "safeenin", required = false) Date safeenin,
	@RequestParam(value = "sacotmd", required = false) String sacotmd,
	@RequestParam(value = "safeoppe", required = false) Date safeoppe,
	@RequestParam(value = "safeopla", required = false) Date safeopla,
	@RequestParam(value = "safereco", required = false) Date safereco,
	@RequestParam(value = "safenola", required = false) Date safenola,
	@RequestParam(value = "safenona", required = false) Date safenona,
	@RequestParam(value = "saferena", required = false) Date saferena,
	@RequestParam(value = "safecona", required = false) Date safecona,
	@RequestParam(value = "sapub", required = false) String sapub,
	@RequestParam(value = "saintica", required = false) String saintica,
	@RequestParam(value = "sacotir", required = false) String sacotir,
	@RequestParam(value = "sacops", required = false) String sacops,
			HttpServletRequest request) {
			try{
				SolicitudArbitraje filterSolicitudArbitraje = new SolicitudArbitraje(sacodigo, sacoja, sanror, sanran, safesoli, sacot4, sacoxj, sanodidc, sacolodc, sanolodc, sacopvdc, sacomudc, sanrcpdc, sainacuo, sacoorpr, sacosere, sacotti, saintiso, sacnrecl, sateobrc, safeinad, sacot5, sateinad, safereit, safetras, sacoortr, saferett, saferets, safemedi, sainreme, saferemt, safedesi, saferedt, safenoco, saferear, safedeco, sacoarpt, sainmencpt, sainrencpt, sacoarps, sainmencps, sainrencps, sacoartt, sainmenctt, sainrenctt, sacoarts, sainmencts, sainrencts, sacoccco, sacoardt, sainmencdt, sainrencdt, sacoards, sainmencds, sainrencds, sacooeco, sacoset, sainmencst, sainrencst, sacoses, sainmencss, sainrencss, sainmenct, sainrenct, safeciau, sahrciau, sanolura, sanodira, sacoloa, sanrcpa, sainsopr, saininpr, sateobpr, sacope1, sacneupr1, sacope2, sacneupr2, safenopr, sainmenp1, sainrenp1, sainmenp2, sainrenp2, sainmenpt, sainrenpt, sanolup, sanodirp, sacolop, sanrcopop, sanopvp, sanrtelp, sanrfaxp, saferepr, sahrrepr, sacoarpt2, sainmencpt2, sainrencpt2, sacoarps2, sainmencps2, sainrencps2, sacoartt2, sainmenctt2, sainrenctt2, sacoarts2, sainmencts2, sainrencts2, sacoccco2, sacoardt2, sainmencdt2, sainrencdt2, sacoards2, sainmencds2, sainrencds2, sacooeco2, sacoset2, sainmencst2, sainrencst2, sacoses2, sainmencss2, sainrencss2, sainmenct2, sainrenct2, safeciau2, sahrciau2, sanolura2, sanodira2, sacoloa2, sanrcpa2, safelaud, sateobre, satemore, sacneuil, sainfdla, sainvola, sainarnl, sacot7, safenolt, sainmelt, sainpubo, sacota1, safesera, sainfdra, safepeex, sainrain, sainefin, safeinef, safear, safenode, saferelt, safenoca, safenoca2, safenoar, sacocccos, sacoccco2s, sacooecos, sacooeco2s, safesoac, safeenac, safenoac, satefpr1, satefpr2, safefpr1, safefpr2, sanrbopl, safeenin, sacotmd, safeoppe, safeopla, safereco, safenola, safenona, saferena, safecona, sapub, saintica, sacotir, sacops, new HechoDenunciado(hechoDenunciadoHdcodigo, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null), new SolicitudArbitraje(solicitudArbitrajeSACOSAAC, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null));
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<SolicitudArbitraje> solicitudArbitrajes =  this.solicitudArbitrajeService.findAll(filterSolicitudArbitraje, pagination);

     			    if (solicitudArbitrajes == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterSolicitudArbitraje, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(solicitudArbitrajes);
				    return data;
				}else{
				    List<SolicitudArbitraje> solicitudArbitrajes =  this.solicitudArbitrajeService.findAll(filterSolicitudArbitraje, pagination);
					if (solicitudArbitrajes == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return solicitudArbitrajes;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterSolicitudArbitraje SolicitudArbitraje 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "solicitudArbitraje", required = false) SolicitudArbitraje  filterSolicitudArbitraje, HttpServletRequest request) {
	    try {
			return solicitudArbitrajeService
					.findAllCount(filterSolicitudArbitraje != null ? filterSolicitudArbitraje
							: new SolicitudArbitraje ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param solicitudArbitraje SolicitudArbitraje 
	 * @param response HttpServletResponse
	 * @return SolicitudArbitraje
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody SolicitudArbitraje edit(@RequestBody SolicitudArbitraje solicitudArbitraje, HttpServletResponse response) {		
		try {
            SolicitudArbitraje solicitudArbitrajeAux  = this.solicitudArbitrajeService.update(solicitudArbitraje);
			logger.info("Entity correctly inserted!");
            return solicitudArbitrajeAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param solicitudArbitraje SolicitudArbitraje 
	 * @return SolicitudArbitraje
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody SolicitudArbitraje add(@RequestBody SolicitudArbitraje solicitudArbitraje) {		
        try {
            SolicitudArbitraje solicitudArbitrajeAux = this.solicitudArbitrajeService.add(solicitudArbitraje);
            logger.info("Entity correctly inserted!");
        	return solicitudArbitrajeAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  sacodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{sacodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String sacodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            SolicitudArbitraje solicitudArbitraje = new SolicitudArbitraje();
            solicitudArbitraje.setSacodigo(sacodigo);
            this.solicitudArbitrajeService.remove(solicitudArbitraje);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  sacodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  solicitudArbitrajeIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> solicitudArbitrajeIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<SolicitudArbitraje> solicitudArbitrajeList = new ArrayList<SolicitudArbitraje>();
        try{		    
            for (ArrayList<String> solicitudArbitrajeId:solicitudArbitrajeIds) {
			    Iterator<String> iterator = solicitudArbitrajeId.iterator();
				    SolicitudArbitraje solicitudArbitraje = new SolicitudArbitraje();
			        solicitudArbitraje.setSacodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    solicitudArbitrajeList.add(solicitudArbitraje);
		    }
            this.solicitudArbitrajeService.removeMultiple(solicitudArbitrajeList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getSolicitudArbitrajeService'.
	 *
	 * @return SolicitudArbitrajeService
	 */
	protected SolicitudArbitrajeService getSolicitudArbitrajeService() {
		return this.solicitudArbitrajeService;
	}

	/**
	 * Method 'setSolicitudArbitrajeService'.
	 *
	 * @param solicitudArbitrajeService  SolicitudArbitrajeService
	 * @return
	 */
	public void setSolicitudArbitrajeService(SolicitudArbitrajeService solicitudArbitrajeService) {
		this.solicitudArbitrajeService = solicitudArbitrajeService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
