package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.SectorAgrupado;
import com.ejie.y41a.service.SectorService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Sector;

/**
 * * SectorController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/sector")
public class SectorController {

	private static final Logger logger = LoggerFactory
			.getLogger(SectorController.class);

	@Autowired
	private SectorService sectorService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("sector", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param secodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{secodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Sector getById(@PathVariable String secodigo) {
		try {
			Sector sector = new Sector();
			sector.setSecodigo(secodigo);
			sector = this.sectorService.find(sector);
			if (sector == null) {
				throw new Exception(secodigo.toString());
			}
			return sector;
		} catch (Exception e) {
			throw new ResourceNotFoundException(secodigo.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param secodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "SectorSeleccionable/{secodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Sector getByIdSeleccionable(@PathVariable String secodigo) {
		try {
			Sector sector = new Sector();
			sector.setSecodigo(secodigo);
			sector = this.sectorService.findSectorSeleccionable(sector);
			if (sector == null) {
				throw new Exception(secodigo.toString());
			}
			return sector;
		} catch (Exception e) {
			throw new ResourceNotFoundException(secodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param secodigo
	 *            String
	 * @param sectorAgrupadoL0codigo
	 *            String
	 * @param senombre
	 *            String
	 * @param senoco
	 *            String
	 * @param sedescri
	 *            String
	 * @param secose
	 *            String
	 * @param senoco2
	 *            String
	 * @param seinsel1
	 *            String
	 * @param senombree
	 *            String
	 * @param senombrei
	 *            String
	 * @param senombref
	 *            String
	 * @param senocoe
	 *            String
	 * @param senocoi
	 *            String
	 * @param senocof
	 *            String
	 * @param sedescrie
	 *            String
	 * @param sedescrii
	 *            String
	 * @param sedescrif
	 *            String
	 * @param secodgrupo
	 *            String
	 * @param senombrea
	 *            String
	 * @param sedescria
	 *            String
	 * @param senocoa
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/sectoresAll", method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "secodigo", required = false) String secodigo,
			@RequestParam(value = "sectorAgrupadoL0codigo", required = false) String sectorAgrupadoL0codigo,
			@RequestParam(value = "senombre", required = false) String senombre,
			@RequestParam(value = "senoco", required = false) String senoco,
			@RequestParam(value = "sedescri", required = false) String sedescri,
			@RequestParam(value = "secose", required = false) String secose,
			@RequestParam(value = "senoco2", required = false) String senoco2,
			@RequestParam(value = "seinsel1", required = false) String seinsel1,
			@RequestParam(value = "senombree", required = false) String senombree,
			@RequestParam(value = "senombrei", required = false) String senombrei,
			@RequestParam(value = "senombref", required = false) String senombref,
			@RequestParam(value = "senocoe", required = false) String senocoe,
			@RequestParam(value = "senocoi", required = false) String senocoi,
			@RequestParam(value = "senocof", required = false) String senocof,
			@RequestParam(value = "sedescrie", required = false) String sedescrie,
			@RequestParam(value = "sedescrii", required = false) String sedescrii,
			@RequestParam(value = "sedescrif", required = false) String sedescrif,
			@RequestParam(value = "secodgrupo", required = false) String secodgrupo,
			@RequestParam(value = "senombrea", required = false) String senombrea,
			@RequestParam(value = "sedescria", required = false) String sedescria,
			@RequestParam(value = "senocoa", required = false) String senocoa,
			HttpServletRequest request) {
		try {
			Sector filterSector = new Sector(secodigo, senombre, senoco,
					sedescri, secose, senoco2, seinsel1, senombree, senombrei,
					senombref, senocoe, senocoi, senocof, sedescrie, sedescrii,
					sedescrif, secodgrupo, senombrea, sedescria, senocoa,
					new SectorAgrupado(sectorAgrupadoL0codigo, null, null,
							null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Sector> sectors = this.sectorService.findAll(filterSector,
						pagination);

				if (sectors == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterSector, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(sectors);
				return data;
			} else {
				List<Sector> sectors = this.sectorService.findAll(filterSector,
						pagination);
				if (sectors == null) {
					throw new Exception("No data Found.");
				}
				return sectors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterSector
	 *            Sector
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "sector", required = false) Sector filterSector,
			HttpServletRequest request) {
		try {
			return sectorService
					.findAllCount(filterSector != null ? filterSector
							: new Sector());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param secodigo
	 *            String
	 * @param sectorAgrupadoL0codigo
	 *            String
	 * @param senombre
	 *            String
	 * @param senoco
	 *            String
	 * @param sedescri
	 *            String
	 * @param secose
	 *            String
	 * @param senoco2
	 *            String
	 * @param seinsel1
	 *            String
	 * @param senombree
	 *            String
	 * @param senombrei
	 *            String
	 * @param senombref
	 *            String
	 * @param senocoe
	 *            String
	 * @param senocoi
	 *            String
	 * @param senocof
	 *            String
	 * @param sedescrie
	 *            String
	 * @param sedescrii
	 *            String
	 * @param sedescrif
	 *            String
	 * @param secodgrupo
	 *            String
	 * @param senombrea
	 *            String
	 * @param sedescria
	 *            String
	 * @param senocoa
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAllSector(
			@RequestParam(value = "secodigo", required = false) String secodigo,
			@RequestParam(value = "sectorAgrupadoL0codigo", required = false) String sectorAgrupadoL0codigo,
			@RequestParam(value = "senombre", required = false) String senombre,
			@RequestParam(value = "senoco", required = false) String senoco,
			@RequestParam(value = "sedescri", required = false) String sedescri,
			@RequestParam(value = "secose", required = false) String secose,
			@RequestParam(value = "senoco2", required = false) String senoco2,
			@RequestParam(value = "seinsel1", required = false) String seinsel1_,
			@RequestParam(value = "senombree", required = false) String senombree,
			@RequestParam(value = "senombrei", required = false) String senombrei,
			@RequestParam(value = "senombref", required = false) String senombref,
			@RequestParam(value = "senocoe", required = false) String senocoe,
			@RequestParam(value = "senocoi", required = false) String senocoi,
			@RequestParam(value = "senocof", required = false) String senocof,
			@RequestParam(value = "sedescrie", required = false) String sedescrie,
			@RequestParam(value = "sedescrii", required = false) String sedescrii,
			@RequestParam(value = "sedescrif", required = false) String sedescrif,
			@RequestParam(value = "secodgrupo", required = false) String secodgrupo,
			@RequestParam(value = "senombrea", required = false) String senombrea,
			@RequestParam(value = "sedescria", required = false) String sedescria,
			@RequestParam(value = "senocoa", required = false) String senocoa,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String seinsel1 = ("".equals(seinsel1_)) ? null : seinsel1_;
			Sector filterSector = new Sector(secodigo, senombre, senoco,
					sedescri, secose, senoco2, seinsel1, senombree, senombrei,
					senombref, senocoe, senocoi, senocof, sedescrie, sedescrii,
					sedescrif, secodgrupo, senombrea, sedescria, senocoa,
					new SectorAgrupado(sectorAgrupadoL0codigo, null, null,
							null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Sector> sectors = this.sectorService.findAllLikeSector(
						filterSector, pagination, false);

				if (sectors == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.sectorService.findAllLikeSectorCount(
						filterSector, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(sectors);
				return data;
			} else {
				List<Sector> sectors = this.sectorService.findAllLikeSector(
						filterSector, pagination, false);
				if (sectors == null) {
					throw new Exception("No data Found.");
				}
				return sectors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param sector
	 *            Sector
	 * @param response
	 *            HttpServletResponse
	 * @return Sector
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Sector edit(@RequestBody Sector sector, HttpServletResponse response) {
		try {
			Sector sectorAux = this.sectorService.update(sector);
			logger.info("Entity correctly inserted!");
			return sectorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param sector
	 *            Sector
	 * @return Sector
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Sector add(@RequestBody Sector sector) {
		try {
			Sector sectorAux = this.sectorService.add(sector);
			logger.info("Entity correctly inserted!");
			return sectorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param secodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{secodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String secodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Sector sector = new Sector();
			sector.setSecodigo(secodigo);
			this.sectorService.remove(sector);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + secodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param sectorIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> sectorIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Sector> sectorList = new ArrayList<Sector>();
		try {
			for (ArrayList<String> sectorId : sectorIds) {
				Iterator<String> iterator = sectorId.iterator();
				Sector sector = new Sector();
				sector.setSecodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				sectorList.add(sector);
			}
			this.sectorService.removeMultiple(sectorList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getSectorService'.
	 * 
	 * @return SectorService
	 */
	protected SectorService getSectorService() {
		return this.sectorService;
	}

	/**
	 * Method 'setSectorService'.
	 * 
	 * @param sectorService
	 *            SectorService
	 * @return
	 */
	public void setSectorService(SectorService sectorService) {
		this.sectorService = sectorService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
