package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.SectorAgrupadoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.SectorAgrupado;

/**
 *  * SectorAgrupadoController generated by UDA, 01-feb-2012 17:10:42.
 *  
 */
 
@Controller
@RequestMapping (value = "/sectoragrupado")

public class SectorAgrupadoController  {

	private static final Logger logger = LoggerFactory.getLogger(SectorAgrupadoController.class);

	@Autowired
	private SectorAgrupadoService sectorAgrupadoService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("sectoragrupado", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  l0codigo String
	 * @return String
	 */
	@RequestMapping(value = "/{l0codigo}", method = RequestMethod.GET)
	public @ResponseBody SectorAgrupado getById(@PathVariable String l0codigo) {
		try{
            SectorAgrupado sectorAgrupado = new SectorAgrupado();
			sectorAgrupado.setL0codigo(l0codigo);
            sectorAgrupado = this.sectorAgrupadoService.find(sectorAgrupado);
            if (sectorAgrupado == null) {
                throw new Exception(l0codigo.toString());
            }
            return sectorAgrupado;
		}catch (Exception e){
		    throw new ResourceNotFoundException(l0codigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  l0codigo String
	 *@param	  l0nombre String
	 *@param	  l0nombree String
	 *@param	  l0nombrei String
	 *@param	  l0nombref String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "l0codigo", required = false) String l0codigo,
	@RequestParam(value = "l0nombre", required = false) String l0nombre,
	@RequestParam(value = "l0nombree", required = false) String l0nombree,
	@RequestParam(value = "l0nombrei", required = false) String l0nombrei,
	@RequestParam(value = "l0nombref", required = false) String l0nombref,
			HttpServletRequest request) {
			try{
				SectorAgrupado filterSectorAgrupado = new SectorAgrupado(l0codigo, l0nombre, l0nombree, l0nombrei, l0nombref);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<SectorAgrupado> sectorAgrupados =  this.sectorAgrupadoService.findAll(filterSectorAgrupado, pagination);

     			    if (sectorAgrupados == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterSectorAgrupado, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(sectorAgrupados);
				    return data;
				}else{
				    List<SectorAgrupado> sectorAgrupados =  this.sectorAgrupadoService.findAll(filterSectorAgrupado, pagination);
					if (sectorAgrupados == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return sectorAgrupados;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterSectorAgrupado SectorAgrupado 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "sectorAgrupado", required = false) SectorAgrupado  filterSectorAgrupado, HttpServletRequest request) {
	    try {
			return sectorAgrupadoService
					.findAllCount(filterSectorAgrupado != null ? filterSectorAgrupado
							: new SectorAgrupado ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param sectorAgrupado SectorAgrupado 
	 * @param response HttpServletResponse
	 * @return SectorAgrupado
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody SectorAgrupado edit(@RequestBody SectorAgrupado sectorAgrupado, HttpServletResponse response) {		
		try {
            SectorAgrupado sectorAgrupadoAux  = this.sectorAgrupadoService.update(sectorAgrupado);
			logger.info("Entity correctly inserted!");
            return sectorAgrupadoAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param sectorAgrupado SectorAgrupado 
	 * @return SectorAgrupado
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody SectorAgrupado add(@RequestBody SectorAgrupado sectorAgrupado) {		
        try {
            SectorAgrupado sectorAgrupadoAux = this.sectorAgrupadoService.add(sectorAgrupado);
            logger.info("Entity correctly inserted!");
        	return sectorAgrupadoAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  l0codigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{l0codigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String l0codigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            SectorAgrupado sectorAgrupado = new SectorAgrupado();
            sectorAgrupado.setL0codigo(l0codigo);
            this.sectorAgrupadoService.remove(sectorAgrupado);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  l0codigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  sectorAgrupadoIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> sectorAgrupadoIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<SectorAgrupado> sectorAgrupadoList = new ArrayList<SectorAgrupado>();
        try{		    
            for (ArrayList<String> sectorAgrupadoId:sectorAgrupadoIds) {
			    Iterator<String> iterator = sectorAgrupadoId.iterator();
				    SectorAgrupado sectorAgrupado = new SectorAgrupado();
			        sectorAgrupado.setL0codigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    sectorAgrupadoList.add(sectorAgrupado);
		    }
            this.sectorAgrupadoService.removeMultiple(sectorAgrupadoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getSectorAgrupadoService'.
	 *
	 * @return SectorAgrupadoService
	 */
	protected SectorAgrupadoService getSectorAgrupadoService() {
		return this.sectorAgrupadoService;
	}

	/**
	 * Method 'setSectorAgrupadoService'.
	 *
	 * @param sectorAgrupadoService  SectorAgrupadoService
	 * @return
	 */
	public void setSectorAgrupadoService(SectorAgrupadoService sectorAgrupadoService) {
		this.sectorAgrupadoService = sectorAgrupadoService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
