package com.ejie.y41a.control;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.DocumentoConsultaDetalle;
import com.ejie.y41a.model.Respuesta;
import com.ejie.y41a.model.RespuestaFile;
import com.ejie.y41a.service.ConsultaService;
import com.ejie.y41a.service.RespuestaFileService;

/**
 * * RespuestaFileController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/respuestafile")
public class RespuestaFileController {

	private static final Logger logger = LoggerFactory
			.getLogger(RespuestaFileController.class);

	@Autowired
	private RespuestaFileService respuestaFileService;
	@Autowired
	private ConsultaService consultaService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("respuestafile", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param q3cofile
	 *            Long
	 * @return String
	 */
	@RequestMapping(value = "/{q3cofile}", method = RequestMethod.GET)
	public @ResponseBody
	RespuestaFile getById(@PathVariable Long q3cofile) {
		try {
			RespuestaFile respuestaFile = new RespuestaFile();
			respuestaFile.setQ3cofile(q3cofile);
			respuestaFile = this.respuestaFileService.find(respuestaFile);
			if (respuestaFile == null) {
				throw new Exception(q3cofile.toString());
			}
			return respuestaFile;
		} catch (Exception e) {
			throw new ResourceNotFoundException(q3cofile.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param q3cofile
	 *            Long
	 * @param respuestaP9codigo
	 *            String
	 * @param q3nofile
	 *            String
	 * @param q3sizefile
	 *            Integer
	 * @param q3tedesfile
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "q3cofile", required = false) Long q3cofile,
			@RequestParam(value = "respuestaP9codigo", required = false) String respuestaP9codigo,
			@RequestParam(value = "q3nofile", required = false) String q3nofile,
			@RequestParam(value = "q3sizefile", required = false) Integer q3sizefile,
			@RequestParam(value = "q3tedesfile", required = false) String q3tedesfile,
			HttpServletRequest request) {
		try {
			RespuestaFile filterRespuestaFile = new RespuestaFile(q3cofile,
					new Respuesta(respuestaP9codigo, null, null, null, null,
							null, null, null, null), null, q3nofile, null,
					q3sizefile, q3tedesfile, null, null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<RespuestaFile> respuestaFiles = this.respuestaFileService
						.findAll(filterRespuestaFile, pagination);

				if (respuestaFiles == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterRespuestaFile, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(respuestaFiles);
				return data;
			} else {
				List<RespuestaFile> respuestaFiles = this.respuestaFileService
						.findAll(filterRespuestaFile, pagination);
				if (respuestaFiles == null) {
					throw new Exception("No data Found.");
				}
				return respuestaFiles;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterRespuestaFile
	 *            RespuestaFile
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "respuestaFile", required = false) RespuestaFile filterRespuestaFile,
			HttpServletRequest request) {
		try {
			return respuestaFileService
					.findAllCount(filterRespuestaFile != null ? filterRespuestaFile
							: new RespuestaFile());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @param response
	 *            HttpServletResponse
	 * @return RespuestaFile
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	RespuestaFile edit(@RequestBody RespuestaFile respuestaFile,
			HttpServletResponse response) {
		try {
			RespuestaFile respuestaFileAux = this.respuestaFileService
					.update(respuestaFile);
			logger.info("Entity correctly inserted!");
			return respuestaFileAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param respuestaFile
	 *            RespuestaFile
	 * @return RespuestaFile
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	RespuestaFile add(@RequestBody RespuestaFile respuestaFile) {
		try {
			RespuestaFile respuestaFileAux = this.respuestaFileService
					.add(respuestaFile);
			logger.info("Entity correctly inserted!");
			return respuestaFileAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param q3cofile
	 *            Long
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{q3cofile}", method = RequestMethod.DELETE)
	public void remove(@PathVariable Long q3cofile, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			RespuestaFile respuestaFile = new RespuestaFile();
			respuestaFile.setQ3cofile(q3cofile);
			this.respuestaFileService.remove(respuestaFile);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + q3cofile);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param respuestaFileIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> respuestaFileIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<RespuestaFile> respuestaFileList = new ArrayList<RespuestaFile>();
		try {
			for (ArrayList<String> respuestaFileId : respuestaFileIds) {
				Iterator<String> iterator = respuestaFileId.iterator();
				RespuestaFile respuestaFile = new RespuestaFile();
				respuestaFile.setQ3cofile(ObjectConversionManager.convert(
						iterator.next(), Long.class));
				respuestaFileList.add(respuestaFile);
			}
			this.respuestaFileService.removeMultiple(respuestaFileList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getRespuestaFileService'.
	 * 
	 * @return RespuestaFileService
	 */
	protected RespuestaFileService getRespuestaFileService() {
		return this.respuestaFileService;
	}

	/**
	 * Method 'setRespuestaFileService'.
	 * 
	 * @param respuestaFileService
	 *            RespuestaFileService
	 * @return
	 */
	public void setRespuestaFileService(
			RespuestaFileService respuestaFileService) {
		this.respuestaFileService = respuestaFileService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'add'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return List<Map<String, Object>>
	 */

	@RequestMapping(value = "subidaRespuesta", method = RequestMethod.POST)
	public @ResponseBody()
	List<Map<String, Object>> add(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {

		try {
			String cocodigo = request.getParameter("cocodigo");

			// RESPUESTA FILE

			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);

			Respuesta respuesta = new Respuesta();
			respuesta.setConsulta(consulta);

			RespuestaFile respuestaFile = new RespuestaFile();
			respuestaFile.setRespuesta(respuesta);

			Blob blob = new SerialBlob(file.getBytes());
			respuestaFile.setQ3datafile(blob);
			respuestaFile.setQ3contenttypefile(file.getContentType());
			respuestaFile.setQ3nofile(file.getOriginalFilename().replace(" ",
					"_"));
			respuestaFile.setQ3sizefile((int) file.getSize());
			respuestaFile.setQ3tedesfile("");

			RespuestaFile respuestaFileAux = this.consultaService
					.addFileRespuesta(respuestaFile);

			logger.info("Entity correctly inserted!" + respuestaFileAux);

			Long cofile = respuestaFileAux.getQ3cofile();
			String strCofile = Long.toString(cofile);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file, strCofile));
			return filesMetaInfo;

		} catch (Exception e) {

			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @param strCofile
	 *            String
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file,
			String strCofile) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41aVistaWar/consultafile/" + strCofile + "/"
				+ Y41aConstantes.TIPO_DOCUMENTO_CONSULTA_RESPUESTA
				+ "/?R01HNoPortal=true");
		mapaRetorno.put("name", file.getOriginalFilename().replace(" ", "_"));
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41aVistaWar/respuestafile/"
				+ strCofile + "?R01HNoPortal=true");
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'deleteFilesRespuesta'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteFilesRespuesta/{cocodigo}", method = RequestMethod.DELETE)
	public void deleteFilesRespuesta(@PathVariable String cocodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			DocumentoConsultaDetalle documentoConsultaDetalle = new DocumentoConsultaDetalle();
			documentoConsultaDetalle.setCocodigo(cocodigo);

			this.consultaService.removeFileConsulta(documentoConsultaDetalle);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + cocodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

}
