package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.TipoRespuesta;
import com.ejie.y41a.service.RespuestaService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Respuesta;

/**
 * * RespuestaController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/respuesta")
public class RespuestaController {

	private static final Logger logger = LoggerFactory
			.getLogger(RespuestaController.class);

	@Autowired
	private RespuestaService respuestaService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("respuesta", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintModalRespuestaConsulta", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalRespuestaResultado(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("modalRespuestaConsulta", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintModalRespuestaEmail", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalRespuestaEmail(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("modalRespuestaEmail", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param p9codigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{p9codigo}", method = RequestMethod.GET)
	public @ResponseBody
	Respuesta getById(@PathVariable String p9codigo) {
		try {
			Respuesta respuesta = new Respuesta();
			respuesta.setP9codigo(p9codigo);
			respuesta = this.respuestaService.find(respuesta);
			if (respuesta == null) {
				throw new Exception(p9codigo.toString());
			}
			return respuesta;
		} catch (Exception e) {
			throw new ResourceNotFoundException(p9codigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param p9codigo
	 *            String
	 * @param tipoRespuestaP8codigo
	 *            String
	 * @param consultaCocodigo
	 *            String
	 * @param p9feanot
	 *            Date
	 * @param p9inemlusu
	 *            String
	 * @param p9feresp
	 *            Date
	 * @param p9nufiladj
	 *            BigDecimal
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "p9codigo", required = false) String p9codigo,
			@RequestParam(value = "tipoRespuestaP8codigo", required = false) String tipoRespuestaP8codigo,
			@RequestParam(value = "consultaCocodigo", required = false) String consultaCocodigo,
			@RequestParam(value = "p9feanot", required = false) Date p9feanot,
			@RequestParam(value = "p9inemlusu", required = false) String p9inemlusu,
			@RequestParam(value = "p9feresp", required = false) Date p9feresp,
			@RequestParam(value = "p9nufiladj", required = false) BigDecimal p9nufiladj,
			HttpServletRequest request) {
		try {
			Respuesta filterRespuesta = new Respuesta(p9codigo, p9feanot,
					p9inemlusu, p9feresp, null, p9nufiladj, new TipoRespuesta(
							tipoRespuestaP8codigo, null, null, null, null,
							null, null), new Consulta(consultaCocodigo, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Respuesta> respuestas = this.respuestaService.findAll(
						filterRespuesta, pagination);

				if (respuestas == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterRespuesta, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(respuestas);
				return data;
			} else {
				List<Respuesta> respuestas = this.respuestaService.findAll(
						filterRespuesta, pagination);
				if (respuestas == null) {
					throw new Exception("No data Found.");
				}
				return respuestas;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterRespuesta
	 *            Respuesta
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "respuesta", required = false) Respuesta filterRespuesta,
			HttpServletRequest request) {
		try {
			return respuestaService
					.findAllCount(filterRespuesta != null ? filterRespuesta
							: new Respuesta());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @param response
	 *            HttpServletResponse
	 * @return Respuesta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Respuesta edit(@RequestBody Respuesta respuesta,
			HttpServletResponse response) {
		try {
			Respuesta respuestaAux = this.respuestaService.update(respuesta);
			logger.info("Entity correctly inserted!");
			return respuestaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param respuesta
	 *            Respuesta
	 * @return Respuesta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Respuesta add(@RequestBody Respuesta respuesta) {
		try {
			Respuesta respuestaAux = this.respuestaService.add(respuesta);
			logger.info("Entity correctly inserted!");
			return respuestaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param p9codigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{p9codigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String p9codigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Respuesta respuesta = new Respuesta();
			respuesta.setP9codigo(p9codigo);
			this.respuestaService.remove(respuesta);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + p9codigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param respuestaIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> respuestaIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Respuesta> respuestaList = new ArrayList<Respuesta>();
		try {
			for (ArrayList<String> respuestaId : respuestaIds) {
				Iterator<String> iterator = respuestaId.iterator();
				Respuesta respuesta = new Respuesta();
				respuesta.setP9codigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				respuestaList.add(respuesta);
			}
			this.respuestaService.removeMultiple(respuestaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getRespuestaService'.
	 * 
	 * @return RespuestaService
	 */
	protected RespuestaService getRespuestaService() {
		return this.respuestaService;
	}

	/**
	 * Method 'setRespuestaService'.
	 * 
	 * @param respuestaService
	 *            RespuestaService
	 * @return
	 */
	public void setRespuestaService(RespuestaService respuestaService) {
		this.respuestaService = respuestaService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
