package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Actuacion;
import com.ejie.y41a.model.ProtocoloDetalle;
import com.ejie.y41a.model.TipPregProtoc;
import com.ejie.y41a.service.ProtocoloService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Protocolo;

/**
 * * ProtocoloController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/protocolo")
public class ProtocoloController {

	private static final Logger logger = LoggerFactory
			.getLogger(ProtocoloController.class);

	@Autowired
	private ProtocoloService protocoloService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("protocolo", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ptcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{ptcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Protocolo getById(@PathVariable String ptcodigo) {
		try {
			Protocolo protocolo = new Protocolo();
			protocolo.setPtcodigo(ptcodigo);
			protocolo = this.protocoloService.find(protocolo);
			if (protocolo == null) {
				throw new Exception(ptcodigo.toString());
			}
			return protocolo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(ptcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param ptcodigo
	 *            String
	 * @param tipPregProtocTrcodigo
	 *            String
	 * @param actuacionAtcodigo
	 *            String
	 * @param ptnrprtp
	 *            Integer
	 * @param ptcoretp
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "ptcodigo", required = false) String ptcodigo,
			@RequestParam(value = "tipPregProtocTrcodigo", required = false) String tipPregProtocTrcodigo,
			@RequestParam(value = "actuacionAtcodigo", required = false) String actuacionAtcodigo,
			@RequestParam(value = "ptnrprtp", required = false) Integer ptnrprtp,
			@RequestParam(value = "ptcoretp", required = false) String ptcoretp,
			HttpServletRequest request) {
		try {
			Protocolo filterProtocolo = new Protocolo(ptcodigo, ptnrprtp,
					ptcoretp, new TipPregProtoc(tipPregProtocTrcodigo, null,
							null, null, null, null, null, null, null, null),
					new Actuacion(actuacionAtcodigo, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Protocolo> protocolos = this.protocoloService.findAll(
						filterProtocolo, pagination);

				if (protocolos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterProtocolo, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(protocolos);
				return data;
			} else {
				List<Protocolo> protocolos = this.protocoloService.findAll(
						filterProtocolo, pagination);
				if (protocolos == null) {
					throw new Exception("No data Found.");
				}
				return protocolos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterProtocolo
	 *            Protocolo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "protocolo", required = false) Protocolo filterProtocolo,
			HttpServletRequest request) {
		try {
			return protocoloService
					.findAllCount(filterProtocolo != null ? filterProtocolo
							: new Protocolo());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @param response
	 *            HttpServletResponse
	 * @return Protocolo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Protocolo edit(@RequestBody Protocolo protocolo,
			HttpServletResponse response) {
		try {
			Protocolo protocoloAux = this.protocoloService.update(protocolo);
			logger.info("Entity correctly inserted!");
			return protocoloAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param protocolo
	 *            Protocolo
	 * @return Protocolo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Protocolo add(@RequestBody Protocolo protocolo) {
		try {
			Protocolo protocoloAux = this.protocoloService.add(protocolo);
			logger.info("Entity correctly inserted!");
			return protocoloAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ptcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{ptcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String ptcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Protocolo protocolo = new Protocolo();
			protocolo.setPtcodigo(ptcodigo);
			this.protocoloService.remove(protocolo);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + ptcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param protocoloIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> protocoloIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Protocolo> protocoloList = new ArrayList<Protocolo>();
		try {
			for (ArrayList<String> protocoloId : protocoloIds) {
				Iterator<String> iterator = protocoloId.iterator();
				Protocolo protocolo = new Protocolo();
				protocolo.setPtcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				protocoloList.add(protocolo);
			}
			this.protocoloService.removeMultiple(protocoloList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getByIdProtocoloActuacionOrdenado'.
	 * 
	 * @param atcodigo_
	 *            String
	 * @param tpcodigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/protocoloActuacionOrdenado", method = RequestMethod.GET)
	public @ResponseBody
	Object getByIdProtocoloActuacionOrdenado(
			@RequestParam(value = "atcodigo", required = false) String atcodigo_,
			@RequestParam(value = "tpcodigo", required = false) String tpcodigo_,
			HttpServletRequest request) {
		try {

			String atcodigo = ("".equals(atcodigo_)) ? null : atcodigo_;
			String tpcodigo = ("".equals(tpcodigo_)) ? null : tpcodigo_;
			ProtocoloDetalle protocoloDetalle = new ProtocoloDetalle();
			protocoloDetalle.setAtcodigo(atcodigo);
			protocoloDetalle.setTpcodigo(tpcodigo);

			List<ProtocoloDetalle> listProtocoloDetalle = this.protocoloService
					.findAllProtocoloActuacionOrdenado(protocoloDetalle);

			return listProtocoloDetalle;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'editProtocolo'.
	 * 
	 * @param protocoloArray
	 *            ArrayList<String>
	 * @param response
	 *            HttpServletResponse
	 */

	@RequestMapping(value = "/editProtocolo", method = RequestMethod.PUT)
	public @ResponseBody
	void editProtocolo(@RequestBody List<Map<String, String>> protocoloArray,
			HttpServletResponse response) {
		try {
			ArrayList<ProtocoloDetalle> protocoloDetalleList = new ArrayList<ProtocoloDetalle>();
			for (Map<String, String> protocolo : protocoloArray) {
				ProtocoloDetalle protocoloDetalle = new ProtocoloDetalle();
				for (Map.Entry<String, String> entry : protocolo.entrySet()) {
					if (entry.getKey().equals("aicodigo")) {
						protocoloDetalle.setAtcodigo(entry.getValue());
					} else if (entry.getKey().equals("tpcodigo")) {
						protocoloDetalle.setPtcodigo(entry.getValue());
					} else if (entry.getKey().equals("trcodigo")) {
						protocoloDetalle.setTrcodigo(entry.getValue());
					} else if (entry.getKey().equals("ptcoretp")) {
						protocoloDetalle.setPtcoretp(entry.getValue());
					} else if (entry.getKey().equals("trnrtipp")) {
						Integer ptnrprtp = Integer.parseInt(entry.getValue());
						protocoloDetalle.setPtnrprtp(ptnrprtp);
					}

				}
				protocoloDetalleList.add(protocoloDetalle);
			}
			this.protocoloService.registerProtocolo(protocoloDetalleList);

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getProtocoloService'.
	 * 
	 * @return ProtocoloService
	 */
	protected ProtocoloService getProtocoloService() {
		return this.protocoloService;
	}

	/**
	 * Method 'setProtocoloService'.
	 * 
	 * @param protocoloService
	 *            ProtocoloService
	 * @return
	 */
	public void setProtocoloService(ProtocoloService protocoloService) {
		this.protocoloService = protocoloService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
