package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.ProdAgrupado;
import com.ejie.y41a.service.ProductoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Producto;

/**
 * * ProductoController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/producto")
public class ProductoController {

	private static final Logger logger = LoggerFactory
			.getLogger(ProductoController.class);

	@Autowired
	private ProductoService productoService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("producto", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("productosServicios", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param pscodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{pscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Producto getById(@PathVariable String pscodigo) {
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			producto = this.productoService.find(producto);
			if (producto == null) {
				throw new Exception(pscodigo.toString());
			}
			return producto;
		} catch (Exception e) {
			throw new ResourceNotFoundException(pscodigo.toString());
		}
	}

	/**
	 * Method 'getByIdSeleccionable'.
	 * 
	 * @param pscodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/seleccionable/{pscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Producto getByIdSeleccionable(@PathVariable String pscodigo) {
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			producto = this.productoService.findProductoSeleccionable(producto);
			if (producto == null) {
				throw new Exception(pscodigo.toString());
			}
			return producto;
		} catch (Exception e) {
			throw new ResourceNotFoundException(pscodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param pscodigo
	 *            String
	 * @param prodAgrupadoE8codigo
	 *            String
	 * @param psnombre
	 *            String
	 * @param psnoco
	 *            String
	 * @param psdescri
	 *            String
	 * @param pscose
	 *            String
	 * @param psnombree
	 *            String
	 * @param psnombrei
	 *            String
	 * @param psnombref
	 *            String
	 * @param psnombrea
	 *            String
	 * @param psnocoe
	 *            String
	 * @param psnocoi
	 *            String
	 * @param psnocof
	 *            String
	 * @param psnocoa
	 *            String
	 * @param psdescrie
	 *            String
	 * @param psdescrii
	 *            String
	 * @param psdescrif
	 *            String
	 * @param psdescria
	 *            String
	 * @param pssel1
	 *            String
	 * @param pscoinc
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "pscodigo", required = false) String pscodigo,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo,
			@RequestParam(value = "psnombre", required = false) String psnombre,
			@RequestParam(value = "psnoco", required = false) String psnoco,
			@RequestParam(value = "psdescri", required = false) String psdescri,
			@RequestParam(value = "pscose", required = false) String pscose,
			@RequestParam(value = "psnombree", required = false) String psnombree,
			@RequestParam(value = "psnombrei", required = false) String psnombrei,
			@RequestParam(value = "psnombref", required = false) String psnombref,
			@RequestParam(value = "psnombrea", required = false) String psnombrea,
			@RequestParam(value = "psnocoe", required = false) String psnocoe,
			@RequestParam(value = "psnocoi", required = false) String psnocoi,
			@RequestParam(value = "psnocof", required = false) String psnocof,
			@RequestParam(value = "psnocoa", required = false) String psnocoa,
			@RequestParam(value = "psdescrie", required = false) String psdescrie,
			@RequestParam(value = "psdescrii", required = false) String psdescrii,
			@RequestParam(value = "psdescrif", required = false) String psdescrif,
			@RequestParam(value = "psdescria", required = false) String psdescria,
			@RequestParam(value = "pssel1", required = false) String pssel1,
			@RequestParam(value = "pscoinc", required = false) String pscoinc,
			HttpServletRequest request) {
		try {
			Producto filterProducto = new Producto(pscodigo, psnombre, psnoco,
					psdescri, pscose, psnombree, psnombrei, psnombref,
					psnombrea, psnocoe, psnocoi, psnocof, psnocoa, psdescrie,
					psdescrii, psdescrif, psdescria, pssel1, pscoinc,
					new ProdAgrupado(prodAgrupadoE8codigo, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Producto> productos = this.productoService.findAll(
						filterProducto, pagination);

				if (productos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterProducto, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(productos);
				return data;
			} else {
				List<Producto> productos = this.productoService.findAll(
						filterProducto, pagination);
				if (productos == null) {
					throw new Exception("No data Found.");
				}
				return productos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllProducto'.
	 * 
	 * @param pscodigo_
	 *            String
	 * @param prodAgrupadoE8codigo_
	 *            String
	 * @param psnombre_
	 *            String
	 * @param psnoco
	 *            String
	 * @param psdescri
	 *            String
	 * @param pscose
	 *            String
	 * @param psnombree
	 *            String
	 * @param psnombrei
	 *            String
	 * @param psnombref
	 *            String
	 * @param psnombrea
	 *            String
	 * @param psnocoe
	 *            String
	 * @param psnocoi
	 *            String
	 * @param psnocof
	 *            String
	 * @param psnocoa
	 *            String
	 * @param psdescrie
	 *            String
	 * @param psdescrii
	 *            String
	 * @param psdescrif
	 *            String
	 * @param psdescria
	 *            String
	 * @param pssel1_
	 *            String
	 * @param pscoinc
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllProducto(
			@RequestParam(value = "pscodigo", required = false) String pscodigo_,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo_,
			@RequestParam(value = "psnombre", required = false) String psnombre_,
			@RequestParam(value = "psnoco", required = false) String psnoco,
			@RequestParam(value = "psdescri", required = false) String psdescri,
			@RequestParam(value = "pscose", required = false) String pscose,
			@RequestParam(value = "psnombree", required = false) String psnombree,
			@RequestParam(value = "psnombrei", required = false) String psnombrei,
			@RequestParam(value = "psnombref", required = false) String psnombref,
			@RequestParam(value = "psnombrea", required = false) String psnombrea,
			@RequestParam(value = "psnocoe", required = false) String psnocoe,
			@RequestParam(value = "psnocoi", required = false) String psnocoi,
			@RequestParam(value = "psnocof", required = false) String psnocof,
			@RequestParam(value = "psnocoa", required = false) String psnocoa,
			@RequestParam(value = "psdescrie", required = false) String psdescrie,
			@RequestParam(value = "psdescrii", required = false) String psdescrii,
			@RequestParam(value = "psdescrif", required = false) String psdescrif,
			@RequestParam(value = "psdescria", required = false) String psdescria,
			@RequestParam(value = "pssel1", required = false) String pssel1_,
			@RequestParam(value = "pscoinc", required = false) String pscoinc,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String pssel1 = ("".equals(pssel1_)) ? null : pssel1_;
			String pscodigo = ("".equals(pscodigo_)) ? null : pscodigo_;
			String psnombre = ("".equals(psnombre_)) ? null : psnombre_;
			String prodAgrupadoE8codigo = ("".equals(prodAgrupadoE8codigo_)) ? null
					: prodAgrupadoE8codigo_;

			Producto filterProducto = new Producto(pscodigo, psnombre, psnoco,
					psdescri, pscose, psnombree, psnombrei, psnombref,
					psnombrea, psnocoe, psnocoi, psnocof, psnocoa, psdescrie,
					psdescrii, psdescrif, psdescria, pssel1, pscoinc,
					new ProdAgrupado(prodAgrupadoE8codigo, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Producto> productos = this.productoService
						.findAllLikeProducto(filterProducto, pagination, false);

				if (productos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.productoService.findAllLikeProductoCount(
						filterProducto, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(productos);
				return data;
			} else {
				List<Producto> productos = this.productoService
						.findAllLikeProducto(filterProducto, pagination, false);
				if (productos == null) {
					throw new Exception("No data Found.");
				}
				return productos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterProducto
	 *            Producto
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "producto", required = false) Producto filterProducto,
			HttpServletRequest request) {
		try {
			return productoService
					.findAllCount(filterProducto != null ? filterProducto
							: new Producto());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param producto
	 *            Producto
	 * @param response
	 *            HttpServletResponse
	 * @return Producto
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Producto edit(@RequestBody Producto producto, HttpServletResponse response) {
		try {
			Producto productoAux = this.productoService.update(producto);
			logger.info("Entity correctly inserted!");
			return productoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param producto
	 *            Producto
	 * @return Producto
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Producto add(@RequestBody Producto producto) {
		try {
			Producto productoAux = this.productoService.add(producto);
			logger.info("Entity correctly inserted!");
			return productoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param pscodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{pscodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String pscodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			this.productoService.remove(producto);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + pscodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param productoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> productoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Producto> productoList = new ArrayList<Producto>();
		try {
			for (ArrayList<String> productoId : productoIds) {
				Iterator<String> iterator = productoId.iterator();
				Producto producto = new Producto();
				producto.setPscodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				productoList.add(producto);
			}
			this.productoService.removeMultiple(productoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getProductoService'.
	 * 
	 * @return ProductoService
	 */
	protected ProductoService getProductoService() {
		return this.productoService;
	}

	/**
	 * Method 'setProductoService'.
	 * 
	 * @param productoService
	 *            ProductoService
	 * @return
	 */
	public void setProductoService(ProductoService productoService) {
		this.productoService = productoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
