package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.service.ProdAgrupadoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.ProdAgrupado;

/**
 * * ProdAgrupadoController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/prodagrupado")
public class ProdAgrupadoController {

	private static final Logger logger = LoggerFactory
			.getLogger(ProdAgrupadoController.class);

	@Autowired
	private ProdAgrupadoService prodAgrupadoService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("prodagrupado", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param e8codigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{e8codigo}", method = RequestMethod.GET)
	public @ResponseBody
	ProdAgrupado getById(@PathVariable String e8codigo) {
		try {
			ProdAgrupado prodAgrupado = new ProdAgrupado();
			prodAgrupado.setE8codigo(e8codigo);
			prodAgrupado = this.prodAgrupadoService.find(prodAgrupado);
			if (prodAgrupado == null) {
				throw new Exception(e8codigo.toString());
			}
			return prodAgrupado;
		} catch (Exception e) {
			throw new ResourceNotFoundException(e8codigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param e8codigo
	 *            String
	 * @param e8nombre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "e8codigo", required = false) String e8codigo,
			@RequestParam(value = "e8nombre", required = false) String e8nombre,
			HttpServletRequest request) {
		try {
			ProdAgrupado filterProdAgrupado = new ProdAgrupado(e8codigo,
					e8nombre);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ProdAgrupado> prodAgrupados = this.prodAgrupadoService
						.findAll(filterProdAgrupado, pagination);

				if (prodAgrupados == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterProdAgrupado, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(prodAgrupados);
				return data;
			} else {
				List<ProdAgrupado> prodAgrupados = this.prodAgrupadoService
						.findAll(filterProdAgrupado, pagination);
				if (prodAgrupados == null) {
					throw new Exception("No data Found.");
				}
				return prodAgrupados;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterProdAgrupado
	 *            ProdAgrupado
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "prodAgrupado", required = false) ProdAgrupado filterProdAgrupado,
			HttpServletRequest request) {
		try {
			return prodAgrupadoService
					.findAllCount(filterProdAgrupado != null ? filterProdAgrupado
							: new ProdAgrupado());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @param response
	 *            HttpServletResponse
	 * @return ProdAgrupado
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	ProdAgrupado edit(@RequestBody ProdAgrupado prodAgrupado,
			HttpServletResponse response) {
		try {
			ProdAgrupado prodAgrupadoAux = this.prodAgrupadoService
					.update(prodAgrupado);
			logger.info("Entity correctly inserted!");
			return prodAgrupadoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param prodAgrupado
	 *            ProdAgrupado
	 * @return ProdAgrupado
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	ProdAgrupado add(@RequestBody ProdAgrupado prodAgrupado) {
		try {
			ProdAgrupado prodAgrupadoAux = this.prodAgrupadoService
					.add(prodAgrupado);
			logger.info("Entity correctly inserted!");
			return prodAgrupadoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param e8codigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{e8codigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String e8codigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			ProdAgrupado prodAgrupado = new ProdAgrupado();
			prodAgrupado.setE8codigo(e8codigo);
			this.prodAgrupadoService.remove(prodAgrupado);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + e8codigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param prodAgrupadoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> prodAgrupadoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<ProdAgrupado> prodAgrupadoList = new ArrayList<ProdAgrupado>();
		try {
			for (ArrayList<String> prodAgrupadoId : prodAgrupadoIds) {
				Iterator<String> iterator = prodAgrupadoId.iterator();
				ProdAgrupado prodAgrupado = new ProdAgrupado();
				prodAgrupado.setE8codigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				prodAgrupadoList.add(prodAgrupado);
			}
			this.prodAgrupadoService.removeMultiple(prodAgrupadoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getProdAgrupadoService'.
	 * 
	 * @return ProdAgrupadoService
	 */
	protected ProdAgrupadoService getProdAgrupadoService() {
		return this.prodAgrupadoService;
	}

	/**
	 * Method 'setProdAgrupadoService'.
	 * 
	 * @param prodAgrupadoService
	 *            ProdAgrupadoService
	 * @return
	 */
	public void setProdAgrupadoService(ProdAgrupadoService prodAgrupadoService) {
		this.prodAgrupadoService = prodAgrupadoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'unBind' ProdMotivo
	 * 
	 * @param e8codigo
	 *            String
	 * @param motivoTircodigo
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindProdMotivo", method = RequestMethod.POST)
	public void unBindProdMotivo(
			@RequestParam(value = "e8codigo", required = false) String e8codigo,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo) {
		ProdAgrupado prodAgrupado = new ProdAgrupado();
		Motivo motivo = new Motivo();
		if (e8codigo != null) {
			prodAgrupado.setE8codigo(e8codigo);
		}
		if (motivoTircodigo != null) {
			motivo.setTircodigo(motivoTircodigo);
		}
		prodAgrupado.getMotivos().add(motivo);
		this.prodAgrupadoService.removeProdMotivo(prodAgrupado);
	}

	/**
	 * Method 'bind' ProdMotivo
	 * 
	 * @param e8codigo
	 *            String
	 * @param motivoTircodigo
	 *            String
	 */
	@RequestMapping(value = "/bindProdMotivo", method = RequestMethod.POST)
	public void bindProdMotivo(
			@RequestParam(value = "e8codigo", required = false) String e8codigo,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo) {
		ProdAgrupado prodAgrupado = new ProdAgrupado();
		Motivo motivo = new Motivo();
		if (e8codigo != null) {
			prodAgrupado.setE8codigo(e8codigo);
		}
		if (motivoTircodigo != null) {
			motivo.setTircodigo(motivoTircodigo);
		}
		prodAgrupado.getMotivos().add(motivo);
		this.prodAgrupadoService.addProdMotivo(prodAgrupado);
	}
}
