package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.FichasSolicitudes;
import com.ejie.y41a.service.FichasSolicitudesService;
import com.ejie.y41a.service.PlantillasFichasSolicitudesService;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.PlantillasFichasSolicitudes;

/**
 * Pantalla de mantenimiento de plantillas para la ficha y la ficha reducida.
 * Permite actualizar o borrar las plantillas asociadas a la ficha y la ficha
 * reducida configuradas para el organismo del usuario conectado.
 * 
 * * PlantillasFichasSolicitudesController generated by UDA, 26-ene-2016
 * 17:53:36.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/fichas")
public class PlantillasFichasSolicitudesController {

	private static final Logger logger = LoggerFactory
			.getLogger(PlantillasFichasSolicitudesController.class);

	@Autowired
	private PlantillasFichasSolicitudesService plantillasFichasSolicitudesService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private FichasSolicitudesService fichasSolicitudesService;

	/**
	 * Method 'getCreateForm'. Navegación a la pantalla de fichas y plantillas
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("fichas", "model", model);
	}

	// /**
	// * Method 'getById'.
	// *
	// * @param pfcodigo
	// * String
	// * @return String
	// */
	// @RequestMapping(value = "/{pfcodigo}", method = RequestMethod.GET)
	// public @ResponseBody()
	// PlantillasFichasSolicitudes getById(@PathVariable String pfcodigo) {
	// try {
	// PlantillasFichasSolicitudes plantillasFichasSolicitudes = new
	// PlantillasFichasSolicitudes();
	// plantillasFichasSolicitudes.setPfcodigo(pfcodigo);
	// plantillasFichasSolicitudes = this.plantillasFichasSolicitudesService
	// .find(plantillasFichasSolicitudes);
	// if (plantillasFichasSolicitudes == null) {
	// throw new Exception(pfcodigo.toString());
	// }
	// return plantillasFichasSolicitudes;
	// } catch (Exception e) {
	// throw new ResourceNotFoundException(pfcodigo.toString());
	// }
	// }

	/**
	 * Method 'getAll'. Obtiene todas las plantillas que cumplan los criterios
	 * de búsqueda
	 * 
	 * @param pfcodigo
	 *            String código de plantilla
	 * @param fichasSolicitudesFicodigo
	 *            String código de ficha
	 * @param pfcoor
	 *            String código de organismo
	 * @param pfnombre
	 *            String nombre de ficha
	 * @param pfultmodificacion
	 *            Date fecha de última modificación
	 * @param pfcontenttypefile
	 *            String content type
	 * @param pfnofile
	 *            String nombre físico del fichero
	 * @param pfsizefile
	 *            Integer tamaño del fichero
	 * @param request
	 *            HttpServletRequest petición HTTP
	 * @return Object de tipo List<PlantillasFichasSolicitudes>
	 */
	@RequestMapping(value = "/getAll", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "pfcodigo", required = false) String pfcodigo,
			@RequestParam(value = "fichasSolicitudesFicodigo", required = false) String fichasSolicitudesFicodigo,
			@RequestParam(value = "pfcoor", required = false) String pfcoor,
			@RequestParam(value = "pfnombre", required = false) String pfnombre,
			@RequestParam(value = "pfultmodificacion", required = false) Date pfultmodificacion,
			@RequestParam(value = "pfcontenttypefile", required = false) String pfcontenttypefile,
			@RequestParam(value = "pfnofile", required = false) String pfnofile,
			@RequestParam(value = "pfsizefile", required = false) Integer pfsizefile,
			HttpServletRequest request) {
		try {
			PlantillasFichasSolicitudes filterPlantillasFichasSolicitudes = new PlantillasFichasSolicitudes(
					pfcodigo, pfcoor, pfnombre, null, pfultmodificacion,
					pfcontenttypefile, pfnofile, pfsizefile,
					new FichasSolicitudes(fichasSolicitudesFicodigo, null,
							null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<PlantillasFichasSolicitudes> plantillasFichasSolicitudess = this.plantillasFichasSolicitudesService
						.findAll(filterPlantillasFichasSolicitudes, pagination);

				if (plantillasFichasSolicitudess == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterPlantillasFichasSolicitudes,
						request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(plantillasFichasSolicitudess);
				return data;
			} else {
				List<PlantillasFichasSolicitudes> plantillasFichasSolicitudess = this.plantillasFichasSolicitudesService
						.findAll(filterPlantillasFichasSolicitudes, pagination);
				if (plantillasFichasSolicitudess == null) {
					throw new Exception("No data Found.");
				}
				return plantillasFichasSolicitudess;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'. Cuenta cuantas plantillas cumplen los criterios de
	 * búsqueda
	 * 
	 * @param filterPlantillasFichasSolicitudes
	 *            PlantillasFichasSolicitudes
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "plantillasFichasSolicitudes", required = false) PlantillasFichasSolicitudes filterPlantillasFichasSolicitudes,
			HttpServletRequest request) {
		try {
			return plantillasFichasSolicitudesService
					.findAllCount(filterPlantillasFichasSolicitudes != null ? filterPlantillasFichasSolicitudes
							: new PlantillasFichasSolicitudes());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAll'. Obtiene todas las fichas del catálogo de fichas para
	 * rellenar el desplegable de tipos de ficha
	 * 
	 * @param ficodigo
	 *            String código de ficha
	 * @param finombre
	 *            String nombre de ficha en castellano
	 * @param finombree
	 *            String nombre de ficha en euskerao
	 * @param request
	 *            HttpServletRequest petición HTTP
	 * @return String
	 */
	@RequestMapping(value = "/getAllFicha", method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "ficodigo", required = false) String ficodigo,
			@RequestParam(value = "finombre", required = false) String finombre,
			@RequestParam(value = "finombree", required = false) String finombree,
			HttpServletRequest request) {
		try {
			FichasSolicitudes filterFichasSolicitudes = new FichasSolicitudes(
					ficodigo, finombre, finombree);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<FichasSolicitudes> fichasSolicitudess = this.fichasSolicitudesService
						.findAll(filterFichasSolicitudes, pagination);

				if (fichasSolicitudess == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.getAllCountFichas(filterFichasSolicitudes,
						request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(fichasSolicitudess);
				return data;
			} else {
				List<FichasSolicitudes> fichasSolicitudess = this.fichasSolicitudesService
						.findAll(filterFichasSolicitudes, pagination);
				if (fichasSolicitudess == null) {
					throw new Exception("No data Found.");
				}
				return fichasSolicitudess;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'. Cuenta cuántas fichas de solicitudes hay en el
	 * catálogo de fichas
	 * 
	 * @param filterFichasSolicitudes
	 *            FichasSolicitudes
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */

	private Long getAllCountFichas(FichasSolicitudes filterFichasSolicitudes,
			HttpServletRequest request) {
		try {
			return this.fichasSolicitudesService
					.findAllCount(filterFichasSolicitudes != null ? filterFichasSolicitudes
							: new FichasSolicitudes());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "../fichas/subePlantilla?R01HNoPortal=true"
				+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put(
				"delete_url",
				"../fichas/subePlantilla?R01HNoPortal=true"
						+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'addDocumentoTramite'. Actualiza el contenido del documento
	 * binario de la plantilla seleccionada. La plantilla se selecciona por
	 * código de tipo de ficha y organismo.
	 * 
	 * @param file
	 *            MultipartFile fichero binario
	 * 
	 * @param response
	 *            HttpServletResponse respuesta HTTP
	 * @param request
	 *            HttpServletRequest petición HTTP
	 * 
	 * @return datos del fichero binario
	 */
	@RequestMapping(value = "subePlantilla", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addDocumentoPlantilla(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			String pfcofi = request.getParameter("pfcodfi");
			String pfcoor = request.getParameter("pfcoor");

			PlantillasFichasSolicitudes plantillasFichasSolicitudes = new PlantillasFichasSolicitudes();
			FichasSolicitudes fichasSolicitudes = new FichasSolicitudes();

			plantillasFichasSolicitudes.setPfcoor(pfcoor);
			fichasSolicitudes.setFicodigo(pfcofi);
			plantillasFichasSolicitudes.setFichasSolicitudes(fichasSolicitudes);
			plantillasFichasSolicitudes.setPfultmodificacion(new Date());

			if (file != null) {
				Blob blob = new SerialBlob(file.getBytes());

				plantillasFichasSolicitudes.setPfplantilla(blob);
				plantillasFichasSolicitudes.setPfnofile(file
						.getOriginalFilename());
				plantillasFichasSolicitudes.setPfnombre(file
						.getOriginalFilename());
				plantillasFichasSolicitudes.setPfcontenttypefile(file
						.getContentType());
				plantillasFichasSolicitudes.setPfsizefile((int) file.getSize());
			}

			PlantillasFichasSolicitudes plantillasFichasSolicitudesAux = this.plantillasFichasSolicitudesService
					.updatePlantilla(plantillasFichasSolicitudes);

			logger.info("Entity correctly update!"
					+ plantillasFichasSolicitudesAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			if (file != null) {
				filesMetaInfo.add(this.getFileReturnMap(file));
			}
			return filesMetaInfo;

		} catch (Exception e) {
			throw new MethodFailureException(
					"Method failed addDocumentoPlantilla");
		}
	}

	/**
	 * Method 'getByIdDocumentoPlantilla'. Obtiene el fichero binario de la
	 * plantilla para su visualización
	 * 
	 * @param pfcodigo
	 *            Long código de plantilla
	 * 
	 * @param response
	 *            HttpServletResponse respuesta HTTP
	 */
	@RequestMapping(value = "file/{pfcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	void getByIdDocumentoPlantilla(@PathVariable String pfcodigo,
			HttpServletResponse response) {
		try {

			PlantillasFichasSolicitudes plantillaFicha = new PlantillasFichasSolicitudes();
			plantillaFicha.setPfcodigo(pfcodigo);

			plantillaFicha = this.plantillasFichasSolicitudesService
					.obtenerDocumentoPlantilla(plantillaFicha);

			if (plantillaFicha == null) {
				throw new Exception(pfcodigo.toString());
			}

			Blob contenido = plantillaFicha.getPfplantilla();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename="
					+ plantillaFicha.getPfnofile() + "");
			response.setContentType(plantillaFicha.getPfcontenttypefile());
			response.setContentLength(plantillaFicha.getPfsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			throw new ResourceNotFoundException(pfcodigo.toString());
		}
	}

	/**
	 * Method 'getFichasSolicitudesService'.
	 * 
	 * @return FichasSolicitudesService
	 */
	protected FichasSolicitudesService getFichasSolicitudesService() {
		return this.fichasSolicitudesService;
	}

	/**
	 * Method 'setFichasSolicitudesService'.
	 * 
	 * @param fichasSolicitudesService
	 *            FichasSolicitudesService
	 * @return
	 */
	public void setFichasSolicitudesService(
			FichasSolicitudesService fichasSolicitudesService) {
		this.fichasSolicitudesService = fichasSolicitudesService;
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getPlantillasFichasSolicitudesService'.
	 * 
	 * @return PlantillasFichasSolicitudesService
	 */
	protected PlantillasFichasSolicitudesService getPlantillasFichasSolicitudesService() {
		return this.plantillasFichasSolicitudesService;
	}

	/**
	 * Method 'setPlantillasFichasSolicitudesService'.
	 * 
	 * @param plantillasFichasSolicitudesService
	 *            PlantillasFichasSolicitudesService
	 * @return
	 */
	public void setPlantillasFichasSolicitudesService(
			PlantillasFichasSolicitudesService plantillasFichasSolicitudesService) {
		this.plantillasFichasSolicitudesService = plantillasFichasSolicitudesService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
