package com.ejie.y41a.control;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Inspecciones;
import com.ejie.y41a.model.PlantillaIns;
import com.ejie.y41a.model.PlantillaInsBusqueda;
import com.ejie.y41a.service.PlantillaInsService;

/**
 * * PlantillaInsController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/plantillains")
public class PlantillaInsController {

	private static final Logger logger = LoggerFactory
			.getLogger(PlantillaInsController.class);

	@Autowired
	private PlantillaInsService plantillaInsService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("plantillains", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param plinscodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{plinscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	PlantillaIns getById(@PathVariable String plinscodigo) {
		try {
			PlantillaIns plantillaIns = new PlantillaIns();
			plantillaIns.setPlinscodigo(plinscodigo);
			plantillaIns = this.plantillaInsService.find(plantillaIns);
			if (plantillaIns == null) {
				throw new Exception(plinscodigo.toString());
			}
			return plantillaIns;
		} catch (Exception e) {
			throw new ResourceNotFoundException(plinscodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param plinscodigo
	 *            String
	 * @param inspeccionesInscodcarta
	 *            String
	 * @param plinscoor
	 *            String
	 * @param plinsnombre
	 *            String
	 * @param plinscontenttypefile
	 *            String
	 * @param plinsnofile
	 *            String
	 * @param plinssizefile
	 *            Integer
	 * @param plinsultmodificacion
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "plinscodigo", required = false) String plinscodigo,
			@RequestParam(value = "inspeccionesInscodcarta", required = false) String inspeccionesInscodcarta,
			@RequestParam(value = "plinscoor", required = false) String plinscoor,
			@RequestParam(value = "plinsnombre", required = false) String plinsnombre,
			@RequestParam(value = "plinscontenttypefile", required = false) String plinscontenttypefile,
			@RequestParam(value = "plinsnofile", required = false) String plinsnofile,
			@RequestParam(value = "plinssizefile", required = false) Integer plinssizefile,
			@RequestParam(value = "plinsultmodificacion", required = false) Date plinsultmodificacion,
			HttpServletRequest request) {
		try {
			PlantillaIns filterPlantillaIns = new PlantillaIns(plinscodigo,
					plinscoor, plinsnombre, null, plinscontenttypefile,
					plinsnofile, plinssizefile, plinsultmodificacion,
					new Inspecciones(inspeccionesInscodcarta, null, null, null,
							null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<PlantillaIns> plantillaInss = this.plantillaInsService
						.findAll(filterPlantillaIns, pagination);

				if (plantillaInss == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterPlantillaIns, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(plantillaInss);
				return data;
			} else {
				List<PlantillaIns> plantillaInss = this.plantillaInsService
						.findAll(filterPlantillaIns, pagination);
				if (plantillaInss == null) {
					throw new Exception("No data Found.");
				}
				return plantillaInss;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllInspeccion'.
	 * 
	 * @param plinscodigo
	 *            String
	 * @param inscodcarta
	 *            String
	 * @param insnombre
	 *            String
	 * @param insnombree
	 *            String
	 * @param insbaja
	 *            Date
	 * @param plinscoor
	 *            String
	 * @param plinsnombre
	 *            String
	 * @param plinsplantilla
	 *            Blob
	 * @param plinscontenttypefile
	 *            String
	 * @param plinsnofile
	 *            String
	 * @param plinssizefile
	 *            Integer
	 * @param plinsultmodificacion
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllInspeccion", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllInspeccion(
			@RequestParam(value = "plinscodigo", required = false) String plinscodigo,
			@RequestParam(value = "inscodcarta", required = false) String inscodcarta,
			@RequestParam(value = "insnombre", required = false) String insnombre,
			@RequestParam(value = "insnombree", required = false) String insnombree,
			@RequestParam(value = "insbaja", required = false) Date insbaja,
			@RequestParam(value = "plinscoor", required = false) String plinscoor,
			@RequestParam(value = "plinsnombre", required = false) String plinsnombre,
			@RequestParam(value = "plinsplantilla", required = false) Blob plinsplantilla,
			@RequestParam(value = "plinscontenttypefile", required = false) String plinscontenttypefile,
			@RequestParam(value = "plinsnofile", required = false) String plinsnofile,
			@RequestParam(value = "plinssizefile", required = false) Integer plinssizefile,
			@RequestParam(value = "plinsultmodificacion", required = false) Date plinsultmodificacion,
			HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			PlantillaIns filterPlantillaIns = new PlantillaIns(plinscodigo,
					censoMonitor.getOrganismo().getCodOrg(), plinsnombre,
					plinsplantilla, plinscontenttypefile, plinsnofile,
					plinssizefile, plinsultmodificacion, new Inspecciones(
							inscodcarta, insnombre, insnombree, insbaja));

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<PlantillaInsBusqueda> plantillaInsBusqueda = this.plantillaInsService
						.findAllPlantillaIns(filterPlantillaIns, pagination);

				if (plantillaInsBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountInspeccion(filterPlantillaIns, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(plantillaInsBusqueda);
				return data;
			} else {
				List<PlantillaInsBusqueda> plantillaInsBusqueda = this.plantillaInsService
						.findAllPlantillaIns(filterPlantillaIns, pagination);
				if (plantillaInsBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return plantillaInsBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountInspeccion'.
	 * 
	 * @param filterPlantillaIns
	 *            PlantillaIns
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountInspeccion(
			@RequestParam(value = "plantillaIns", required = false) PlantillaIns filterPlantillaIns,
			HttpServletRequest request) {
		try {
			return plantillaInsService
					.findAllCountInspeccion(filterPlantillaIns != null ? filterPlantillaIns
							: new PlantillaIns());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterPlantillaIns
	 *            PlantillaIns
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "plantillaIns", required = false) PlantillaIns filterPlantillaIns,
			HttpServletRequest request) {
		try {
			return plantillaInsService
					.findAllCount(filterPlantillaIns != null ? filterPlantillaIns
							: new PlantillaIns());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @param response
	 *            HttpServletResponse
	 * @return PlantillaIns
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	PlantillaIns edit(@RequestBody PlantillaIns plantillaIns,
			HttpServletResponse response) {
		try {
			PlantillaIns plantillaInsAux = this.plantillaInsService
					.update(plantillaIns);
			logger.info("Entity correctly inserted!");
			return plantillaInsAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param plantillaIns
	 *            PlantillaIns
	 * @return PlantillaIns
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	PlantillaIns add(@RequestBody PlantillaIns plantillaIns) {
		try {
			PlantillaIns plantillaInsAux = this.plantillaInsService
					.add(plantillaIns);
			logger.info("Entity correctly inserted!");
			return plantillaInsAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param plinscodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{plinscodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String plinscodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			PlantillaIns plantillaIns = new PlantillaIns();
			plantillaIns.setPlinscodigo(plinscodigo);
			this.plantillaInsService.remove(plantillaIns);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + plinscodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param plantillaInsIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> plantillaInsIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<PlantillaIns> plantillaInsList = new ArrayList<PlantillaIns>();
		try {
			for (ArrayList<String> plantillaInsId : plantillaInsIds) {
				Iterator<String> iterator = plantillaInsId.iterator();
				PlantillaIns plantillaIns = new PlantillaIns();
				plantillaIns.setPlinscodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				plantillaInsList.add(plantillaIns);
			}
			this.plantillaInsService.removeMultiple(plantillaInsList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getPlantillaInsService'.
	 * 
	 * @return PlantillaInsService
	 */
	protected PlantillaInsService getPlantillaInsService() {
		return this.plantillaInsService;
	}

	/**
	 * Method 'setPlantillaInsService'.
	 * 
	 * @param plantillaInsService
	 *            PlantillaInsService
	 * @return
	 */
	public void setPlantillaInsService(PlantillaInsService plantillaInsService) {
		this.plantillaInsService = plantillaInsService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'getByIdDocumentoInspeccionDetalle'.
	 * 
	 * @param cofile
	 *            Long
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "inspeccionfile/{cofile}", method = RequestMethod.GET)
	public @ResponseBody
	void getByIdDocumentoInspeccionDetalle(@PathVariable String cofile,
			HttpServletResponse response) {
		try {

			PlantillaIns plantillaIns = new PlantillaIns();
			plantillaIns.setPlinscodigo(cofile);

			plantillaIns = this.plantillaInsService
					.obtenerDocumentoPlantilla(plantillaIns);

			if (plantillaIns == null) {
				throw new Exception(cofile.toString());
			}

			Blob contenido = plantillaIns.getPlinsplantilla();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename="
					+ plantillaIns.getPlinsnofile() + "");
			response.setContentType(plantillaIns.getPlinscontenttypefile());
			response.setContentLength(plantillaIns.getPlinssizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

			// return documentoConsultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cofile.toString());
		}
	}

	/**
	 * Method 'addDocumentoInspeccion'.
	 * 
	 * @param file
	 *            MultipartFile
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "subidaInspeccion", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addDocumentoInspeccion(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			String inscodcarta = request.getParameter("inscodcarta");
			String plinscoor = request.getParameter("plinscoor");

			PlantillaIns plantillaIns = new PlantillaIns();
			Inspecciones inspecciones = new Inspecciones();

			plantillaIns.setPlinscoor(plinscoor);
			inspecciones.setInscodcarta(inscodcarta);
			plantillaIns.setInspecciones(inspecciones);
			plantillaIns.setPlinsultmodificacion(new Date());

			if (file != null) {
				Blob blob = new SerialBlob(file.getBytes());

				plantillaIns.setPlinsplantilla(blob);
				plantillaIns.setPlinsnofile(file.getOriginalFilename());
				plantillaIns.setPlinsnombre(file.getOriginalFilename());
				plantillaIns.setPlinscontenttypefile(file.getContentType());
				plantillaIns.setPlinssizefile((int) file.getSize());
			}

			PlantillaIns plantillaInsAux = this.plantillaInsService
					.updatePlantilla(plantillaIns);

			logger.info("Entity correctly update!" + plantillaInsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			if (file != null) {
				filesMetaInfo.add(this.getFileReturnMap(file));
			}
			return filesMetaInfo;

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed addDocumentoConsultaDetalle");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put(
				"url",
				"../plantillains/subidaInspeccion/"
						+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "../plantillains/subidaInspeccion/"
				+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/********************************************************/
	/**
	 * Method 'addDocumentoInspeccionAll'.
	 * 
	 * @param file
	 *            MultipartFile
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "subidaInspeccionAll", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addDocumentoInspeccionAll(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			String inscodcarta = request.getParameter("inscodcarta");
			String plinscoor = request.getParameter("plinscoor");

			PlantillaIns plantillaIns = new PlantillaIns();
			Inspecciones inspecciones = new Inspecciones();

			plantillaIns.setPlinscoor(plinscoor);
			inspecciones.setInscodcarta(inscodcarta);
			plantillaIns.setInspecciones(inspecciones);
			plantillaIns.setPlinsultmodificacion(new Date());

			if (file != null) {
				Blob blob = new SerialBlob(file.getBytes());

				plantillaIns.setPlinsplantilla(blob);
				plantillaIns.setPlinsnofile(file.getOriginalFilename());
				plantillaIns.setPlinsnombre(file.getOriginalFilename());
				plantillaIns.setPlinscontenttypefile(file.getContentType());
				plantillaIns.setPlinssizefile((int) file.getSize());
			}

			PlantillaIns plantillaInsAux = this.plantillaInsService
					.updatePlantillaTodosOrganismos(plantillaIns);

			logger.info("Entity correctly update!" + plantillaInsAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			if (file != null) {
				filesMetaInfo.add(this.getFileReturnMapAll(file));
			}
			return filesMetaInfo;

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed addDocumentoConsultaDetalle");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMapAll(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put(
				"url",
				"../plantillains/subidaInspeccionAll/"
						+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "../plantillains/subidaInspeccionAll/"
				+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/*******************************************************/
}
