package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Decision;
import com.ejie.y41a.model.PlantillaDecisionBusqueda;
import com.ejie.y41a.service.PlantillaDecisionService;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.PlantillaDecision;

/**
 * * PlantillaDecisionController generated by UDA, 05-mar-2012 9:11:48.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/plantilladecision")
public class PlantillaDecisionController {

	private static final Logger logger = LoggerFactory
			.getLogger(PlantillaDecisionController.class);

	@Autowired
	private PlantillaDecisionService plantillaDecisionService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("plantilladecision", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param pdcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{pdcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	PlantillaDecision getById(@PathVariable String pdcodigo) {
		try {
			PlantillaDecision plantillaDecision = new PlantillaDecision();
			plantillaDecision.setPdcodigo(pdcodigo);
			plantillaDecision = this.plantillaDecisionService
					.find(plantillaDecision);
			if (plantillaDecision == null) {
				throw new Exception(pdcodigo.toString());
			}
			return plantillaDecision;
		} catch (Exception e) {
			throw new ResourceNotFoundException(pdcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param pdcodigo
	 *            String
	 * @param decisionDecodigo
	 *            String
	 * @param pdcoor
	 *            String
	 * @param pdnombre
	 *            String
	 * @param pdnombree
	 *            String
	 * @param pdultmodificacion
	 *            Date
	 * @param pdcontenttypefile
	 *            String
	 * @param pdnofile
	 *            String
	 * @param pdsizefile
	 *            Integer
	 * @param pdcontenttypefilee
	 *            String
	 * @param pdnofilee
	 *            String
	 * @param pdsizefilee
	 *            Integer
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "pdcodigo", required = false) String pdcodigo,
			@RequestParam(value = "decisionDecodigo", required = false) String decisionDecodigo,
			@RequestParam(value = "pdcoor", required = false) String pdcoor,
			@RequestParam(value = "pdnombre", required = false) String pdnombre,
			@RequestParam(value = "pdnombree", required = false) String pdnombree,
			@RequestParam(value = "pdultmodificacion", required = false) Date pdultmodificacion,
			@RequestParam(value = "pdcontenttypefile", required = false) String pdcontenttypefile,
			@RequestParam(value = "pdnofile", required = false) String pdnofile,
			@RequestParam(value = "pdsizefile", required = false) Integer pdsizefile,
			@RequestParam(value = "pdcontenttypefilee", required = false) String pdcontenttypefilee,
			@RequestParam(value = "pdnofilee", required = false) String pdnofilee,
			@RequestParam(value = "pdsizefilee", required = false) Integer pdsizefilee,
			HttpServletRequest request) {
		try {
			PlantillaDecision filterPlantillaDecision = new PlantillaDecision(
					pdcodigo, pdcoor, pdnombre, pdnombree, null, null,
					pdultmodificacion, pdcontenttypefile, pdnofile, pdsizefile,
					pdcontenttypefilee, pdnofilee, pdsizefilee, new Decision(
							decisionDecodigo, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<PlantillaDecision> plantillaDecisions = this.plantillaDecisionService
						.findAll(filterPlantillaDecision, pagination);

				if (plantillaDecisions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterPlantillaDecision, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(plantillaDecisions);
				return data;
			} else {
				List<PlantillaDecision> plantillaDecisions = this.plantillaDecisionService
						.findAll(filterPlantillaDecision, pagination);
				if (plantillaDecisions == null) {
					throw new Exception("No data Found.");
				}
				return plantillaDecisions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterPlantillaDecision
	 *            PlantillaDecision
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "plantillaDecision", required = false) PlantillaDecision filterPlantillaDecision,
			HttpServletRequest request) {
		try {
			return plantillaDecisionService
					.findAllCount(filterPlantillaDecision != null ? filterPlantillaDecision
							: new PlantillaDecision());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllDecision'.
	 * 
	 * @param pdcodigo
	 *            String
	 * @param decodigo
	 *            String
	 * @param denombre
	 *            String
	 * @param denombree
	 *            String
	 * @param debaja
	 *            Date
	 * @param pdcoor
	 *            String
	 * @param pdnombre
	 *            String
	 * @param pdnombree
	 *            String
	 * @param pdplantilla
	 *            String
	 * @param pdplantillae
	 *            String
	 * @param pdultmodificacion
	 *            Date
	 * @param pdcontenttypefile
	 *            String
	 * @param pdnofile
	 *            String
	 * @param pdsizefile
	 *            Integer
	 * @param pdcontenttypefilee
	 *            String
	 * @param pdnofilee
	 *            String
	 * @param pdsizefilee
	 *            Integer
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/getAllDecision", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllDecision(
			@RequestParam(value = "pdcodigo", required = false) String pdcodigo,
			@RequestParam(value = "decodigo", required = false) String decodigo,
			@RequestParam(value = "denombre", required = false) String denombre,
			@RequestParam(value = "denombree", required = false) String denombree,
			@RequestParam(value = "debaja", required = false) Date debaja,
			@RequestParam(value = "pdcoor", required = false) String pdcoor,
			@RequestParam(value = "pdnombre", required = false) String pdnombre,
			@RequestParam(value = "pdnombree", required = false) String pdnombree,
			@RequestParam(value = "pdplantilla", required = false) Blob pdplantilla,
			@RequestParam(value = "pdplantillae", required = false) Blob pdplantillae,
			@RequestParam(value = "pdultmodificacion", required = false) Date pdultmodificacion,
			@RequestParam(value = "pdcontenttypefile", required = false) String pdcontenttypefile,
			@RequestParam(value = "pdnofile", required = false) String pdnofile,
			@RequestParam(value = "pdsizefile", required = false) Integer pdsizefile,
			@RequestParam(value = "pdcontenttypefilee", required = false) String pdcontenttypefilee,
			@RequestParam(value = "pdnofilee", required = false) String pdnofilee,
			@RequestParam(value = "pdsizefilee", required = false) Integer pdsizefilee,
			HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			PlantillaDecision filterPlantillaDecision = new PlantillaDecision(
					pdcodigo, censoMonitor.getOrganismo().getCodOrg(),
					pdnombre, pdnombree, pdplantilla, pdplantillae,
					pdultmodificacion, pdcontenttypefile, pdnofile, pdsizefile,
					pdcontenttypefilee, pdnofilee, pdsizefilee, new Decision(
							decodigo, denombre, denombree, debaja));

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<PlantillaDecisionBusqueda> plantillaDecisionBusqueda = this.plantillaDecisionService
						.findAllPlantillaDecision(filterPlantillaDecision,
								pagination);

				if (plantillaDecisionBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountDecision(filterPlantillaDecision,
						request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(plantillaDecisionBusqueda);
				return data;
			} else {
				List<PlantillaDecisionBusqueda> plantillaDecisionBusqueda = this.plantillaDecisionService
						.findAllPlantillaDecision(filterPlantillaDecision,
								pagination);
				if (plantillaDecisionBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return plantillaDecisionBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountDecision'.
	 * 
	 * @param filterPlantillaDecision
	 *            PlantillaTramite
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountDecision(
			@RequestParam(value = "plantillaTramite", required = false) PlantillaDecision filterPlantillaDecision,
			HttpServletRequest request) {
		try {
			return plantillaDecisionService
					.findAllPlantillaDecisionCount(filterPlantillaDecision != null ? filterPlantillaDecision
							: new PlantillaDecision());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @param response
	 *            HttpServletResponse
	 * @return PlantillaDecision
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	PlantillaDecision edit(@RequestBody PlantillaDecision plantillaDecision,
			HttpServletResponse response) {
		try {
			PlantillaDecision plantillaDecisionAux = this.plantillaDecisionService
					.update(plantillaDecision);
			logger.info("Entity correctly inserted!");
			return plantillaDecisionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param plantillaDecision
	 *            PlantillaDecision
	 * @return PlantillaDecision
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	PlantillaDecision add(@RequestBody PlantillaDecision plantillaDecision) {
		try {
			PlantillaDecision plantillaDecisionAux = this.plantillaDecisionService
					.add(plantillaDecision);
			logger.info("Entity correctly inserted!");
			return plantillaDecisionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param pdcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeDecision/{pdcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String pdcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			PlantillaDecision plantillaDecision = new PlantillaDecision();
			plantillaDecision.setPdcodigo(pdcodigo);
			this.plantillaDecisionService.remove(plantillaDecision);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + pdcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param plantillaDecisionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> plantillaDecisionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<PlantillaDecision> plantillaDecisionList = new ArrayList<PlantillaDecision>();
		try {
			for (ArrayList<String> plantillaDecisionId : plantillaDecisionIds) {
				Iterator<String> iterator = plantillaDecisionId.iterator();
				PlantillaDecision plantillaDecision = new PlantillaDecision();
				plantillaDecision.setPdcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				plantillaDecisionList.add(plantillaDecision);
			}
			this.plantillaDecisionService.removeMultiple(plantillaDecisionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getPlantillaDecisionService'.
	 * 
	 * @return PlantillaDecisionService
	 */
	protected PlantillaDecisionService getPlantillaDecisionService() {
		return this.plantillaDecisionService;
	}

	/**
	 * Method 'setPlantillaDecisionService'.
	 * 
	 * @param plantillaDecisionService
	 *            PlantillaDecisionService
	 * @return
	 */
	public void setPlantillaDecisionService(
			PlantillaDecisionService plantillaDecisionService) {
		this.plantillaDecisionService = plantillaDecisionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'addDocumentoDecision'.
	 * 
	 * @param file
	 *            MultipartFile
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "subidaDecision", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addDocumentoDecision(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			String decodigo = request.getParameter("decodigo");
			String pdcoor = request.getParameter("pdcoor");

			PlantillaDecision plantillaDecision = new PlantillaDecision();
			Decision decision = new Decision();

			plantillaDecision.setPdcoor(pdcoor);
			decision.setDecodigo(decodigo);
			plantillaDecision.setDecision(decision);
			plantillaDecision.setPdultmodificacion(new Date());

			if (file != null) {
				Blob blob = new SerialBlob(file.getBytes());

				plantillaDecision.setPdplantilla(blob);
				plantillaDecision.setPdnofile(file.getOriginalFilename());
				plantillaDecision.setPdnombre(file.getOriginalFilename());
				plantillaDecision.setPdcontenttypefile(file.getContentType());
				plantillaDecision.setPdsizefile((int) file.getSize());
			}

			PlantillaDecision plantillaDecisionAux = this.plantillaDecisionService
					.updateDecision(plantillaDecision);

			logger.info("Entity correctly update!" + plantillaDecisionAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			if (file != null) {
				filesMetaInfo.add(this.getFileReturnMap(file));
			}
			return filesMetaInfo;

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed addDocumentoDecision");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put(
				"url",
				"../plantilladecision/subidaDecision?R01HNoPortal=true"
						+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put(
				"delete_url",
				"../plantilladecision/subidaDecision?R01HNoPortal=true"
						+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**************************************************************/
	/**
	 * Method 'addDocumentoDecision'.
	 * 
	 * @param file
	 *            MultipartFile
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return ConsultaFile
	 */
	@RequestMapping(value = "subidaDecisionAll", method = RequestMethod.POST)
	public @ResponseBody
	List<Map<String, Object>> addDocumentoDecisionAll(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			String decodigo = request.getParameter("decodigo");
			String pdcoor = request.getParameter("pdcoor");

			PlantillaDecision plantillaDecision = new PlantillaDecision();
			Decision decision = new Decision();

			plantillaDecision.setPdcoor(pdcoor);
			decision.setDecodigo(decodigo);
			plantillaDecision.setDecision(decision);
			plantillaDecision.setPdultmodificacion(new Date());

			if (file != null) {
				Blob blob = new SerialBlob(file.getBytes());

				plantillaDecision.setPdplantilla(blob);
				plantillaDecision.setPdnofile(file.getOriginalFilename());
				plantillaDecision.setPdnombre(file.getOriginalFilename());
				plantillaDecision.setPdcontenttypefile(file.getContentType());
				plantillaDecision.setPdsizefile((int) file.getSize());
			}

			PlantillaDecision plantillaDecisionAux = this.plantillaDecisionService
					.updateDecisionTodosOrganismos(plantillaDecision);

			logger.info("Entity correctly update!" + plantillaDecisionAux);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			if (file != null) {
				filesMetaInfo.add(this.getFileReturnMapAll(file));
			}
			return filesMetaInfo;

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed addDocumentoDecision");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMapAll(MultipartFile file) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url",
				"../plantilladecision/subidaDecisionAll?R01HNoPortal=true"
						+ file.getOriginalFilename());
		mapaRetorno.put("name", file.getOriginalFilename());
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url",
				"../plantilladecision/subidaDecisionAll?R01HNoPortal=true"
						+ file.getOriginalFilename());
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**************************************************************/

	/**
	 * Method 'getByIdDocumentoDecisionDetalle'.
	 * 
	 * @param cofile
	 *            Long
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "decisionfile/{cofile}", method = RequestMethod.GET)
	public @ResponseBody
	void getByIdDocumentoDecisionDetalle(@PathVariable String cofile,
			HttpServletResponse response) {
		try {

			PlantillaDecision plantillaDecision = new PlantillaDecision();
			plantillaDecision.setPdcodigo(cofile);

			plantillaDecision = this.plantillaDecisionService
					.obtenerDocumentoPlantilla(plantillaDecision);

			if (plantillaDecision == null) {
				throw new Exception(cofile.toString());
			}

			Blob contenido = plantillaDecision.getPdplantilla();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename="
					+ plantillaDecision.getPdnofile() + "");
			response.setContentType(plantillaDecision.getPdcontenttypefile());
			response.setContentLength(plantillaDecision.getPdsizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

			// return documentoConsultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cofile.toString());
		}
	}

}
