package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.PaisService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Pais;

/**
 *  * PaisController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/pais")

public class PaisController  {

	private static final Logger logger = LoggerFactory.getLogger(PaisController.class);

	@Autowired
	private PaisService paisService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("pais", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  pacodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{pacodigo}", method = RequestMethod.GET)
	public @ResponseBody Pais getById(@PathVariable String pacodigo) {
		try{
            Pais pais = new Pais();
			pais.setPacodigo(pacodigo);
            pais = this.paisService.find(pais);
            if (pais == null) {
                throw new Exception(pacodigo.toString());
            }
            return pais;
		}catch (Exception e){
		    throw new ResourceNotFoundException(pacodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  pacodigo String
	 *@param	  pacoal2 String
	 *@param	  pacoal3 String
	 *@param	  panombre String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "pacodigo", required = false) String pacodigo,
	@RequestParam(value = "pacoal2", required = false) String pacoal2,
	@RequestParam(value = "pacoal3", required = false) String pacoal3,
	@RequestParam(value = "panombre", required = false) String panombre,
			HttpServletRequest request) {
			try{
				Pais filterPais = new Pais(pacodigo, pacoal2, pacoal3, panombre);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<Pais> paiss =  this.paisService.findAll(filterPais, pagination);

     			    if (paiss == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterPais, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(paiss);
				    return data;
				}else{
				    List<Pais> paiss =  this.paisService.findAll(filterPais, pagination);
					if (paiss == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return paiss;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterPais Pais 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "pais", required = false) Pais  filterPais, HttpServletRequest request) {
	    try {
			return paisService
					.findAllCount(filterPais != null ? filterPais
							: new Pais ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param pais Pais 
	 * @param response HttpServletResponse
	 * @return Pais
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Pais edit(@RequestBody Pais pais, HttpServletResponse response) {		
		try {
            Pais paisAux  = this.paisService.update(pais);
			logger.info("Entity correctly inserted!");
            return paisAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param pais Pais 
	 * @return Pais
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Pais add(@RequestBody Pais pais) {		
        try {
            Pais paisAux = this.paisService.add(pais);
            logger.info("Entity correctly inserted!");
        	return paisAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  pacodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{pacodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String pacodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            Pais pais = new Pais();
            pais.setPacodigo(pacodigo);
            this.paisService.remove(pais);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  pacodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  paisIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> paisIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<Pais> paisList = new ArrayList<Pais>();
        try{		    
            for (ArrayList<String> paisId:paisIds) {
			    Iterator<String> iterator = paisId.iterator();
				    Pais pais = new Pais();
			        pais.setPacodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    paisList.add(pais);
		    }
            this.paisService.removeMultiple(paisList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getPaisService'.
	 *
	 * @return PaisService
	 */
	protected PaisService getPaisService() {
		return this.paisService;
	}

	/**
	 * Method 'setPaisService'.
	 *
	 * @param paisService  PaisService
	 * @return
	 */
	public void setPaisService(PaisService paisService) {
		this.paisService = paisService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
