package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.OriProdAlertaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.OriProdAlerta;

/**
 *  * OriProdAlertaController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/oriprodalerta")

public class OriProdAlertaController  {

	private static final Logger logger = LoggerFactory.getLogger(OriProdAlertaController.class);

	@Autowired
	private OriProdAlertaService oriProdAlertaService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("oriprodalerta", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  tomcodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{tomcodigo}", method = RequestMethod.GET)
	public @ResponseBody OriProdAlerta getById(@PathVariable String tomcodigo) {
		try{
            OriProdAlerta oriProdAlerta = new OriProdAlerta();
			oriProdAlerta.setTomcodigo(tomcodigo);
            oriProdAlerta = this.oriProdAlertaService.find(oriProdAlerta);
            if (oriProdAlerta == null) {
                throw new Exception(tomcodigo.toString());
            }
            return oriProdAlerta;
		}catch (Exception e){
		    throw new ResourceNotFoundException(tomcodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  tomcodigo String
	 *@param	  tomnombre String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "tomcodigo", required = false) String tomcodigo,
	@RequestParam(value = "tomnombre", required = false) String tomnombre,
			HttpServletRequest request) {
			try{
				OriProdAlerta filterOriProdAlerta = new OriProdAlerta(tomcodigo, tomnombre);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<OriProdAlerta> oriProdAlertas =  this.oriProdAlertaService.findAll(filterOriProdAlerta, pagination);

     			    if (oriProdAlertas == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterOriProdAlerta, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(oriProdAlertas);
				    return data;
				}else{
				    List<OriProdAlerta> oriProdAlertas =  this.oriProdAlertaService.findAll(filterOriProdAlerta, pagination);
					if (oriProdAlertas == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return oriProdAlertas;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterOriProdAlerta OriProdAlerta 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "oriProdAlerta", required = false) OriProdAlerta  filterOriProdAlerta, HttpServletRequest request) {
	    try {
			return oriProdAlertaService
					.findAllCount(filterOriProdAlerta != null ? filterOriProdAlerta
							: new OriProdAlerta ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param oriProdAlerta OriProdAlerta 
	 * @param response HttpServletResponse
	 * @return OriProdAlerta
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody OriProdAlerta edit(@RequestBody OriProdAlerta oriProdAlerta, HttpServletResponse response) {		
		try {
            OriProdAlerta oriProdAlertaAux  = this.oriProdAlertaService.update(oriProdAlerta);
			logger.info("Entity correctly inserted!");
            return oriProdAlertaAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param oriProdAlerta OriProdAlerta 
	 * @return OriProdAlerta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody OriProdAlerta add(@RequestBody OriProdAlerta oriProdAlerta) {		
        try {
            OriProdAlerta oriProdAlertaAux = this.oriProdAlertaService.add(oriProdAlerta);
            logger.info("Entity correctly inserted!");
        	return oriProdAlertaAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  tomcodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{tomcodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String tomcodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            OriProdAlerta oriProdAlerta = new OriProdAlerta();
            oriProdAlerta.setTomcodigo(tomcodigo);
            this.oriProdAlertaService.remove(oriProdAlerta);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  tomcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  oriProdAlertaIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> oriProdAlertaIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<OriProdAlerta> oriProdAlertaList = new ArrayList<OriProdAlerta>();
        try{		    
            for (ArrayList<String> oriProdAlertaId:oriProdAlertaIds) {
			    Iterator<String> iterator = oriProdAlertaId.iterator();
				    OriProdAlerta oriProdAlerta = new OriProdAlerta();
			        oriProdAlerta.setTomcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    oriProdAlertaList.add(oriProdAlerta);
		    }
            this.oriProdAlertaService.removeMultiple(oriProdAlertaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getOriProdAlertaService'.
	 *
	 * @return OriProdAlertaService
	 */
	protected OriProdAlertaService getOriProdAlertaService() {
		return this.oriProdAlertaService;
	}

	/**
	 * Method 'setOriProdAlertaService'.
	 *
	 * @param oriProdAlertaService  OriProdAlertaService
	 * @return
	 */
	public void setOriProdAlertaService(OriProdAlertaService oriProdAlertaService) {
		this.oriProdAlertaService = oriProdAlertaService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
