package com.ejie.y41a.control;

import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.Ooee;
import com.ejie.y41a.service.OoeeService;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * OoeeController generated by UDA, 23-nov-2016 12:18:31.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/ooee")
public class OoeeController {

	private static final Logger logger = LoggerFactory
			.getLogger(OoeeController.class);

	@Autowired()
	private OoeeService ooeeService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "seleccionOoee", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41bVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41bVistaWar.default.layout"));

		model.addAttribute("modoBusquedaOoee",
				Y41aConstantes.MODO_POPUP_SELECCION);

		return new ModelAndView("ooeeSeleccion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param oecodigo
	 *            String
	 * @return ooee Ooee
	 */
	@RequestMapping(value = "/getById/{oecodigo}", method = RequestMethod.GET)
	public @ResponseBody()
	Ooee getById(@PathVariable() String oecodigo) {
		try {
			Ooee ooee = new Ooee();
			ooee.setOecodigo(oecodigo);
			ooee = this.ooeeService.find(ooee);
			OoeeController.logger
					.info("[GET - findBy_PK] : Obtener Ooee por PK");
			if (ooee == null) {
				throw new Exception(oecodigo.toString());
			}
			return ooee;
		} catch (Exception e) {
			throw new ResourceNotFoundException(oecodigo.toString());
		}

	}

	/**
	 * Method 'getAllJQGrid'.
	 * 
	 * @param filterOoee
	 *            Ooee
	 * @param request
	 *            HttpServletRequest
	 * @return JQGridJSONModel
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET, headers = { "JQGridModel=true" })
	public @ResponseBody()
	JQGridJSONModel getAllJQGrid(@ModelAttribute() Ooee filterOoee,
			HttpServletRequest request) {

		if (!Y41aUtils.esNullOCadenaVacia(filterOoee.getOenombre())) {
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();
			if (Y41aConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				filterOoee.getOrganismo().setNombreEs(filterOoee.getOenombre());
			} else if (Y41aConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
				filterOoee.getOrganismo().setNombreEu(filterOoee.getOenombre());
			}
		}
		Pagination pagination = null;
		pagination = new Pagination();
		pagination.setPage(Long.valueOf(request.getParameter("page")));
		pagination.setRows(Long.valueOf(request.getParameter("rows")));
		pagination.setSort(request.getParameter("sidx"));
		pagination.setAscDsc(request.getParameter("sord"));

		List<Ooee> ooees = this.ooeeService.findAllBusqueda(filterOoee,
				pagination);
		Long recordNum = this.ooeeService.findAllBusquedaCount(filterOoee);
		OoeeController.logger.info("[GET - jqGrid] : Obtener Ooee");

		JQGridJSONModel data = new JQGridJSONModel();
		data.setPage(request.getParameter("page"));
		data.setRecords(recordNum.intValue());
		data.setTotal(recordNum, pagination.getRows());
		data.setRows(ooees);
		return data;
	}

}
