/**
 * 
 */
package com.ejie.y41a.control;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.T17Calle;
import com.ejie.y41a.model.T17Localidad;
import com.ejie.y41a.model.T17Municipio;
import com.ejie.y41a.model.T17Pais;
import com.ejie.y41a.model.T17Portal;
import com.ejie.y41a.model.T17Provincia;
import com.ejie.y41a.model.T17TipoVia;
import com.ejie.y41a.service.T17CalleService;
import com.ejie.y41a.service.T17LocalidadService;
import com.ejie.y41a.service.T17MunicipioService;
import com.ejie.y41a.service.T17PaisService;
import com.ejie.y41a.service.T17PortalService;
import com.ejie.y41a.service.T17ProvinciaService;
import com.ejie.y41a.service.T17TipoViaService;

/**
 *  
 * 
 */
@Controller
@RequestMapping(value = "/nora")
public class NoraController {

	private static final Logger logger = LoggerFactory
			.getLogger(NoraController.class);

	@Autowired()
	private Properties appConfiguration;

	@Autowired()
	private T17PaisService paisService;

	@Autowired()
	private T17ProvinciaService provinciaService;

	@Autowired()
	private T17MunicipioService municipioService;

	@Autowired()
	private T17LocalidadService localidadService;

	@Autowired()
	private T17CalleService calleService;

	@Autowired()
	private T17PortalService portalService;

	@Autowired()
	private T17TipoViaService tipoViaService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaCalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaCalle(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("busquedaCalle", "model", model);
	}

	/********************************************************************************
	 * 
	 * COMBO
	 * 
	 *******************************************************************************/

	/********************************************************************************
	 * Provincias
	 *******************************************************************************/
	/**
	 * Method 'getProvincias'.
	 * 
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/provincias", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Provincia> getProvincias() {

		// // para que salgan solo los 3 T.H.
		// T17Provincia t17provincia = new T17Provincia();
		// t17provincia.setAutonomiaId(Y41aConstantes.CAPV);
		// return this.provinciaService.findAll(null, null);

		logger.debug("Cargar provincias");
		return this.provinciaService.findAll(null, null);
	}

	/********************************************************************************
	 * Municipios
	 *******************************************************************************/
	/**
	 * Method 'getMunicipios'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/municipios", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Municipio> getMunicipios(HttpServletRequest request) {
		// @RequestParam(value = "provinciaId", required = false) String
		// provinciaId) {

		String provinciaId = "";
		if (!"".equalsIgnoreCase((String) request.getParameter("provinciaId"))
				&& null != (String) request.getParameter("provinciaId")) {
			provinciaId = request.getParameter("provinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("dtnoraProvinciaId"))
				&& null != (String) request.getParameter("dtnoraProvinciaId")) {
			provinciaId = request.getParameter("dtnoraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("esnoraProvinciaId"))
				&& null != (String) request.getParameter("esnoraProvinciaId")) {
			provinciaId = request.getParameter("esnoraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("acnoraProvinciaId"))
				&& null != (String) request.getParameter("acnoraProvinciaId")) {
			provinciaId = request.getParameter("acnoraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("organismo.noraProvinciaId"))
				&& null != (String) request
						.getParameter("organismo.noraProvinciaId")) {
			provinciaId = request.getParameter("organismo.noraProvinciaId");
		}

		T17Municipio t17Municipio = new T17Municipio();
		t17Municipio.setProvinciaId(provinciaId);

		return this.municipioService.findAll(t17Municipio, null);
	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getLocalidades'.
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/localidades", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Localidad> getLocalidades(HttpServletRequest request) {
		// @RequestParam(value = "provinciaId", required = false) String
		// provinciaId,
		// @RequestParam(value = "municipioId", required = false) String
		// municipalityId) {

		String provinciaId = "";
		String municipioId = "";
		if (!"".equalsIgnoreCase((String) request.getParameter("provinciaId"))
				&& null != (String) request.getParameter("provinciaId")) {
			provinciaId = request.getParameter("provinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("dtnoraProvinciaId"))
				&& null != (String) request.getParameter("dtnoraProvinciaId")) {
			provinciaId = request.getParameter("dtnoraProvinciaId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("esnoraProvinciaId"))
				&& null != (String) request.getParameter("esnoraProvinciaId")) {
			provinciaId = request.getParameter("esnoraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("acnoraProvinciaId"))
				&& null != (String) request.getParameter("acnoraProvinciaId")) {
			provinciaId = request.getParameter("acnoraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("organismo.noraProvinciaId"))
				&& null != (String) request
						.getParameter("organismo.noraProvinciaId")) {
			provinciaId = request.getParameter("organismo.noraProvinciaId");
		}

		if (!"".equalsIgnoreCase((String) request.getParameter("municipioId"))
				&& null != (String) request.getParameter("municipioId")) {
			municipioId = request.getParameter("municipioId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("dtnoraMunicipioId"))
				&& null != (String) request.getParameter("dtnoraMunicipioId")) {
			municipioId = request.getParameter("dtnoraMunicipioId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("esnoraMunicipioId"))
				&& null != (String) request.getParameter("esnoraMunicipioId")) {
			municipioId = request.getParameter("esnoraMunicipioId");
		}
		if (!"".equalsIgnoreCase((String) request
				.getParameter("acnoraMunicipioId"))
				&& null != (String) request.getParameter("acnoraMunicipioId")) {
			municipioId = request.getParameter("acnoraMunicipioId");
		}

		if (!"".equalsIgnoreCase((String) request
				.getParameter("organismo.noraMunicipioId"))
				&& null != (String) request
						.getParameter("organismo.noraMunicipioId")) {
			municipioId = request.getParameter("organismo.noraMunicipioId");
		}

		T17Localidad t17Localidad = new T17Localidad();
		t17Localidad.setProvinciaId(provinciaId);
		t17Localidad.setMunicipioId(municipioId);

		return this.localidadService.findAll(t17Localidad, null);
	}

	/********************************************************************************
	 * Municipios
	 *******************************************************************************/
	/**
	 * Method 'getUpdateLocalidades'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/updateMunicipios", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Municipio> getUpdateMunicipios(
			@RequestParam(value = "provinciaId", required = false) String provinciaId) {

		if (provinciaId != null && !provinciaId.equals("")
				&& !provinciaId.equals("null")) {

			T17Municipio t17Municipio = new T17Municipio();
			t17Municipio.setProvinciaId(provinciaId);

			return this.municipioService.findAll(t17Municipio, null);
		} else {
			return (List<T17Municipio>) new ArrayList<T17Municipio>();
		}
	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getUpdateLocalidades'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @param municipioId
	 *            identificador de la municipio
	 * @return 'lista de provincias' para el COMBO
	 */
	@RequestMapping(value = "/updateLocalidad", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Localidad> getUpdateLocalidades(
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipioId) {

		if (provinciaId != null && !provinciaId.equals("")
				&& !provinciaId.equals("null") && municipioId != null
				&& !municipioId.equals("") && !municipioId.equals("null")) {

			T17Localidad t17Localidad = new T17Localidad();
			t17Localidad.setProvinciaId(provinciaId);
			t17Localidad.setMunicipioId(municipioId);

			return this.localidadService.findAll(t17Localidad, null);
		} else {
			return (List<T17Localidad>) new ArrayList<T17Localidad>();
		}
	}

	/********************************************************************************
	 * Codigo Postal
	 *******************************************************************************/
	/**
	 * Method 'getCodigoPostal'.
	 * 
	 * @param portal
	 *            identificador del portal
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/codigo_postal/{portal}", method = RequestMethod.GET)
	public @ResponseBody()
	T17Portal getCodigoPostal(@PathVariable() String portal) {

		T17Portal t17Portal = new T17Portal();
		t17Portal.setId(new Long(portal));
		return this.portalService.findCodigoPostal(t17Portal);

	}

	/********************************************************************************
	 * Localidades
	 *******************************************************************************/
	/**
	 * Method 'getCalles'.
	 * 
	 * @param provinciaId
	 *            identificador de la provincia
	 * @param municipalityId
	 *            identificador de la provincia
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/calles", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Calle> getCalles(
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipalityId) {

		T17Calle t17Calle = new T17Calle();
		t17Calle.setProvinciaId(provinciaId);
		t17Calle.setMunicipioId(municipalityId);

		return this.calleService.findAll(t17Calle, null);

	}

	/********************************************************************************
	 * Portal
	 *******************************************************************************/
	/**
	 * Method 'getPortales'.
	 * 
	 * @param localidadId
	 *            identificador de la localidad
	 * @param calleId
	 *            identificador de la calle
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/portales", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Portal> getPortales(
			@RequestParam(value = "localidadId", required = false) String localidadId,
			@RequestParam(value = "calleId", required = false) Long calleId) {

		if (// localidadId != null && !localidadId.equals("")&&
			// !localidadId.equals("null") &&
		calleId != null && calleId != 0) {
			T17Portal t17Portal = new T17Portal();
			// t17Portal.setLocalidadId(localidadId);
			t17Portal.setCalleId(calleId);

			return this.portalService.findAll(t17Portal, null);
		} else {
			return (List<T17Portal>) new ArrayList<T17Portal>();
		}
	}

	/********************************************************************************
	 * Paises
	 *******************************************************************************/
	/**
	 * Method 'getPaises'.
	 * 
	 * @return 'lista de paises' para el COMBO
	 */
	@RequestMapping(value = "paises", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Pais> getPaises() {
		logger.debug("Cargar paises");
		T17Pais pais = new T17Pais();
		// pais.setId("351");
		return this.paisService.findAll(pais, null);

	}

	/********************************************************************************
	 * CP
	 *******************************************************************************/
	/**
	 * Method 'getCP'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            String
	 * @return Lista
	 */
	@RequestMapping(value = "/cp", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Portal> getCP(@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c) {

		// HashMap<String, String> aMap = null;
		// List<HashMap<String, String>> lst = new ArrayList<HashMap<String,
		// String>>();

		// aMap = new HashMap<String, String>();
		// aMap.put("label", "48940");
		// aMap.put("value", "48940");
		// lst.add(aMap);

		// aMap = new HashMap<String, String>();
		// aMap.put("label", "48003");
		// aMap.put("value", "48003");
		// lst.add(aMap);

		T17Portal t17Portal = new T17Portal();
		t17Portal.setCodigoPostal(q);
		return this.portalService.findAllLike_CodigoPostal(t17Portal, null, c);

	}

	/********************************************************************************
	 * Calle
	 *******************************************************************************/
	/**
	 * Method 'getCalle'.
	 * 
	 * @param q
	 *            String
	 * @param c
	 *            String
	 * @param provincia
	 *            String
	 * @param municipio
	 *            String
	 * 
	 * @return list
	 */
	@RequestMapping(value = "/calle", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17Calle> getCalle(
			@RequestParam(value = "q", required = true) String q,
			@RequestParam(value = "c", required = true) Boolean c,
			@RequestParam(value = "provincia", required = true) String provincia,
			@RequestParam(value = "municipio", required = true) String municipio) {

		T17Calle t17Calle = new T17Calle();
		t17Calle.setDsO(q);
		t17Calle.setMunicipioId(municipio);
		t17Calle.setProvinciaId(provincia);

		return this.calleService.findAllLike_Calle(t17Calle, null, c);

	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 * 
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * 
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/********************************************************************************
	 * Codigo Postal
	 *******************************************************************************/
	/**
	 * Method 'getProvMun'. Recupera la provincia y el municipio a partir de un
	 * cod postal
	 * 
	 * @param codigoPostal
	 *            identificador del codigo postal
	 * @return T17Portal
	 */
	@RequestMapping(value = "/codigo_postal/obtenerprovmun/{codigoPostal}", method = RequestMethod.GET)
	public @ResponseBody()
	T17Calle getProvMun(@PathVariable() String codigoPostal) {

		T17Portal t17Portal = new T17Portal();
		t17Portal.setCodigoPostal(codigoPostal);
		return this.calleService.findProvMun(t17Portal);

	}

	/********************************************************************************
	 * Tipos via
	 *******************************************************************************/
	/**
	 * Method 'getAllTipoVia'.
	 * 
	 * @return 'lista de tipos de via' para el COMBO
	 */
	@RequestMapping(value = "/tipoVia", method = RequestMethod.GET)
	public @ResponseBody()
	List<T17TipoVia> getAllTipoVia() {
		List<T17TipoVia> listaVias = this.tipoViaService.findAll(null, null);

		return listaVias;
	}

	/********************************************************************************
	 * Busqueda Calles
	 *******************************************************************************/
	/**
	 * Method 'getCallesLike'.
	 * 
	 * 
	 * @param dsO_
	 *            descripcion calle
	 * @param tipoViaId_
	 *            identificador del tipo de via
	 * @param provinciaId
	 *            identificador de la provincia
	 * @param municipalityId
	 *            identificador del municipio
	 * @param request
	 *            HttpServletRequest
	 * @return 'lista de municipio' para el COMBO
	 */
	@RequestMapping(value = "/busquedaCalles", method = RequestMethod.GET)
	public @ResponseBody()
	Object getCallesLike(
			@RequestParam(value = "dsO", required = false) String dsO_,
			@RequestParam(value = "tipoViaId", required = false) String tipoViaId_,
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "municipioId", required = false) String municipalityId,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String tipoViaId = ("".equals(tipoViaId_)) ? null : tipoViaId_;
			String dsO = ("".equals(dsO_)) ? null : dsO_;

			T17Calle t17Calle = new T17Calle();
			t17Calle.setProvinciaId(provinciaId);
			t17Calle.setMunicipioId(municipalityId);
			t17Calle.setTipoViaId(tipoViaId);
			t17Calle.setDsO(dsO);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<T17Calle> callesBusqueda = this.calleService
						.findAllCalleLike(t17Calle, pagination, false);

				if (callesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.calleService.findAllCalleLikeCount(t17Calle,
						false);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(callesBusqueda);
				return data;
			} else {

				List<T17Calle> callesBusqueda = this.calleService
						.findAllCalleLike(t17Calle, pagination, false);

				if (callesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return callesBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

}
