package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.ProdAgrupado;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.service.MotivoService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Motivo;

/**
 * * MotivoController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/motivo")
public class MotivoController {

	private static final Logger logger = LoggerFactory
			.getLogger(MotivoController.class);

	@Autowired
	private MotivoService motivoService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("motivo", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("motivos", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param tircodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{tircodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Motivo getById(@PathVariable String tircodigo) {
		try {
			Motivo motivo = new Motivo();
			motivo.setTircodigo(tircodigo);
			motivo = this.motivoService.find(motivo);
			if (motivo == null) {
				throw new Exception(tircodigo.toString());
			}
			return motivo;
		} catch (Exception e) {
			throw new ResourceNotFoundException(tircodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param tircodigo
	 *            String
	 * @param tirnombre
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "tircodigo", required = false) String tircodigo,
			@RequestParam(value = "tirnombre", required = false) String tirnombre,
			HttpServletRequest request) {
		try {
			Motivo filterMotivo = new Motivo(tircodigo, tirnombre, null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Motivo> motivos = this.motivoService.findAll(filterMotivo,
						pagination);

				if (motivos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterMotivo, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(motivos);
				return data;
			} else {
				List<Motivo> motivos = this.motivoService.findAll(filterMotivo,
						pagination);
				if (motivos == null) {
					throw new Exception("No data Found.");
				}
				return motivos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllMotivo'. de tipo like
	 * 
	 * @param tircodigo_
	 *            String
	 * @param tirnombre_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/like", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllMotivo(
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "tirnombre", required = false) String tirnombre_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String tircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			String tirnombre = ("".equals(tirnombre_)) ? null : tirnombre_;
			String tirnombree = null;
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			if (Y41aConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
				tirnombre = ("".equals(tirnombre_)) ? null : tirnombre_;
			} else {
				tirnombree = ("".equals(tirnombre_)) ? null : tirnombre_;
			}

			Motivo filterMotivo = new Motivo(tircodigo, tirnombre, tirnombree);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Motivo> motivos = this.motivoService.findAllLike(
						filterMotivo, pagination, false);

				if (motivos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.motivoService.findAllLikeCount(filterMotivo,
						false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(motivos);
				return data;
			} else {
				List<Motivo> motivos = this.motivoService.findAllLike(
						filterMotivo, pagination, false);
				if (motivos == null) {
					throw new Exception("No data Found.");
				}
				return motivos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllMotivoProdServ'.
	 * 
	 * @param pscodigo
	 *            String
	 * @return Object
	 *  
	 */
	@RequestMapping(value = "/prodserv/{pscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllMotivoProdServ(@PathVariable String pscodigo) {
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			Pagination pagination = null;
			List<Motivo> motivos = this.motivoService.findAllMotivoProducto(
					producto, pagination);
			if (motivos == null) {
				throw new Exception("No data Found.");
			}
			return motivos;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllMotivoProdServAlta'.
	 * 
	 * @param pscodigo
	 *            String
	 * @return Object
	 *  
	 */
	@RequestMapping(value = "/prodservAlta/{pscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllMotivoProdServAlta(@PathVariable String pscodigo) {
		try {
			Producto producto = new Producto();
			producto.setPscodigo(pscodigo);
			Pagination pagination = null;
			List<Motivo> motivos = this.motivoService
					.findAllMotivoProductoAlta(producto, pagination);
			if (motivos == null) {
				throw new Exception("No data Found.");
			}
			return motivos;
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterMotivo
	 *            Motivo
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "motivo", required = false) Motivo filterMotivo,
			HttpServletRequest request) {
		try {
			return motivoService
					.findAllCount(filterMotivo != null ? filterMotivo
							: new Motivo());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param motivo
	 *            Motivo
	 * @param response
	 *            HttpServletResponse
	 * @return Motivo
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Motivo edit(@RequestBody Motivo motivo, HttpServletResponse response) {
		try {
			Motivo motivoAux = this.motivoService.update(motivo);
			logger.info("Entity correctly inserted!");
			return motivoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param motivo
	 *            Motivo
	 * @return Motivo
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Motivo add(@RequestBody Motivo motivo) {
		try {
			Motivo motivoAux = this.motivoService.add(motivo);
			logger.info("Entity correctly inserted!");
			return motivoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param tircodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{tircodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String tircodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Motivo motivo = new Motivo();
			motivo.setTircodigo(tircodigo);
			this.motivoService.remove(motivo);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + tircodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param motivoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> motivoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Motivo> motivoList = new ArrayList<Motivo>();
		try {
			for (ArrayList<String> motivoId : motivoIds) {
				Iterator<String> iterator = motivoId.iterator();
				Motivo motivo = new Motivo();
				motivo.setTircodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				motivoList.add(motivo);
			}
			this.motivoService.removeMultiple(motivoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getMotivoService'.
	 * 
	 * @return MotivoService
	 */
	protected MotivoService getMotivoService() {
		return this.motivoService;
	}

	/**
	 * Method 'setMotivoService'.
	 * 
	 * @param motivoService
	 *            MotivoService
	 * @return
	 */
	public void setMotivoService(MotivoService motivoService) {
		this.motivoService = motivoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'unBind' ProdMotivo
	 * 
	 * @param tircodigo
	 *            String
	 * @param prodAgrupadoE8codigo
	 *            String
	 * @return
	 */
	@RequestMapping(value = "/unbindProdMotivo", method = RequestMethod.POST)
	public void unBindProdMotivo(
			@RequestParam(value = "tircodigo", required = false) String tircodigo,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo) {
		Motivo motivo = new Motivo();
		ProdAgrupado prodAgrupado = new ProdAgrupado();
		if (tircodigo != null) {
			motivo.setTircodigo(tircodigo);
		}
		if (prodAgrupadoE8codigo != null) {
			prodAgrupado.setE8codigo(prodAgrupadoE8codigo);
		}
		motivo.getProdAgrupados().add(prodAgrupado);
		this.motivoService.removeProdMotivo(motivo);
	}

	/**
	 * Method 'bind' ProdMotivo
	 * 
	 * @param tircodigo
	 *            String
	 * @param prodAgrupadoE8codigo
	 *            String
	 */
	@RequestMapping(value = "/bindProdMotivo", method = RequestMethod.POST)
	public void bindProdMotivo(
			@RequestParam(value = "tircodigo", required = false) String tircodigo,
			@RequestParam(value = "prodAgrupadoE8codigo", required = false) String prodAgrupadoE8codigo) {
		Motivo motivo = new Motivo();
		ProdAgrupado prodAgrupado = new ProdAgrupado();
		if (tircodigo != null) {
			motivo.setTircodigo(tircodigo);
		}
		if (prodAgrupadoE8codigo != null) {
			prodAgrupado.setE8codigo(prodAgrupadoE8codigo);
		}
		motivo.getProdAgrupados().add(prodAgrupado);
		this.motivoService.addProdMotivo(motivo);
	}
}
