package com.ejie.y41a.control;

import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

import org.springframework.web.bind.annotation.ResponseBody;

import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.service.CensoMonitorService;

/**
 * * ConsultaController generated by UDA, 24-ene-2012 8:50:50.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/login")
public class LoginController {

	private static final Logger logger = LoggerFactory
			.getLogger(LoginController.class);

	@Autowired
	private Properties appConfiguration;
	@Autowired
	private CensoMonitorService censoMonitorService;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, HttpServletRequest request) {

		request.getSession().removeAttribute(
				"SPRING_SECURITY_SAVED_REQUEST_KEY");

		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("login", "model", model);
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Method 'getCensoMonitorService'.
	 * 
	 * @return CensoMonitorService
	 */
	protected CensoMonitorService getCensoMonitorService() {
		return this.censoMonitorService;
	}

	/**
	 * Method 'setCensoMonitorService'.
	 * 
	 * @param censoMonitorService
	 *            CensoMonitorService
	 * @return
	 */
	public void setCensoMonitorService(CensoMonitorService censoMonitorService) {
		this.censoMonitorService = censoMonitorService;
	}

	/**
	 * Method 'updateLogin'.
	 * 
	 * @param moclave
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 */
	@RequestMapping(value = "cambiarLogin", method = RequestMethod.POST)
	public void updateLogin(
			@RequestParam(value = "moclave", required = true) String moclave,
			HttpServletResponse response, HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);
			censoMonitor.setMoclave(moclave);

			this.censoMonitorService.inicializarOrganismo(censoMonitor);

			logger.info("Entity correctly update!" + censoMonitor);

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed addDocumentoConsultaDetalle");
		}
	}
}
