package com.ejie.y41a.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Inspecciones;
import com.ejie.y41a.service.InspeccionesService;

/**
 * * InspeccionesController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/inspecciones")
public class InspeccionesController {

	private static final Logger logger = LoggerFactory
			.getLogger(InspeccionesController.class);

	@Autowired()
	private InspeccionesService inspeccionesService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("inspecciones", "model", model);
	}

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "altaInspeccion", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("modalInspecciones", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param inscodcarta
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{inscodcarta}", method = RequestMethod.GET)
	public @ResponseBody()
	Inspecciones getById(@PathVariable() String inscodcarta) {
		try {
			Inspecciones inspecciones = new Inspecciones();
			inspecciones.setInscodcarta(inscodcarta);
			inspecciones = this.inspeccionesService.find(inspecciones);
			if (inspecciones == null) {
				throw new Exception(inscodcarta.toString());
			}
			return inspecciones;
		} catch (Exception e) {
			throw new ResourceNotFoundException(inscodcarta.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param inscodcarta
	 *            String
	 * @param insnombre
	 *            String
	 * @param insnombree
	 *            String
	 * @param insbaja
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "inscodcarta", required = false) String inscodcarta,
			@RequestParam(value = "insnombre", required = false) String insnombre,
			@RequestParam(value = "insnombree", required = false) String insnombree,
			@RequestParam(value = "insbaja", required = false) Date insbaja,
			HttpServletRequest request) {
		try {
			Inspecciones filterInspecciones = new Inspecciones(inscodcarta,
					insnombre, insnombree, insbaja);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Inspecciones> inspeccioness = this.inspeccionesService
						.findAll(filterInspecciones, pagination);

				if (inspeccioness == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterInspecciones, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(inspeccioness);
				return data;
			} else {
				List<Inspecciones> inspeccioness = this.inspeccionesService
						.findAll(filterInspecciones, pagination);
				if (inspeccioness == null) {
					throw new Exception("No data Found.");
				}
				return inspeccioness;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterInspecciones
	 *            Inspecciones
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@RequestParam(value = "inspecciones", required = false) Inspecciones filterInspecciones,
			HttpServletRequest request) {
		try {
			return this.inspeccionesService
					.findAllCount(filterInspecciones != null ? filterInspecciones
							: new Inspecciones());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param inscodcarta
	 *            String
	 * @return Inspecciones
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Inspecciones edit(
			@RequestParam(value = "inscodcarta", required = true) String inscodcarta) {
		try {
			Inspecciones inspecciones = new Inspecciones();
			inspecciones.setInscodcarta(inscodcarta);
			inspecciones.setInsbaja(new Date());

			Inspecciones inspeccionesAux = this.inspeccionesService
					.updateFecha(inspecciones);
			logger.info("Entity correctly inserted!");
			return inspeccionesAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @return Inspecciones
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Inspecciones add(@RequestBody() Inspecciones inspecciones) {
		try {
			Inspecciones inspeccionesAux = this.inspeccionesService
					.add(inspecciones);
			logger.info("Entity correctly inserted!");
			return inspeccionesAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addInspeccion'.
	 * 
	 * @param inspecciones
	 *            Inspecciones
	 * @return Inspecciones
	 */
	@RequestMapping(value = "addInspeccion", method = RequestMethod.POST)
	public @ResponseBody()
	Inspecciones addInspeccion(@RequestBody() Inspecciones inspecciones) {
		try {
			Inspecciones inspeccionesAux = this.inspeccionesService
					.addInspeccion(inspecciones);
			logger.info("Entity correctly inserted!");
			return inspeccionesAux;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param inscodcarta
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{inscodcarta}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String inscodcarta,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Inspecciones inspecciones = new Inspecciones();
			inspecciones.setInscodcarta(inscodcarta);
			this.inspeccionesService.remove(inspecciones);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + inscodcarta);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param inspeccionesIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody() ArrayList<ArrayList<String>> inspeccionesIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Inspecciones> inspeccionesList = new ArrayList<Inspecciones>();
		try {
			for (ArrayList<String> inspeccionesId : inspeccionesIds) {
				Iterator<String> iterator = inspeccionesId.iterator();
				Inspecciones inspecciones = new Inspecciones();
				inspecciones.setInscodcarta(ObjectConversionManager.convert(
						iterator.next(), String.class));
				inspeccionesList.add(inspecciones);
			}
			this.inspeccionesService.removeMultiple(inspeccionesList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getInspeccionesService'.
	 * 
	 * @return InspeccionesService
	 */
	protected InspeccionesService getInspeccionesService() {
		return this.inspeccionesService;
	}

	/**
	 * Method 'setInspeccionesService'.
	 * 
	 * @param inspeccionesService
	 *            InspeccionesService
	 * @return
	 */
	public void setInspeccionesService(InspeccionesService inspeccionesService) {
		this.inspeccionesService = inspeccionesService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

}
