package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.TipReqNormativo;
import com.ejie.y41a.service.InfracAlertaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.InfracAlerta;

/**
 *  * InfracAlertaController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/infracalerta")

public class InfracAlertaController  {

	private static final Logger logger = LoggerFactory.getLogger(InfracAlertaController.class);

	@Autowired
	private InfracAlertaService infracAlertaService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("infracalerta", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  iacodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{iacodigo}", method = RequestMethod.GET)
	public @ResponseBody InfracAlerta getById(@PathVariable String iacodigo) {
		try{
            InfracAlerta infracAlerta = new InfracAlerta();
			infracAlerta.setIacodigo(iacodigo);
            infracAlerta = this.infracAlertaService.find(infracAlerta);
            if (infracAlerta == null) {
                throw new Exception(iacodigo.toString());
            }
            return infracAlerta;
		}catch (Exception e){
		    throw new ResourceNotFoundException(iacodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  iacodigo String
	 *@param	  tipReqNormativoTticodigo String
	 *@param	  alertaAlcodigo String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "iacodigo", required = false) String iacodigo,
	@RequestParam(value = "tipReqNormativoTticodigo", required = false) String tipReqNormativoTticodigo,
	@RequestParam(value = "alertaAlcodigo", required = false) String alertaAlcodigo,
			HttpServletRequest request) {
			try{
				InfracAlerta filterInfracAlerta = new InfracAlerta(iacodigo, new TipReqNormativo(tipReqNormativoTticodigo, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null), new Alerta(alertaAlcodigo, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null));
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<InfracAlerta> infracAlertas =  this.infracAlertaService.findAll(filterInfracAlerta, pagination);

     			    if (infracAlertas == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterInfracAlerta, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(infracAlertas);
				    return data;
				}else{
				    List<InfracAlerta> infracAlertas =  this.infracAlertaService.findAll(filterInfracAlerta, pagination);
					if (infracAlertas == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return infracAlertas;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterInfracAlerta InfracAlerta 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "infracAlerta", required = false) InfracAlerta  filterInfracAlerta, HttpServletRequest request) {
	    try {
			return infracAlertaService
					.findAllCount(filterInfracAlerta != null ? filterInfracAlerta
							: new InfracAlerta ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param infracAlerta InfracAlerta 
	 * @param response HttpServletResponse
	 * @return InfracAlerta
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody InfracAlerta edit(@RequestBody InfracAlerta infracAlerta, HttpServletResponse response) {		
		try {
            InfracAlerta infracAlertaAux  = this.infracAlertaService.update(infracAlerta);
			logger.info("Entity correctly inserted!");
            return infracAlertaAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param infracAlerta InfracAlerta 
	 * @return InfracAlerta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody InfracAlerta add(@RequestBody InfracAlerta infracAlerta) {		
        try {
            InfracAlerta infracAlertaAux = this.infracAlertaService.add(infracAlerta);
            logger.info("Entity correctly inserted!");
        	return infracAlertaAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  iacodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{iacodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String iacodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            InfracAlerta infracAlerta = new InfracAlerta();
            infracAlerta.setIacodigo(iacodigo);
            this.infracAlertaService.remove(infracAlerta);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  iacodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  infracAlertaIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> infracAlertaIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<InfracAlerta> infracAlertaList = new ArrayList<InfracAlerta>();
        try{		    
            for (ArrayList<String> infracAlertaId:infracAlertaIds) {
			    Iterator<String> iterator = infracAlertaId.iterator();
				    InfracAlerta infracAlerta = new InfracAlerta();
			        infracAlerta.setIacodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    infracAlertaList.add(infracAlerta);
		    }
            this.infracAlertaService.removeMultiple(infracAlertaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getInfracAlertaService'.
	 *
	 * @return InfracAlertaService
	 */
	protected InfracAlertaService getInfracAlertaService() {
		return this.infracAlertaService;
	}

	/**
	 * Method 'setInfracAlertaService'.
	 *
	 * @param infracAlertaService  InfracAlertaService
	 * @return
	 */
	public void setInfracAlertaService(InfracAlertaService infracAlertaService) {
		this.infracAlertaService = infracAlertaService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
