package com.ejie.y41a.control;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Denuncia;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.Sector;
import com.ejie.y41a.model.TipoReclamacion;
import com.ejie.y41a.service.HechoDenunciadoService;

/**
 * * HechoDenunciadoController generated by UDA, 22-feb-2012 17:30:45.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/hechodenunciado")
public class HechoDenunciadoController {

	private static final Logger logger = LoggerFactory
			.getLogger(HechoDenunciadoController.class);

	@Autowired
	private HechoDenunciadoService hechoDenunciadoService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("hechodenunciado", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	HechoDenunciado getById(@PathVariable String hdcodigo) {
		try {
			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(hdcodigo);
			hechoDenunciado = this.hechoDenunciadoService.find(hechoDenunciado);
			if (hechoDenunciado == null) {
				throw new Exception(hdcodigo.toString());
			}
			return hechoDenunciado;
		} catch (Exception e) {
			throw new ResourceNotFoundException(hdcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param denunciaDecodigo
	 *            String
	 * @param establecimientoEscodigo
	 *            String
	 * @param sectorSecodigo
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param productoPscodigo
	 *            String
	 * @param tipoReclamacionTsrcodigo
	 *            String
	 * @param motivoTircodigo
	 *            String
	 * @param hdnror
	 *            BigDecimal
	 * @param hdte
	 *            String
	 * @param hdtedoad
	 *            String
	 * @param hdcoav
	 *            String
	 * @param hdnops
	 *            String
	 * @param hdnomaps
	 *            String
	 * @param hdnomops
	 *            String
	 * @param hdnrlops
	 *            String
	 * @param hdfedmps
	 *            Date
	 * @param hdinsotr
	 *            String
	 * @param hdinsoma
	 *            String
	 * @param hdcaptso
	 *            BigDecimal
	 * @param hdteso
	 *            String
	 * @param hdfeardt
	 *            Date
	 * @param hdfeiohd
	 *            Date
	 * @param hdininin
	 *            String
	 * @param hdfeiopc
	 *            Date
	 * @param hdferopc
	 *            Date
	 * @param hdcorepc
	 *            String
	 * @param hdfeiorp
	 *            Date
	 * @param hdferorp
	 *            Date
	 * @param hdcoreap
	 *            String
	 * @param hdfeiora
	 *            Date
	 * @param hdteacpa
	 *            String
	 * @param hdfeceac
	 *            Date
	 * @param hdhoceac
	 *            String
	 * @param hdfeioca
	 *            Date
	 * @param hdteacde
	 *            String
	 * @param hdfeioac
	 *            Date
	 * @param hdfeiofc
	 *            Date
	 * @param hdcotra
	 *            String
	 * @param hdte02
	 *            String
	 * @param hdte03
	 *            String
	 * @param hdte04
	 *            String
	 * @param hdte05
	 *            String
	 * @param hdte06
	 *            String
	 * @param hdte07
	 *            String
	 * @param hdte08
	 *            String
	 * @param hdte09
	 *            String
	 * @param hdte10
	 *            String
	 * @param hdcosc
	 *            String
	 * @param hdidal
	 *            String
	 * @param hdferoad
	 *            Date
	 * @param hdferoat
	 *            Date
	 * @param hdtealdt
	 *            String
	 * @param hdtedeat
	 *            String
	 * @param hdfedeat
	 *            Date
	 * @param hdfehd
	 *            Date
	 * @param hdtedoade
	 *            String
	 * @param hdtedoadi
	 *            String
	 * @param hdtedoadf
	 *            String
	 * @param hdtedoada
	 *            String
	 * @param hdnopse
	 *            String
	 * @param hdnopsi
	 *            String
	 * @param hdnopsf
	 *            String
	 * @param hdnopsa
	 *            String
	 * @param hdcocodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "hdcodigo", required = false) String hdcodigo,
			@RequestParam(value = "denunciaDecodigo", required = false) String denunciaDecodigo,
			@RequestParam(value = "establecimientoEscodigo", required = false) String establecimientoEscodigo,
			@RequestParam(value = "sectorSecodigo", required = false) String sectorSecodigo,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo,
			@RequestParam(value = "tipoReclamacionTsrcodigo", required = false) String tipoReclamacionTsrcodigo,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo,
			@RequestParam(value = "hdnror", required = false) Long hdnror,
			@RequestParam(value = "hdte", required = false) String hdte,
			@RequestParam(value = "hdtedoad", required = false) String hdtedoad,
			@RequestParam(value = "hdcoav", required = false) String hdcoav,
			@RequestParam(value = "hdnops", required = false) String hdnops,
			@RequestParam(value = "hdnomaps", required = false) String hdnomaps,
			@RequestParam(value = "hdnomops", required = false) String hdnomops,
			@RequestParam(value = "hdnrlops", required = false) String hdnrlops,
			@RequestParam(value = "hdfedmps", required = false) Date hdfedmps,
			@RequestParam(value = "hdinsotr", required = false) String hdinsotr,
			@RequestParam(value = "hdinsoma", required = false) String hdinsoma,
			@RequestParam(value = "hdcaptso", required = false) BigDecimal hdcaptso,
			@RequestParam(value = "hdteso", required = false) String hdteso,
			@RequestParam(value = "hdfeardt", required = false) Date hdfeardt,
			@RequestParam(value = "hdfeiohd", required = false) Date hdfeiohd,
			@RequestParam(value = "hdininin", required = false) String hdininin,
			@RequestParam(value = "hdfeiopc", required = false) Date hdfeiopc,
			@RequestParam(value = "hdferopc", required = false) Date hdferopc,
			@RequestParam(value = "hdcorepc", required = false) String hdcorepc,
			@RequestParam(value = "hdfeiorp", required = false) Date hdfeiorp,
			@RequestParam(value = "hdferorp", required = false) Date hdferorp,
			@RequestParam(value = "hdcoreap", required = false) String hdcoreap,
			@RequestParam(value = "hdfeiora", required = false) Date hdfeiora,
			@RequestParam(value = "hdteacpa", required = false) String hdteacpa,
			@RequestParam(value = "hdfeceac", required = false) Date hdfeceac,
			@RequestParam(value = "hdhoceac", required = false) String hdhoceac,
			@RequestParam(value = "hdfeioca", required = false) Date hdfeioca,
			@RequestParam(value = "hdteacde", required = false) String hdteacde,
			@RequestParam(value = "hdfeioac", required = false) Date hdfeioac,
			@RequestParam(value = "hdfeiofc", required = false) Date hdfeiofc,
			@RequestParam(value = "hdcotra", required = false) String hdcotra,
			@RequestParam(value = "hdte02", required = false) String hdte02,
			@RequestParam(value = "hdte03", required = false) String hdte03,
			@RequestParam(value = "hdte04", required = false) String hdte04,
			@RequestParam(value = "hdte05", required = false) String hdte05,
			@RequestParam(value = "hdte06", required = false) String hdte06,
			@RequestParam(value = "hdte07", required = false) String hdte07,
			@RequestParam(value = "hdte08", required = false) String hdte08,
			@RequestParam(value = "hdte09", required = false) String hdte09,
			@RequestParam(value = "hdte10", required = false) String hdte10,
			@RequestParam(value = "hdcosc", required = false) String hdcosc,
			@RequestParam(value = "hdidal", required = false) String hdidal,
			@RequestParam(value = "hdferoad", required = false) Date hdferoad,
			@RequestParam(value = "hdferoat", required = false) Date hdferoat,
			@RequestParam(value = "hdtealdt", required = false) String hdtealdt,
			@RequestParam(value = "hdtedeat", required = false) String hdtedeat,
			@RequestParam(value = "hdfedeat", required = false) Date hdfedeat,
			@RequestParam(value = "hdfehd", required = false) Date hdfehd,
			@RequestParam(value = "hdtedoade", required = false) String hdtedoade,
			@RequestParam(value = "hdtedoadi", required = false) String hdtedoadi,
			@RequestParam(value = "hdtedoadf", required = false) String hdtedoadf,
			@RequestParam(value = "hdtedoada", required = false) String hdtedoada,
			@RequestParam(value = "hdnopse", required = false) String hdnopse,
			@RequestParam(value = "hdnopsi", required = false) String hdnopsi,
			@RequestParam(value = "hdnopsf", required = false) String hdnopsf,
			@RequestParam(value = "hdnopsa", required = false) String hdnopsa,
			@RequestParam(value = "hdcocodigo", required = false) String hdcocodigo,
			@RequestParam(value = "hdcodexpedienteorigen", required = false) String hdcodexpedienteorigen,
			HttpServletRequest request) {
		try {
			HechoDenunciado filterHechoDenunciado = new HechoDenunciado(
					hdcodigo, hdnror, hdte, hdtedoad, hdcoav, hdnops, hdnomaps,
					hdnomops, hdnrlops, hdfedmps, hdinsotr, hdinsoma, hdcaptso,
					hdteso, hdfeardt, hdfeiohd, hdininin, hdfeiopc, hdferopc,
					hdcorepc, hdfeiorp, hdferorp, hdcoreap, hdfeiora, hdteacpa,
					hdfeceac, hdhoceac, hdfeioca, hdteacde, hdfeioac, hdfeiofc,
					hdcotra, hdte02, hdte03, hdte04, hdte05, hdte06, hdte07,
					hdte08, hdte09, hdte10, hdcosc, hdidal, hdferoad, hdferoat,
					hdtealdt, hdtedeat, hdfedeat, hdfehd, hdtedoade, hdtedoadi,
					hdtedoadf, hdtedoada, hdnopse, hdnopsi, hdnopsf, hdnopsa,
					hdcocodigo, hdcodexpedienteorigen, new Denuncia(
							denunciaDecodigo, null, null, null, null, null,
							null, null, null, null, null, null, null, null),
					new Establecimiento(establecimientoEscodigo, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null), new Sector(sectorSecodigo, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null), new CensoMonitor(censoMonitorMocodigo,
							null, null, null, null, null, null, null, null,
							null, null, null), new Producto(productoPscodigo,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null), new TipoReclamacion(
							tipoReclamacionTsrcodigo, null, null, null, null,
							null, null), new Motivo(motivoTircodigo, null,
							null, null), null);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<HechoDenunciado> hechoDenunciados = this.hechoDenunciadoService
						.findAll(filterHechoDenunciado, pagination);

				if (hechoDenunciados == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterHechoDenunciado, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(hechoDenunciados);
				return data;
			} else {
				List<HechoDenunciado> hechoDenunciados = this.hechoDenunciadoService
						.findAll(filterHechoDenunciado, pagination);
				if (hechoDenunciados == null) {
					throw new Exception("No data Found.");
				}
				return hechoDenunciados;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterHechoDenunciado
	 *            HechoDenunciado
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "hechoDenunciado", required = false) HechoDenunciado filterHechoDenunciado,
			HttpServletRequest request) {
		try {
			return hechoDenunciadoService
					.findAllCount(filterHechoDenunciado != null ? filterHechoDenunciado
							: new HechoDenunciado());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @param response
	 *            HttpServletResponse
	 * @return HechoDenunciado
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	HechoDenunciado edit(@RequestBody HechoDenunciado hechoDenunciado,
			HttpServletResponse response) {
		try {
			HechoDenunciado hechoDenunciadoAux = this.hechoDenunciadoService
					.update(hechoDenunciado);
			logger.info("Entity correctly inserted!");
			return hechoDenunciadoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param hechoDenunciado
	 *            HechoDenunciado
	 * @return HechoDenunciado
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	HechoDenunciado add(@RequestBody HechoDenunciado hechoDenunciado) {
		try {
			HechoDenunciado hechoDenunciadoAux = this.hechoDenunciadoService
					.add(hechoDenunciado);
			logger.info("Entity correctly inserted!");
			return hechoDenunciadoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{hdcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String hdcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			HechoDenunciado hechoDenunciado = new HechoDenunciado();
			hechoDenunciado.setHdcodigo(hdcodigo);
			this.hechoDenunciadoService.remove(hechoDenunciado);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + hdcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param hechoDenunciadoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> hechoDenunciadoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<HechoDenunciado> hechoDenunciadoList = new ArrayList<HechoDenunciado>();
		try {
			for (ArrayList<String> hechoDenunciadoId : hechoDenunciadoIds) {
				Iterator<String> iterator = hechoDenunciadoId.iterator();
				HechoDenunciado hechoDenunciado = new HechoDenunciado();
				hechoDenunciado.setHdcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				hechoDenunciadoList.add(hechoDenunciado);
			}
			this.hechoDenunciadoService.removeMultiple(hechoDenunciadoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getHechoDenunciadoService'.
	 * 
	 * @return HechoDenunciadoService
	 */
	protected HechoDenunciadoService getHechoDenunciadoService() {
		return this.hechoDenunciadoService;
	}

	/**
	 * Method 'setHechoDenunciadoService'.
	 * 
	 * @param hechoDenunciadoService
	 *            HechoDenunciadoService
	 * @return
	 */
	public void setHechoDenunciadoService(
			HechoDenunciadoService hechoDenunciadoService) {
		this.hechoDenunciadoService = hechoDenunciadoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
