package com.ejie.y41a.control;

import java.util.Properties;

import javax.servlet.http.HttpServletResponse;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.utils.config.Y41aConfig;

/**
 * * GuiaUsuarioController generated by UDA, 24-ene-2012 8:50:50.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/guiausuario")
public class GuiaUsuarioController {

	/**
	 * Method 'getFicheroAyuda'.
	 * 
	 * @param type
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/documentacion/{type}", method = RequestMethod.GET)
	public @ResponseBody
	void getFicheroAyuda(@PathVariable String type, HttpServletResponse response) {
		String nombreFichero = "";
		try {
			Properties prop = Y41aConfig
					.loadProperties(Y41aConstantes.CONFIG_PATH);

			String pathAyuda = prop.getProperty("RUTA_DOCUMENTACION");

			if (type.equalsIgnoreCase("1")) {
				nombreFichero = prop.getProperty("NAME_ARBITRAJE");
			} else if (type.equalsIgnoreCase("2")) {
				nombreFichero = prop.getProperty("NAME_TRASLADO");
			} else if (type.equalsIgnoreCase("3")) {
				nombreFichero = prop.getProperty("NAME_PLANTILLA");
			} else if (type.equalsIgnoreCase("4")) {
				nombreFichero = prop.getProperty("NAME_MANUALUSUARIO");
			} else if (type.equalsIgnoreCase("5")) {
				nombreFichero = prop
						.getProperty("NAME_CRITERIOS_RECLAMACIONES_DE_CONSUMO");
			}

			response.sendRedirect(pathAyuda + nombreFichero);

		} catch (Exception e) {
			throw new ResourceNotFoundException(nombreFichero);
		}
	}
}
