package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.FormasVentaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.FormasVenta;

/**
 *  * FormasVentaController generated by UDA, 19-ene-2016 11:45:28.
 *  
 */
 
@Controller
@RequestMapping (value = "/formasventa")

public class FormasVentaController  {

	private static final Logger logger = LoggerFactory.getLogger(FormasVentaController.class);

	@Autowired
	private FormasVentaService formasVentaService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("formasventa", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  fvcodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{fvcodigo}", method = RequestMethod.GET)
	public @ResponseBody FormasVenta getById(@PathVariable String fvcodigo) {
		try{
            FormasVenta formasVenta = new FormasVenta();
			formasVenta.setFvcodigo(fvcodigo);
            formasVenta = this.formasVentaService.find(formasVenta);
            if (formasVenta == null) {
                throw new Exception(fvcodigo.toString());
            }
            return formasVenta;
		}catch (Exception e){
		    throw new ResourceNotFoundException(fvcodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  fvcodigo String
	 *@param	  fvnombre String
	 *@param	  fvnombree String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "fvcodigo", required = false) String fvcodigo,
	@RequestParam(value = "fvnombre", required = false) String fvnombre,
	@RequestParam(value = "fvnombree", required = false) String fvnombree,
			HttpServletRequest request) {
			try{
				FormasVenta filterFormasVenta = new FormasVenta(fvcodigo, fvnombre, fvnombree);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<FormasVenta> formasVentas =  this.formasVentaService.findAll(filterFormasVenta, pagination);

     			    if (formasVentas == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterFormasVenta, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(formasVentas);
				    return data;
				}else{
				    List<FormasVenta> formasVentas =  this.formasVentaService.findAll(filterFormasVenta, pagination);
					if (formasVentas == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return formasVentas;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterFormasVenta FormasVenta 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "formasVenta", required = false) FormasVenta  filterFormasVenta, HttpServletRequest request) {
	    try {
			return formasVentaService
					.findAllCount(filterFormasVenta != null ? filterFormasVenta
							: new FormasVenta ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param formasVenta FormasVenta 
	 * @param response HttpServletResponse
	 * @return FormasVenta
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody FormasVenta edit(@RequestBody FormasVenta formasVenta, HttpServletResponse response) {		
		try {
            FormasVenta formasVentaAux  = this.formasVentaService.update(formasVenta);
			logger.info("Entity correctly inserted!");
            return formasVentaAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param formasVenta FormasVenta 
	 * @return FormasVenta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody FormasVenta add(@RequestBody FormasVenta formasVenta) {		
        try {
            FormasVenta formasVentaAux = this.formasVentaService.add(formasVenta);
            logger.info("Entity correctly inserted!");
        	return formasVentaAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  fvcodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{fvcodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String fvcodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            FormasVenta formasVenta = new FormasVenta();
            formasVenta.setFvcodigo(fvcodigo);
            this.formasVentaService.remove(formasVenta);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  fvcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  formasVentaIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> formasVentaIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<FormasVenta> formasVentaList = new ArrayList<FormasVenta>();
        try{		    
            for (ArrayList<String> formasVentaId:formasVentaIds) {
			    Iterator<String> iterator = formasVentaId.iterator();
				    FormasVenta formasVenta = new FormasVenta();
			        formasVenta.setFvcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    formasVentaList.add(formasVenta);
		    }
            this.formasVentaService.removeMultiple(formasVentaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getFormasVentaService'.
	 *
	 * @return FormasVentaService
	 */
	protected FormasVentaService getFormasVentaService() {
		return this.formasVentaService;
	}

	/**
	 * Method 'setFormasVentaService'.
	 *
	 * @param formasVentaService  FormasVentaService
	 * @return
	 */
	public void setFormasVentaService(FormasVentaService formasVentaService) {
		this.formasVentaService = formasVentaService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
