package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.FormaPresentacionService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.FormaPresentacion;

/**
 *  * FormaPresentacionController generated by UDA, 01-feb-2012 17:10:42.
 *  
 */
 
@Controller
@RequestMapping (value = "/formapresentacion")

public class FormaPresentacionController  {

	private static final Logger logger = LoggerFactory.getLogger(FormaPresentacionController.class);

	@Autowired
	private FormaPresentacionService formaPresentacionService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("formapresentacion", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  tfpcodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{tfpcodigo}", method = RequestMethod.GET)
	public @ResponseBody FormaPresentacion getById(@PathVariable String tfpcodigo) {
		try{
            FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(tfpcodigo);
            formaPresentacion = this.formaPresentacionService.find(formaPresentacion);
            if (formaPresentacion == null) {
                throw new Exception(tfpcodigo.toString());
            }
            return formaPresentacion;
		}catch (Exception e){
		    throw new ResourceNotFoundException(tfpcodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  tfpcodigo String
	 *@param	  tfpnombre String
	 *@param	  tfpnombree String
	 *@param	  tfpnombrei String
	 *@param	  tfpnombref String
	 *@param	  tfpnombrea String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo,
	@RequestParam(value = "tfpnombre", required = false) String tfpnombre,
	@RequestParam(value = "tfpnombree", required = false) String tfpnombree,
	@RequestParam(value = "tfpnombrei", required = false) String tfpnombrei,
	@RequestParam(value = "tfpnombref", required = false) String tfpnombref,
	@RequestParam(value = "tfpnombrea", required = false) String tfpnombrea,
			HttpServletRequest request) {
			try{
				FormaPresentacion filterFormaPresentacion = new FormaPresentacion(tfpcodigo, tfpnombre, tfpnombree, tfpnombrei, tfpnombref, tfpnombrea);
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<FormaPresentacion> formaPresentacions =  this.formaPresentacionService.findAll(filterFormaPresentacion, pagination);

     			    if (formaPresentacions == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterFormaPresentacion, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(formaPresentacions);
				    return data;
				}else{
				    List<FormaPresentacion> formaPresentacions =  this.formaPresentacionService.findAll(filterFormaPresentacion, pagination);
					if (formaPresentacions == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return formaPresentacions;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterFormaPresentacion FormaPresentacion 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "formaPresentacion", required = false) FormaPresentacion  filterFormaPresentacion, HttpServletRequest request) {
	    try {
			return formaPresentacionService
					.findAllCount(filterFormaPresentacion != null ? filterFormaPresentacion
							: new FormaPresentacion ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param formaPresentacion FormaPresentacion 
	 * @param response HttpServletResponse
	 * @return FormaPresentacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody FormaPresentacion edit(@RequestBody FormaPresentacion formaPresentacion, HttpServletResponse response) {		
		try {
            FormaPresentacion formaPresentacionAux  = this.formaPresentacionService.update(formaPresentacion);
			logger.info("Entity correctly inserted!");
            return formaPresentacionAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param formaPresentacion FormaPresentacion 
	 * @return FormaPresentacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody FormaPresentacion add(@RequestBody FormaPresentacion formaPresentacion) {		
        try {
            FormaPresentacion formaPresentacionAux = this.formaPresentacionService.add(formaPresentacion);
            logger.info("Entity correctly inserted!");
        	return formaPresentacionAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  tfpcodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{tfpcodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String tfpcodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            FormaPresentacion formaPresentacion = new FormaPresentacion();
            formaPresentacion.setTfpcodigo(tfpcodigo);
            this.formaPresentacionService.remove(formaPresentacion);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  tfpcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  formaPresentacionIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> formaPresentacionIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<FormaPresentacion> formaPresentacionList = new ArrayList<FormaPresentacion>();
        try{		    
            for (ArrayList<String> formaPresentacionId:formaPresentacionIds) {
			    Iterator<String> iterator = formaPresentacionId.iterator();
				    FormaPresentacion formaPresentacion = new FormaPresentacion();
			        formaPresentacion.setTfpcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    formaPresentacionList.add(formaPresentacion);
		    }
            this.formaPresentacionService.removeMultiple(formaPresentacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getFormaPresentacionService'.
	 *
	 * @return FormaPresentacionService
	 */
	protected FormaPresentacionService getFormaPresentacionService() {
		return this.formaPresentacionService;
	}

	/**
	 * Method 'setFormaPresentacionService'.
	 *
	 * @param formaPresentacionService  FormaPresentacionService
	 * @return
	 */
	public void setFormaPresentacionService(FormaPresentacionService formaPresentacionService) {
		this.formaPresentacionService = formaPresentacionService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
