package com.ejie.y41a.control;

import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.SolicitudBusqueda;
import com.ejie.y41a.service.EstadisticasSolicitudesService;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * * AnalisisController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/estadisticasSolicitudes")
public class EstadisticasSolicitudesController {

	@Autowired
	private EstadisticasSolicitudesService estadisticasSolicitudesService;

	@Autowired
	private Properties appConfiguration;

	@Resource
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintEstadisticasSolicitudes", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("maintEstadisticasSolicitudes", "model", model);
	}

	/**
	 * Method 'getCreateFormBusquedaSolicitudes'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "busquedaSolicitudesTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaSolicitudes(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("busquedaSolicitudesTab", "model", model);
	}

	/**
	 * Method 'getCreateFormListadoSolicitudes'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "listadoSolicitudesTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormListadoSolicitudes(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("listadoSolicitudesTab", "model", model);
	}

	/**
	 * Method 'getCreateFormEstadisiticaSolicitudes'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "estadisticaSolicitudesTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormEstadisticaSolicitudes(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("estadisticaSolicitudesTab", "model", model);
	}

	/**
	 * Method 'getEstadisticaSolicitudesExcel'.
	 * 
	 * @param indEstadisticasSolicitudes_
	 *            String
	 * @param decoor_
	 *            String
	 * @param denror
	 *            BigDecimal
	 * @param denran
	 *            BigDecimal
	 * @param indGestion_
	 *            String
	 * @param hcfedeDesde_
	 *            String
	 * @param hcfedeHasta_
	 *            String
	 * @param defereDesde_
	 *            String
	 * @param defereHasta_
	 *            String
	 * @param tfpcodigo_
	 *            String
	 * @param hdcodexpedienteorigen_
	 *            String
	 * @param tfpnombre_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param indUltimoTramite_
	 *            String
	 * @param decodigo_
	 *            String
	 * @param defedeDesde_
	 *            String
	 * @param defedeHasta_
	 *            String
	 * @param dtnombre_
	 *            String
	 * @param dtnif_
	 *            String
	 * @param dtnoraProvinciaId_
	 *            String
	 * @param dtnoraMunicipioId_
	 *            String
	 * @param dtnoraLocalidadId_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoraProvinciaId_
	 *            String
	 * @param esnoraMunicipioId_
	 *            String
	 * @param esnoraLocalidadId_
	 *            String
	 * @param secodigo_
	 *            String
	 * @param senombre_
	 *            String
	 * @param pscodigo_
	 *            String
	 * @param psnombre_
	 *            String
	 * @param tircodigo_
	 *            String
	 * @param tirnombre_
	 *            String
	 * @param hdcosc_
	 *            String
	 * @param trnombre_
	 *            String
	 * @param denombre_
	 *            String
	 * @param dtnombreProvincia_
	 *            String
	 * @param dtnombreMunicipio_
	 *            String
	 * @param dtnombreLocalidad_
	 *            String
	 * @param esnombreProvincia_
	 *            String
	 * @param esnombreMunicipio_
	 *            String
	 * @param esnombreLocalidad_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/estadisticaSolicitudesExcel", method = RequestMethod.GET)
	public void getEstadisticasSolicitudesExcel(

			@RequestParam(value = "indEstadisticasSolicitudes", required = false) String indEstadisticasSolicitudes_,
			@RequestParam(value = "decoor", required = false) String decoor_,
			@RequestParam(value = "denror", required = false) BigDecimal denror,
			@RequestParam(value = "denran", required = false) BigDecimal denran,
			@RequestParam(value = "indGestion", required = false) String indGestion_,
			@RequestParam(value = "hcfedeDesde_", required = false) String hcfedeDesde_,
			@RequestParam(value = "hcfedeHasta", required = false) String hcfedeHasta_,
			@RequestParam(value = "defereDesde", required = false) String defereDesde_,
			@RequestParam(value = "defereHasta", required = false) String defereHasta_,
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo_,
			@RequestParam(value = "hdcodexpedienteorigen", required = false) String hdcodexpedienteorigen_,
			@RequestParam(value = "tfpnombre", required = false) String tfpnombre_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "indUltimoTramite", required = false) String indUltimoTramite_,
			@RequestParam(value = "decodigo", required = false) String decodigo_,
			@RequestParam(value = "defedeDesde", required = false) String defedeDesde_,
			@RequestParam(value = "defedeHasta", required = false) String defedeHasta_,
			@RequestParam(value = "dtnombre", required = false) String dtnombre_,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1_,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2_,
			@RequestParam(value = "dtnif", required = false) String dtnif_,
			@RequestParam(value = "dtnoraProvinciaId", required = false) String dtnoraProvinciaId_,
			@RequestParam(value = "dtnoraMunicipioId", required = false) String dtnoraMunicipioId_,
			@RequestParam(value = "dtnoraLocalidadId", required = false) String dtnoraLocalidadId_,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero_,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId_,
			@RequestParam(value = "dtdireccion_nocapv", required = false) String dtdireccion_nocapv_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId_,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId_,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId_,
			@RequestParam(value = "secodigo", required = false) String secodigo_,
			@RequestParam(value = "senombre", required = false) String senombre_, // idiomatico-e-ee
			@RequestParam(value = "pscodigo", required = false) String pscodigo_,
			@RequestParam(value = "psnombre", required = false) String psnombre_, // idiomatico-e-ee
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "tirnombre", required = false) String tirnombre_, // noidiomatico
			@RequestParam(value = "hdcosc", required = false) String hdcosc_,
			@RequestParam(value = "trnombre", required = false) String trnombre_,
			@RequestParam(value = "denombre", required = false) String denombre_,
			@RequestParam(value = "dtnombreProvincia", required = false) String dtnombreProvincia_,
			@RequestParam(value = "dtnombreMunicipio", required = false) String dtnombreMunicipio_,
			@RequestParam(value = "dtnombreLocalidad", required = false) String dtnombreLocalidad_,
			@RequestParam(value = "esnombreProvincia", required = false) String esnombreProvincia_,
			@RequestParam(value = "esnombreMunicipio", required = false) String esnombreMunicipio_,
			@RequestParam(value = "esnombreLocalidad", required = false) String esnombreLocalidad_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			HttpServletRequest request, HttpServletResponse response) {

		OutputStream out = null;
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date hcfedeDesde = Y41aUtils.parseDate(hcfedeDesde_, locale);
			Date hcfedeHasta = Y41aUtils.parseDate(hcfedeHasta_, locale);
			Date defereDesde = Y41aUtils.parseDate(defereDesde_, locale);
			Date defereHasta = Y41aUtils.parseDate(defereHasta_, locale);
			Date defedeDesde = Y41aUtils.parseDate(defedeDesde_, locale);
			Date defedeHasta = Y41aUtils.parseDate(defedeHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro

			String indEstadisticasSolicitudes = (""
					.equals(indEstadisticasSolicitudes_)) ? null
					: indEstadisticasSolicitudes_;

			String decoor = ("".equals(decoor_)) ? null : decoor_;
			String indGestion = ("".equals(indGestion_)) ? null : indGestion_;
			String tfpcodigo = ("".equals(tfpcodigo_)) ? null : tfpcodigo_;

			String tfpnombre = ("".equals(tfpnombre_)) ? null : tfpnombre_;

			String formaPresentacionTfpNombre = null;
			String formaPresentacionTfpNombree = null;
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				formaPresentacionTfpNombre = tfpnombre;
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				formaPresentacionTfpNombree = tfpnombre;
			}
			String hdcodexpedienteorigen = ("".equals(hdcodexpedienteorigen_)) ? null
					: hdcodexpedienteorigen_;
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String decodigo = ("".equals(decodigo_)) ? null : decodigo_;
			String dtnombre = ("".equals(dtnombre_)) ? null : dtnombre_;
			String dtapellido1 = ("".equals(dtapellido1_)) ? null
					: dtapellido1_;
			String dtapellido2 = ("".equals(dtapellido2_)) ? null
					: dtapellido2_;
			String dtnif = ("".equals(dtnif_)) ? null : dtnif_;

			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;
			String esnif = ("".equals(esnif_)) ? null : esnif_;

			// cons
			String dtextranjero = null;
			String dtestado = null;
			String dtnoraPaisId = null;
			String dtnoraProvinciaId = null;
			String dtnoraMunicipioId = null;
			String dtnoraLocalidadId = null;
			String dtdireccion_nocapv = null;

			if (Y41aConstantes.NORA_LOCALIZACION_TODOS.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = null;
			} else if (Y41aConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(dtextranjero_)) {
				dtextranjero = Y41aConstantes.VALOR_SI;
				dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
						: dtnoraPaisId_;

				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;

			} else if (Y41aConstantes.NORA_LOCALIZACION_ESTADO
					.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = Y41aConstantes.VALOR_SI;
				dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null
						: dtnoraProvinciaId_;
				dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null
						: dtnoraMunicipioId_;
				dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null
						: dtnoraLocalidadId_;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;
			}

			// est
			String esextranjero = null;
			String esestado = null;
			String esnoraPaisId = null;
			String esnoraProvinciaId = null;
			String esnoraMunicipioId = null;
			String esnoraLocalidadId = null;
			String esdireccion_nocapv = null;

			if (Y41aConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41aConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(esextranjero_)) {
				esextranjero = Y41aConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
						: esnoraPaisId_;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;

			} else if (Y41aConstantes.NORA_LOCALIZACION_ESTADO
					.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41aConstantes.VALOR_SI;
				esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null
						: esnoraProvinciaId_;
				esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null
						: esnoraMunicipioId_;
				esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null
						: esnoraLocalidadId_;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;
			}

			String secodigo = ("".equals(secodigo_)) ? null : secodigo_;
			String pscodigo = ("".equals(pscodigo_)) ? null : pscodigo_;

			String senombre = null;
			String senombree = null;
			String psnombre = null;
			String psnombree = null;
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				senombre = senombre_;
				psnombre = psnombre_;
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				psnombree = psnombre_;
				senombree = senombre_;
			}

			String tircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			String tirnombre = ("".equals(tirnombre_)) ? null : tirnombre_;

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);
			String codOrgConectado = censoMonitor.getOrganismo().getCodOrg();

			String hdcosc = ("".equals(hdcosc_)) ? null : hdcosc_;
			String trnombre = ("".equals(trnombre_)) ? null : trnombre_;
			String denombre = ("".equals(denombre_)) ? null : denombre_;

			String dtnombreProvincia = ("".equals(dtnombreProvincia_)) ? null
					: dtnombreProvincia_;
			String dtnombreMunicipio = ("".equals(dtnombreMunicipio_)) ? null
					: dtnombreMunicipio_;
			String dtnombreLocalidad = ("".equals(dtnombreLocalidad_)) ? null
					: dtnombreLocalidad_;
			String esnombreProvincia = ("".equals(esnombreProvincia_)) ? null
					: esnombreProvincia_;
			String esnombreMunicipio = ("".equals(esnombreMunicipio_)) ? null
					: esnombreMunicipio_;
			String esnombreLocalidad = ("".equals(esnombreLocalidad_)) ? null
					: esnombreLocalidad_;

			// control checks
			String indUltimoTramite = ("on".equals(indUltimoTramite_)) ? Y41aConstantes.VALOR_SI
					: null;

			// Filtro
			SolicitudBusqueda filterSolicitudBusqueda = new SolicitudBusqueda(
					null, decoor, denran, denror, null, indGestion, tfpcodigo,
					formaPresentacionTfpNombre, formaPresentacionTfpNombree,
					null, null, hdcosc, null, trcodigo, trnombre, null,
					indUltimoTramite, null, decodigo, denombre, null, null,
					null, dtnombre, dtapellido1, dtapellido2, dtnif, dtestado,
					dtnoraProvinciaId, dtnombreProvincia, dtnoraMunicipioId,
					dtnombreMunicipio, dtnoraLocalidadId, dtnombreLocalidad,
					dtextranjero, dtnoraPaisId, null, dtdireccion_nocapv, null,
					esnombre, esnif, esestado, esnoraProvinciaId,
					esnombreProvincia, esnoraMunicipioId, esnombreMunicipio,
					esnoraLocalidadId, esnombreLocalidad, esextranjero,
					esnoraPaisId, null, esdireccion_nocapv, null, null,
					codOrgConectado, hdcodexpedienteorigen, null, null, null,
					null, null, pscodigo, psnombre, psnombree, tircodigo,
					tirnombre, secodigo, senombre, senombree, null);

			String xslString = estadisticasSolicitudesService
					.getEstadisticaSolicitudesExcel(filterSolicitudBusqueda,
							defedeDesde, defedeHasta, defereDesde, defereHasta,
							hcfedeDesde, hcfedeHasta,
							indEstadisticasSolicitudes);

			Date fechaHoy = new Date();
			String fechaActual = Y41aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");
			String nombre = appMessageSource.getMessage(
					"excel.titulo.solicitudes", null, locale)
					+ "_"
					+ fechaActual + ".xls";

			response.setCharacterEncoding("ISO-8859-1"); //
			response.setHeader("Cache-Control", "no-cache");

			response.setContentType("application/vnd.ms-excel");
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombre);

			out = response.getOutputStream();
			out.write(xslString.getBytes());
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}
}
