package com.ejie.y41a.control;

/*import com.ejie.x38.control.exception.ControlException;
 import com.ejie.x38.control.exception.MethodFailureException;
 import com.ejie.x38.control.exception.ResourceNotFoundException;
 import com.ejie.x38.control.exception.ServiceUnavailableException;
 import com.ejie.x38.dto.JQGridJSONModel;
 import com.ejie.x38.dto.Pagination;
 import com.ejie.x38.util.ObjectConversionManager;
 import com.ejie.y41a.model.Actuacion;
 import com.ejie.y41a.model.AnalisisDetalle;
 import com.ejie.y41a.model.OriProdAlerta;
 import com.ejie.y41a.model.TipCaracMuestra;
 import com.ejie.y41a.model.TipDepoMuestra;
 import com.ejie.y41a.service.AnalisisService;
 import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
 import com.ejie.y41a.utils.exception.Y41aUDAException;*/

//import java.io.IOException;
//import java.io.Writer;
//import java.math.BigDecimal;
//import java.util.ArrayList;
//import java.util.Date;
//import java.util.Iterator;
//import java.util.List;
import java.io.OutputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.y41a.model.EstadisticasKontsumonetBusqueda;
import com.ejie.y41a.service.EstadisticasKontsumonetService;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * * AnalisisController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/estadisticasKontsumonet")
public class EstadisticasKontsumonetController {

	@Autowired
	private EstadisticasKontsumonetService estadisticasKontsumonetService;

	@Autowired
	private Properties appConfiguration;

	@Resource
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("estadisticasKontsumonet", "model", model);
	}

	/**
	 * Method 'getEstadisticaKontsumonetExcel'.
	 * 
	 * @param anyo_
	 *            String
	 * @param indEstadistica_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/estadisticaKontsumonetExcel", method = RequestMethod.GET)
	public void getEstadisticaKontsumonetExcel(
			@RequestParam(value = "anyo", required = false) String anyo_,
			@RequestParam(value = "indEstadistica", required = false) String indEstadistica_,
			HttpServletRequest request, HttpServletResponse response) {
		OutputStream out = null;
		try {
			Locale locale = LocaleContextHolder.getLocale();

			EstadisticasKontsumonetBusqueda estadisticasKontsumonetBusqueda = new EstadisticasKontsumonetBusqueda();

			String anyo = ("".equals(anyo_)) ? null : anyo_;
			String indEstadistica = ("".equals(indEstadistica_)) ? null
					: indEstadistica_;

			estadisticasKontsumonetBusqueda.setAnyo(anyo);
			estadisticasKontsumonetBusqueda.setIndEstadistica(indEstadistica);

			String xslString = estadisticasKontsumonetService
					.getEstadisticaKontsumonetExcel(estadisticasKontsumonetBusqueda);

			Date fechaHoy = new Date();
			String fechaActual = Y41aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");
			response.setContentType("application/vnd.ms-excel");

			String nombre = appMessageSource.getMessage(
					"excel.titulo.kontsumonet", null, locale)
					+ "_"
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombre + "\"");

			out = response.getOutputStream();
			out.write(xslString.getBytes());
			out.flush();
			out.close();

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

}
