package com.ejie.y41a.control;

import java.io.OutputStream;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.FormaPresentacion;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.RangoEdad;
import com.ejie.y41a.service.EstadisticasConsultasService;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * * AnalisisController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/estadisticasConsultas")
public class EstadisticasConsultaController {

	@Autowired
	private EstadisticasConsultasService estadisticasConsultasService;

	@Autowired
	private Properties appConfiguration;

	@Resource
	private ReloadableResourceBundleMessageSource appMessageSource;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintEstadisticasConsultas", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("maintEstadisticasConsultas", "model", model);
	}

	/**
	 * Method 'getCreateFormBusquedaConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "busquedaConsultaTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaConsulta(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("busquedaConsultaTab", "model", model);
	}

	/**
	 * Method 'getCreateFormListadoConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "listadoConsultaTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormListadoConsulta(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("listadoConsultaTab", "model", model);
	}

	/**
	 * Method 'getCreateFormEstadisiticaConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "estadisticaConsultaTab", method = RequestMethod.GET)
	public ModelAndView getCreateFormEstadisiticaConsulta(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("estadisticaConsultaTab", "model", model);
	}

	/**
	 * Method 'getEstadisticaConsultaExcel'.
	 * 
	 * 
	 * @param cocodigo
	 *            String
	 * @param motivoTircodigo_
	 *            String
	 * @param motivoTirnombre_
	 *            String
	 * @param productoPscodigo_
	 *            String
	 * @param productoPsnombre_
	 *            String
	 * @param rangoEdadRancod_
	 *            String
	 * @param rangoEdadRanDesc_
	 *            String
	 * @param formaPresentacionTfpcodigo_
	 *            String
	 * @param formaPresentacionTfpNombre_
	 *            String
	 * @param organismoCodOrg
	 *            String
	 * @param censoMonitorMocodigo_
	 *            String
	 * @param censoMonitorMonombre_
	 *            String
	 * @param cofecha
	 *            Date
	 * @param cocosx_
	 *            String
	 * @param conran
	 *            String
	 * @param cocose
	 *            String
	 * @param cotexto_
	 *            String
	 * @param conrreg
	 *            Integer
	 * @param conoco_
	 *            String
	 * @param conodirco
	 *            String
	 * @param conrcpco
	 *            String
	 * @param cocoloco
	 *            String
	 * @param conoloco
	 *            String
	 * @param conomuco
	 *            String
	 * @param cocopvco
	 *            String
	 * @param cocopaco
	 *            String
	 * @param conrtelco
	 *            String
	 * @param conrfaxco
	 *            String
	 * @param cocoemco
	 *            String
	 * @param coferes
	 *            Date
	 * @param coinreenv
	 *            String
	 * @param coteresp
	 *            String
	 * @param cocotfpr
	 *            String
	 * @param coinl37_
	 *            String
	 * @param conranrg
	 *            Long
	 * @param cocopro
	 *            String
	 * @param cohdcodigo
	 *            String
	 * @param cohora
	 *            String
	 * @param cofechaconsumidor
	 *            Date
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param coinl21_
	 *            String
	 * @param cosituacion_
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param cofechaDesde_
	 *            String
	 * @param cofechaHasta_
	 *            String
	 * @param indEstadisticaConsulta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/estadisticaConsultaExcel", method = RequestMethod.GET)
	public void getEstadisticaConsultaExcel(
			@RequestParam(value = "indEstadisticaConsulta", required = false) String indEstadisticaConsulta_,
			@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "motivoTirnombre", required = false) String motivoTirnombre_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "productoPsnombre", required = false) String productoPsnombre_,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod_,
			@RequestParam(value = "rangoEdadRanDesc", required = false) String rangoEdadRanDesc_,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo_,
			@RequestParam(value = "formaPresentacionTfpNombre", required = false) String formaPresentacionTfpNombre_,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo_,
			@RequestParam(value = "censoMonitorMonombre", required = false) String censoMonitorMonombre_,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx_,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto_,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco_,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37_,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "coinl21", required = false) String coinl21_,
			@RequestParam(value = "cosituacion", required = false) String cosituacion_,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "coextranjero", required = false) String coextranjero,
			@RequestParam(value = "cofechaDesde", required = false) String cofechaDesde_,
			@RequestParam(value = "cofechaHasta", required = false) String cofechaHasta_,
			HttpServletRequest request, HttpServletResponse response) {
		OutputStream out = null;
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date cofechaDesde = Y41aUtils.parseDate(cofechaDesde_, locale);
			Date cofechaHasta = Y41aUtils.parseDate(cofechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String cosituacion = ("".equals(cosituacion_)) ? null
					: cosituacion_;
			String censoMonitorMocodigo = ("".equals(censoMonitorMocodigo_)) ? null
					: censoMonitorMocodigo_;

			String censoMonitorMonombre = ("".equals(censoMonitorMonombre_)) ? null
					: censoMonitorMonombre_;
			String formaPresentacionTfpcodigo = (""
					.equals(formaPresentacionTfpcodigo_)) ? null
					: formaPresentacionTfpcodigo_;

			String fpTfpNombre = ("".equals(formaPresentacionTfpNombre_)) ? null
					: formaPresentacionTfpNombre_;

			String formaPresentacionTfpNombre = null;
			String formaPresentacionTfpNombree = null;
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				formaPresentacionTfpNombre = fpTfpNombre;
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				formaPresentacionTfpNombree = fpTfpNombre;
			}
			String cotexto = ("".equals(cotexto_)) ? null : cotexto_;

			String conoco = ("".equals(conoco_)) ? null : conoco_;
			String provinciaId = ("".equals(provinciaId_)) ? null
					: provinciaId_;
			String municipioId = ("".equals(municipioId_)) ? null
					: municipioId_;
			String localidadId = ("".equals(localidadId_)) ? null
					: localidadId_;
			String rangoEdadRancod = ("".equals(rangoEdadRancod_)) ? null
					: rangoEdadRancod_;
			String rangoEdadRanDesc = ("".equals(rangoEdadRanDesc_)) ? null
					: rangoEdadRanDesc_;
			String cocosx = ("".equals(cocosx_)) ? null : cocosx_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null
					: productoPscodigo_;

			String psNombre = ("".equals(productoPsnombre_)) ? null
					: productoPsnombre_;

			String productoPsnombre = null;
			String productoPsnombree = null;
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				productoPsnombre = psNombre;
			} else if (Y41aConstantes.EUSKERA.equals(locale.getLanguage())) {
				productoPsnombree = psNombre;
			}

			String motivoTircodigo = ("".equals(motivoTircodigo_)) ? null
					: motivoTircodigo_;
			String motivoTirnombre = ("".equals(motivoTirnombre_)) ? null
					: motivoTirnombre_;

			// control checks
			String coinl21 = ("on".equals(coinl21_)) ? Y41aConstantes.VALOR_SI
					: null;
			String coinl37 = ("on".equals(coinl37_)) ? Y41aConstantes.VALOR_SI
					: null;

			// Filtro
			Consulta consulta = new Consulta(
					cocodigo,
					new Motivo(motivoTircodigo, motivoTirnombre, null, null),
					new Producto(productoPscodigo, productoPsnombre, null,
							null, null, productoPsnombree, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null),
					new RangoEdad(rangoEdadRancod, rangoEdadRanDesc, null, null),
					new FormaPresentacion(formaPresentacionTfpcodigo,
							formaPresentacionTfpNombre,
							formaPresentacionTfpNombree, null, null, null, null),
					new Organismo(organismoCodOrg, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null),
					new CensoMonitor(censoMonitorMocodigo,
							censoMonitorMonombre, null, null, null, null, null,
							null, null, null, null, null), cofecha, cocosx,
					conran, cocose, cotexto, conrreg, conoco, conodirco,
					conrcpco, cocoloco, conoloco, conomuco, cocopvco, cocopaco,
					conrtelco, conrfaxco, cocoemco, coferes, coinreenv,
					coteresp, cocotfpr, coinl37, conranrg, cocopro, cohdcodigo,
					cohora, cofechaconsumidor, noraPaisId, nombrePais,
					provinciaId, nombreProvincia, municipioId, nombreMunicipio,
					localidadId, nombreLocalidad, noraCalleId, nombreCalle,
					noraCpId, nombreCp, noraPortalId, nombrePortal, coinl21,
					cosituacion, nombrePiso, coextranjero, null, null, null,
					null);

			String xslString = estadisticasConsultasService
					.getEstadisticaConsultasExcel(consulta, cofechaDesde,
							cofechaHasta, indEstadisticaConsulta_);

			Date fechaHoy = new Date();
			String fechaActual = Y41aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			String nombre = appMessageSource.getMessage(
					"excel.titulo.consultas", null, locale)
					+ "_"
					+ fechaActual
					+ ".xls";

			response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");

			response.setContentType("application/vnd.ms-excel");
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ nombre);

			out = response.getOutputStream();
			out.write(xslString.getBytes());
			out.flush();
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}
}
