package com.ejie.y41a.control;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Actividad;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.EstablecimSector;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.EstablecimientoDetalle;
import com.ejie.y41a.model.EstablecimientoReclamacionesAnyo;
import com.ejie.y41a.model.EstablecimientoDecisionAnyo;
import com.ejie.y41a.model.Sector;
import com.ejie.y41a.service.EstablecimientoService;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

import com.ejie.y41a.constantes.Y41aConstantes;

/**
 * * EstablecimientoController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

/**
 *  
 * 
 */
@Controller
@RequestMapping(value = "/establecimiento")
public class EstablecimientoController {

	private static final Logger logger = LoggerFactory
			.getLogger(EstablecimientoController.class);

	@Autowired
	private EstablecimientoService establecimientoService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("establecimiento", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("establecimientoModal", "model", model);
	}

	/**
	 * Method 'getCreateModalSector'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "sectores", method = RequestMethod.GET)
	public ModelAndView getCreateModalSector(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("sectores", "model", model);
	}

	/**
	 * Method 'getCreateModalMantenimiento'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "mantenimiento", method = RequestMethod.GET)
	public ModelAndView getCreateModalMantenimiento(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("mantenimiento", "model", model);
	}

	/**
	 * Method 'getCreateModalNuReclamaciones'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "reclamaciones", method = RequestMethod.GET)
	public ModelAndView getCreateModalReclamaciones(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("reclamaciones", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param escodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{escodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Establecimiento getById(@PathVariable String escodigo) {
		try {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(escodigo);
			establecimiento = this.establecimientoService.find(establecimiento);
			if (establecimiento == null) {
				throw new Exception(escodigo.toString());
			}
			return establecimiento;
		} catch (Exception e) {
			throw new ResourceNotFoundException(escodigo.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param escodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/detalle", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimientoDetalle getEstablecimientoById(
			@RequestParam(value = "escodigo", required = true) String escodigo) {
		try {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(escodigo);
			EstablecimientoDetalle establecimientoDetalle = this.establecimientoService
					.findEstablecimiento(establecimiento);
			if (establecimientoDetalle == null) {
				throw new Exception(escodigo.toString());
			}
			return establecimientoDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(escodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param escodigo
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param esnombre
	 *            String
	 * @param esnif
	 *            String
	 * @param esnoan
	 *            String
	 * @param esnoco
	 *            String
	 * @param esnodir
	 *            String
	 * @param escolo
	 *            String
	 * @param esnrcopo
	 *            String
	 * @param esnrtel
	 *            String
	 * @param esnrfax
	 *            String
	 * @param escopa
	 *            String
	 * @param esincapr
	 *            String
	 * @param esindemp
	 *            String
	 * @param esteco
	 *            String
	 * @param esinadar
	 *            String
	 * @param esfeadar
	 *            Date
	 * @param escoem
	 *            String
	 * @param esinempr
	 *            String
	 * @param esnrtel2
	 *            String
	 * @param esfeba
	 *            Date
	 * @param esnoap1
	 *            String
	 * @param esnoap2
	 *            String
	 * @param esnolo
	 *            String
	 * @param escomapv
	 *            String
	 * @param escoca
	 *            String
	 * @param esnopeco
	 *            String
	 * @param escoidco
	 *            String
	 * @param esinreco
	 *            String
	 * @param esfemod
	 *            String
	 * @param esinesco
	 *            String
	 * @param esnomu
	 *            String
	 * @param esnorep
	 *            String
	 * @param esnifrep
	 *            String
	 * @param dtteemr
	 *            String
	 * @param escarep
	 *            String
	 * @param esteurl
	 *            String
	 * @param escooe
	 *            String
	 * @param esnodeco
	 *            String
	 * @param esintiar
	 *            String
	 * @param esfeplad
	 *            Date
	 * @param esindeme
	 *            String
	 * @param esnoraPaisId
	 *            String
	 * @param esnoraPaisNombre
	 *            String
	 * @param esnoraProvinciaId
	 *            String
	 * @param esnombreProvincia
	 *            String
	 * @param esnoraMunicipioId
	 *            String
	 * @param esnombreMunicipio
	 *            String
	 * @param esnoraLocalidadId
	 *            String
	 * @param esnombreLocalidad
	 *            String
	 * @param esnoraCalleId
	 *            String
	 * @param esnombreCalle
	 *            String
	 * @param esnoraCpId
	 *            String
	 * @param esnombreCp
	 *            String
	 * @param esnoraPortalId
	 *            String
	 * @param esnombrePortal
	 *            String
	 * @param esnombrePiso
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/establecimientosAll", method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "escodigo", required = false) String escodigo,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "esnombre", required = false) String esnombre,
			@RequestParam(value = "esnif", required = false) String esnif,
			@RequestParam(value = "esnoan", required = false) String esnoan,
			@RequestParam(value = "esnoco", required = false) String esnoco,
			@RequestParam(value = "esnodir", required = false) String esnodir,
			@RequestParam(value = "escolo", required = false) String escolo,
			@RequestParam(value = "esnrcopo", required = false) String esnrcopo,
			@RequestParam(value = "esnrtel", required = false) String esnrtel,
			@RequestParam(value = "esnrfax", required = false) String esnrfax,
			@RequestParam(value = "escopa", required = false) String escopa,
			@RequestParam(value = "esincapr", required = false) String esincapr,
			@RequestParam(value = "esindemp", required = false) String esindemp,
			@RequestParam(value = "esteco", required = false) String esteco,
			@RequestParam(value = "esinadar", required = false) String esinadar,
			@RequestParam(value = "esfeadar", required = false) Date esfeadar,
			@RequestParam(value = "escoem", required = false) String escoem,
			@RequestParam(value = "esinempr", required = false) String esinempr,
			@RequestParam(value = "esnrtel2", required = false) String esnrtel2,
			@RequestParam(value = "esfeba", required = false) Date esfeba,
			@RequestParam(value = "esnoap1", required = false) String esnoap1,
			@RequestParam(value = "esnoap2", required = false) String esnoap2,
			@RequestParam(value = "esnolo", required = false) String esnolo,
			@RequestParam(value = "escomapv", required = false) String escomapv,
			@RequestParam(value = "escoca", required = false) String escoca,
			@RequestParam(value = "esnopeco", required = false) String esnopeco,
			@RequestParam(value = "escoidco", required = false) String escoidco,
			@RequestParam(value = "esinreco", required = false) String esinreco,
			@RequestParam(value = "esfemod", required = false) String esfemod,
			@RequestParam(value = "esinesco", required = false) String esinesco,
			@RequestParam(value = "esnomu", required = false) String esnomu,
			@RequestParam(value = "esnorep", required = false) String esnorep,
			@RequestParam(value = "esnifrep", required = false) String esnifrep,
			@RequestParam(value = "dtteemr", required = false) String dtteemr,
			@RequestParam(value = "escarep", required = false) String escarep,
			@RequestParam(value = "esteurl", required = false) String esteurl,
			@RequestParam(value = "escooe", required = false) String escooe,
			@RequestParam(value = "esnodeco", required = false) String esnodeco,
			@RequestParam(value = "esintiar", required = false) String esintiar,
			@RequestParam(value = "esfeplad", required = false) Date esfeplad,
			@RequestParam(value = "esindeme", required = false) String esindeme,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId,
			@RequestParam(value = "esnoraPaisNombre", required = false) String esnoraPaisNombre,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId,
			@RequestParam(value = "esnombreProvincia", required = false) String esnombreProvincia,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId,
			@RequestParam(value = "esnombreMunicipio", required = false) String esnombreMunicipio,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId,
			@RequestParam(value = "esnombreLocalidad", required = false) String esnombreLocalidad,
			@RequestParam(value = "esnoraCalleId", required = false) String esnoraCalleId,
			@RequestParam(value = "esnombreCalle", required = false) String esnombreCalle,
			@RequestParam(value = "esnoraCpId", required = false) String esnoraCpId,
			@RequestParam(value = "esnombreCp", required = false) String esnombreCp,
			@RequestParam(value = "esnoraPortalId", required = false) String esnoraPortalId,
			@RequestParam(value = "esnombrePortal", required = false) String esnombrePortal,
			@RequestParam(value = "esnombrePiso", required = false) String esnombrePiso,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv,
			@RequestParam(value = "esextranjero", required = false) String esextranjero,
			@RequestParam(value = "esestado", required = false) String esestado,
			HttpServletRequest request) {
		try {
			Establecimiento filterEstablecimiento = new Establecimiento(
					escodigo, esnombre, esnif, esnoan, esnoco, esnodir, escolo,
					esnrcopo, esnrtel, esnrfax, escopa, esincapr, esindemp,
					esteco, esinadar, esfeadar, escoem, esinempr, esnrtel2,
					esfeba, esnoap1, esnoap2, esnolo, escomapv, escoca,
					esnopeco, escoidco, esinreco, esfemod, esinesco, esnomu,
					esnorep, esnifrep, dtteemr, escarep, esteurl, escooe,
					esnodeco, esintiar, esfeplad, esindeme, esnoraPaisId,
					esnoraPaisNombre, esnoraProvinciaId, esnombreProvincia,
					esnoraMunicipioId, esnombreMunicipio, esnoraLocalidadId,
					esnombreLocalidad, esnoraCalleId, esnombreCalle,
					esnoraCpId, esnombreCp, esnoraPortalId, esnombrePortal,
					esnombrePiso, esdireccion_nocapv, esextranjero, esestado,
					new CensoMonitor(censoMonitorMocodigo, null, null, null,
							null, null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Establecimiento> establecimientos = this.establecimientoService
						.findAll(filterEstablecimiento, pagination);

				if (establecimientos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterEstablecimiento, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(establecimientos);
				return data;
			} else {
				List<Establecimiento> establecimientos = this.establecimientoService
						.findAll(filterEstablecimiento, pagination);
				if (establecimientos == null) {
					throw new Exception("No data Found.");
				}
				return establecimientos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllEstablecimiento'.
	 * 
	 * @param escodigo
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param esnombre
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoan
	 *            String
	 * @param esnoco_
	 *            String
	 * @param esnodir
	 *            String
	 * @param escolo
	 *            String
	 * @param esnrcopo
	 *            String
	 * @param esnrtel
	 *            String
	 * @param esnrfax
	 *            String
	 * @param escopa
	 *            String
	 * @param esincapr
	 *            String
	 * @param esindemp_
	 *            String
	 * @param esteco
	 *            String
	 * @param esinadar_
	 *            String
	 * @param esfeadar
	 *            Date
	 * @param escoem
	 *            String
	 * @param esinempr
	 *            String
	 * @param esnrtel2
	 *            String
	 * @param esfeba
	 *            Date
	 * @param esnoap1
	 *            String
	 * @param esnoap2
	 *            String
	 * @param esnolo
	 *            String
	 * @param escomapv
	 *            String
	 * @param escoca
	 *            String
	 * @param esnopeco
	 *            String
	 * @param escoidco
	 *            String
	 * @param esinreco
	 *            String
	 * @param esfemod
	 *            String
	 * @param esinesco
	 *            String
	 * @param esnomu
	 *            String
	 * @param esnorep
	 *            String
	 * @param esnifrep
	 *            String
	 * @param dtteemr
	 *            String
	 * @param escarep
	 *            String
	 * @param esteurl
	 *            String
	 * @param escooe
	 *            String
	 * @param esnodeco
	 *            String
	 * @param esintiar
	 *            String
	 * @param esfeplad
	 *            Date
	 * @param esindeme
	 *            String
	 * @param esnoraPaisId
	 *            String
	 * @param esnoraPaisNombre
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param esnombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param esnombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param esnombreLocalidad
	 *            String
	 * @param esnoraCalleId
	 *            String
	 * @param esnombreCalle
	 *            String
	 * @param esnoraCpId
	 *            String
	 * @param esnombreCp
	 *            String
	 * @param esnoraPortalId
	 *            String
	 * @param esnombrePortal
	 *            String
	 * @param esnombrePiso
	 *            String
	 * @param esinfeba_
	 *            String
	 * @param sectorSecodigo_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllEstablecimiento(
			@RequestParam(value = "escodigo", required = false) String escodigo,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esnoan", required = false) String esnoan,
			@RequestParam(value = "esnoco", required = false) String esnoco_,
			@RequestParam(value = "esnodir", required = false) String esnodir,
			@RequestParam(value = "escolo", required = false) String escolo,
			@RequestParam(value = "esnrcopo", required = false) String esnrcopo,
			@RequestParam(value = "esnrtel", required = false) String esnrtel,
			@RequestParam(value = "esnrfax", required = false) String esnrfax,
			@RequestParam(value = "escopa", required = false) String escopa,
			@RequestParam(value = "esincapr", required = false) String esincapr,
			@RequestParam(value = "esindemp", required = false) String esindemp_,
			@RequestParam(value = "esteco", required = false) String esteco,
			@RequestParam(value = "esinadar", required = false) String esinadar_,
			@RequestParam(value = "esfeadar", required = false) Date esfeadar,
			@RequestParam(value = "escoem", required = false) String escoem,
			@RequestParam(value = "esinempr", required = false) String esinempr,
			@RequestParam(value = "esnrtel2", required = false) String esnrtel2,
			@RequestParam(value = "esfeba", required = false) Date esfeba,
			@RequestParam(value = "esnoap1", required = false) String esnoap1,
			@RequestParam(value = "esnoap2", required = false) String esnoap2,
			@RequestParam(value = "esnolo", required = false) String esnolo,
			@RequestParam(value = "escomapv", required = false) String escomapv,
			@RequestParam(value = "escoca", required = false) String escoca,
			@RequestParam(value = "esnopeco", required = false) String esnopeco,
			@RequestParam(value = "escoidco", required = false) String escoidco,
			@RequestParam(value = "esinreco", required = false) String esinreco,
			@RequestParam(value = "esfemod", required = false) String esfemod,
			@RequestParam(value = "esinesco", required = false) String esinesco,
			@RequestParam(value = "esnomu", required = false) String esnomu,
			@RequestParam(value = "esnorep", required = false) String esnorep,
			@RequestParam(value = "esnifrep", required = false) String esnifrep,
			@RequestParam(value = "dtteemr", required = false) String dtteemr,
			@RequestParam(value = "escarep", required = false) String escarep,
			@RequestParam(value = "esteurl", required = false) String esteurl,
			@RequestParam(value = "escooe", required = false) String escooe,
			@RequestParam(value = "esnodeco", required = false) String esnodeco,
			@RequestParam(value = "esintiar", required = false) String esintiar,
			@RequestParam(value = "esfeplad", required = false) Date esfeplad,
			@RequestParam(value = "esindeme", required = false) String esindeme,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esnoraPaisNombre", required = false) String esnoraPaisNombre,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "esnombreProvincia", required = false) String esnombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "esnombreMunicipio", required = false) String esnombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "esnombreLocalidad", required = false) String esnombreLocalidad,
			@RequestParam(value = "esnoraCalleId", required = false) String esnoraCalleId,
			@RequestParam(value = "esnombreCalle", required = false) String esnombreCalle,
			@RequestParam(value = "esnoraCpId", required = false) String esnoraCpId,
			@RequestParam(value = "esnombreCp", required = false) String esnombreCp,
			@RequestParam(value = "esnoraPortalId", required = false) String esnoraPortalId,
			@RequestParam(value = "esnombrePortal", required = false) String esnombrePortal,
			@RequestParam(value = "esnombrePiso", required = false) String esnombrePiso,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esinfeba", required = false) String esinfeba_,
			@RequestParam(value = "sectorSecodigo", required = false) String sectorSecodigo_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro
			String esnombre = devuelveValorFiltro(esnombre_);

			String esnoco = devuelveValorFiltro(esnoco_);
			String esnif = devuelveValorFiltro(esnif_);
			String esindemp = devuelveValorFiltro(esindemp_);

			String esinadar = devuelveValorFiltro(esinadar_);
			String esinfeba = devuelveValorFiltro(esinfeba_);

			String sectorSecodigo = devuelveValorFiltro(sectorSecodigo_);

			String esextranjero = "";
			String esestado = "";
			String provinciaId = "";
			String municipioId = "";
			String localidadId = "";
			String esnoraPaisId = "";
			String esdireccion_nocapv = "";

			if (Y41aConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41aConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(esextranjero_)) {
				esextranjero = Y41aConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
						: esnoraPaisId_;
				esestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				esdireccion_nocapv = devuelveValorFiltro(esdireccion_nocapv_);
			} else {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41aConstantes.NORA_LOCALIZACION_ESTADO;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				esdireccion_nocapv = devuelveValorFiltro(esdireccion_nocapv_);
			}

			Establecimiento filterEstablecimiento = new Establecimiento(
					escodigo, esnombre, esnif, esnoan, esnoco, esnodir, escolo,
					esnrcopo, esnrtel, esnrfax, escopa, esincapr, esindemp,
					esteco, esinadar, esfeadar, escoem, esinempr, esnrtel2,
					esfeba, esnoap1, esnoap2, esnolo, escomapv, escoca,
					esnopeco, escoidco, esinreco, esfemod, esinesco, esnomu,
					esnorep, esnifrep, dtteemr, escarep, esteurl, escooe,
					esnodeco, esintiar, esfeplad, esindeme, esnoraPaisId,
					esnoraPaisNombre, provinciaId, esnombreProvincia,
					municipioId, esnombreMunicipio, localidadId,
					esnombreLocalidad, esnoraCalleId, esnombreCalle,
					esnoraCpId, esnombreCp, esnoraPortalId, esnombrePortal,
					esnombrePiso, esdireccion_nocapv, esextranjero, esestado,
					new CensoMonitor(censoMonitorMocodigo, null, null, null,
							null, null, null, null, null, null, null, null));
			filterEstablecimiento.setEsinfeba(esinfeba);

			EstablecimSector filterEstablecimSector = new EstablecimSector(
					null, null, new Establecimiento(null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null),
					new Actividad(null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null), new Sector(sectorSecodigo, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null));

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Establecimiento> establecimientos = this.establecimientoService
						.findAllLikeEstablecimiento(filterEstablecimiento,
								filterEstablecimSector, pagination, false);

				if (establecimientos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.establecimientoService
						.findAllLikeEstablecimientoCount(filterEstablecimiento,
								filterEstablecimSector, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(establecimientos);
				return data;
			} else {
				List<Establecimiento> establecimientos = this.establecimientoService
						.findAllLikeEstablecimiento(filterEstablecimiento,
								filterEstablecimSector, pagination, false);
				if (establecimientos == null) {
					throw new Exception("No data Found.");
				}
				return establecimientos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterEstablecimiento
	 *            Establecimiento
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "establecimiento", required = false) Establecimiento filterEstablecimiento,
			HttpServletRequest request) {
		try {
			return establecimientoService
					.findAllCount(filterEstablecimiento != null ? filterEstablecimiento
							: new Establecimiento());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @param response
	 *            HttpServletResponse
	 * @return Establecimiento
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Establecimiento edit(@RequestBody Establecimiento establecimiento,
			HttpServletResponse response) {
		try {
			Establecimiento establecimientoAux = this.establecimientoService
					.update(establecimiento);
			logger.info("Entity correctly inserted!");
			return establecimientoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'updateEstablecimiento'.
	 * 
	 * @param establecimientoDetalle
	 *            EstablecimientoDetalle
	 * @param request
	 *            HttpServletRequest
	 * @return Establecimiento
	 */
	@RequestMapping(value = "/modificacionDetalle", method = RequestMethod.PUT)
	public @ResponseBody
	Establecimiento updateEstablecimiento(
			@RequestBody EstablecimientoDetalle establecimientoDetalle,
			HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			Establecimiento estableci;
			// estado
			if ((establecimientoDetalle.getEsextranjero())
					.equalsIgnoreCase(Y41aConstantes.NO)) {

				estableci = new Establecimiento(
						establecimientoDetalle.getEscodigo(),
						establecimientoDetalle.getEsnombre(),
						establecimientoDetalle.getEsnif(),
						establecimientoDetalle.getEsnoan(),
						establecimientoDetalle.getEsnoco(),
						establecimientoDetalle.getEsnodir(), "0",
						establecimientoDetalle.getEsnrcopo(),
						establecimientoDetalle.getEsnrtel(),
						establecimientoDetalle.getEsnrfax(),
						establecimientoDetalle.getEscopa(),
						establecimientoDetalle.getEsincapr(),
						establecimientoDetalle.getEsindemp(),
						establecimientoDetalle.getEsteco(),
						establecimientoDetalle.getEsinadar(),
						establecimientoDetalle.getEsfeadar(),
						establecimientoDetalle.getEscoem(),
						establecimientoDetalle.getEsinempr(),
						establecimientoDetalle.getEsnrtel2(),
						establecimientoDetalle.getEsfeba(),
						establecimientoDetalle.getEsnoap1(),
						establecimientoDetalle.getEsnoap2(),
						establecimientoDetalle.getEsnolo(),
						establecimientoDetalle.getEscomapv(),
						establecimientoDetalle.getEscoca(),
						establecimientoDetalle.getEsnopeco(),
						establecimientoDetalle.getEscoidco(),
						establecimientoDetalle.getEsinreco(),
						Y41aUtils.parseDateToString(new Date(),
								Y41aConstantes.CASTELLANO),
						establecimientoDetalle.getEsinesco(),
						establecimientoDetalle.getEsnomu(),
						establecimientoDetalle.getEsnorep(),
						establecimientoDetalle.getEsnifrep(),
						establecimientoDetalle.getDtteemr(),
						establecimientoDetalle.getEscarep(),
						establecimientoDetalle.getEsteurl(),
						establecimientoDetalle.getEscooe(),
						establecimientoDetalle.getEsnodeco(),
						establecimientoDetalle.getEsintiar(),
						establecimientoDetalle.getEsfeplad(),
						establecimientoDetalle.getEsindeme(), null, null,
						establecimientoDetalle.getProvinciaId(),
						establecimientoDetalle.getEsnombreProvincia(),
						establecimientoDetalle.getMunicipioId(),
						establecimientoDetalle.getEsnombreMunicipio(),
						establecimientoDetalle.getLocalidadId(),
						establecimientoDetalle.getEsnombreLocalidad(),
						establecimientoDetalle.getCalleId(),
						establecimientoDetalle.getCalleId_label(),
						establecimientoDetalle.getCpId(),
						establecimientoDetalle.getEsnombreCp(),
						establecimientoDetalle.getPortalId(),
						establecimientoDetalle.getEsnombrePortal(),
						establecimientoDetalle.getEsnombrePiso(),
						establecimientoDetalle.getEsdireccion_nocapv(),
						establecimientoDetalle.getEsextranjero(), null,
						censoMonitor);
			} else {
				// extranjero
				estableci = new Establecimiento(
						establecimientoDetalle.getEscodigo(),
						establecimientoDetalle.getEsnombre(),
						establecimientoDetalle.getEsnif(),
						establecimientoDetalle.getEsnoan(),
						establecimientoDetalle.getEsnoco(),
						establecimientoDetalle.getEsnodir(), "0",
						establecimientoDetalle.getEsnrcopo(),
						establecimientoDetalle.getEsnrtel(),
						establecimientoDetalle.getEsnrfax(),
						establecimientoDetalle.getEscopa(),
						establecimientoDetalle.getEsincapr(),
						establecimientoDetalle.getEsindemp(),
						establecimientoDetalle.getEsteco(),
						establecimientoDetalle.getEsinadar(),
						establecimientoDetalle.getEsfeadar(),
						establecimientoDetalle.getEscoem(),
						establecimientoDetalle.getEsinempr(),
						establecimientoDetalle.getEsnrtel2(),
						establecimientoDetalle.getEsfeba(),
						establecimientoDetalle.getEsnoap1(),
						establecimientoDetalle.getEsnoap2(),
						establecimientoDetalle.getEsnolo(),
						establecimientoDetalle.getEscomapv(),
						establecimientoDetalle.getEscoca(),
						establecimientoDetalle.getEsnopeco(),
						establecimientoDetalle.getEscoidco(),
						establecimientoDetalle.getEsinreco(),
						Y41aUtils.parseDateToString(new Date(),
								Y41aConstantes.CASTELLANO),
						establecimientoDetalle.getEsinesco(),
						establecimientoDetalle.getEsnomu(),
						establecimientoDetalle.getEsnorep(),
						establecimientoDetalle.getEsnifrep(),
						establecimientoDetalle.getDtteemr(),
						establecimientoDetalle.getEscarep(),
						establecimientoDetalle.getEsteurl(),
						establecimientoDetalle.getEscooe(),
						establecimientoDetalle.getEsnodeco(),
						establecimientoDetalle.getEsintiar(),
						establecimientoDetalle.getEsfeplad(),
						establecimientoDetalle.getEsindeme(),
						establecimientoDetalle.getEsnoraPaisId(),
						establecimientoDetalle.getEsnoraPaisNombre(), null,
						null, null, null, null, null, null, null,
						establecimientoDetalle.getCpId(),
						establecimientoDetalle.getEsnombreCp(), null, null,
						null, establecimientoDetalle.getEsdireccion_nocapv(),
						establecimientoDetalle.getEsextranjero(), null,
						censoMonitor);
			}

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(establecimientoDetalle.getEscodigo());

			Sector sector = new Sector();
			sector.setSecodigo(establecimientoDetalle.getSecodigo());

			Actividad actividad = new Actividad();
			String avCodigo = "";

			if (sector.getSecodigo().length() >= 3) {
				avCodigo = sector.getSecodigo().substring(0, 3);
			}
			actividad.setAvcodigo(avCodigo);

			EstablecimSector establecimSector = new EstablecimSector(
					establecimientoDetalle.getEacodigo(),
					// establecimientoDetalle.getEainprse(),
					Y41aConstantes.ACTIVIDAD_SECTOR_INDICADOR, establecimiento,
					actividad, sector);

			this.establecimientoService.updateEstablecimiento(estableci,
					establecimSector);

			logger.info("Entity correctly inserted!");
			return estableci;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param establecimiento
	 *            Establecimiento
	 * @return Establecimiento
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Establecimiento add(@RequestBody Establecimiento establecimiento) {
		try {

			Establecimiento establecimientoAux = this.establecimientoService
					.add(establecimiento);
			logger.info("Entity correctly inserted!");
			return establecimientoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addEstablecimiento'.
	 * 
	 * @param establecimientoDetalle
	 *            Establecimiento
	 * @param request
	 *            HttpServletRequest
	 * @return Establecimiento
	 */
	@RequestMapping(value = "/altaDetalle", method = RequestMethod.POST)
	public @ResponseBody
	Establecimiento addEstablecimiento(
			@RequestBody EstablecimientoDetalle establecimientoDetalle,
			HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			Establecimiento estableci;
			// estado
			if ((establecimientoDetalle.getEsextranjero())
					.equalsIgnoreCase(Y41aConstantes.NO)) {

				estableci = new Establecimiento(
						establecimientoDetalle.getEscodigo(),
						establecimientoDetalle.getEsnombre(),
						establecimientoDetalle.getEsnif(),
						establecimientoDetalle.getEsnoan(),
						establecimientoDetalle.getEsnoco(),
						establecimientoDetalle.getEsnodir(), "0",
						establecimientoDetalle.getEsnrcopo(),
						establecimientoDetalle.getEsnrtel(),
						establecimientoDetalle.getEsnrfax(),
						establecimientoDetalle.getEscopa(),
						establecimientoDetalle.getEsincapr(),
						establecimientoDetalle.getEsindemp(),
						establecimientoDetalle.getEsteco(),
						establecimientoDetalle.getEsinadar(),
						establecimientoDetalle.getEsfeadar(),
						establecimientoDetalle.getEscoem(),
						establecimientoDetalle.getEsinempr(),
						establecimientoDetalle.getEsnrtel2(),
						establecimientoDetalle.getEsfeba(),
						establecimientoDetalle.getEsnoap1(),
						establecimientoDetalle.getEsnoap2(),
						establecimientoDetalle.getEsnolo(),
						establecimientoDetalle.getEscomapv(),
						establecimientoDetalle.getEscoca(),
						establecimientoDetalle.getEsnopeco(),
						establecimientoDetalle.getEscoidco(),
						establecimientoDetalle.getEsinreco(),
						Y41aUtils.parseDateToString(new Date(),
								Y41aConstantes.CASTELLANO),
						establecimientoDetalle.getEsinesco(),
						establecimientoDetalle.getEsnomu(),
						establecimientoDetalle.getEsnorep(),
						establecimientoDetalle.getEsnifrep(),
						establecimientoDetalle.getDtteemr(),
						establecimientoDetalle.getEscarep(),
						establecimientoDetalle.getEsteurl(),
						establecimientoDetalle.getEscooe(),
						establecimientoDetalle.getEsnodeco(),
						establecimientoDetalle.getEsintiar(),
						establecimientoDetalle.getEsfeplad(),
						establecimientoDetalle.getEsindeme(), null, null,
						establecimientoDetalle.getProvinciaId(),
						establecimientoDetalle.getEsnombreProvincia(),
						establecimientoDetalle.getMunicipioId(),
						establecimientoDetalle.getEsnombreMunicipio(),
						establecimientoDetalle.getLocalidadId(),
						establecimientoDetalle.getEsnombreLocalidad(),
						establecimientoDetalle.getCalleId(),
						establecimientoDetalle.getCalleId_label(),
						establecimientoDetalle.getCpId(),
						establecimientoDetalle.getEsnombreCp(),
						establecimientoDetalle.getPortalId(),
						establecimientoDetalle.getEsnombrePortal(),
						establecimientoDetalle.getEsnombrePiso(),
						establecimientoDetalle.getEsdireccion_nocapv(),
						establecimientoDetalle.getEsextranjero(), null,
						censoMonitor);
			} else {
				// extranjero
				estableci = new Establecimiento(
						establecimientoDetalle.getEscodigo(),
						establecimientoDetalle.getEsnombre(),
						establecimientoDetalle.getEsnif(),
						establecimientoDetalle.getEsnoan(),
						establecimientoDetalle.getEsnoco(),
						establecimientoDetalle.getEsnodir(), "0",
						establecimientoDetalle.getEsnrcopo(),
						establecimientoDetalle.getEsnrtel(),
						establecimientoDetalle.getEsnrfax(),
						establecimientoDetalle.getEscopa(),
						establecimientoDetalle.getEsincapr(),
						establecimientoDetalle.getEsindemp(),
						establecimientoDetalle.getEsteco(),
						establecimientoDetalle.getEsinadar(),
						establecimientoDetalle.getEsfeadar(),
						establecimientoDetalle.getEscoem(),
						establecimientoDetalle.getEsinempr(),
						establecimientoDetalle.getEsnrtel2(),
						establecimientoDetalle.getEsfeba(),
						establecimientoDetalle.getEsnoap1(),
						establecimientoDetalle.getEsnoap2(),
						establecimientoDetalle.getEsnolo(),
						establecimientoDetalle.getEscomapv(),
						establecimientoDetalle.getEscoca(),
						establecimientoDetalle.getEsnopeco(),
						establecimientoDetalle.getEscoidco(),
						establecimientoDetalle.getEsinreco(),
						Y41aUtils.parseDateToString(new Date(),
								Y41aConstantes.CASTELLANO),
						establecimientoDetalle.getEsinesco(),
						establecimientoDetalle.getEsnomu(),
						establecimientoDetalle.getEsnorep(),
						establecimientoDetalle.getEsnifrep(),
						establecimientoDetalle.getDtteemr(),
						establecimientoDetalle.getEscarep(),
						establecimientoDetalle.getEsteurl(),
						establecimientoDetalle.getEscooe(),
						establecimientoDetalle.getEsnodeco(),
						establecimientoDetalle.getEsintiar(),
						establecimientoDetalle.getEsfeplad(),
						establecimientoDetalle.getEsindeme(),
						establecimientoDetalle.getEsnoraPaisId(),
						establecimientoDetalle.getEsnoraPaisNombre(), null,
						null, null, null, null, null, null, null,
						establecimientoDetalle.getCpId(),
						establecimientoDetalle.getEsnombreCp(), null, null,
						null, establecimientoDetalle.getEsdireccion_nocapv(),
						establecimientoDetalle.getEsextranjero(), null,
						censoMonitor);
			}
			// Establecimiento estableci = new Establecimiento(
			// establecimientoDetalle.getEscodigo(),
			// establecimientoDetalle.getEsnombre(),
			// establecimientoDetalle.getEsnif(),
			// establecimientoDetalle.getEsnoan(),
			// establecimientoDetalle.getEsnoco(),
			// establecimientoDetalle.getEsnodir(), "0",
			// establecimientoDetalle.getEsnrcopo(),
			// establecimientoDetalle.getEsnrtel(),
			// establecimientoDetalle.getEsnrfax(),
			// establecimientoDetalle.getEscopa(),
			// establecimientoDetalle.getEsincapr(),
			// establecimientoDetalle.getEsindemp(),
			// establecimientoDetalle.getEsteco(),
			// establecimientoDetalle.getEsinadar(),
			// establecimientoDetalle.getEsfeadar(),
			// establecimientoDetalle.getEscoem(),
			// establecimientoDetalle.getEsinempr(),
			// establecimientoDetalle.getEsnrtel2(),
			// establecimientoDetalle.getEsfeba(),
			// establecimientoDetalle.getEsnoap1(),
			// establecimientoDetalle.getEsnoap2(),
			// establecimientoDetalle.getEsnolo(),
			// establecimientoDetalle.getEscomapv(),
			// establecimientoDetalle.getEscoca(),
			// establecimientoDetalle.getEsnopeco(),
			// establecimientoDetalle.getEscoidco(),
			// establecimientoDetalle.getEsinreco(),
			// Y41aUtils.parseDateToString(new Date(),
			// Y41aConstantes.CASTELLANO),
			// establecimientoDetalle.getEsinesco(),
			// establecimientoDetalle.getEsnomu(),
			// establecimientoDetalle.getEsnorep(),
			// establecimientoDetalle.getEsnifrep(),
			// establecimientoDetalle.getDtteemr(),
			// establecimientoDetalle.getEscarep(),
			// establecimientoDetalle.getEsteurl(),
			// establecimientoDetalle.getEscooe(),
			// establecimientoDetalle.getEsnodeco(),
			// establecimientoDetalle.getEsintiar(),
			// establecimientoDetalle.getEsfeplad(),
			// establecimientoDetalle.getEsindeme(),
			// establecimientoDetalle.getEsnoraPaisId(),
			// establecimientoDetalle.getEsnoraPaisNombre(),
			// establecimientoDetalle.getProvinciaId(),
			// establecimientoDetalle.getEsnombreProvincia(),
			// establecimientoDetalle.getMunicipioId(),
			// establecimientoDetalle.getEsnombreMunicipio(),
			// establecimientoDetalle.getLocalidadId(),
			// establecimientoDetalle.getEsnombreLocalidad(),
			// establecimientoDetalle.getCalleId(),
			// establecimientoDetalle.getCalleId_label(),
			// establecimientoDetalle.getCpId(),
			// establecimientoDetalle.getEsnombreCp(),
			// establecimientoDetalle.getPortalId(),
			// establecimientoDetalle.getEsnombrePortal(),
			// establecimientoDetalle.getEsnombrePiso(),
			// establecimientoDetalle.getEsdireccion_nocapv(),
			// establecimientoDetalle.getEsextranjero(), censoMonitor);

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(establecimientoDetalle.getEscodigo());

			Sector sector = new Sector();
			sector.setSecodigo(establecimientoDetalle.getSecodigo());

			Actividad actividad = new Actividad();
			String avCodigo = "";

			if (sector.getSecodigo().length() >= 3) {
				avCodigo = sector.getSecodigo().substring(0, 3);
			}
			actividad.setAvcodigo(avCodigo);

			EstablecimSector establecimSector = new EstablecimSector(
					establecimientoDetalle.getEacodigo(),
					// establecimientoDetalle.getEainprse(),
					Y41aConstantes.ACTIVIDAD_SECTOR_INDICADOR, establecimiento,
					actividad, sector);

			this.establecimientoService.addEstablecimiento(estableci,
					establecimSector);

			logger.info("Entity correctly inserted!");
			return estableci;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param escodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{escodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String escodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(escodigo);
			this.establecimientoService.remove(establecimiento);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + escodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param escodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "removeEstablecimiento/{escodigo}", method = RequestMethod.DELETE)
	public void removeEstablecimiento(@PathVariable String escodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {

			Establecimiento establecimiento = new Establecimiento();
			establecimiento.setEscodigo(escodigo);

			EstablecimSector establecimSector = new EstablecimSector();

			establecimSector.setEstablecimiento(establecimiento);

			this.establecimientoService.removeEstablecimiento(establecimiento,
					establecimSector);

			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + escodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param establecimientoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> establecimientoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Establecimiento> establecimientoList = new ArrayList<Establecimiento>();
		try {
			for (ArrayList<String> establecimientoId : establecimientoIds) {
				Iterator<String> iterator = establecimientoId.iterator();
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				establecimientoList.add(establecimiento);
			}
			this.establecimientoService.removeMultiple(establecimientoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'fusionarEstablecimiento'.
	 * 
	 * @param establecimientoIdBueno
	 * 
	 * @param establecimientoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/fusionarEstablecimiento", method = RequestMethod.POST)
	public void fusionarEstablecimiento(
			@RequestParam(value = "escodigo", required = true) String escodigo,
			@RequestBody ArrayList<String> establecimientoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");

		ArrayList<Establecimiento> establecimientoList = new ArrayList<Establecimiento>();
		try {

			for (String establecimientoId : establecimientoIds) {
				Establecimiento establecimiento = new Establecimiento();
				establecimiento.setEscodigo(establecimientoId);
				establecimientoList.add(establecimiento);
			}

			Establecimiento establecimientoCodigo = new Establecimiento();
			establecimientoCodigo.setEscodigo(escodigo);

			this.establecimientoService.fusionEstablecimientos(
					establecimientoCodigo, establecimientoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error(e.getMessage());
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException(e.getMessage());
		}
	}

	/**
	 * Method 'getReclamacionesAnyo'.
	 * 
	 * @param escodigo
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/reclamacionesAnyo/{escodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getReclamacionesAnyo(@PathVariable String escodigo,
			HttpServletRequest request) {
		try {
			Establecimiento filterEstablecimiento = new Establecimiento();

			filterEstablecimiento.setEscodigo(escodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<EstablecimientoReclamacionesAnyo> establecimientoReclamacionesAnyo = this.establecimientoService
						.findAllEstablecimientoReclamacionesAnyo(
								filterEstablecimiento, pagination);

				if (establecimientoReclamacionesAnyo == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountReclamaciones(filterEstablecimiento,
						request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(establecimientoReclamacionesAnyo);
				return data;
			} else {
				List<EstablecimientoReclamacionesAnyo> establecimientoReclamacionesAnyo = this.establecimientoService
						.findAllEstablecimientoReclamacionesAnyo(
								filterEstablecimiento, pagination);
				if (establecimientoReclamacionesAnyo == null) {
					throw new Exception("No data Found.");
				}
				return establecimientoReclamacionesAnyo;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountReclamaciones'.
	 * 
	 * @param filterEstablecimiento
	 *            Establecimiento
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countReclamaciones", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountReclamaciones(
			@RequestParam(value = "establecimiento", required = false) Establecimiento filterEstablecimiento,
			HttpServletRequest request) {
		try {
			return establecimientoService
					.findAllEstablecimientoReclamacionesAnyoCount(filterEstablecimiento != null ? filterEstablecimiento
							: new Establecimiento());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getDecisionesAnyo'.
	 * 
	 * @param escodigo
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/decisionesAnyo/{escodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getDecisionesAnyo(@PathVariable String escodigo,
			HttpServletRequest request) {
		try {
			Establecimiento filterEstablecimiento = new Establecimiento();

			filterEstablecimiento.setEscodigo(escodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<EstablecimientoDecisionAnyo> establecimientoDecisionAnyo = this.establecimientoService
						.findAllEstablecimientoDecisionAnyo(
								filterEstablecimiento, pagination);

				if (establecimientoDecisionAnyo == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountDecision(filterEstablecimiento, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(establecimientoDecisionAnyo);
				return data;
			} else {
				List<EstablecimientoDecisionAnyo> establecimientoDecisionAnyo = this.establecimientoService
						.findAllEstablecimientoDecisionAnyo(
								filterEstablecimiento, pagination);
				if (establecimientoDecisionAnyo == null) {
					throw new Exception("No data Found.");
				}
				return establecimientoDecisionAnyo;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountDecision'.
	 * 
	 * @param filterEstablecimiento
	 *            Establecimiento
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countDecision", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountDecision(
			@RequestParam(value = "establecimiento", required = false) Establecimiento filterEstablecimiento,
			HttpServletRequest request) {
		try {
			return establecimientoService
					.findAllEstablecimientoDecisionAnyoCount(filterEstablecimiento != null ? filterEstablecimiento
							: new Establecimiento());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getEstablecimientoService'.
	 * 
	 * @return EstablecimientoService
	 */
	protected EstablecimientoService getEstablecimientoService() {
		return this.establecimientoService;
	}

	/**
	 * Method 'setEstablecimientoService'.
	 * 
	 * @param establecimientoService
	 *            EstablecimientoService
	 * @return
	 */
	public void setEstablecimientoService(
			EstablecimientoService establecimientoService) {
		this.establecimientoService = establecimientoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * 
	 * @param cadena
	 *            cadena
	 * @return valor o ""
	 */
	private static String devuelveValorFiltro(String cadena) {
		if (null != cadena && !"".equalsIgnoreCase(cadena)) {
			return cadena;
		} else {
			return null;
		}
	}
}
