package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Actividad;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.model.Sector;
import com.ejie.y41a.service.EstablecimSectorService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.EstablecimSector;

/**
 * * EstablecimSectorController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/establecimsector")
public class EstablecimSectorController {

	private static final Logger logger = LoggerFactory
			.getLogger(EstablecimSectorController.class);

	@Autowired
	private EstablecimSectorService establecimSectorService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("establecimsector", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param eacodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{eacodigo}", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimSector getById(@PathVariable String eacodigo) {
		try {
			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEacodigo(eacodigo);
			establecimSector = this.establecimSectorService
					.find(establecimSector);
			if (establecimSector == null) {
				throw new Exception(eacodigo.toString());
			}
			return establecimSector;
		} catch (Exception e) {
			throw new ResourceNotFoundException(eacodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param eacodigo
	 *            String
	 * @param establecimientoEscodigo
	 *            String
	 * @param actividadAvcodigo
	 *            String
	 * @param sectorSecodigo
	 *            String
	 * @param eainprse
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "eacodigo", required = false) String eacodigo,
			@RequestParam(value = "establecimientoEscodigo", required = false) String establecimientoEscodigo,
			@RequestParam(value = "actividadAvcodigo", required = false) String actividadAvcodigo,
			@RequestParam(value = "sectorSecodigo", required = false) String sectorSecodigo,
			@RequestParam(value = "eainprse", required = false) String eainprse,
			HttpServletRequest request) {
		try {
			EstablecimSector filterEstablecimSector = new EstablecimSector(
					eacodigo, eainprse, new Establecimiento(
							establecimientoEscodigo, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null),
					new Actividad(actividadAvcodigo, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null), new Sector(
							sectorSecodigo, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<EstablecimSector> establecimSectors = this.establecimSectorService
						.findAll(filterEstablecimSector, pagination);

				if (establecimSectors == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterEstablecimSector, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(establecimSectors);
				return data;
			} else {
				List<EstablecimSector> establecimSectors = this.establecimSectorService
						.findAll(filterEstablecimSector, pagination);
				if (establecimSectors == null) {
					throw new Exception("No data Found.");
				}
				return establecimSectors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterEstablecimSector
	 *            EstablecimSector
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "establecimSector", required = false) EstablecimSector filterEstablecimSector,
			HttpServletRequest request) {
		try {
			return establecimSectorService
					.findAllCount(filterEstablecimSector != null ? filterEstablecimSector
							: new EstablecimSector());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param establecimSector
	 *            EstablecimSector
	 * @param response
	 *            HttpServletResponse
	 * @return EstablecimSector
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	EstablecimSector edit(@RequestBody EstablecimSector establecimSector,
			HttpServletResponse response) {
		try {
			EstablecimSector establecimSectorAux = this.establecimSectorService
					.update(establecimSector);
			logger.info("Entity correctly inserted!");
			return establecimSectorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param establecimSector
	 *            EstablecimSector
	 * @return EstablecimSector
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	EstablecimSector add(@RequestBody EstablecimSector establecimSector) {
		try {
			EstablecimSector establecimSectorAux = this.establecimSectorService
					.add(establecimSector);
			logger.info("Entity correctly inserted!");
			return establecimSectorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param eacodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{eacodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String eacodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			EstablecimSector establecimSector = new EstablecimSector();
			establecimSector.setEacodigo(eacodigo);
			this.establecimSectorService.remove(establecimSector);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + eacodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param establecimSectorIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> establecimSectorIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<EstablecimSector> establecimSectorList = new ArrayList<EstablecimSector>();
		try {
			for (ArrayList<String> establecimSectorId : establecimSectorIds) {
				Iterator<String> iterator = establecimSectorId.iterator();
				EstablecimSector establecimSector = new EstablecimSector();
				establecimSector.setEacodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				establecimSectorList.add(establecimSector);
			}
			this.establecimSectorService.removeMultiple(establecimSectorList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getEstablecimSectorService'.
	 * 
	 * @return EstablecimSectorService
	 */
	protected EstablecimSectorService getEstablecimSectorService() {
		return this.establecimSectorService;
	}

	/**
	 * Method 'setEstablecimSectorService'.
	 * 
	 * @param establecimSectorService
	 *            EstablecimSectorService
	 * @return
	 */
	public void setEstablecimSectorService(
			EstablecimSectorService establecimSectorService) {
		this.establecimSectorService = establecimSectorService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
