package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Establecimiento;
import com.ejie.y41a.service.EstablecimArbitraService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.EstablecimArbitra;

/**
 * * EstablecimArbitraController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/establecimarbitra")
public class EstablecimArbitraController {

	private static final Logger logger = LoggerFactory
			.getLogger(EstablecimArbitraController.class);

	@Autowired
	private EstablecimArbitraService establecimArbitraService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("establecimarbitra", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param ahcodigo
	 *            String
	 * @param establecimientoEscodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{ahcodigo}/{establecimientoEscodigo}", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimArbitra getById(@PathVariable String ahcodigo,
			@PathVariable String establecimientoEscodigo) {
		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.setAhcodigo(ahcodigo);
			establecimArbitra.getEstablecimiento().setEscodigo(
					establecimientoEscodigo);
			establecimArbitra = this.establecimArbitraService
					.find(establecimArbitra);
			if (establecimArbitra == null) {
				throw new Exception(ahcodigo.toString()
						+ establecimientoEscodigo.toString());
			}
			return establecimArbitra;
		} catch (Exception e) {
			throw new ResourceNotFoundException(ahcodigo.toString()
					+ establecimientoEscodigo.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param establecimientoEscodigo
	 *            String
	 * @return String
	 */

	@RequestMapping(value = "/detalleAdhesion", method = RequestMethod.GET)
	public @ResponseBody
	EstablecimArbitra getArbitrajeById(
			@RequestParam(value = "establecimientoEscodigo", required = true) String establecimientoEscodigo) {
		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.getEstablecimiento().setEscodigo(
					establecimientoEscodigo);
			establecimArbitra = this.establecimArbitraService
					.findArbitraje(establecimArbitra);
			if (establecimArbitra == null) {
				throw new Exception(establecimientoEscodigo.toString());
			}
			return establecimArbitra;
		} catch (Exception e) {
			throw new ResourceNotFoundException(
					establecimientoEscodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param ahcodigo
	 *            String
	 * @param establecimientoEscodigo
	 *            String
	 * @param ahcoex
	 *            Integer
	 * @param ahnrdi
	 *            Integer
	 * @param ahfecodi
	 *            Date
	 * @param ahfeba
	 *            Date
	 * @param ahcotag
	 *            String
	 * @param ahcot2
	 *            String
	 * @param ahcoav
	 *            String
	 * @param ahcose
	 *            String
	 * @param ahcosede
	 *            String
	 * @param ahfepucd
	 *            Date
	 * @param ahfepuba
	 *            Date
	 * @param ahcocc
	 *            String
	 * @param ahnirep
	 *            String
	 * @param ahnorep
	 *            String
	 * @param ahnoap1r
	 *            String
	 * @param ahnoap2r
	 *            String
	 * @param ahnocare
	 *            String
	 * @param ahfere
	 *            Date
	 * @param ahtelimi
	 *            String
	 * @param ahinamna
	 *            String
	 * @param ahcoja
	 *            String
	 * @param ahcozs
	 *            String
	 * @param ahcojaad
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "ahcodigo", required = false) String ahcodigo,
			@RequestParam(value = "establecimientoEscodigo", required = false) String establecimientoEscodigo,
			@RequestParam(value = "ahcoex", required = false) Integer ahcoex,
			@RequestParam(value = "ahnrdi", required = false) Integer ahnrdi,
			@RequestParam(value = "ahfecodi", required = false) Date ahfecodi,
			@RequestParam(value = "ahfeba", required = false) Date ahfeba,
			@RequestParam(value = "ahcotag", required = false) String ahcotag,
			@RequestParam(value = "ahcot2", required = false) String ahcot2,
			@RequestParam(value = "ahcoav", required = false) String ahcoav,
			@RequestParam(value = "ahcose", required = false) String ahcose,
			@RequestParam(value = "ahcosede", required = false) String ahcosede,
			@RequestParam(value = "ahfepucd", required = false) Date ahfepucd,
			@RequestParam(value = "ahfepuba", required = false) Date ahfepuba,
			@RequestParam(value = "ahcocc", required = false) String ahcocc,
			@RequestParam(value = "ahnirep", required = false) String ahnirep,
			@RequestParam(value = "ahnorep", required = false) String ahnorep,
			@RequestParam(value = "ahnoap1r", required = false) String ahnoap1r,
			@RequestParam(value = "ahnoap2r", required = false) String ahnoap2r,
			@RequestParam(value = "ahnocare", required = false) String ahnocare,
			@RequestParam(value = "ahfere", required = false) Date ahfere,
			@RequestParam(value = "ahtelimi", required = false) String ahtelimi,
			@RequestParam(value = "ahinamna", required = false) String ahinamna,
			@RequestParam(value = "ahcoja", required = false) String ahcoja,
			@RequestParam(value = "ahcozs", required = false) String ahcozs,
			@RequestParam(value = "ahcojaad", required = false) String ahcojaad,
			HttpServletRequest request) {
		try {
			EstablecimArbitra filterEstablecimArbitra = new EstablecimArbitra(
					ahcodigo, new Establecimiento(establecimientoEscodigo,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null), ahcoex, ahnrdi, ahfecodi,
					ahfeba, ahcotag, ahcot2, ahcoav, ahcose, ahcosede,
					ahfepucd, ahfepuba, ahcocc, ahnirep, ahnorep, ahnoap1r,
					ahnoap2r, ahnocare, ahfere, ahtelimi, ahinamna, ahcoja,
					ahcozs, ahcojaad);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<EstablecimArbitra> establecimArbitras = this.establecimArbitraService
						.findAll(filterEstablecimArbitra, pagination);

				if (establecimArbitras == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterEstablecimArbitra, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(establecimArbitras);
				return data;
			} else {
				List<EstablecimArbitra> establecimArbitras = this.establecimArbitraService
						.findAll(filterEstablecimArbitra, pagination);
				if (establecimArbitras == null) {
					throw new Exception("No data Found.");
				}
				return establecimArbitras;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterEstablecimArbitra
	 *            EstablecimArbitra
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "establecimArbitra", required = false) EstablecimArbitra filterEstablecimArbitra,
			HttpServletRequest request) {
		try {
			return establecimArbitraService
					.findAllCount(filterEstablecimArbitra != null ? filterEstablecimArbitra
							: new EstablecimArbitra());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @param response
	 *            HttpServletResponse
	 * @return EstablecimArbitra
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	EstablecimArbitra edit(@RequestBody EstablecimArbitra establecimArbitra,
			HttpServletResponse response) {
		try {
			EstablecimArbitra establecimArbitraAux = this.establecimArbitraService
					.update(establecimArbitra);
			logger.info("Entity correctly inserted!");
			return establecimArbitraAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param establecimArbitra
	 *            EstablecimArbitra
	 * @return EstablecimArbitra
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	EstablecimArbitra add(@RequestBody EstablecimArbitra establecimArbitra) {
		try {
			EstablecimArbitra establecimArbitraAux = this.establecimArbitraService
					.add(establecimArbitra);
			logger.info("Entity correctly inserted!");
			return establecimArbitraAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param ahcodigo
	 *            String
	 * @param establecimientoEscodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{ahcodigo}/{establecimientoEscodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String ahcodigo,
			@PathVariable String establecimientoEscodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			EstablecimArbitra establecimArbitra = new EstablecimArbitra();
			establecimArbitra.setEstablecimiento(new Establecimiento());
			establecimArbitra.setAhcodigo(ahcodigo);
			establecimArbitra.getEstablecimiento().setEscodigo(
					establecimientoEscodigo);
			this.establecimArbitraService.remove(establecimArbitra);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + ahcodigo
					+ establecimientoEscodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param establecimArbitraIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> establecimArbitraIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<EstablecimArbitra> establecimArbitraList = new ArrayList<EstablecimArbitra>();
		try {
			for (ArrayList<String> establecimArbitraId : establecimArbitraIds) {
				Iterator<String> iterator = establecimArbitraId.iterator();
				EstablecimArbitra establecimArbitra = new EstablecimArbitra();
				establecimArbitra.setEstablecimiento(new Establecimiento());
				establecimArbitra.setAhcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				establecimArbitra.getEstablecimiento().setEscodigo(
						ObjectConversionManager.convert(iterator.next(),
								String.class));
				establecimArbitraList.add(establecimArbitra);
			}
			this.establecimArbitraService.removeMultiple(establecimArbitraList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getEstablecimArbitraService'.
	 * 
	 * @return EstablecimArbitraService
	 */
	protected EstablecimArbitraService getEstablecimArbitraService() {
		return this.establecimArbitraService;
	}

	/**
	 * Method 'setEstablecimArbitraService'.
	 * 
	 * @param establecimArbitraService
	 *            EstablecimArbitraService
	 * @return
	 */
	public void setEstablecimArbitraService(
			EstablecimArbitraService establecimArbitraService) {
		this.establecimArbitraService = establecimArbitraService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
