package com.ejie.y41a.control;

import java.util.Properties;

import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;

/**
 * * ConsultaController generated by UDA, 24-ene-2012 8:50:50.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/escritorio")
public class EscritorioController {

	private static final Logger logger = LoggerFactory
			.getLogger(EscritorioController.class);

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            ServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model, ServletRequest request) {
		if (request instanceof HttpServletRequest) {
			HttpServletRequest httpRequest = (HttpServletRequest) request;

			HttpSession httpSession = httpRequest.getSession(false);

			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			if (Y41aConstantes.PRIMERA_VEZ.equals(censoMonitor.getMoprimera())) {
				model.addAttribute("defaultLanguage", this.appConfiguration
						.get("y41aVistaWar.default.language"));
				model.addAttribute("defaultLayout", this.appConfiguration
						.get("y41aVistaWar.default.layout"));
				request.setAttribute("R01HNoPortal", "true");
				model.addAttribute("censoMonitor", censoMonitor);

				return new ModelAndView("primeraVezLogin", "model", model);
			} else {
				model.addAttribute("defaultLanguage", this.appConfiguration
						.get("y41aVistaWar.default.language"));
				model.addAttribute("defaultLayout", this.appConfiguration
						.get("y41aVistaWar.default.layout"));
				request.setAttribute("R01HNoPortal", "true");
				model.addAttribute("censoMonitor", censoMonitor);

				return new ModelAndView("inicio", "model", model);
			}
		} else {
			model.addAttribute("defaultLanguage",
					this.appConfiguration.get("y41aVistaWar.default.language"));
			model.addAttribute("defaultLayout",
					this.appConfiguration.get("y41aVistaWar.default.layout"));
			request.setAttribute("R01HNoPortal", "true");

			return new ModelAndView("inicio", "model", model);
		}
	}

	/**
	 * Method 'getCreateForm_avisolegal'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "aviso_legal", method = RequestMethod.GET)
	public ModelAndView getCreateFormAvisolegal(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("aviso_legal", "model", model);
	}

	/**
	 * Method 'getCreateForm_privacidad'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "privacidad", method = RequestMethod.GET)
	public ModelAndView getCreateFormPrivacidad(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("privacidad_modal", "model", model);
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
