package com.ejie.y41a.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.y41a.model.DocumentoHecho;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.model.TramiteHecho;
import com.ejie.y41a.service.DocumentoHechoService;

/**
 * * DocumentoHechoController generated by UDA, 22-feb-2012 17:30:45.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/documentohecho")
public class DocumentoHechoController {

	private static final Logger logger = LoggerFactory
			.getLogger(DocumentoHechoController.class);

	@Autowired
	private DocumentoHechoService documentoHechoService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("documentohecho", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param q5codocumento
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{q5codocumento}", method = RequestMethod.GET)
	public @ResponseBody
	DocumentoHecho getById(@PathVariable String q5codocumento) {
		try {
			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5codocumento(q5codocumento);
			documentoHecho = this.documentoHechoService.find(documentoHecho);
			if (documentoHecho == null) {
				throw new Exception(q5codocumento.toString());
			}
			return documentoHecho;
		} catch (Exception e) {
			throw new ResourceNotFoundException(q5codocumento.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param q5codocumento
	 *            String
	 * @param tramiteHechoEhcodigo
	 *            String
	 * @param tramiteHechoEhcodigo
	 *            String
	 * @param hechoDenunciadoHdcodigo
	 *            String
	 * @param q5nofile
	 *            String
	 * @param q5sizefile
	 *            Integer
	 * @param q5tedesfile
	 *            String
	 * @param q5origen
	 *            String
	 * @param q5fecha
	 *            Date
	 * @param q5indmail
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "q5codocumento", required = false) String q5codocumento,
			@RequestParam(value = "tramiteHechoEhcodigo", required = false) String tramiteHechoEhcodigo,
			@RequestParam(value = "hechoDenunciadoHdcodigo", required = false) String hechoDenunciadoHdcodigo,
			@RequestParam(value = "q5nofile", required = false) String q5nofile,
			@RequestParam(value = "q5sizefile", required = false) Integer q5sizefile,
			@RequestParam(value = "q5tedesfile", required = false) String q5tedesfile,
			@RequestParam(value = "q5origen", required = false) String q5origen,
			@RequestParam(value = "q5fecha", required = false) Date q5fecha,
			@RequestParam(value = "q5indmail", required = false) String q5indmail,
			HttpServletRequest request) {
		try {
			TramiteHecho tramiteHecho = new TramiteHecho();
			tramiteHecho.setEhcodigo(tramiteHechoEhcodigo);
			DocumentoHecho filterDocumentoHecho = new DocumentoHecho(
					q5codocumento, q5nofile, null, q5sizefile, q5tedesfile,
					q5origen, q5fecha, q5indmail, null, tramiteHecho,
					tramiteHecho, new HechoDenunciado(hechoDenunciadoHdcodigo,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<DocumentoHecho> documentoHechos = this.documentoHechoService
						.findAll(filterDocumentoHecho, pagination);

				if (documentoHechos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterDocumentoHecho, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(documentoHechos);
				return data;
			} else {
				List<DocumentoHecho> documentoHechos = this.documentoHechoService
						.findAll(filterDocumentoHecho, pagination);
				if (documentoHechos == null) {
					throw new Exception("No data Found.");
				}
				return documentoHechos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterDocumentoHecho
	 *            DocumentoHecho
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "documentoHecho", required = false) DocumentoHecho filterDocumentoHecho,
			HttpServletRequest request) {
		try {
			return documentoHechoService
					.findAllCount(filterDocumentoHecho != null ? filterDocumentoHecho
							: new DocumentoHecho());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @param response
	 *            HttpServletResponse
	 * @return DocumentoHecho
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	DocumentoHecho edit(@RequestBody DocumentoHecho documentoHecho,
			HttpServletResponse response) {
		try {
			DocumentoHecho documentoHechoAux = this.documentoHechoService
					.update(documentoHecho);
			logger.info("Entity correctly inserted!");
			return documentoHechoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param documentoHecho
	 *            DocumentoHecho
	 * @return DocumentoHecho
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	DocumentoHecho add(@RequestBody DocumentoHecho documentoHecho) {
		try {
			DocumentoHecho documentoHechoAux = this.documentoHechoService
					.add(documentoHecho);
			logger.info("Entity correctly inserted!");
			return documentoHechoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param q5codocumento
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{q5codocumento}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String q5codocumento,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			DocumentoHecho documentoHecho = new DocumentoHecho();
			documentoHecho.setQ5codocumento(q5codocumento);
			this.documentoHechoService.remove(documentoHecho);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + q5codocumento);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param documentoHechoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> documentoHechoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<DocumentoHecho> documentoHechoList = new ArrayList<DocumentoHecho>();
		try {
			for (ArrayList<String> documentoHechoId : documentoHechoIds) {
				Iterator<String> iterator = documentoHechoId.iterator();
				DocumentoHecho documentoHecho = new DocumentoHecho();
				documentoHecho.setQ5codocumento(iterator.next());
				documentoHechoList.add(documentoHecho);
			}
			this.documentoHechoService.removeMultiple(documentoHechoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getDocumentoHechoService'.
	 * 
	 * @return DocumentoHechoService
	 */
	protected DocumentoHechoService getDocumentoHechoService() {
		return this.documentoHechoService;
	}

	/**
	 * Method 'setDocumentoHechoService'.
	 * 
	 * @param documentoHechoService
	 *            DocumentoHechoService
	 * @return
	 */
	public void setDocumentoHechoService(
			DocumentoHechoService documentoHechoService) {
		this.documentoHechoService = documentoHechoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
