package com.ejie.y41a.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Comunicacion;
import com.ejie.y41a.model.DestComunicacion;
import com.ejie.y41a.model.DestComunicacionBusqueda;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.service.ComunicacionService;
import com.ejie.y41a.service.DestComunicacionService;

/**
 * * DestComunicacionController generated by UDA, 22-feb-2012 17:30:45.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/destcomunicacion")
public class DestComunicacionController {

	private static final Logger logger = LoggerFactory
			.getLogger(DestComunicacionController.class);

	@Autowired()
	private ComunicacionService comunicacionService;

	@Autowired()
	private DestComunicacionService destComunicacionService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("destcomunicacion", "model", model);
	}

	/**
	 * Detalle de comunicaciones. Method getCreateFormEnviosDetalleModal
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            Request
	 * @return String
	 */
	@RequestMapping(value = "maintSeguimientoComunicacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormEnviosSeguimientoModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));

		Comunicacion comunicacion = new Comunicacion();
		comunicacion.setM4cocomu(new Long(0));
		if (request.getParameter("m4cocomu") != null) {
			comunicacion.setM4cocomu(Long.parseLong(request
					.getParameter("m4cocomu")));
		}

		Comunicacion comAux = this.comunicacionService.find(comunicacion);
		model.addAttribute("comunicacion", comAux);

		return new ModelAndView("com_envios_SeguimientoModal", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param m5coor
	 *            String
	 * @param comunicacionM4cocomu
	 *            Long
	 * @return String
	 */
	@RequestMapping(value = "/{m5coor}/{comunicacionM4cocomu}", method = RequestMethod.GET)
	public @ResponseBody()
	DestComunicacion getById(@PathVariable() String m5coor,
			@PathVariable() Long comunicacionM4cocomu) {
		try {
			DestComunicacion destComunicacion = new DestComunicacion();
			destComunicacion.setComunicacion(new Comunicacion());
			destComunicacion.setOrganismo(new Organismo());
			destComunicacion.getOrganismo().setCodOrg(m5coor);
			destComunicacion.getComunicacion()
					.setM4cocomu(comunicacionM4cocomu);
			destComunicacion = this.destComunicacionService
					.find(destComunicacion);
			if (destComunicacion == null) {
				throw new Exception(m5coor.toString()
						+ comunicacionM4cocomu.toString());
			}
			return destComunicacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(m5coor.toString()
					+ comunicacionM4cocomu.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param m5coor
	 *            String
	 * @param comunicacionM4cocomu
	 *            Long
	 * @param m5feleido
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "m5coor", required = false) String m5coor,
			@RequestParam(value = "comunicacionM4cocomu", required = false) Long comunicacionM4cocomu,
			@RequestParam(value = "m5feleido", required = false) Date m5feleido,
			HttpServletRequest request) {
		try {
			DestComunicacion filterDestComunicacion = new DestComunicacion(
					new Organismo(m5coor, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null), new Comunicacion(
							comunicacionM4cocomu, null, null, null, null, null,
							null, null, null, null, null, null, null, null),
					m5feleido);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<DestComunicacionBusqueda> destComunicacions = this.destComunicacionService
						.findAllDestinatario(filterDestComunicacion, pagination);

				if (destComunicacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterDestComunicacion, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(destComunicacions);
				return data;
			} else {
				List<DestComunicacion> destComunicacions = this.destComunicacionService
						.findAll(filterDestComunicacion, pagination);
				if (destComunicacions == null) {
					throw new Exception("No data Found.");
				}
				return destComunicacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterDestComunicacion
	 *            DestComunicacion
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@RequestParam(value = "destComunicacion", required = false) DestComunicacion filterDestComunicacion,
			HttpServletRequest request) {
		try {
			return this.destComunicacionService
					.findAllCount(filterDestComunicacion != null ? filterDestComunicacion
							: new DestComunicacion());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param destComunicacion
	 *            DestComunicacion
	 * @param response
	 *            HttpServletResponse
	 * @return DestComunicacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	DestComunicacion edit(@RequestBody() DestComunicacion destComunicacion,
			HttpServletResponse response) {
		try {
			DestComunicacion destComunicacionAux = this.destComunicacionService
					.update(destComunicacion);
			DestComunicacionController.logger
					.info("Entity correctly inserted!");
			return destComunicacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param destComunicacion
	 *            DestComunicacion
	 * @return DestComunicacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	DestComunicacion add(@RequestBody() DestComunicacion destComunicacion) {
		try {
			DestComunicacion destComunicacionAux = this.destComunicacionService
					.add(destComunicacion);
			logger.info("Entity correctly inserted!");
			return destComunicacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param m5coor
	 *            String
	 * @param comunicacionM4cocomu
	 *            Long
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{m5coor}/{comunicacionM4cocomu}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() String m5coor,
			@PathVariable() Long comunicacionM4cocomu,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			DestComunicacion destComunicacion = new DestComunicacion();
			destComunicacion.setComunicacion(new Comunicacion());
			destComunicacion.setOrganismo(new Organismo());
			destComunicacion.getOrganismo().setCodOrg(m5coor);
			destComunicacion.getComunicacion()
					.setM4cocomu(comunicacionM4cocomu);
			this.destComunicacionService.remove(destComunicacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + m5coor + comunicacionM4cocomu);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param destComunicacionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody() ArrayList<ArrayList<String>> destComunicacionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<DestComunicacion> destComunicacionList = new ArrayList<DestComunicacion>();
		try {
			for (ArrayList<String> destComunicacionId : destComunicacionIds) {
				Iterator<String> iterator = destComunicacionId.iterator();
				DestComunicacion destComunicacion = new DestComunicacion();
				destComunicacion.setComunicacion(new Comunicacion());
				destComunicacion.setOrganismo(new Organismo());
				destComunicacion.getOrganismo().setCodOrg(
						ObjectConversionManager.convert(iterator.next(),
								String.class));
				destComunicacion.getComunicacion().setM4cocomu(
						ObjectConversionManager.convert(iterator.next(),
								Long.class));
				destComunicacionList.add(destComunicacion);
			}
			this.destComunicacionService.removeMultiple(destComunicacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getDestComunicacionService'.
	 * 
	 * @return DestComunicacionService
	 */
	protected DestComunicacionService getDestComunicacionService() {
		return this.destComunicacionService;
	}

	/**
	 * Method 'setDestComunicacionService'.
	 * 
	 * @param destComunicacionService
	 *            DestComunicacionService
	 * @return
	 */
	public void setDestComunicacionService(
			DestComunicacionService destComunicacionService) {
		this.destComunicacionService = destComunicacionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
