package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.service.DenunciaRecibService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.DenunciaRecib;

/**
 * * DenunciaRecibController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/denunciarecib")
public class DenunciaRecibController {

	private static final Logger logger = LoggerFactory
			.getLogger(DenunciaRecibController.class);

	@Autowired
	private DenunciaRecibService denunciaRecibService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("denunciarecib", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param s6codigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{s6codigo}", method = RequestMethod.GET)
	public @ResponseBody
	DenunciaRecib getById(@PathVariable String s6codigo) {
		try {
			DenunciaRecib denunciaRecib = new DenunciaRecib();
			denunciaRecib.setS6codigo(s6codigo);
			denunciaRecib = this.denunciaRecibService.find(denunciaRecib);
			if (denunciaRecib == null) {
				throw new Exception(s6codigo.toString());
			}
			return denunciaRecib;
		} catch (Exception e) {
			throw new ResourceNotFoundException(s6codigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param s6codigo
	 *            String
	 * @param hechoDenunciadoHdcodigo
	 *            String
	 * @param s6codorganismo
	 *            String
	 * @param s6feccomunicacion
	 *            Date
	 * @param s6fecfinalizacion
	 *            Date
	 * @param s6cantidadactuaciones
	 *            Integer
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "s6codigo", required = false) String s6codigo,
			@RequestParam(value = "hechoDenunciadoHdcodigo", required = false) String hechoDenunciadoHdcodigo,
			@RequestParam(value = "s6codorganismo", required = false) String s6codorganismo,
			@RequestParam(value = "s6feccomunicacion", required = false) Date s6feccomunicacion,
			@RequestParam(value = "s6fecfinalizacion", required = false) Date s6fecfinalizacion,
			@RequestParam(value = "s6cantidadactuaciones", required = false) Integer s6cantidadactuaciones,
			HttpServletRequest request) {
		try {
			DenunciaRecib filterDenunciaRecib = new DenunciaRecib(s6codigo,
					s6codorganismo, s6feccomunicacion, s6fecfinalizacion,
					s6cantidadactuaciones, new HechoDenunciado(
							hechoDenunciadoHdcodigo, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<DenunciaRecib> denunciaRecibs = this.denunciaRecibService
						.findAll(filterDenunciaRecib, pagination);

				if (denunciaRecibs == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterDenunciaRecib, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(denunciaRecibs);
				return data;
			} else {
				List<DenunciaRecib> denunciaRecibs = this.denunciaRecibService
						.findAll(filterDenunciaRecib, pagination);
				if (denunciaRecibs == null) {
					throw new Exception("No data Found.");
				}
				return denunciaRecibs;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterDenunciaRecib
	 *            DenunciaRecib
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "denunciaRecib", required = false) DenunciaRecib filterDenunciaRecib,
			HttpServletRequest request) {
		try {
			return denunciaRecibService
					.findAllCount(filterDenunciaRecib != null ? filterDenunciaRecib
							: new DenunciaRecib());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param denunciaRecib
	 *            DenunciaRecib
	 * @param response
	 *            HttpServletResponse
	 * @return DenunciaRecib
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	DenunciaRecib edit(@RequestBody DenunciaRecib denunciaRecib,
			HttpServletResponse response) {
		try {
			DenunciaRecib denunciaRecibAux = this.denunciaRecibService
					.update(denunciaRecib);
			logger.info("Entity correctly inserted!");
			return denunciaRecibAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param denunciaRecib
	 *            DenunciaRecib
	 * @return DenunciaRecib
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	DenunciaRecib add(@RequestBody DenunciaRecib denunciaRecib) {
		try {
			DenunciaRecib denunciaRecibAux = this.denunciaRecibService
					.add(denunciaRecib);
			logger.info("Entity correctly inserted!");
			return denunciaRecibAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param s6codigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{s6codigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String s6codigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			DenunciaRecib denunciaRecib = new DenunciaRecib();
			denunciaRecib.setS6codigo(s6codigo);
			this.denunciaRecibService.remove(denunciaRecib);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + s6codigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param denunciaRecibIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> denunciaRecibIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<DenunciaRecib> denunciaRecibList = new ArrayList<DenunciaRecib>();
		try {
			for (ArrayList<String> denunciaRecibId : denunciaRecibIds) {
				Iterator<String> iterator = denunciaRecibId.iterator();
				DenunciaRecib denunciaRecib = new DenunciaRecib();
				denunciaRecib.setS6codigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				denunciaRecibList.add(denunciaRecib);
			}
			this.denunciaRecibService.removeMultiple(denunciaRecibList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getDenunciaRecibService'.
	 * 
	 * @return DenunciaRecibService
	 */
	protected DenunciaRecibService getDenunciaRecibService() {
		return this.denunciaRecibService;
	}

	/**
	 * Method 'setDenunciaRecibService'.
	 * 
	 * @param denunciaRecibService
	 *            DenunciaRecibService
	 * @return
	 */
	public void setDenunciaRecibService(
			DenunciaRecibService denunciaRecibService) {
		this.denunciaRecibService = denunciaRecibService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
