package com.ejie.y41a.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Blob;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Consumidor;
import com.ejie.y41a.model.DecisionHechoDetalle;
import com.ejie.y41a.model.Denuncia;
import com.ejie.y41a.model.DocumentoHecho;
import com.ejie.y41a.model.DocumentoHechoDetalle;
import com.ejie.y41a.model.FichasSolicitudes;
import com.ejie.y41a.model.FormaPresentacion;
import com.ejie.y41a.model.PlantillaSolicitudDetalle;
import com.ejie.y41a.model.SolicitudArbitrajeDetalle;
import com.ejie.y41a.model.SolicitudBusqueda;
import com.ejie.y41a.model.SolicitudDetalle;
import com.ejie.y41a.model.TramiteComun;
import com.ejie.y41a.model.TramiteHecho;
import com.ejie.y41a.model.TramiteHechoDetalle;
import com.ejie.y41a.model.TramiteHechoDetalleMail;
import com.ejie.y41a.service.DenunciaService;
import com.ejie.y41a.service.PlantillasFichasSolicitudesService;
import com.ejie.y41a.service.Y41aExcelGeneratorService;
import com.ejie.y41a.utils.Y41aStringUtils;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.documentos.Y41aGenerarDocumento;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * DenunciaController generated by UDA, 22-feb-2012 17:30:45.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/denuncia")
public class DenunciaController {

	private static final Logger logger = LoggerFactory
			.getLogger(DenunciaController.class);

	@Autowired
	private DenunciaService denunciaService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41aExcelGeneratorService y41aExcelGeneratorService;

	@Autowired
	private PlantillasFichasSolicitudesService plantillasFichasSolicitudesService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("denuncia", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aTabsBusquedaResultadoSolicitudes", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aTabsBusquedaResultadoSolicitudes(
			Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("y41aTabsBusquedaResultadoSolicitudes",
				"model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aTabBusquedaSolicitudes", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aTabBusquedaSolicitudes(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("y41aTabBusquedaSolicitudes", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aTabResultadoSolicitudes", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aTabResultadoSolicitudes(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("y41aTabResultadoSolicitudes", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aTabsDetalleSolicitudNormal", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aTabsDetalleSolicitudNormal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("y41aTabsDetalleSolicitudNormal", "model",
				model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aTabsDetalleSolicitudModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aTabsDetalleSolicitudModal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("y41aTabsDetalleSolicitudModal", "model", model);
	}

	// /**
	// * Method 'getCreateForm'.
	// *
	// * @param model
	// * Model
	// * @param request
	// * HttpServletRequest
	// *
	// * @return String
	// */
	// @RequestMapping(value = "y41aTabsDetalleSolicitud", method =
	// RequestMethod.GET)
	// public ModelAndView getCreateFormY41aTabsDetalleSolicitudNoModal(
	// Model model, HttpServletRequest request) {
	//
	// String hdcodigo = (String) request.getParameter("hdcodigo");
	//
	// model.addAttribute("defaultLanguage",
	// appConfiguration.get("y41aVistaWar.default.language"));
	// model.addAttribute("defaultLayout",
	// appConfiguration.get("y41aVistaWar.default.layout"));
	// model.addAttribute("bean_hdcodigo", hdcodigo);
	// model.addAttribute("statics_path",
	// this.appConfiguration.get("statics.path"));
	//
	// if (hdcodigo != null)
	// return new ModelAndView("y41aTabsDetalleSolicitudNoModal", "model",
	// model);
	//
	// return new ModelAndView("y41aTabsDetalleSolicitud", "model", model);
	//
	// }

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aSolicitudTramitacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aSolicitudTramitacion(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y41aSolicitudTramitacion", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aSolicitudDocumentacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aSolicitudDocumentacion(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y41aSolicitudDocumentacion", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aSolicitudTramitacionDetalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aSolicitudTramitacionDetalle(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y41aSolicitudTramitacionDetalle", "model",
				model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aSolicitudDetalle", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aSolicitudDetalle(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y41aSolicitudDetalle", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aSolicitudTramitacionEmail", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aSolicitudTramitacionEmail(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y41aSolicitudTramitacionEmail", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "y41aSolicitudTramitacionArbitraje", method = RequestMethod.GET)
	public ModelAndView getCreateFormY41aSolicitudTramitacionArbitraje(
			Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("y41aSolicitudTramitacionArbitraje", "model",
				model);
	}

	/**
	 * Abre la ventana modal que muestra los documentos relativos a un tramite
	 * del hecho denunciado
	 * 
	 * @param model
	 *            Model modelo de datos
	 * @return ModelAndView modelo y vista y41aDocumentosTramiteSolicitud
	 */
	@RequestMapping(value = "y41aSolicitudTramitacionModal", method = RequestMethod.GET)
	ModelAndView getModalDocumentosTramite(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));

		return new ModelAndView("y41aDocumentosTramiteSolicitud", "model",
				model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param decodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{decodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Denuncia getById(@PathVariable String decodigo) {
		try {
			Denuncia denuncia = new Denuncia();
			denuncia.setDecodigo(decodigo);
			denuncia = this.denunciaService.find(denuncia);
			if (denuncia == null) {
				throw new Exception(decodigo.toString());
			}
			return denuncia;
		} catch (Exception e) {
			throw new ResourceNotFoundException(decodigo.toString());
		}
	}

	/**
	 * Method 'getByIdHecho'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * 
	 * 
	 * @return String
	 */
	@RequestMapping(value = "/getbyid/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	SolicitudDetalle getByIdHecho(@PathVariable String hdcodigo,
			HttpServletRequest request) {
		try {

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);
			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);
			String codOrgConectado = censoMonitor.getOrganismo().getCodOrg();
			solicitudDetalle.setCodOrgConectado(codOrgConectado);
			solicitudDetalle = this.denunciaService
					.findSolicitud(solicitudDetalle);

			if (solicitudDetalle == null) {
				throw new Exception(hdcodigo.toString());
			}

			return solicitudDetalle;
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		}
	}

	/**
	 * Method 'getArbitrajeByIdHecho'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/arbitraje/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	SolicitudArbitrajeDetalle getArbitrajeByIdHecho(
			@PathVariable String hdcodigo) {
		try {

			SolicitudArbitrajeDetalle solicitudArbitrajeDetalle = new SolicitudArbitrajeDetalle();
			solicitudArbitrajeDetalle.setHdcodigo(hdcodigo);
			solicitudArbitrajeDetalle = this.denunciaService
					.findSolicitudArbitraje(solicitudArbitrajeDetalle);

			if (solicitudArbitrajeDetalle == null) {
				throw new Exception(hdcodigo.toString());
			}
			return solicitudArbitrajeDetalle;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new ResourceNotFoundException(hdcodigo.toString());
		}
	}

	/**
	 * Method 'getByIdTramitacion'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/tramitacion/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getByIdTramitacion(@PathVariable String hdcodigo,
			HttpServletRequest request) {
		try {

			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setHdcodigo(hdcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<TramiteHechoDetalle> tramitesHecho = this.denunciaService
						.findAllTramiteHecho(tramiteHechoDetalle, pagination);

				if (tramitesHecho == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService
						.findAllTramiteHechoCount(tramiteHechoDetalle);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(tramitesHecho);
				return data;
			} else {
				List<TramiteHechoDetalle> tramitesHecho = this.denunciaService
						.findAllTramiteHecho(tramiteHechoDetalle, pagination);
				if (tramitesHecho == null) {
					throw new Exception("No data Found.");
				}
				return tramitesHecho;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getDetalleByIdTramitacion'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/tramitacion/detalle/{ehcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getDetalleByIdTramitacion(@PathVariable String ehcodigo,
			HttpServletRequest request) {
		try {

			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setEhcodigo(ehcodigo);

			tramiteHechoDetalle = this.denunciaService
					.findTramiteHecho(tramiteHechoDetalle);

			if (tramiteHechoDetalle == null) {
				throw new Exception(
						"No data Found. /tramitacion/detalle/{ehcodigo}");
			} else if (tramiteHechoDetalle.getEhtexto() != null
					&& !("".equalsIgnoreCase(tramiteHechoDetalle.getEhtexto()))) {
				tramiteHechoDetalle.setEhtexto(Y41aUtils
						.eliminarAmpersand(tramiteHechoDetalle.getEhtexto()));

			}

			// else {
			// // ehoraa, amputarle los :ss
			// tramiteHechoDetalle.setEhhora(Y41aUtils
			// .horaToHora(tramiteHechoDetalle.getEhhora()));
			// }
			return tramiteHechoDetalle;

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(
					"No data Found. /tramitacion/detalle/{ehcodigo}");
		}
	}

	/**
	 * Obtiene los datos de la decisión asociada al hecho
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/tramitacion/getdecision/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getDecision(@PathVariable String hdcodigo, HttpServletRequest request) {
		try {

			DecisionHechoDetalle decisionHechoDetalle = new DecisionHechoDetalle();
			decisionHechoDetalle.setHdcodigo(hdcodigo);

			decisionHechoDetalle = this.denunciaService
					.findDecisionHecho(decisionHechoDetalle);

			if (decisionHechoDetalle == null) {
				throw new Exception(
						"No data Found. /tramitacion/getdecision/{hdcodigo}");
			}
			return decisionHechoDetalle;

		} catch (Exception e) {
			throw new ResourceNotFoundException(
					"No data Found. /tramitacion/getdecision/{hdcodigo}");
		}
	}

	/**
	 * Method 'addDetalleTramiteHecho'.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Object
	 */

	@RequestMapping(value = "/tramitacion/detallegrabar", method = RequestMethod.POST)
	public @ResponseBody
	TramiteHechoDetalle addDetalleTramiteHecho(
			@RequestBody TramiteHechoDetalle tramiteHechoDetalle) {

		try {
			TramiteHechoDetalle tramiteHechoDetalleAux = this.denunciaService
					.addTramiteHecho(tramiteHechoDetalle);
			logger.info("Entity correctly inserted!");
			return tramiteHechoDetalleAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException(
					"Method failed. /tramitacion/detalle/grabar . POST");
		}
	}

	/**
	 * Method 'addTramiteHechoDetalleMail'.
	 * 
	 * @param tramiteHechoDetalleMail
	 *            TramiteHechoDetalleMail
	 * @return Object
	 */

	@RequestMapping(value = "/tramitacion/detallemail", method = RequestMethod.POST)
	public @ResponseBody
	TramiteHechoDetalleMail addTramiteHechoDetalleMail(
			@RequestBody TramiteHechoDetalleMail tramiteHechoDetalleMail) {

		try {
			TramiteHechoDetalleMail tramiteHechoDetalleMailAux = this.denunciaService
					.enviarMail(tramiteHechoDetalleMail);
			logger.info("Entity correctly inserted!");
			return tramiteHechoDetalleMailAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException(
					"Method failed. /tramitacion/detalleemail");
		}
	}

	/**
	 * Method 'editDetalleTramiteHecho'.
	 * 
	 * @param decisionHechoDetalle
	 *            DecisionHechoDetalle
	 * @return Object
	 */
	@RequestMapping(value = "/tramitacion/decisiongrabar", method = RequestMethod.PUT)
	public @ResponseBody
	DecisionHechoDetalle editDetalleTramiteHecho(
			@RequestBody DecisionHechoDetalle decisionHechoDetalle) {
		try {
			DecisionHechoDetalle decisionHechoDetalleAux = this.denunciaService
					.updateDecisionHecho(decisionHechoDetalle);
			logger.info("Entity correctly inserted!");
			return decisionHechoDetalleAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed. /tramitacion/decisiongrabar . PUT");
		}
	}

	/**
	 * Method 'editDecision'.
	 * 
	 * @param tramiteHechoDetalle
	 *            TramiteHechoDetalle
	 * @return Object
	 */

	@RequestMapping(value = "/tramitacion/detallegrabar", method = RequestMethod.PUT)
	public @ResponseBody
	TramiteHechoDetalle editDecision(
			@RequestBody TramiteHechoDetalle tramiteHechoDetalle) {

		try {
			TramiteHechoDetalle tramiteHechoDetalleAux = this.denunciaService
					.updateTramiteHecho(tramiteHechoDetalle);
			logger.info("Entity correctly inserted!");
			return tramiteHechoDetalleAux;

		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException(
					"Method failed. /tramitacion/detalle/grabar . PUT");
		}
	}

	/**
	 * Method 'getByIdDocumentacion'.
	 * 
	 * @param hdcodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Object
	 */
	@RequestMapping(value = "/documentacion/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getByIdDocumentacion(@PathVariable String hdcodigo,
			HttpServletRequest request) {
		try {
			DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
			documentoHechoDetalle.setHdcodigo(hdcodigo);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<DocumentoHechoDetalle> documentosHecho = this.denunciaService
						.findAllDocumentoHecho(documentoHechoDetalle,
								pagination);

				if (documentosHecho == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService
						.findAllDocumentoHechoCount(documentoHechoDetalle);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(documentosHecho);
				return data;
			} else {
				List<DocumentoHechoDetalle> documentosHecho = this.denunciaService
						.findAllDocumentoHecho(documentoHechoDetalle,
								pagination);
				if (documentosHecho == null) {
					throw new Exception("No data Found.");
				}
				return documentosHecho;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException(
					"No data Found. /denuncia/documentacion/{hdcodigo}");
		}
	}

	/**
	 * Method 'addDocumentoConsultaDetalle'.
	 * 
	 * @param file
	 *            MultipartFile
	 * 
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 */
	@RequestMapping(value = "/documentacion/subidaFichero", method = RequestMethod.POST)
	public void addDocumentoDenunciaDetalle(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			String hdcodigo = request.getParameter("hdcodigo");
			String q5origen = request.getParameter("q5origen");
			String q5tedesfile = request.getParameter("q5tedesfile");
			String q5idtipodoc = request.getParameter("q5idtipodoc");

			// DOC FILE
			DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
			documentoHechoDetalle.setHdcodigo(hdcodigo);
			documentoHechoDetalle.setQ5origen(q5origen);
			documentoHechoDetalle.setQ5tedesfile(q5tedesfile);
			documentoHechoDetalle.setQ5tedesfile(q5tedesfile);
			documentoHechoDetalle.setQ5idtipodoc(q5idtipodoc);
			Blob blob = new SerialBlob(file.getBytes());
			documentoHechoDetalle.setQ5datafile(blob);
			documentoHechoDetalle.setQ5contenttypefile(file.getContentType());
			documentoHechoDetalle.setQ5nofile(file.getOriginalFilename());
			documentoHechoDetalle.setQ5sizefile((int) file.getSize());
			documentoHechoDetalle.setQ5fecha(new Date());

			DocumentoHechoDetalle documentoHechoDetalleAux = this.denunciaService
					.addDocumentoHecho(documentoHechoDetalle);

			logger.info("Entity correctly inserted!" + documentoHechoDetalleAux);

		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException(
					"Method failed /documentacion/subidaFichero");
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @return mapa
	 */
	// private Map<String, Object> getFileReturnMap(MultipartFile file) {
	// Map<String, Object> mapaRetorno = new HashMap<String, Object>();
	// mapaRetorno.put(
	// "url",
	// "/y41aVistaWar/denuncia/documentacion/subidaFichero/"
	// + file.getOriginalFilename() + "?R01HNoPortal=true");
	// mapaRetorno.put("name", file.getOriginalFilename());
	// mapaRetorno.put("type", file.getContentType());
	// mapaRetorno.put("size", file.getSize());
	// mapaRetorno.put(
	// "delete_url",
	// "/y41aVistaWar/denuncia/documentacion/subidaFichero/"
	// + file.getOriginalFilename() + "?R01HNoPortal=true");
	// mapaRetorno.put("delete_type", "DELETE");
	// return mapaRetorno;
	// }

	/**
	 * Method 'removeDocumentoHechoDetalle'.
	 * 
	 * @param q5codocumento
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/documentacion/{q5codocumento}", method = RequestMethod.DELETE)
	public void removeDocumentoHechoDetalle(@PathVariable String q5codocumento,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
			documentoHechoDetalle.setQ5codocumento(q5codocumento);
			this.denunciaService.removeDocumentoHecho(documentoHechoDetalle);

			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + q5codocumento);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeTramite'.
	 * 
	 * @param ehcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/removetramite/{ehcodigo}", method = RequestMethod.DELETE)
	public void removeTramite(@PathVariable String ehcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			TramiteHechoDetalle tramiteHechoDetalle = new TramiteHechoDetalle();
			tramiteHechoDetalle.setEhcodigo(ehcodigo);
			this.denunciaService.removeTramiteHecho(tramiteHechoDetalle);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + ehcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getByIdDocumentoHechoDetalle'.
	 * 
	 * @param q5codocumento
	 *            String
	 * 
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/documentacion/link/{q5codocumento}", method = RequestMethod.GET)
	public @ResponseBody
	void getByIdDocumentoHechoDetalle(@PathVariable String q5codocumento,
			HttpServletResponse response) {
		try {

			DocumentoHechoDetalle documentoHechoDetalle = new DocumentoHechoDetalle();
			documentoHechoDetalle.setQ5codocumento(q5codocumento);

			documentoHechoDetalle = this.denunciaService
					.findDocumentoHecho(documentoHechoDetalle);

			if (documentoHechoDetalle == null) {
				throw new Exception(q5codocumento.toString());
			}

			Blob contenido = documentoHechoDetalle.getQ5datafile();
			if (contenido != null) {
				byte[] bContenido = contenido.getBytes(1,
						(int) contenido.length());

				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader(
						"Content-Disposition",
						"attachment; filename="
								+ Y41aStringUtils.unescapeHTML(
										documentoHechoDetalle.getQ5nofile(), 0)
								+ "");
				response.setContentType(documentoHechoDetalle
						.getQ5contenttypefile());
				// response.setContentLength(documentoHechoDetalle.getQ5sizefile());
				response.flushBuffer();

				response.getOutputStream().write(bContenido);

				// Vaciamos el stream
				response.getOutputStream().flush();
			} else {
				// Cambiamos el objeto Response para visualizar el contenido del
				// archivo
				response.setHeader(
						"Content-Disposition",
						"attachment; filename="
								+ Y41aStringUtils.unescapeHTML(
										documentoHechoDetalle.getQ5nofile(), 0)
								+ "");
				response.setContentType(documentoHechoDetalle
						.getQ5contenttypefile());
				// response.setContentLength(documentoHechoDetalle.getQ5sizefile());
				response.flushBuffer();

				// Vaciamos el stream
				response.getOutputStream().flush();
			}

			// return documentoConsultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(q5codocumento.toString());
		}
	}

	/**
	 * Method 'getFichaByCodHecho'. Obtiene la ficha completa de la solicitud
	 * combinando los datos de la solicitud con la plantilla definida para el
	 * organismo (en Fichas y Plantillas) y la devuelve como un documento RTF.
	 * 
	 * @param hdcodigo
	 *            String código de solicitud
	 * @param request
	 *            HttpServletRequest petición HTTP
	 * @param response
	 *            HttpServletResponse respuesta HTTP
	 * 
	 */
	@RequestMapping(value = "/ficha/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	void getFichaByCodHecho(@PathVariable String hdcodigo,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			HttpSession sesion = request.getSession();
			CensoMonitor monitor = (CensoMonitor) sesion
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			PlantillaSolicitudDetalle plantillaSolicitudDetalle = this.denunciaService
					.findPlantillaSolicitudDetalle(solicitudDetalle);
			if (plantillaSolicitudDetalle == null) {
				throw new Exception(hdcodigo.toString());
			}

			String rutaXML = (String) appConfiguration
					.get("y41aVistaWar.rutaxml.plantillas.word");
			String nombreXML = Y41aConstantes.NOMBRE_PLANTILLA_SOLICITUDES_FICHA_XML;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantillaRTF = this.plantillasFichasSolicitudesService
					.obtieneBinarioPlantillaFichaByOrganismo(
							FichasSolicitudes.Codigos.COMPLETA.getFicodigo(),
							monitor.getOrganismo().getCodOrg());

			String strFileDataDecode = Y41aGenerarDocumento
					.generarDocumentoWord(rutaCompletaXML,
							plantillaSolicitudDetalle, plantillaRTF);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = plantillaSolicitudDetalle.getDecoor() + "-"
					+ plantillaSolicitudDetalle.getDenror() + "-"
					+ plantillaSolicitudDetalle.getDenran() + ".doc";

			// response.addHeader("Expires", "-1");

			// FIXME Esto se ha quitado porque sino en Internet Explorer produce
			// un error al mostrarse
			// response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");

			response.setHeader("Content-Disposition", "attachment; filename="
					+ nombreFichero + "");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		}
	}

	/**
	 * Method 'getFichaReducidaByCodHecho'. Obtiene la ficha reducida de la
	 * solicitud combinando los datos de la solicitud con la plantilla definida
	 * para el organismo (en Fichas y Plantillas) y la devuelve como un
	 * documento RTF.
	 * 
	 * @param hdcodigo
	 *            String código de solicitud
	 * @param request
	 *            HttpServletRequest petición HTTP
	 * @param response
	 *            HttpServletResponse respuesta HTTP
	 * 
	 */
	@RequestMapping(value = "/fichareducida/{hdcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	void getFichaReducidaByCodHecho(@PathVariable String hdcodigo,
			HttpServletRequest request, HttpServletResponse response) {
		try {

			HttpSession sesion = request.getSession();
			CensoMonitor monitor = (CensoMonitor) sesion
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			SolicitudDetalle solicitudDetalle = new SolicitudDetalle();
			solicitudDetalle.setHdcodigo(hdcodigo);

			PlantillaSolicitudDetalle plantillaSolicitudDetalle = this.denunciaService
					.findPlantillaSolicitudDetalle(solicitudDetalle);
			if (plantillaSolicitudDetalle == null) {
				throw new Exception(hdcodigo.toString());
			}

			String rutaXML = (String) this.appConfiguration
					.get("y41aVistaWar.rutaxml.plantillas.word");

			String nombreXML = Y41aConstantes.NOMBRE_PLANTILLA_SOLICITUDES_FICHA_REDUCIDA_XML;

			String rutaCompletaXML = rutaXML + nombreXML;

			String plantillaRTF = this.plantillasFichasSolicitudesService
					.obtieneBinarioPlantillaFichaByOrganismo(
							FichasSolicitudes.Codigos.REDUCIDA.getFicodigo(),
							monitor.getOrganismo().getCodOrg());

			String strFileDataDecode = Y41aGenerarDocumento
					.generarDocumentoWord(rutaCompletaXML,
							plantillaSolicitudDetalle, plantillaRTF);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = plantillaSolicitudDetalle.getDecoor() + "-"
					+ plantillaSolicitudDetalle.getDenror() + "-"
					+ plantillaSolicitudDetalle.getDenran() + ".doc";

			// response.addHeader("Expires", "-1");

			// FIXME Esto se ha quitado porque sino en Internet Explorer produce
			// un error al mostrarse
			// response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");

			response.setHeader("Content-Disposition", "attachment; filename="
					+ nombreFichero + "");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		} catch (Throwable t) {
			t.printStackTrace();
			throw new ResourceNotFoundException(hdcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param decodigo
	 *            String
	 * @param formaPresentacionTfpcodigo
	 *            String
	 * @param consumidorDtcodigo
	 *            String
	 * @param decocp
	 *            String
	 * @param decoor
	 *            String
	 * @param denran
	 *            BigDecimal
	 * @param denror
	 *            BigDecimal
	 * @param defede
	 *            Date
	 * @param defere
	 *            Date
	 * @param defeex
	 *            Date
	 * @param defeim
	 *            Date
	 * @param deinre
	 *            String
	 * @param denrrgen
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "decodigo", required = false) String decodigo,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo,
			@RequestParam(value = "consumidorDtcodigo", required = false) String consumidorDtcodigo,
			@RequestParam(value = "decocp", required = false) String decocp,
			@RequestParam(value = "decoor", required = false) String decoor,
			@RequestParam(value = "denran", required = false) Integer denran,
			@RequestParam(value = "denror", required = false) Long denror,
			@RequestParam(value = "defede", required = false) Date defede,
			@RequestParam(value = "defere", required = false) Date defere,
			@RequestParam(value = "defeex", required = false) Date defeex,
			@RequestParam(value = "defeim", required = false) Date defeim,
			@RequestParam(value = "deinre", required = false) String deinre,
			@RequestParam(value = "denrrgen", required = false) String denrrgen,
			HttpServletRequest request) {
		try {
			Denuncia filterDenuncia = new Denuncia(decodigo, decocp, decoor,
					denran, denror, defede, defere, defeex, defeim, deinre,
					denrrgen, new FormaPresentacion(formaPresentacionTfpcodigo,
							null, null, null, null, null, null),
					new Consumidor(consumidorDtcodigo, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Denuncia> denuncias = this.denunciaService.findAll(
						filterDenuncia, pagination);

				if (denuncias == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterDenuncia, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(denuncias);
				return data;
			} else {
				List<Denuncia> denuncias = this.denunciaService.findAll(
						filterDenuncia, pagination);
				if (denuncias == null) {
					throw new Exception("No data Found.");
				}
				return denuncias;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllSolicitud'.
	 * 
	 * @param decoor_
	 *            String
	 * @param denror
	 *            BigDecimal
	 * @param denran
	 *            BigDecimal
	 * @param indGestion_
	 *            String
	 * @param hcfedeDesde_
	 *            String
	 * @param hcfedeHasta_
	 *            String
	 * @param hdcosc_
	 *            String
	 * @param defereDesde_
	 *            String
	 * @param defereHasta_
	 *            String
	 * @param tfpcodigo_
	 *            String
	 * @param hdcodexpedienteorigen_
	 *            String
	 * @param trcodigo_
	 *            String
	 * @param indUltimoTramite_
	 *            String
	 * @param decodigo_
	 *            String
	 * @param defedeDesde_
	 *            String
	 * @param defedeHasta_
	 *            String
	 * @param dtnombre_
	 *            String
	 * @param dtnif_
	 *            String
	 * @param dtnoraProvinciaId_
	 *            String
	 * @param dtnoraMunicipioId_
	 *            String
	 * @param dtnoraLocalidadId_
	 *            String
	 * @param esnombre_
	 *            String
	 * @param esnif_
	 *            String
	 * @param esnoraProvinciaId_
	 *            String
	 * @param esnoraMunicipioId_
	 *            String
	 * @param esnoraLocalidadId_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busquedaSolicitudes", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllSolicitud(
			@RequestParam(value = "decoor", required = false) String decoor_,
			@RequestParam(value = "denror", required = false) BigDecimal denror,
			@RequestParam(value = "denran", required = false) BigDecimal denran,
			@RequestParam(value = "indGestion", required = false) String indGestion_,
			@RequestParam(value = "hcfedeDesde", required = false) String hcfedeDesde_,
			@RequestParam(value = "hcfedeHasta", required = false) String hcfedeHasta_,
			@RequestParam(value = "hdcosc", required = false) String hdcosc_,
			@RequestParam(value = "defereDesde", required = false) String defereDesde_,
			@RequestParam(value = "defereHasta", required = false) String defereHasta_,
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo_,
			@RequestParam(value = "hdcodexpedienteorigen", required = false) String hdcodexpedienteorigen_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "indUltimoTramite", required = false) String indUltimoTramite_,
			@RequestParam(value = "decodigo", required = false) String decodigo_,
			@RequestParam(value = "defedeDesde", required = false) String defedeDesde_,
			@RequestParam(value = "defedeHasta", required = false) String defedeHasta_,
			@RequestParam(value = "dtnombre", required = false) String dtnombre_,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1_,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2_,
			@RequestParam(value = "dtnif", required = false) String dtnif_,
			@RequestParam(value = "dtestado", required = false) String dtestado_,
			@RequestParam(value = "dtnoraProvinciaId", required = false) String dtnoraProvinciaId_,
			@RequestParam(value = "dtnoraMunicipioId", required = false) String dtnoraMunicipioId_,
			@RequestParam(value = "dtnoraLocalidadId", required = false) String dtnoraLocalidadId_,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero_,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId_,
			@RequestParam(value = "dtdireccion_nocapv", required = false) String dtdireccion_nocapv_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId_,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId_,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			@RequestParam(value = "mocodigo", required = false) String mocodigo_,

			HttpServletRequest request) {
		try {
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date hcfedeDesde = Y41aUtils.parseDate(hcfedeDesde_, locale);
			Date hcfedeHasta = Y41aUtils.parseDate(hcfedeHasta_, locale);
			Date defereDesde = Y41aUtils.parseDate(defereDesde_, locale);
			Date defereHasta = Y41aUtils.parseDate(defereHasta_, locale);
			Date defedeDesde = Y41aUtils.parseDate(defedeDesde_, locale);
			Date defedeHasta = Y41aUtils.parseDate(defedeHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro

			String hdcosc = ("".equals(hdcosc_)) ? null : hdcosc_;

			String decoor = ("".equals(decoor_)) ? null : decoor_;
			String indGestion = ("".equals(indGestion_)) ? null : indGestion_;
			String tfpcodigo = ("".equals(tfpcodigo_)) ? null : tfpcodigo_;
			String hdcodexpedienteorigen = ("".equals(hdcodexpedienteorigen_)) ? null
					: hdcodexpedienteorigen_;
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String decodigo = ("".equals(decodigo_)) ? null : decodigo_;
			String dtnombre = ("".equals(dtnombre_)) ? null : dtnombre_;
			String dtapellido1 = ("".equals(dtapellido1_)) ? null
					: dtapellido1_;
			String dtapellido2 = ("".equals(dtapellido2_)) ? null
					: dtapellido2_;

			String dtnif = ("".equals(dtnif_)) ? null : dtnif_;

			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;
			String esnif = ("".equals(esnif_)) ? null : esnif_;
			// cons
			String dtextranjero = null;
			String dtestado = null;
			String dtnoraPaisId = null;
			String dtnoraProvinciaId = null;
			String dtnoraMunicipioId = null;
			String dtnoraLocalidadId = null;
			String dtdireccion_nocapv = null;

			if (Y41aConstantes.NORA_LOCALIZACION_TODOS.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = null;
			} else if (Y41aConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(dtextranjero_)) {
				dtextranjero = Y41aConstantes.VALOR_SI;
				dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
						: dtnoraPaisId_;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;

			} else if (Y41aConstantes.NORA_LOCALIZACION_ESTADO
					.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = Y41aConstantes.VALOR_SI;
				dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null
						: dtnoraProvinciaId_;
				dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null
						: dtnoraMunicipioId_;
				dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null
						: dtnoraLocalidadId_;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;
			}

			// est
			String esextranjero = null;
			String esestado = null;
			String esnoraPaisId = null;
			String esnoraProvinciaId = null;
			String esnoraMunicipioId = null;
			String esnoraLocalidadId = null;
			String esdireccion_nocapv = null;

			if (Y41aConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41aConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(esextranjero_)) {
				esextranjero = Y41aConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
						: esnoraPaisId_;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;

			} else if (Y41aConstantes.NORA_LOCALIZACION_ESTADO
					.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41aConstantes.VALOR_SI;
				esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null
						: esnoraProvinciaId_;
				esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null
						: esnoraMunicipioId_;
				esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null
						: esnoraLocalidadId_;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;
			}

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);
			String codOrgConectado = censoMonitor.getOrganismo().getCodOrg();

			// control checks
			String indUltimoTramite = ("on".equals(indUltimoTramite_)) ? Y41aConstantes.VALOR_SI
					: null;

			String mocodigo = ("".equals(mocodigo_)) ? null : mocodigo_;

			SolicitudBusqueda filterSolicitudBusqueda = new SolicitudBusqueda(
					null, decoor, denran, denror, null, indGestion, tfpcodigo,
					null, null, null, null, hdcosc, null, trcodigo, null, null,
					indUltimoTramite, null, decodigo, null, null, null, null,
					dtnombre, dtapellido1, dtapellido2, dtnif, dtestado,
					dtnoraProvinciaId, null, dtnoraMunicipioId, null,
					dtnoraLocalidadId, null, dtextranjero, dtnoraPaisId, null,
					dtdireccion_nocapv, null, esnombre, esnif, esestado,
					esnoraProvinciaId, null, esnoraMunicipioId, null,
					esnoraLocalidadId, null, esextranjero, esnoraPaisId, null,
					esdireccion_nocapv, null, null, codOrgConectado,
					hdcodexpedienteorigen, null, null, null, null, null,
					mocodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<SolicitudBusqueda> solicitudesBusqueda = this.denunciaService
						.findAllLikeSolicitudes(filterSolicitudBusqueda,
								pagination, false, defedeDesde, defedeHasta,
								defereDesde, defereHasta, hcfedeDesde,
								hcfedeHasta);

				if (solicitudesBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService.findAllLikeSolicitudesCount(
						filterSolicitudBusqueda, false, defedeDesde,
						defedeHasta, defereDesde, defereHasta, hcfedeDesde,
						hcfedeHasta);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(solicitudesBusqueda);
				return data;
			} else {
				List<SolicitudBusqueda> solicitudesBusqueda = this.denunciaService
						.findAllLikeSolicitudes(filterSolicitudBusqueda,
								pagination, false, defedeDesde, defedeHasta,
								defereDesde, defereHasta, hcfedeDesde,
								hcfedeHasta);
				if (solicitudesBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return solicitudesBusqueda;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterDenuncia
	 *            Denuncia
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "denuncia", required = false) Denuncia filterDenuncia,
			HttpServletRequest request) {
		try {
			return denunciaService
					.findAllCount(filterDenuncia != null ? filterDenuncia
							: new Denuncia());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @param response
	 *            HttpServletResponse
	 * @return Denuncia
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Denuncia edit(@RequestBody Denuncia denuncia, HttpServletResponse response) {
		try {
			Denuncia denunciaAux = this.denunciaService.update(denuncia);
			logger.info("Entity correctly inserted!");
			return denunciaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param denuncia
	 *            Denuncia
	 * @return Denuncia
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Denuncia add(@RequestBody Denuncia denuncia) {
		try {
			Denuncia denunciaAux = this.denunciaService.add(denuncia);
			logger.info("Entity correctly inserted!");
			return denunciaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addConsulta'.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * 
	 * @return Solicitud
	 */
	@RequestMapping(value = "/altaSolicitud", method = RequestMethod.POST)
	public @ResponseBody
	SolicitudDetalle addSolicitud(@RequestBody SolicitudDetalle solicitudDetalle) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			solicitudDetalle.setDefede(Y41aUtils.parseDate(
					solicitudDetalle.getDefede(), locale));
			solicitudDetalle.setDefere(Y41aUtils.parseDate(
					solicitudDetalle.getDefere(), locale));
			solicitudDetalle.setHdfehd(Y41aUtils.parseDate(
					solicitudDetalle.getHdfehd(), locale));

			SolicitudDetalle solicitudDetalleAux = this.denunciaService
					.addSolicitud(solicitudDetalle);

			logger.info("Entity correctly inserted!");
			return solicitudDetalleAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addNuevoHecho'.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * 
	 * @return Solicitud
	 */
	@RequestMapping(value = "/nuevoHecho", method = RequestMethod.POST)
	public @ResponseBody
	SolicitudDetalle addNuevoHecho(
			@RequestBody SolicitudDetalle solicitudDetalle) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			solicitudDetalle.setDefede(Y41aUtils.parseDate(
					solicitudDetalle.getDefede(), locale));
			solicitudDetalle.setDefere(Y41aUtils.parseDate(
					solicitudDetalle.getDefere(), locale));
			solicitudDetalle.setHdfehd(Y41aUtils.parseDate(
					solicitudDetalle.getHdfehd(), locale));

			SolicitudDetalle solicitudDetalleAux = this.denunciaService
					.addNuevoHecho(solicitudDetalle);

			logger.info("Entity correctly inserted!");
			return solicitudDetalleAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addConsulta'.
	 * 
	 * @param solicitudDetalle
	 *            SolicitudDetalle
	 * 
	 * @return Solicitud
	 */
	@RequestMapping(value = "/detalleSolicitud", method = RequestMethod.PUT)
	public @ResponseBody
	SolicitudDetalle editSolicitud(
			@RequestBody SolicitudDetalle solicitudDetalle) {
		try {
			Locale locale = LocaleContextHolder.getLocale();
			solicitudDetalle.setDefede(Y41aUtils.parseDate(
					solicitudDetalle.getDefede(), locale));
			solicitudDetalle.setDefere(Y41aUtils.parseDate(
					solicitudDetalle.getDefere(), locale));
			solicitudDetalle.setHdfehd(Y41aUtils.parseDate(
					solicitudDetalle.getHdfehd(), locale));
			SolicitudDetalle solicitudDetalleAux = this.denunciaService
					.updateSolicitud(solicitudDetalle);

			solicitudDetalleAux.setHdte(Y41aStringUtils.unescapeHTML(
					solicitudDetalleAux.getHdte(), 0));
			solicitudDetalleAux.setHdteso(Y41aStringUtils.unescapeHTML(
					solicitudDetalleAux.getHdteso(), 0));

			logger.info("Entity correctly inserted!");
			return solicitudDetalleAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param decodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{decodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String decodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Denuncia denuncia = new Denuncia();
			denuncia.setDecodigo(decodigo);
			this.denunciaService.remove(denuncia);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + decodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param denunciaIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> denunciaIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Denuncia> denunciaList = new ArrayList<Denuncia>();
		try {
			for (ArrayList<String> denunciaId : denunciaIds) {
				Iterator<String> iterator = denunciaId.iterator();
				Denuncia denuncia = new Denuncia();
				denuncia.setDecodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				denunciaList.add(denuncia);
			}
			this.denunciaService.removeMultiple(denunciaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getDenunciaService'.
	 * 
	 * @return DenunciaService
	 */
	protected DenunciaService getDenunciaService() {
		return this.denunciaService;
	}

	/**
	 * Method 'setDenunciaService'.
	 * 
	 * @param denunciaService
	 *            DenunciaService
	 * @return
	 */
	public void setDenunciaService(DenunciaService denunciaService) {
		this.denunciaService = denunciaService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Exporta el resultado de la búsqueda a una tabla excel
	 * 
	 * @param decoor_
	 * @param denror
	 * @param denran
	 * @param indGestion_
	 * @param hcfedeDesde_
	 * @param hcfedeHasta_
	 * @param hdcosc_
	 * @param defereDesde_
	 * @param defereHasta_
	 * @param tfpcodigo_
	 * @param hdcodexpedienteorigen_
	 * @param trcodigo_
	 * @param indUltimoTramite_
	 * @param decodigo_
	 * @param defedeDesde_
	 * @param defedeHasta_
	 * @param dtnombre_
	 * @param dtapellido1_
	 * @param dtapellido2_
	 * @param dtnif_
	 * @param dtestado_
	 * @param dtnoraProvinciaId_
	 * @param dtnoraMunicipioId_
	 * @param dtnoraLocalidadId_
	 * @param dtextranjero_
	 * @param dtnoraPaisId_
	 * @param dtdireccion_nocapv_
	 * @param esnombre_
	 * @param esnif_
	 * @param esestado_
	 * @param esnoraProvinciaId_
	 * @param esnoraMunicipioId_
	 * @param esnoraLocalidadId_
	 * @param esextranjero_
	 * @param esnoraPaisId_
	 * @param esdireccion_nocapv_
	 * @param mocodigo_
	 * @param request
	 * @param response
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllConsultaExcel(
			@RequestParam(value = "decoor", required = false) String decoor_,
			@RequestParam(value = "denror", required = false) BigDecimal denror,
			@RequestParam(value = "denran", required = false) BigDecimal denran,
			@RequestParam(value = "indGestion", required = false) String indGestion_,
			@RequestParam(value = "hcfedeDesde", required = false) String hcfedeDesde_,
			@RequestParam(value = "hcfedeHasta", required = false) String hcfedeHasta_,
			@RequestParam(value = "hdcosc", required = false) String hdcosc_,
			@RequestParam(value = "defereDesde", required = false) String defereDesde_,
			@RequestParam(value = "defereHasta", required = false) String defereHasta_,
			@RequestParam(value = "tfpcodigo", required = false) String tfpcodigo_,
			@RequestParam(value = "hdcodexpedienteorigen", required = false) String hdcodexpedienteorigen_,
			@RequestParam(value = "trcodigo", required = false) String trcodigo_,
			@RequestParam(value = "indUltimoTramite", required = false) String indUltimoTramite_,
			@RequestParam(value = "decodigo", required = false) String decodigo_,
			@RequestParam(value = "defedeDesde", required = false) String defedeDesde_,
			@RequestParam(value = "defedeHasta", required = false) String defedeHasta_,
			@RequestParam(value = "dtnombre", required = false) String dtnombre_,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1_,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2_,
			@RequestParam(value = "dtnif", required = false) String dtnif_,
			@RequestParam(value = "dtestado", required = false) String dtestado_,
			@RequestParam(value = "dtnoraProvinciaId", required = false) String dtnoraProvinciaId_,
			@RequestParam(value = "dtnoraMunicipioId", required = false) String dtnoraMunicipioId_,
			@RequestParam(value = "dtnoraLocalidadId", required = false) String dtnoraLocalidadId_,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero_,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId_,
			@RequestParam(value = "dtdireccion_nocapv", required = false) String dtdireccion_nocapv_,
			@RequestParam(value = "esnombre", required = false) String esnombre_,
			@RequestParam(value = "esnif", required = false) String esnif_,
			@RequestParam(value = "esestado", required = false) String esestado_,
			@RequestParam(value = "esnoraProvinciaId", required = false) String esnoraProvinciaId_,
			@RequestParam(value = "esnoraMunicipioId", required = false) String esnoraMunicipioId_,
			@RequestParam(value = "esnoraLocalidadId", required = false) String esnoraLocalidadId_,
			@RequestParam(value = "esextranjero", required = false) String esextranjero_,
			@RequestParam(value = "esnoraPaisId", required = false) String esnoraPaisId_,
			@RequestParam(value = "esdireccion_nocapv", required = false) String esdireccion_nocapv_,
			@RequestParam(value = "mocodigo", required = false) String mocodigo_,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date hcfedeDesde = Y41aUtils.parseDate(hcfedeDesde_, locale);
			Date hcfedeHasta = Y41aUtils.parseDate(hcfedeHasta_, locale);
			Date defereDesde = Y41aUtils.parseDate(defereDesde_, locale);
			Date defereHasta = Y41aUtils.parseDate(defereHasta_, locale);
			Date defedeDesde = Y41aUtils.parseDate(defedeDesde_, locale);
			Date defedeHasta = Y41aUtils.parseDate(defedeHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro

			String hdcosc = ("".equals(hdcosc_)) ? null : hdcosc_;

			String decoor = ("".equals(decoor_)) ? null : decoor_;
			String indGestion = ("".equals(indGestion_)) ? null : indGestion_;
			String tfpcodigo = ("".equals(tfpcodigo_)) ? null : tfpcodigo_;
			String hdcodexpedienteorigen = ("".equals(hdcodexpedienteorigen_)) ? null
					: hdcodexpedienteorigen_;
			String trcodigo = ("".equals(trcodigo_)) ? null : trcodigo_;
			String decodigo = ("".equals(decodigo_)) ? null : decodigo_;
			String dtnombre = ("".equals(dtnombre_)) ? null : dtnombre_;
			String dtapellido1 = ("".equals(dtapellido1_)) ? null
					: dtapellido1_;
			String dtapellido2 = ("".equals(dtapellido2_)) ? null
					: dtapellido2_;

			String dtnif = ("".equals(dtnif_)) ? null : dtnif_;

			String esnombre = ("".equals(esnombre_)) ? null : esnombre_;
			String esnif = ("".equals(esnif_)) ? null : esnif_;
			// cons
			String dtextranjero = null;
			String dtestado = null;
			String dtnoraPaisId = null;
			String dtnoraProvinciaId = null;
			String dtnoraMunicipioId = null;
			String dtnoraLocalidadId = null;
			String dtdireccion_nocapv = null;

			if (Y41aConstantes.NORA_LOCALIZACION_TODOS.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = null;
			} else if (Y41aConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(dtextranjero_)) {
				dtextranjero = Y41aConstantes.VALOR_SI;
				dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
						: dtnoraPaisId_;
				dtestado = null;
				dtnoraProvinciaId = null;
				dtnoraMunicipioId = null;
				dtnoraLocalidadId = null;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;

			} else if (Y41aConstantes.NORA_LOCALIZACION_ESTADO
					.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = Y41aConstantes.VALOR_SI;
				dtnoraProvinciaId = ("".equals(dtnoraProvinciaId_)) ? null
						: dtnoraProvinciaId_;
				dtnoraMunicipioId = ("".equals(dtnoraMunicipioId_)) ? null
						: dtnoraMunicipioId_;
				dtnoraLocalidadId = ("".equals(dtnoraLocalidadId_)) ? null
						: dtnoraLocalidadId_;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;
			}

			// est
			String esextranjero = null;
			String esestado = null;
			String esnoraPaisId = null;
			String esnoraProvinciaId = null;
			String esnoraMunicipioId = null;
			String esnoraLocalidadId = null;
			String esdireccion_nocapv = null;

			if (Y41aConstantes.NORA_LOCALIZACION_TODOS.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = null;
			} else if (Y41aConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(esextranjero_)) {
				esextranjero = Y41aConstantes.VALOR_SI;
				esnoraPaisId = ("".equals(esnoraPaisId_)) ? null
						: esnoraPaisId_;
				esestado = null;
				esnoraProvinciaId = null;
				esnoraMunicipioId = null;
				esnoraLocalidadId = null;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;

			} else if (Y41aConstantes.NORA_LOCALIZACION_ESTADO
					.equals(esextranjero_)) {
				esextranjero = null;
				esnoraPaisId = null;
				esestado = Y41aConstantes.VALOR_SI;
				esnoraProvinciaId = ("".equals(esnoraProvinciaId_)) ? null
						: esnoraProvinciaId_;
				esnoraMunicipioId = ("".equals(esnoraMunicipioId_)) ? null
						: esnoraMunicipioId_;
				esnoraLocalidadId = ("".equals(esnoraLocalidadId_)) ? null
						: esnoraLocalidadId_;
				esdireccion_nocapv = ("".equals(esdireccion_nocapv_)) ? null
						: esdireccion_nocapv_;
			}

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);
			String codOrgConectado = censoMonitor.getOrganismo().getCodOrg();

			// control checks
			String indUltimoTramite = ("on".equals(indUltimoTramite_)) ? Y41aConstantes.VALOR_SI
					: null;

			String mocodigo = ("".equals(mocodigo_)) ? null : mocodigo_;

			SolicitudBusqueda filterSolicitudBusqueda = new SolicitudBusqueda(
					null, decoor, denran, denror, null, indGestion, tfpcodigo,
					null, null, null, null, hdcosc, null, trcodigo, null, null,
					indUltimoTramite, null, decodigo, null, null, null, null,
					dtnombre, dtapellido1, dtapellido2, dtnif, dtestado,
					dtnoraProvinciaId, null, dtnoraMunicipioId, null,
					dtnoraLocalidadId, null, dtextranjero, dtnoraPaisId, null,
					dtdireccion_nocapv, null, esnombre, esnif, esestado,
					esnoraProvinciaId, null, esnoraMunicipioId, null,
					esnoraLocalidadId, null, esextranjero, esnoraPaisId, null,
					esdireccion_nocapv, null, null, codOrgConectado,
					hdcodexpedienteorigen, null, null, null, null, null,
					mocodigo);

			Date fechaHoy = new Date();
			String fechaActual = Y41aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41aConstantes.EXCEL_BUSQUEDA_CONSULTAS
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ Y41aStringUtils.unescapeHTML(nombre, 0) + "\"");

			String xslString = this.y41aExcelGeneratorService
					.getSolicitudesExcel(filterSolicitudBusqueda, defedeDesde,
							defedeHasta, defereDesde, defereHasta, hcfedeDesde,
							hcfedeHasta);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Obtiene los documentos relativos a un tramite del hecho denunciado
	 * 
	 * @param ehcodigo
	 *            código de trámite
	 * @param request
	 *            petición HTTP
	 * @return List<DocumentoHecho>
	 */
	@RequestMapping(value = "/documentosTramitacion/{ehcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Object getDocumentosByIdTramite(@PathVariable String ehcodigo,
			HttpServletRequest request) {
		try {

			TramiteHecho tramite = new TramiteHecho();
			tramite.setEhcodigo(ehcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<DocumentoHecho> documentos = this.denunciaService
						.findAllDocumentosByTramite(tramite, pagination);

				if (documentos == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.denunciaService
						.findAllCountDocumentosByTramite(new TramiteComun(
								ehcodigo, null, null), pagination);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(documentos);
				return data;
			} else {
				List<DocumentoHecho> documentos = this.denunciaService
						.findAllDocumentosByTramite(tramite, pagination);
				if (documentos == null) {
					throw new Exception("No data Found.");
				}
				return documentos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

}
