package com.ejie.y41a.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Decision;
import com.ejie.y41a.model.DecisionHecho;
import com.ejie.y41a.model.HechoDenunciado;
import com.ejie.y41a.service.DecisionHechoService;

/**
 * * DecisionHechoController generated by UDA, 22-feb-2012 17:30:45.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/decisionhecho")
public class DecisionHechoController {

	private static final Logger logger = LoggerFactory
			.getLogger(DecisionHechoController.class);

	@Autowired
	private DecisionHechoService decisionHechoService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("decisionhecho", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param hccodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{hccodigo}", method = RequestMethod.GET)
	public @ResponseBody
	DecisionHecho getById(@PathVariable String hccodigo) {
		try {
			DecisionHecho decisionHecho = new DecisionHecho();
			decisionHecho.setHccodigo(hccodigo);
			decisionHecho = this.decisionHechoService.find(decisionHecho);
			if (decisionHecho == null) {
				throw new Exception(hccodigo.toString());
			}
			return decisionHecho;
		} catch (Exception e) {
			throw new ResourceNotFoundException(hccodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param hccodigo
	 *            String
	 * @param hechoDenunciadoHdcodigo
	 *            String
	 * @param decisionDecodigo
	 *            String
	 * @param hccoor
	 *            String
	 * @param hcfede
	 *            Date
	 * @param hcfecode
	 *            Date
	 * @param hccoorprop
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "hccodigo", required = false) String hccodigo,
			@RequestParam(value = "hechoDenunciadoHdcodigo", required = false) String hechoDenunciadoHdcodigo,
			@RequestParam(value = "decisionDecodigo", required = false) String decisionDecodigo,
			@RequestParam(value = "hccoor", required = false) String hccoor,
			@RequestParam(value = "hcfede", required = false) Date hcfede,
			@RequestParam(value = "hcfecode", required = false) Date hcfecode,
			@RequestParam(value = "hccoorprop", required = false) String hccoorprop,
			@RequestParam(value = "hcoortrasinhibi", required = false) String hcoortrasinhibi,
			HttpServletRequest request) {
		try {
			DecisionHecho filterDecisionHecho = new DecisionHecho(hccodigo,
					hccoor, hcfede, hcfecode, hccoorprop, hcoortrasinhibi,
					new HechoDenunciado(hechoDenunciadoHdcodigo, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null), new Decision(decisionDecodigo, null,
							null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<DecisionHecho> decisionHechos = this.decisionHechoService
						.findAll(filterDecisionHecho, pagination);

				if (decisionHechos == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterDecisionHecho, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(decisionHechos);
				return data;
			} else {
				List<DecisionHecho> decisionHechos = this.decisionHechoService
						.findAll(filterDecisionHecho, pagination);
				if (decisionHechos == null) {
					throw new Exception("No data Found.");
				}
				return decisionHechos;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterDecisionHecho
	 *            DecisionHecho
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "decisionHecho", required = false) DecisionHecho filterDecisionHecho,
			HttpServletRequest request) {
		try {
			return decisionHechoService
					.findAllCount(filterDecisionHecho != null ? filterDecisionHecho
							: new DecisionHecho());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCountDecisiones'.
	 * 
	 * @param decodigo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countDecisiones/{decodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountDecisiones(@PathVariable String decodigo,
			HttpServletRequest request) {
		try {

			Decision decisionConsulta = new Decision();
			decisionConsulta.setDecodigo(decodigo);
			DecisionHecho decisionHecho = new DecisionHecho();
			decisionHecho.setDecision(decisionConsulta);
			return this.decisionHechoService.findAllCount(decisionHecho);

		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param decisionHecho
	 *            DecisionHecho
	 * @param response
	 *            HttpServletResponse
	 * @return DecisionHecho
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	DecisionHecho edit(@RequestBody DecisionHecho decisionHecho,
			HttpServletResponse response) {
		try {
			DecisionHecho decisionHechoAux = this.decisionHechoService
					.update(decisionHecho);
			logger.info("Entity correctly inserted!");
			return decisionHechoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param decisionHecho
	 *            DecisionHecho
	 * @return DecisionHecho
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	DecisionHecho add(@RequestBody DecisionHecho decisionHecho) {
		try {
			DecisionHecho decisionHechoAux = this.decisionHechoService
					.add(decisionHecho);
			logger.info("Entity correctly inserted!");
			return decisionHechoAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param hccodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{hccodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String hccodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			DecisionHecho decisionHecho = new DecisionHecho();
			decisionHecho.setHccodigo(hccodigo);
			this.decisionHechoService.remove(decisionHecho);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + hccodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param decisionHechoIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> decisionHechoIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<DecisionHecho> decisionHechoList = new ArrayList<DecisionHecho>();
		try {
			for (ArrayList<String> decisionHechoId : decisionHechoIds) {
				Iterator<String> iterator = decisionHechoId.iterator();
				DecisionHecho decisionHecho = new DecisionHecho();
				decisionHecho.setHccodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				decisionHechoList.add(decisionHecho);
			}
			this.decisionHechoService.removeMultiple(decisionHechoList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getDecisionHechoService'.
	 * 
	 * @return DecisionHechoService
	 */
	protected DecisionHechoService getDecisionHechoService() {
		return this.decisionHechoService;
	}

	/**
	 * Method 'setDecisionHechoService'.
	 * 
	 * @param decisionHechoService
	 *            DecisionHechoService
	 * @return
	 */
	public void setDecisionHechoService(
			DecisionHechoService decisionHechoService) {
		this.decisionHechoService = decisionHechoService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
