package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.DecisionService;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Decision;

/**
 * * DecisionController generated by UDA, 05-mar-2012 9:11:48.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/decision")
public class DecisionController {

	private static final Logger logger = LoggerFactory
			.getLogger(DecisionController.class);

	@Autowired
	private DecisionService decisionService;

	@Autowired
	private Properties appConfiguration;

	@Autowired
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */
	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("decision", "model", model);
	}

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "modalDecision", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("modalDecision", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param decodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{decodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Decision getById(@PathVariable String decodigo) {
		try {
			Decision decision = new Decision();
			decision.setDecodigo(decodigo);
			decision = this.decisionService.find(decision);
			if (decision == null) {
				throw new Exception(decodigo.toString());
			}
			return decision;
		} catch (Exception e) {
			throw new ResourceNotFoundException(decodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param decodigo
	 *            String
	 * @param denombre
	 *            String
	 * @param denombree
	 *            String
	 * @param debaja
	 *            Date
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "decodigo", required = false) String decodigo,
			@RequestParam(value = "denombre", required = false) String denombre,
			@RequestParam(value = "denombree", required = false) String denombree,
			@RequestParam(value = "debaja", required = false) Date debaja,
			HttpServletRequest request) {
		try {
			Decision filterDecision = new Decision(decodigo, denombre,
					denombree, debaja);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Decision> decisions = this.decisionService.findAll(
						filterDecision, pagination);

				if (decisions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterDecision, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(decisions);
				return data;
			} else {
				List<Decision> decisions = this.decisionService.findAll(
						filterDecision, pagination);
				if (decisions == null) {
					throw new Exception("No data Found.");
				}
				return decisions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterDecision
	 *            Decision
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "decision", required = false) Decision filterDecision,
			HttpServletRequest request) {
		try {
			return decisionService
					.findAllCount(filterDecision != null ? filterDecision
							: new Decision());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param decodigo
	 *            string
	 * @return Decision
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Decision edit(
			@RequestParam(value = "decodigo", required = true) String decodigo) {
		try {

			Decision decision = new Decision();
			decision.setDecodigo(decodigo);
			decision.setDebaja(new Date());

			Decision decisionAux = this.decisionService.updateFecha(decision);
			logger.info("Entity correctly inserted!");
			return decisionAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param decision
	 *            Decision
	 * @return Decision
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Decision add(@RequestBody Decision decision) {
		try {
			Decision decisionAux = this.decisionService.addDecision(decision);
			logger.info("Entity correctly inserted!");
			return decisionAux;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param decodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{decodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String decodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Decision decision = new Decision();
			decision.setDecodigo(decodigo);
			this.decisionService.remove(decision);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + decodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param decisionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> decisionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Decision> decisionList = new ArrayList<Decision>();
		try {
			for (ArrayList<String> decisionId : decisionIds) {
				Iterator<String> iterator = decisionId.iterator();
				Decision decision = new Decision();
				decision.setDecodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				decisionList.add(decision);
			}
			this.decisionService.removeMultiple(decisionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getDecisionService'.
	 * 
	 * @return DecisionService
	 */
	protected DecisionService getDecisionService() {
		return this.decisionService;
	}

	/**
	 * Method 'setDecisionService'.
	 * 
	 * @param decisionService
	 *            DecisionService
	 * @return
	 */
	public void setDecisionService(DecisionService decisionService) {
		this.decisionService = decisionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
