package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.ConsumidorDetalle;
import com.ejie.y41a.model.ConsumidorReclamaciones;
import com.ejie.y41a.model.RangoEdad;
import com.ejie.y41a.service.ConsumidorService;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Consumidor;

/**
 * * ConsumidorController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/consumidor")
public class ConsumidorController {

	private static final Logger logger = LoggerFactory
			.getLogger(ConsumidorController.class);

	@Autowired
	private ConsumidorService consumidorService;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("consumidor", "model", model);
	}

	/**
	 * Method 'getCreateFormModal'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintModal", method = RequestMethod.GET)
	public ModelAndView getCreateFormModal(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("consumidorModal", "model", model);
	}

	/**
	 * Method 'getCreateFormModalSolicitud'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintModalConsumidor", method = RequestMethod.GET)
	public ModelAndView getCreateFormModalSolicitud(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("solicitudconsumidorModal", "model", model);
	}

	/**
	 * Method 'getCreateModalReclamacionesConsumidor'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "reclamacionesConsumidor", method = RequestMethod.GET)
	public ModelAndView getCreateModalReclamacionesConsumidor(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("reclamacionesConsumidor", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param dtcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{dtcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Consumidor getById(@PathVariable String dtcodigo) {
		try {
			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(dtcodigo);
			consumidor = this.consumidorService.find(consumidor);
			if (consumidor == null) {
				throw new Exception(dtcodigo.toString());
			}
			return consumidor;
		} catch (Exception e) {
			throw new ResourceNotFoundException(dtcodigo.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param dtcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/detalle", method = RequestMethod.GET)
	public @ResponseBody
	ConsumidorDetalle getConsumidorById(
			@RequestParam(value = "dtcodigo", required = true) String dtcodigo) {
		try {

			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(dtcodigo);
			ConsumidorDetalle consumidorDetalle = this.consumidorService
					.findConsumidor(consumidor);
			if (consumidorDetalle == null) {
				throw new Exception(dtcodigo.toString());
			}
			return consumidorDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(dtcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param dtcodigo
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param rangoEdadRancod
	 *            String
	 * @param dtnombre
	 *            String
	 * @param dtapellido1
	 *            String
	 * @param dtapellido2
	 *            String
	 * @param dtnif
	 *            String
	 * @param dtnodir
	 *            String
	 * @param dtcolo
	 *            String
	 * @param dtnrcopo
	 *            String
	 * @param dtnrtel
	 *            String
	 * @param dtnrfax
	 *            String
	 * @param dtcopa
	 *            String
	 * @param dtnrdimu
	 *            String
	 * @param dttecoem
	 *            String
	 * @param dtnrtel2
	 *            String
	 * @param dtnrtel3
	 *            String
	 * @param dtcoidco
	 *            String
	 * @param dtinreco
	 *            String
	 * @param dtcoorac
	 *            String
	 * @param dtnoap1
	 *            String
	 * @param dtnoap2
	 *            String
	 * @param dtnrsoci
	 *            String
	 * @param dtnran
	 *            String
	 * @param dtcosx
	 *            String
	 * @param dtnorep
	 *            String
	 * @param dtnifrep
	 *            String
	 * @param dtfemod
	 *            String
	 * @param dtnolo
	 *            String
	 * @param dtcopv
	 *            String
	 * @param dtinrl
	 *            String
	 * @param dtnodirr
	 *            String
	 * @param dtcolor
	 *            String
	 * @param dtnrcopor
	 *            String
	 * @param dtcopvr
	 *            String
	 * @param dtnrtelr
	 *            String
	 * @param dtnrtel2r
	 *            String
	 * @param dtnrfaxr
	 *            String
	 * @param dtteemr
	 *            String
	 * @param dtintipid
	 *            String
	 * @param dtnoraPaisId
	 *            String
	 * @param dtnoraPaisNombre
	 *            String
	 * @param dtnoraProvinciaId
	 *            String
	 * @param dtnombreProvincia
	 *            String
	 * @param dtnoraMunicipioId
	 *            String
	 * @param dtnombreMunicipio
	 *            String
	 * @param dtnoraLocalidadId
	 *            String
	 * @param dtnombreLocalidad
	 *            String
	 * @param dtnoraCalleId
	 *            String
	 * @param dtnombreCalle
	 *            String
	 * @param dtnoraCpId
	 *            String
	 * @param dtnombreCp
	 *            String
	 * @param dtnoraPortalId
	 *            String
	 * @param dtnombrePortal
	 *            String
	 * @param dtnombrePiso
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "dtcodigo", required = false) String dtcodigo,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod,
			@RequestParam(value = "dtnombre", required = false) String dtnombre,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2,
			@RequestParam(value = "dtnif", required = false) String dtnif,
			@RequestParam(value = "dtnodir", required = false) String dtnodir,
			@RequestParam(value = "dtcolo", required = false) String dtcolo,
			@RequestParam(value = "dtnrcopo", required = false) String dtnrcopo,
			@RequestParam(value = "dtnrtel", required = false) String dtnrtel,
			@RequestParam(value = "dtnrfax", required = false) String dtnrfax,
			@RequestParam(value = "dtcopa", required = false) String dtcopa,
			@RequestParam(value = "dtnrdimu", required = false) String dtnrdimu,
			@RequestParam(value = "dttecoem", required = false) String dttecoem,
			@RequestParam(value = "dtnrtel2", required = false) String dtnrtel2,
			@RequestParam(value = "dtnrtel3", required = false) String dtnrtel3,
			@RequestParam(value = "dtcoidco", required = false) String dtcoidco,
			@RequestParam(value = "dtinreco", required = false) String dtinreco,
			@RequestParam(value = "dtcoorac", required = false) String dtcoorac,
			@RequestParam(value = "dtnoap1", required = false) String dtnoap1,
			@RequestParam(value = "dtnoap2", required = false) String dtnoap2,
			@RequestParam(value = "dtnrsoci", required = false) String dtnrsoci,
			@RequestParam(value = "dtnran", required = false) String dtnran,
			@RequestParam(value = "dtcosx", required = false) String dtcosx,
			@RequestParam(value = "dtnorep", required = false) String dtnorep,
			@RequestParam(value = "dtnifrep", required = false) String dtnifrep,
			@RequestParam(value = "dtfemod", required = false) String dtfemod,
			@RequestParam(value = "dtnolo", required = false) String dtnolo,
			@RequestParam(value = "dtcopv", required = false) String dtcopv,
			@RequestParam(value = "dtinrl", required = false) String dtinrl,
			@RequestParam(value = "dtnodirr", required = false) String dtnodirr,
			@RequestParam(value = "dtcolor", required = false) String dtcolor,
			@RequestParam(value = "dtnrcopor", required = false) String dtnrcopor,
			@RequestParam(value = "dtcopvr", required = false) String dtcopvr,
			@RequestParam(value = "dtnrtelr", required = false) String dtnrtelr,
			@RequestParam(value = "dtnrtel2r", required = false) String dtnrtel2r,
			@RequestParam(value = "dtnrfaxr", required = false) String dtnrfaxr,
			@RequestParam(value = "dtteemr", required = false) String dtteemr,
			@RequestParam(value = "dtintipid", required = false) String dtintipid,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId,
			@RequestParam(value = "dtnoraPaisNombre", required = false) String dtnoraPaisNombre,
			@RequestParam(value = "dtnoraProvinciaId", required = false) String dtnoraProvinciaId,
			@RequestParam(value = "dtnombreProvincia", required = false) String dtnombreProvincia,
			@RequestParam(value = "dtnoraMunicipioId", required = false) String dtnoraMunicipioId,
			@RequestParam(value = "dtnombreMunicipio", required = false) String dtnombreMunicipio,
			@RequestParam(value = "dtnoraLocalidadId", required = false) String dtnoraLocalidadId,
			@RequestParam(value = "dtnombreLocalidad", required = false) String dtnombreLocalidad,
			@RequestParam(value = "dtnoraCalleId", required = false) String dtnoraCalleId,
			@RequestParam(value = "dtnombreCalle", required = false) String dtnombreCalle,
			@RequestParam(value = "dtnoraCpId", required = false) String dtnoraCpId,
			@RequestParam(value = "dtnombreCp", required = false) String dtnombreCp,
			@RequestParam(value = "dtnoraPortalId", required = false) String dtnoraPortalId,
			@RequestParam(value = "dtnombrePortal", required = false) String dtnombrePortal,
			@RequestParam(value = "dtnombrePiso", required = false) String dtnombrePiso,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero,
			@RequestParam(value = "dtestado", required = false) String dtestado,
			HttpServletRequest request) {
		try {
			Consumidor filterConsumidor = new Consumidor(dtcodigo,
					new CensoMonitor(censoMonitorMocodigo, null, null, null,
							null, null, null, null, null, null, null, null),
					new RangoEdad(rangoEdadRancod, null, null, null), dtnombre,
					dtapellido1, dtapellido2, dtnif, dtnodir, dtcolo, dtnrcopo,
					dtnrtel, dtnrfax, dtcopa, dtnrdimu, dttecoem, dtnrtel2,
					dtnrtel3, dtcoidco, dtinreco, dtcoorac, dtnoap1, dtnoap2,
					dtnrsoci, dtnran, dtcosx, dtnorep, dtnifrep, dtfemod,
					dtnolo, dtcopv, dtinrl, dtnodirr, dtcolor, dtnrcopor,
					dtcopvr, dtnrtelr, dtnrtel2r, dtnrfaxr, dtteemr, dtintipid,
					dtnoraPaisId, dtnoraPaisNombre, dtnoraProvinciaId,
					dtnombreProvincia, dtnoraMunicipioId, dtnombreMunicipio,
					dtnoraLocalidadId, dtnombreLocalidad, dtnoraCalleId,
					dtnombreCalle, dtnoraCpId, dtnombreCp, dtnoraPortalId,
					dtnombrePortal, dtnombrePiso, null, null, null,
					dtextranjero, dtestado);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Consumidor> consumidors = this.consumidorService.findAll(
						filterConsumidor, pagination);

				if (consumidors == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterConsumidor, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(consumidors);
				return data;
			} else {
				List<Consumidor> consumidors = this.consumidorService.findAll(
						filterConsumidor, pagination);
				if (consumidors == null) {
					throw new Exception("No data Found.");
				}
				return consumidors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllConsumidor'.
	 * 
	 * @param dtcodigo
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param rangoEdadRancod
	 *            String
	 * @param dtnombre_
	 *            String
	 * @param dtapellido1_
	 *            String
	 * @param dtapellido2_
	 *            String
	 * @param dtnif_
	 *            String
	 * @param dtnodir
	 *            String
	 * @param dtcolo
	 *            String
	 * @param dtnrcopo
	 *            String
	 * @param dtnrtel
	 *            String
	 * @param dtnrfax
	 *            String
	 * @param dtcopa
	 *            String
	 * @param dtnrdimu
	 *            String
	 * @param dttecoem
	 *            String
	 * @param dtnrtel2
	 *            String
	 * @param dtnrtel3
	 *            String
	 * @param dtcoidco
	 *            String
	 * @param dtinreco
	 *            String
	 * @param dtcoorac
	 *            String
	 * @param dtnoap1
	 *            String
	 * @param dtnoap2
	 *            String
	 * @param dtnrsoci
	 *            String
	 * @param dtnran
	 *            String
	 * @param dtcosx
	 *            String
	 * @param dtnorep
	 *            String
	 * @param dtnifrep
	 *            String
	 * @param dtfemod
	 *            String
	 * @param dtnolo
	 *            String
	 * @param dtcopv
	 *            String
	 * @param dtinrl
	 *            String
	 * @param dtnodirr
	 *            String
	 * @param dtcolor
	 *            String
	 * @param dtnrcopor
	 *            String
	 * @param dtcopvr
	 *            String
	 * @param dtnrtelr
	 *            String
	 * @param dtnrtel2r
	 *            String
	 * @param dtnrfaxr
	 *            String
	 * @param dtteemr
	 *            String
	 * @param dtintipid
	 *            String
	 * @param dtnoraPaisId
	 *            String
	 * @param dtnoraPaisNombre
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param dtnombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param dtnombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param dtnombreLocalidad
	 *            String
	 * @param dtnoraCalleId
	 *            String
	 * @param dtnombreCalle
	 *            String
	 * @param dtnoraCpId
	 *            String
	 * @param dtnombreCp
	 *            String
	 * @param dtnoraPortalId
	 *            String
	 * @param dtnombrePortal
	 *            String
	 * @param dtnombrePiso
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllConsumidor(
			@RequestParam(value = "dtcodigo", required = false) String dtcodigo,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod,
			@RequestParam(value = "dtnombre", required = false) String dtnombre_,
			@RequestParam(value = "dtapellido1", required = false) String dtapellido1_,
			@RequestParam(value = "dtapellido2", required = false) String dtapellido2_,
			@RequestParam(value = "dtnif", required = false) String dtnif_,
			@RequestParam(value = "dtnodir", required = false) String dtnodir,
			@RequestParam(value = "dtcolo", required = false) String dtcolo,
			@RequestParam(value = "dtnrcopo", required = false) String dtnrcopo,
			@RequestParam(value = "dtnrtel", required = false) String dtnrtel,
			@RequestParam(value = "dtnrfax", required = false) String dtnrfax,
			@RequestParam(value = "dtcopa", required = false) String dtcopa,
			@RequestParam(value = "dtnrdimu", required = false) String dtnrdimu,
			@RequestParam(value = "dttecoem", required = false) String dttecoem,
			@RequestParam(value = "dtnrtel2", required = false) String dtnrtel2,
			@RequestParam(value = "dtnrtel3", required = false) String dtnrtel3,
			@RequestParam(value = "dtcoidco", required = false) String dtcoidco,
			@RequestParam(value = "dtinreco", required = false) String dtinreco,
			@RequestParam(value = "dtcoorac", required = false) String dtcoorac,
			@RequestParam(value = "dtnoap1", required = false) String dtnoap1,
			@RequestParam(value = "dtnoap2", required = false) String dtnoap2,
			@RequestParam(value = "dtnrsoci", required = false) String dtnrsoci,
			@RequestParam(value = "dtnran", required = false) String dtnran,
			@RequestParam(value = "dtcosx", required = false) String dtcosx,
			@RequestParam(value = "dtnorep", required = false) String dtnorep,
			@RequestParam(value = "dtnifrep", required = false) String dtnifrep,
			@RequestParam(value = "dtfemod", required = false) String dtfemod,
			@RequestParam(value = "dtnolo", required = false) String dtnolo,
			@RequestParam(value = "dtcopv", required = false) String dtcopv,
			@RequestParam(value = "dtinrl", required = false) String dtinrl,
			@RequestParam(value = "dtnodirr", required = false) String dtnodirr,
			@RequestParam(value = "dtcolor", required = false) String dtcolor,
			@RequestParam(value = "dtnrcopor", required = false) String dtnrcopor,
			@RequestParam(value = "dtcopvr", required = false) String dtcopvr,
			@RequestParam(value = "dtnrtelr", required = false) String dtnrtelr,
			@RequestParam(value = "dtnrtel2r", required = false) String dtnrtel2r,
			@RequestParam(value = "dtnrfaxr", required = false) String dtnrfaxr,
			@RequestParam(value = "dtteemr", required = false) String dtteemr,
			@RequestParam(value = "dtintipid", required = false) String dtintipid,
			@RequestParam(value = "dtnoraPaisId", required = false) String dtnoraPaisId_,
			@RequestParam(value = "dtnoraPaisNombre", required = false) String dtnoraPaisNombre,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "dtnombreProvincia", required = false) String dtnombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "dtnombreMunicipio", required = false) String dtnombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "dtnombreLocalidad", required = false) String dtnombreLocalidad,
			@RequestParam(value = "dtnoraCalleId", required = false) String dtnoraCalleId,
			@RequestParam(value = "dtnombreCalle", required = false) String dtnombreCalle,
			@RequestParam(value = "dtnoraCpId", required = false) String dtnoraCpId,
			@RequestParam(value = "dtnombreCp", required = false) String dtnombreCp,
			@RequestParam(value = "dtnoraPortalId", required = false) String dtnoraPortalId,
			@RequestParam(value = "dtnombrePortal", required = false) String dtnombrePortal,
			@RequestParam(value = "dtnombrePiso", required = false) String dtnombrePiso,
			@RequestParam(value = "dtextranjero", required = false) String dtextranjero_,
			@RequestParam(value = "dtestado", required = false) String dtestado_,
			@RequestParam(value = "dtdireccion_nocapv", required = false) String dtdireccion_nocapv_,
			HttpServletRequest request) {
		try {
			// control de los campos susceptibles de llegar a "" desde el filtro

			String dtnif = ("".equals(dtnif_)) ? null : dtnif_;
			String dtnombre = ("".equals(dtnombre_)) ? null : dtnombre_;
			String dtapellido1 = ("".equals(dtapellido1_)) ? null
					: dtapellido1_;
			String dtapellido2 = ("".equals(dtapellido2_)) ? null
					: dtapellido2_;

			String dtextranjero = "";
			String dtestado = "";
			String dtnoraPaisId = "";
			String provinciaId = "";
			String municipioId = "";
			String localidadId = "";
			String dtdireccion_nocapv = "";

			if (Y41aConstantes.NORA_LOCALIZACION_TODOS.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				dtdireccion_nocapv = null;
			} else if (Y41aConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(dtextranjero_)) {
				dtextranjero = Y41aConstantes.VALOR_SI;
				dtnoraPaisId = ("".equals(dtnoraPaisId_)) ? null
						: dtnoraPaisId_;
				dtestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;
			} else if (Y41aConstantes.NORA_LOCALIZACION_ESTADO
					.equals(dtextranjero_)) {
				dtextranjero = null;
				dtnoraPaisId = null;
				dtestado = Y41aConstantes.VALOR_SI;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				dtdireccion_nocapv = ("".equals(dtdireccion_nocapv_)) ? null
						: dtdireccion_nocapv_;
			}

			Consumidor filterConsumidor = new Consumidor(dtcodigo,
					new CensoMonitor(censoMonitorMocodigo, null, null, null,
							null, null, null, null, null, null, null, null),
					new RangoEdad(rangoEdadRancod, null, null, null), dtnombre,
					dtapellido1, dtapellido2, dtnif, dtnodir, dtcolo, dtnrcopo,
					dtnrtel, dtnrfax, dtcopa, dtnrdimu, dttecoem, dtnrtel2,
					dtnrtel3, dtcoidco, dtinreco, dtcoorac, dtnoap1, dtnoap2,
					dtnrsoci, dtnran, dtcosx, dtnorep, dtnifrep, dtfemod,
					dtnolo, dtcopv, dtinrl, dtnodirr, dtcolor, dtnrcopor,
					dtcopvr, dtnrtelr, dtnrtel2r, dtnrfaxr, dtteemr, dtintipid,
					dtnoraPaisId, dtnoraPaisNombre, provinciaId,
					dtnombreProvincia, municipioId, dtnombreMunicipio,
					localidadId, dtnombreLocalidad, dtnoraCalleId,
					dtnombreCalle, dtnoraCpId, dtnombreCp, dtnoraPortalId,
					dtnombrePortal, dtnombrePiso, dtdireccion_nocapv, null,
					null, dtextranjero, dtestado);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Consumidor> consumidors = this.consumidorService
						.findAllLikeConsumidor(filterConsumidor, pagination,
								false);

				if (consumidors == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.consumidorService.findAllLikeConsumidorCount(
						filterConsumidor, false);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(consumidors);
				return data;
			} else {
				List<Consumidor> consumidors = this.consumidorService
						.findAllLikeConsumidor(filterConsumidor, pagination,
								false);
				if (consumidors == null) {
					throw new Exception("No data Found.");
				}
				return consumidors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterConsumidor
	 *            Consumidor
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "consumidor", required = false) Consumidor filterConsumidor,
			HttpServletRequest request) {
		try {
			return consumidorService
					.findAllCount(filterConsumidor != null ? filterConsumidor
							: new Consumidor());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @param response
	 *            HttpServletResponse
	 * @return Consumidor
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Consumidor edit(@RequestBody Consumidor consumidor,
			HttpServletResponse response) {
		try {
			Consumidor consumidorAux = this.consumidorService
					.update(consumidor);
			logger.info("Entity correctly inserted!");
			return consumidorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param consumidorDetalle
	 *            ConsumidorDetalle
	 * @param request
	 *            HttpServletResponse
	 * @return Consumidor
	 */
	@RequestMapping(value = "/editConsumidor", method = RequestMethod.PUT)
	public @ResponseBody
	Consumidor editConsumidor(@RequestBody ConsumidorDetalle consumidorDetalle,
			HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			RangoEdad rangoEdad = new RangoEdad();
			rangoEdad.setRancod(consumidorDetalle.getRancod());

			Consumidor consumidor;

			// estado
			if ((consumidorDetalle.getDtextranjero())
					.equalsIgnoreCase(Y41aConstantes.NO)) {
				consumidor = new Consumidor(consumidorDetalle.getDtcodigo(),
						censoMonitor, rangoEdad,
						consumidorDetalle.getDtnombre(),
						consumidorDetalle.getDtapellido1(),
						consumidorDetalle.getDtapellido2(),
						consumidorDetalle.getDtnif(),
						consumidorDetalle.getDtnodirr(),
						consumidorDetalle.getDtcolo(),
						consumidorDetalle.getDtnrcopo(),
						consumidorDetalle.getDtnrtel(),
						consumidorDetalle.getDtnrfax(),
						consumidorDetalle.getDtcopa(),
						consumidorDetalle.getDtnrdimu(),
						consumidorDetalle.getDttecoem(),
						consumidorDetalle.getDtnrtel2(),
						consumidorDetalle.getDtnrtel3(),
						consumidorDetalle.getDtcoidco(),
						consumidorDetalle.getDtinreco(),
						consumidorDetalle.getDtcoorac(),
						consumidorDetalle.getDtnoap1(),
						consumidorDetalle.getDtnoap2(),
						consumidorDetalle.getDtnrsoci(),
						consumidorDetalle.getDtnran(),
						consumidorDetalle.getDtcosx(),
						consumidorDetalle.getDtnorep(),
						consumidorDetalle.getDtnifrep(),
						Y41aUtils.parseDateToString(new Date(),
								Y41aConstantes.CASTELLANO),
						consumidorDetalle.getDtnolo(),
						consumidorDetalle.getDtcopv(),
						consumidorDetalle.getDtinrl(),
						consumidorDetalle.getDtnodirr(),
						consumidorDetalle.getDtcolor(),
						consumidorDetalle.getDtnrcopor(),
						consumidorDetalle.getDtcopvr(),
						consumidorDetalle.getDtnrtelr(),
						consumidorDetalle.getDtnrtel2r(),
						consumidorDetalle.getDtnrfaxr(),
						consumidorDetalle.getDtteemr(),
						consumidorDetalle.getDtintipid(), null, null,
						consumidorDetalle.getProvinciaId(),
						consumidorDetalle.getDtnombreProvincia(),
						consumidorDetalle.getMunicipioId(),
						consumidorDetalle.getDtnombreMunicipio(),
						consumidorDetalle.getLocalidadId(),
						consumidorDetalle.getDtnombreLocalidad(),
						consumidorDetalle.getCalleId(),
						consumidorDetalle.getCalleId_label(),
						consumidorDetalle.getCpId(),
						consumidorDetalle.getDtnombreCp(),
						consumidorDetalle.getPortalId(),
						consumidorDetalle.getDtnombrePortal(),
						consumidorDetalle.getDtnombrePiso(),
						consumidorDetalle.getDtdireccion_nocapv(), null, null,
						consumidorDetalle.getDtextranjero(), null);
			} else {
				// extranjero

				consumidor = new Consumidor(consumidorDetalle.getDtcodigo(),
						censoMonitor, rangoEdad,
						consumidorDetalle.getDtnombre(),
						consumidorDetalle.getDtapellido1(),
						consumidorDetalle.getDtapellido2(),
						consumidorDetalle.getDtnif(),
						consumidorDetalle.getDtnodirr(),
						consumidorDetalle.getDtcolo(),
						consumidorDetalle.getDtnrcopo(),
						consumidorDetalle.getDtnrtel(),
						consumidorDetalle.getDtnrfax(),
						consumidorDetalle.getDtcopa(),
						consumidorDetalle.getDtnrdimu(),
						consumidorDetalle.getDttecoem(),
						consumidorDetalle.getDtnrtel2(),
						consumidorDetalle.getDtnrtel3(),
						consumidorDetalle.getDtcoidco(),
						consumidorDetalle.getDtinreco(),
						consumidorDetalle.getDtcoorac(),
						consumidorDetalle.getDtnoap1(),
						consumidorDetalle.getDtnoap2(),
						consumidorDetalle.getDtnrsoci(),
						consumidorDetalle.getDtnran(),
						consumidorDetalle.getDtcosx(),
						consumidorDetalle.getDtnorep(),
						consumidorDetalle.getDtnifrep(),
						Y41aUtils.parseDateToString(new Date(),
								Y41aConstantes.CASTELLANO),
						consumidorDetalle.getDtnolo(),
						consumidorDetalle.getDtcopv(),
						consumidorDetalle.getDtinrl(),
						consumidorDetalle.getDtnodirr(),
						consumidorDetalle.getDtcolor(),
						consumidorDetalle.getDtnrcopor(),
						consumidorDetalle.getDtcopvr(),
						consumidorDetalle.getDtnrtelr(),
						consumidorDetalle.getDtnrtel2r(),
						consumidorDetalle.getDtnrfaxr(),
						consumidorDetalle.getDtteemr(),
						consumidorDetalle.getDtintipid(),
						consumidorDetalle.getDtnoraPaisId(),
						consumidorDetalle.getDtnoraPaisNombre(), null, null,
						null, null, null, null, null, null,
						consumidorDetalle.getCpId(),
						consumidorDetalle.getDtnombreCp(), null, null, null,
						consumidorDetalle.getDtdireccion_nocapv(), null, null,
						consumidorDetalle.getDtextranjero(), null);
			}
			Consumidor consumidorAux = this.consumidorService
					.update(consumidor);
			logger.info("Entity correctly inserted!");
			return consumidorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param consumidor
	 *            Consumidor
	 * @return Consumidor
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Consumidor add(@RequestBody Consumidor consumidor) {
		try {
			Consumidor consumidorAux = this.consumidorService.add(consumidor);
			logger.info("Entity correctly inserted!");
			return consumidorAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addConsumidor'.
	 * 
	 * @param consumidorDetalle
	 *            ConsumidorDetalle
	 * @return Consumidor
	 */

	@RequestMapping(value = "/addConsumidor", method = RequestMethod.POST)
	public @ResponseBody
	Consumidor addConsumidor(@RequestBody ConsumidorDetalle consumidorDetalle,
			HttpServletRequest request) {
		try {

			CensoMonitor censoMonitor = (CensoMonitor) request.getSession()
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			RangoEdad rangoEdad = new RangoEdad();
			rangoEdad.setRancod(consumidorDetalle.getRancod());

			Consumidor consumidor;
			// estado
			if ((consumidorDetalle.getDtextranjero())
					.equalsIgnoreCase(Y41aConstantes.NO)) {
				consumidor = new Consumidor(consumidorDetalle.getDtcodigo(),
						censoMonitor, rangoEdad,
						consumidorDetalle.getDtnombre(),
						consumidorDetalle.getDtapellido1(),
						consumidorDetalle.getDtapellido2(),
						consumidorDetalle.getDtnif(),
						consumidorDetalle.getDtnodirr(),
						consumidorDetalle.getDtcolo(),
						consumidorDetalle.getDtnrcopo(),
						consumidorDetalle.getDtnrtel(),
						consumidorDetalle.getDtnrfax(),
						consumidorDetalle.getDtcopa(),
						consumidorDetalle.getDtnrdimu(),
						consumidorDetalle.getDttecoem(),
						consumidorDetalle.getDtnrtel2(),
						consumidorDetalle.getDtnrtel3(),
						consumidorDetalle.getDtcoidco(),
						consumidorDetalle.getDtinreco(),
						consumidorDetalle.getDtcoorac(),
						consumidorDetalle.getDtnoap1(),
						consumidorDetalle.getDtnoap2(),
						consumidorDetalle.getDtnrsoci(),
						consumidorDetalle.getDtnran(),
						consumidorDetalle.getDtcosx(),
						consumidorDetalle.getDtnorep(),
						consumidorDetalle.getDtnifrep(),
						Y41aUtils.parseDateToString(new Date(),
								Y41aConstantes.CASTELLANO),
						consumidorDetalle.getDtnolo(),
						consumidorDetalle.getDtcopv(),
						consumidorDetalle.getDtinrl(),
						consumidorDetalle.getDtnodirr(),
						consumidorDetalle.getDtcolor(),
						consumidorDetalle.getDtnrcopor(),
						consumidorDetalle.getDtcopvr(),
						consumidorDetalle.getDtnrtelr(),
						consumidorDetalle.getDtnrtel2r(),
						consumidorDetalle.getDtnrfaxr(),
						consumidorDetalle.getDtteemr(),
						consumidorDetalle.getDtintipid(), null, null,
						consumidorDetalle.getProvinciaId(),
						consumidorDetalle.getDtnombreProvincia(),
						consumidorDetalle.getMunicipioId(),
						consumidorDetalle.getDtnombreMunicipio(),
						consumidorDetalle.getLocalidadId(),
						consumidorDetalle.getDtnombreLocalidad(),
						consumidorDetalle.getCalleId(),
						consumidorDetalle.getCalleId_label(),
						consumidorDetalle.getCpId(),
						consumidorDetalle.getDtnombreCp(),
						consumidorDetalle.getPortalId(),
						consumidorDetalle.getDtnombrePortal(),
						consumidorDetalle.getDtnombrePiso(),
						consumidorDetalle.getDtdireccion_nocapv(), null, null,
						consumidorDetalle.getDtextranjero(), null);
			} else {
				// extranjero

				consumidor = new Consumidor(consumidorDetalle.getDtcodigo(),
						censoMonitor, rangoEdad,
						consumidorDetalle.getDtnombre(),
						consumidorDetalle.getDtapellido1(),
						consumidorDetalle.getDtapellido2(),
						consumidorDetalle.getDtnif(),
						consumidorDetalle.getDtnodirr(),
						consumidorDetalle.getDtcolo(),
						consumidorDetalle.getDtnrcopo(),
						consumidorDetalle.getDtnrtel(),
						consumidorDetalle.getDtnrfax(),
						consumidorDetalle.getDtcopa(),
						consumidorDetalle.getDtnrdimu(),
						consumidorDetalle.getDttecoem(),
						consumidorDetalle.getDtnrtel2(),
						consumidorDetalle.getDtnrtel3(),
						consumidorDetalle.getDtcoidco(),
						consumidorDetalle.getDtinreco(),
						consumidorDetalle.getDtcoorac(),
						consumidorDetalle.getDtnoap1(),
						consumidorDetalle.getDtnoap2(),
						consumidorDetalle.getDtnrsoci(),
						consumidorDetalle.getDtnran(),
						consumidorDetalle.getDtcosx(),
						consumidorDetalle.getDtnorep(),
						consumidorDetalle.getDtnifrep(),
						Y41aUtils.parseDateToString(new Date(),
								Y41aConstantes.CASTELLANO),
						consumidorDetalle.getDtnolo(),
						consumidorDetalle.getDtcopv(),
						consumidorDetalle.getDtinrl(),
						consumidorDetalle.getDtnodirr(),
						consumidorDetalle.getDtcolor(),
						consumidorDetalle.getDtnrcopor(),
						consumidorDetalle.getDtcopvr(),
						consumidorDetalle.getDtnrtelr(),
						consumidorDetalle.getDtnrtel2r(),
						consumidorDetalle.getDtnrfaxr(),
						consumidorDetalle.getDtteemr(),
						consumidorDetalle.getDtintipid(),
						consumidorDetalle.getDtnoraPaisId(),
						consumidorDetalle.getDtnoraPaisNombre(), null, null,
						null, null, null, null, null, null,
						consumidorDetalle.getCpId(),
						consumidorDetalle.getDtnombreCp(), null, null, null,
						consumidorDetalle.getDtdireccion_nocapv(), null, null,
						consumidorDetalle.getDtextranjero(), null);
			}

			Consumidor consumidorAux = this.consumidorService
					.addConsumidor(consumidor);
			logger.info("Entity correctly inserted!");
			return consumidorAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param dtcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{dtcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String dtcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(dtcodigo);
			this.consumidorService.remove(consumidor);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + dtcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeConsumidor'.
	 * 
	 * @param dtcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/removeConsumidor/{dtcodigo}", method = RequestMethod.DELETE)
	public void removeConsumidor(@PathVariable String dtcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Consumidor consumidor = new Consumidor();
			consumidor.setDtcodigo(dtcodigo);
			this.consumidorService.removeConsumidor(consumidor);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + dtcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param consumidorIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> consumidorIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Consumidor> consumidorList = new ArrayList<Consumidor>();
		try {
			for (ArrayList<String> consumidorId : consumidorIds) {
				Iterator<String> iterator = consumidorId.iterator();
				Consumidor consumidor = new Consumidor();
				consumidor.setDtcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				consumidorList.add(consumidor);
			}
			this.consumidorService.removeMultiple(consumidorList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getReclamacionesConsumidor'.
	 * 
	 * @param dtcodigo
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */

	@RequestMapping(value = "/reclamaciones", method = RequestMethod.GET)
	public @ResponseBody
	Object getReclamacionesConsumidor(
			@RequestParam(value = "dtcodigo", required = true) String dtcodigo,
			HttpServletRequest request) {
		try {
			Consumidor filterConsumidor = new Consumidor();

			filterConsumidor.setDtcodigo(dtcodigo);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ConsumidorReclamaciones> consumidorReclamaciones = this.consumidorService
						.findAllConsumidorReclamaciones(filterConsumidor,
								pagination);

				if (consumidorReclamaciones == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountReclamacionesConsumidor(
						filterConsumidor, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(consumidorReclamaciones);
				return data;
			} else {
				List<ConsumidorReclamaciones> establecimientoReclamacionesAnyo = this.consumidorService
						.findAllConsumidorReclamaciones(filterConsumidor,
								pagination);
				if (establecimientoReclamacionesAnyo == null) {
					throw new Exception("No data Found.");
				}
				return establecimientoReclamacionesAnyo;
			}
		} catch (Exception e) {
			e.printStackTrace();
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountReclamaciones'.
	 * 
	 * @param filterConsumidor
	 *            Consumidor
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/countReclamaciones", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountReclamacionesConsumidor(
			@RequestParam(value = "consumidor", required = false) Consumidor filterConsumidor,
			HttpServletRequest request) {
		try {
			return consumidorService
					.findAllConsumidorReclamacionesCount(filterConsumidor != null ? filterConsumidor
							: new Consumidor());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getConsumidorService'.
	 * 
	 * @return ConsumidorService
	 */
	protected ConsumidorService getConsumidorService() {
		return this.consumidorService;
	}

	/**
	 * Method 'setConsumidorService'.
	 * 
	 * @param consumidorService
	 *            ConsumidorService
	 * @return
	 */
	public void setConsumidorService(ConsumidorService consumidorService) {
		this.consumidorService = consumidorService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
