package com.ejie.y41a.control;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Consulta;
import com.ejie.y41a.model.ConsultaBusqueda;
import com.ejie.y41a.model.ConsultaDetalle;
import com.ejie.y41a.model.ConsultaRespuestaConsulta;
import com.ejie.y41a.model.ConsultaRespuestaEmail;
import com.ejie.y41a.model.FormaPresentacion;
import com.ejie.y41a.model.Motivo;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.model.RangoEdad;
import com.ejie.y41a.model.Respuesta;
import com.ejie.y41a.model.TipoRespuesta;
import com.ejie.y41a.service.ConsultaService;
import com.ejie.y41a.service.Y41aExcelGeneratorService;
import com.ejie.y41a.utils.Y41aStringUtils;
import com.ejie.y41a.utils.Y41aUtils;
import com.ejie.y41a.utils.documentos.Y41aDocumento;
import com.ejie.y41a.utils.documentos.Y41aGenerarDocumento;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * ConsultaController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/consulta")
@SessionAttributes("consultaDetalle")
public class ConsultaController {

	private static final Logger logger = LoggerFactory
			.getLogger(ConsultaController.class);

	@Autowired
	private ConsultaService consultaService;

	@Autowired
	private Y41aExcelGeneratorService y41aExcelGeneratorService;
	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("consulta", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintBusquedaResultado", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusquedaResultado(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("busquedaResultado", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintBusqueda", method = RequestMethod.GET)
	public ModelAndView getCreateFormBusqueda(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("busqueda", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintResultado", method = RequestMethod.GET)
	public ModelAndView getCreateFormResultado(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("resultado", "model", model);
	}

	/**
	 * Method 'getCreateFormTabsDetalleDocs'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintTabsDetalleDocs", method = RequestMethod.GET)
	public ModelAndView getCreateFormTabsDetalleDocs(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		ConsultaDetalle consultaDetalle = new ConsultaDetalle();
		model.addAttribute("consultaDetalle", consultaDetalle);
		return new ModelAndView("tabsDetalleDocs", "model", model);
	}

	/**
	 * Method 'getCreateFormAltaTabsDetalleDocs'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param model
	 *            Model
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "maintAltaTabsDetalleDocs/{cocodigo}", method = RequestMethod.GET)
	public ModelAndView getCreateFormAltaTabsDetalleDocs(
			@PathVariable String cocodigo, Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));

		ConsultaDetalle consultaDetalle = new ConsultaDetalle();
		consultaDetalle.setCocodigo(cocodigo);
		model.addAttribute("consultaDetalle", consultaDetalle);

		return new ModelAndView("tabsAltaDetalleDocs", "model", model);

	}

	/**
	 * Method 'getCreateFormDetalleConsulta'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintDetalleConsulta", method = RequestMethod.GET)
	public ModelAndView getCreateFormDetalleConsulta(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("detalleConsulta", "model", model);
	}

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintAltaConsulta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		model.addAttribute("statics_path",
				this.appConfiguration.get("statics.path"));
		return new ModelAndView("altaConsulta", "model", model);
	}

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintDocumentos", method = RequestMethod.GET)
	public ModelAndView getCreateFormDocumentos(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("documentosConsulta", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cocodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{cocodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Consulta getById(@PathVariable String cocodigo) {
		try {
			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);
			consulta = this.consultaService.find(consulta);
			if (consulta == null) {
				throw new Exception(cocodigo.toString());
			}
			return consulta;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cocodigo.toString());
		}
	}

	/**
	 * Method 'getByIdConsulta'.
	 * 
	 * @param cocodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/edicion/{cocodigo}", method = RequestMethod.GET)
	public @ResponseBody
	ConsultaDetalle getByIdConsulta(@PathVariable String cocodigo) {
		try {
			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);
			ConsultaDetalle consultaDetalle = this.consultaService
					.findConsulta(consulta);
			if (consultaDetalle == null) {
				throw new Exception(cocodigo.toString());
			}

			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			String cofechaconshora = "";
			if (consultaDetalle.getCofechaconsumidor() != null) {
				if (Y41aConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					cofechaconshora = Y41aUtils.formatearDateToString(
							consultaDetalle.getCofechaconsumidor(),
							Y41aConstantes.FORMATO_FECHAHORA_ES);
				} else if (Y41aConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					cofechaconshora = Y41aUtils.formatearDateToString(
							consultaDetalle.getCofechaconsumidor(),
							Y41aConstantes.FORMATO_FECHAHORA_EU);
				}
				consultaDetalle.setCofechaconshora(cofechaconshora);

				String strTime = cofechaconshora
						.substring(Y41aConstantes.NUM_CARACTERES_FECHA);
				consultaDetalle.setLlegadaHoras(strTime.split(":")[0]);
				consultaDetalle.setLlegadaMinutos(strTime.split(":")[1]);
			}

			if (Y41aUtils.isFilled(consultaDetalle.getCohora())) {
				String strTime = consultaDetalle.getCohora();
				consultaDetalle.setAtencionHoras(strTime.split(":")[0]);
				consultaDetalle.setAtencionMinutos(strTime.split(":")[1]);
			}

			return consultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cocodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param motivoTircodigo
	 *            String
	 * @param productoPscodigo
	 *            String
	 * @param rangoEdadRancod
	 *            String
	 * @param formaPresentacionTfpcodigo
	 *            String
	 * @param organismoCodOrg
	 *            String
	 * @param censoMonitorMocodigo
	 *            String
	 * @param cofecha
	 *            Date
	 * @param cocosx
	 *            String
	 * @param conran
	 *            String
	 * @param cocose
	 *            String
	 * @param cotexto
	 *            String
	 * @param conrreg
	 *            Integer
	 * @param conoco
	 *            String
	 * @param conodirco
	 *            String
	 * @param conrcpco
	 *            String
	 * @param cocoloco
	 *            String
	 * @param conoloco
	 *            String
	 * @param conomuco
	 *            String
	 * @param cocopvco
	 *            String
	 * @param cocopaco
	 *            String
	 * @param conrtelco
	 *            String
	 * @param conrfaxco
	 *            String
	 * @param cocoemco
	 *            String
	 * @param coferes
	 *            Date
	 * @param coinreenv
	 *            String
	 * @param coteresp
	 *            String
	 * @param cocotfpr
	 *            String
	 * @param coinl37
	 *            String
	 * @param conranrg
	 *            Long
	 * @param cocopro
	 *            String
	 * @param cohdcodigo
	 *            String
	 * @param cohora
	 *            String
	 * @param cofechaconsumidor
	 *            Date
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param provinciaId
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param municipioId
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param localidadId
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param coinl21
	 *            String
	 * @param cosituacion
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param coextranjero
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "coinl21", required = false) String coinl21,
			@RequestParam(value = "cosituacion", required = false) String cosituacion,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "coextranjero", required = false) String coextranjero,
			HttpServletRequest request) {
		try {
			Consulta filterConsulta = new Consulta(cocodigo, new Motivo(
					motivoTircodigo, null, null, null), new Producto(
					productoPscodigo, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null), new RangoEdad(rangoEdadRancod, null,
					null, null), new FormaPresentacion(
					formaPresentacionTfpcodigo, null, null, null, null, null,
					null), new Organismo(organismoCodOrg, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null), new CensoMonitor(censoMonitorMocodigo, null, null,
					null, null, null, null, null, null, null, null, null),
					cofecha, cocosx, conran, cocose, cotexto, conrreg, conoco,
					conodirco, conrcpco, cocoloco, conoloco, conomuco,
					cocopvco, cocopaco, conrtelco, conrfaxco, cocoemco,
					coferes, coinreenv, coteresp, cocotfpr, coinl37, conranrg,
					cocopro, cohdcodigo, cohora, cofechaconsumidor, noraPaisId,
					nombrePais, provinciaId, nombreProvincia, municipioId,
					nombreMunicipio, localidadId, nombreLocalidad, noraCalleId,
					nombreCalle, noraCpId, nombreCp, noraPortalId,
					nombrePortal, coinl21, cosituacion, nombrePiso,
					coextranjero, null, null, null, null);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Consulta> consultas = this.consultaService.findAll(
						filterConsulta, pagination);

				if (consultas == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterConsulta, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(consultas);
				return data;
			} else {
				List<Consulta> consultas = this.consultaService.findAll(
						filterConsulta, pagination);
				if (consultas == null) {
					throw new Exception("No data Found.");
				}
				return consultas;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterConsulta
	 *            Consulta
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "consulta", required = false) Consulta filterConsulta,
			HttpServletRequest request) {
		try {
			return consultaService
					.findAllCount(filterConsulta != null ? filterConsulta
							: new Consulta());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getFichaByIdConsulta'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * 
	 */
	@RequestMapping(value = "/ficha/{cocodigo}", method = RequestMethod.GET)
	public @ResponseBody
	void getFichaByIdConsulta(@PathVariable String cocodigo,
			HttpServletResponse response) {
		try {

			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);
			ConsultaDetalle consultaDetalle = this.consultaService
					.findConsulta(consulta);
			if (consultaDetalle == null) {
				throw new Exception(cocodigo.toString());
			}

			if (consultaDetalle.getCalleId_label() == null
					|| consultaDetalle.getCalleId_label().equals("")) {
				if (consultaDetalle.getDireccion_nocapv() == null
						|| consultaDetalle.getDireccion_nocapv().equals("")) {
					consultaDetalle.setCalleId_label(consultaDetalle
							.getDireccionAntiguaCompleta());
				} else {
					consultaDetalle.setCalleId_label(consultaDetalle
							.getDireccion_nocapv());
				}
			} else {
				StringBuffer domicilio = new StringBuffer();
				domicilio.append(consultaDetalle.getCalleId_label());

				if (consultaDetalle.getNombrePortal() != null) {
					domicilio.append(", ").append(
							consultaDetalle.getNombrePortal());
				}
				if (consultaDetalle.getNombrePiso() != null) {
					domicilio.append(" ").append(
							consultaDetalle.getNombrePiso());
				}
				consultaDetalle.setCalleId_label(domicilio.toString());
			}

			// tratamiento de los datos temporales (horas)
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			String cofechaconshora = "";
			if (consultaDetalle.getCofechaconsumidor() != null) {
				if (Y41aConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					cofechaconshora = Y41aUtils.formatearDateToString(
							consultaDetalle.getCofechaconsumidor(),
							Y41aConstantes.FORMATO_FECHAHORA_ES);
				} else if (Y41aConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					cofechaconshora = Y41aUtils.formatearDateToString(
							consultaDetalle.getCofechaconsumidor(),
							Y41aConstantes.FORMATO_FECHAHORA_EU);
				}
				consultaDetalle.setCofechaconshora(cofechaconshora);

				String strTime = cofechaconshora
						.substring(Y41aConstantes.NUM_CARACTERES_FECHA);
				consultaDetalle.setLlegadaHoras(strTime.split(":")[0]);
				consultaDetalle.setLlegadaMinutos(strTime.split(":")[1]);
			}

			if (Y41aUtils.isFilled(consultaDetalle.getCohora())) {
				String strTime = consultaDetalle.getCohora();
				consultaDetalle.setAtencionHoras(strTime.split(":")[0]);
				consultaDetalle.setAtencionMinutos(strTime.split(":")[1]);
			}

			if (Y41aUtils.isFilled(consultaDetalle.getP9teres())) {
				// Tratamiento tiny
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("</p>", "&lineSeparator;"));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("<br/>", "&lineSeparator;"));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("</li>", "&lineSeparator;"));

				// negrita
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("<strong>", "&negritaini;"));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("</strong>", "&negritafin;"));

				// italic
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("<em>", "&italicini;"));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("</em>", "&italicfin;"));

				// subrayado
				consultaDetalle.setP9teres(Y41aUtils
						.sustituirTagsSpanUnderline(consultaDetalle
								.getP9teres()));

				// lista
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("<ol>", ""));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("</ol>", ""));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("<ul>", ""));
				consultaDetalle.setP9teres(consultaDetalle.getP9teres()
						.replaceAll("</ul>", ""));

				consultaDetalle.setP9teres(Y41aUtils
						.sustituirTagsLi(consultaDetalle.getP9teres()));

				// consultaDetalle.setP9teres(consultaDetalle.getP9teres().replaceAll("</span>",
				// "&separator;"));

				String p9teres = Y41aStringUtils
						.unescapeHTML(Y41aUtils.eliminarTags(consultaDetalle
								.getP9teres()), 0);

				consultaDetalle.setP9teres(new String(p9teres
						.getBytes("ISO-8859-15"), "UTF-8"));

			}

			String rutaRTF = (String) appConfiguration
					.get("y41aVistaWar.ruta.plantillas.word");
			String rutaXML = (String) appConfiguration
					.get("y41aVistaWar.rutaxml.plantillas.word");
			String nombreRTF = Y41aConstantes.NOMBRE_PLANTILLA_CONSULTAS_FICHA_RTF;
			String nombreXML = Y41aConstantes.NOMBRE_PLANTILLA_CONSULTAS_FICHA_XML;
			String rutaCompletaRTF = rutaRTF + nombreRTF;
			String rutaCompletaXML = rutaXML + nombreXML;

			String plantilla = new String(
					Y41aDocumento.leerArchivoOrigen(rutaCompletaRTF));

			String strFileDataDecode = Y41aGenerarDocumento
					.generarDocumentoWord(rutaCompletaXML, consultaDetalle,
							plantilla);

			byte[] bytesFichero = strFileDataDecode.getBytes();

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			String nombreFichero = consultaDetalle.getCodOrg() + "-"
					+ consultaDetalle.getConrreg() + "-"
					+ consultaDetalle.getConranrg() + ".doc";

			// FIXME Esto se ha quitado porque sino en Internet Explorer produce
			// un error al mostrarse
			// response.setCharacterEncoding("ISO-8859-1");
			// response.setHeader("Cache-Control", "no-cache");

			response.setHeader("Content-Disposition", "attachment; filename="
					+ nombreFichero + "");
			response.setContentType("application/msword");
			response.setContentLength(bytesFichero.length);
			response.getOutputStream().write(bytesFichero);

			// Vaciamos el stream
			response.getOutputStream().flush();

		} catch (Exception e) {
			throw new ResourceNotFoundException(cocodigo.toString());
		} catch (Throwable t) {
			throw new ResourceNotFoundException(cocodigo.toString());
		}
	}

	/**
	 * Method 'getAllConsulta'.
	 * 
	 * @param tircodigo_
	 *            String
	 * 
	 * @param cocodigo
	 *            String
	 * @param motivoTircodigo_
	 *            String
	 * @param productoPscodigo_
	 *            String
	 * @param rangoEdadRancod_
	 *            String
	 * @param formaPresentacionTfpcodigo_
	 *            String
	 * @param organismoCodOrg
	 *            String
	 * @param censoMonitorMocodigo_
	 *            String
	 * @param cofecha
	 *            Date
	 * @param cocosx_
	 *            String
	 * @param conran
	 *            String
	 * @param cocose
	 *            String
	 * @param cotexto_
	 *            String
	 * @param conrreg
	 *            Integer
	 * @param conoco_
	 *            String
	 * @param conodirco
	 *            String
	 * @param conrcpco
	 *            String
	 * @param cocoloco
	 *            String
	 * @param conoloco
	 *            String
	 * @param conomuco
	 *            String
	 * @param cocopvco
	 *            String
	 * @param cocopaco
	 *            String
	 * @param conrtelco
	 *            String
	 * @param conrfaxco
	 *            String
	 * @param cocoemco
	 *            String
	 * @param coferes
	 *            Date
	 * @param coinreenv
	 *            String
	 * @param coteresp
	 *            String
	 * @param cocotfpr
	 *            String
	 * @param coinl37_
	 *            String
	 * @param conranrg
	 *            Long
	 * @param cocopro
	 *            String
	 * @param cohdcodigo
	 *            String
	 * @param cohora
	 *            String
	 * @param cofechaconsumidor
	 *            Date
	 * @param noraPaisId
	 *            String
	 * @param nombrePais
	 *            String
	 * @param provinciaId_
	 *            String
	 * @param nombreProvincia
	 *            String
	 * @param municipioId_
	 *            String
	 * @param nombreMunicipio
	 *            String
	 * @param localidadId_
	 *            String
	 * @param nombreLocalidad
	 *            String
	 * @param noraCalleId
	 *            String
	 * @param nombreCalle
	 *            String
	 * @param noraCpId
	 *            String
	 * @param nombreCp
	 *            String
	 * @param noraPortalId
	 *            String
	 * @param nombrePortal
	 *            String
	 * @param direccion_nocapv_
	 *            String
	 * @param coextranjero_
	 *            String
	 * @param coestado_
	 *            String
	 * @param coinl21_
	 *            String
	 * @param cosituacion_
	 *            String
	 * @param nombrePiso
	 *            String
	 * @param cofechaDesde_
	 *            String
	 * @param cofechaHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/busqueda", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllConsulta(
			@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod_,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo_,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo_,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx_,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto_,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco_,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37_,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId_,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "direccion_nocapv", required = false) String direccion_nocapv_,
			@RequestParam(value = "coextranjero", required = false) String coextranjero_,
			@RequestParam(value = "coestado", required = false) String coestado_,
			@RequestParam(value = "coinl21", required = false) String coinl21_,
			@RequestParam(value = "cosituacion", required = false) String cosituacion_,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "cofechaDesde", required = false) String cofechaDesde_,
			@RequestParam(value = "cofechaHasta", required = false) String cofechaHasta_,
			HttpServletRequest request) {
		try {

			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date cofechaDesde = Y41aUtils.parseDate(cofechaDesde_, locale);
			Date cofechaHasta = Y41aUtils.parseDate(cofechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String cosituacion = ("".equals(cosituacion_)) ? null
					: cosituacion_;
			String censoMonitorMocodigo = ("".equals(censoMonitorMocodigo_)) ? null
					: censoMonitorMocodigo_;
			String formaPresentacionTfpcodigo = (""
					.equals(formaPresentacionTfpcodigo_)) ? null
					: formaPresentacionTfpcodigo_;
			String cotexto = ("".equals(cotexto_)) ? null : cotexto_;
			String conoco = ("".equals(conoco_)) ? null : conoco_;
			String coextranjero = null;
			String coestado = null;
			String noraPaisId = null;
			String provinciaId = null;
			String municipioId = null;
			String localidadId = null;
			String direccion_nocapv = null;

			if (Y41aConstantes.NORA_LOCALIZACION_TODOS.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = null;
			} else if (Y41aConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(coextranjero_)) {
				coextranjero = Y41aConstantes.VALOR_SI;
				noraPaisId = ("".equals(noraPaisId_)) ? null : noraPaisId_;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null
						: direccion_nocapv_;

			} else if (Y41aConstantes.NORA_LOCALIZACION_ESTADO
					.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = Y41aConstantes.VALOR_SI;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null
						: direccion_nocapv_;
			}
			String rangoEdadRancod = ("".equals(rangoEdadRancod_)) ? null
					: rangoEdadRancod_;
			String cocosx = ("".equals(cocosx_)) ? null : cocosx_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null
					: productoPscodigo_;

			String motivoTircodigo = "";
			if (tircodigo_ != "" && tircodigo_ != null) {
				motivoTircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			} else {
				motivoTircodigo = ("".equals(motivoTircodigo_)) ? null
						: motivoTircodigo_;

			}

			// control checks
			String coinl21 = ("on".equals(coinl21_)) ? Y41aConstantes.VALOR_SI
					: null;
			String coinl37 = ("on".equals(coinl37_)) ? Y41aConstantes.VALOR_SI
					: null;

			// Filtro
			Consulta filterConsulta = new Consulta(cocodigo, new Motivo(
					motivoTircodigo, null, null, null), new Producto(
					productoPscodigo, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null), new RangoEdad(rangoEdadRancod, null,
					null, null), new FormaPresentacion(
					formaPresentacionTfpcodigo, null, null, null, null, null,
					null), new Organismo(organismoCodOrg, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null), new CensoMonitor(censoMonitorMocodigo, null, null,
					null, null, null, null, null, null, null, null, null),
					cofecha, cocosx, conran, cocose, cotexto, conrreg, conoco,
					conodirco, conrcpco, cocoloco, conoloco, conomuco,
					cocopvco, cocopaco, conrtelco, conrfaxco, cocoemco,
					coferes, coinreenv, coteresp, cocotfpr, coinl37, conranrg,
					cocopro, cohdcodigo, cohora, cofechaconsumidor, noraPaisId,
					nombrePais, provinciaId, nombreProvincia, municipioId,
					nombreMunicipio, localidadId, nombreLocalidad, noraCalleId,
					nombreCalle, noraCpId, nombreCp, noraPortalId,
					nombrePortal, coinl21, cosituacion, nombrePiso,
					direccion_nocapv, coextranjero, coestado, null, null);

			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ConsultaBusqueda> consultasBusqueda = this.consultaService
						.findAllLikeConsulta(filterConsulta, pagination, false,
								cofechaDesde, cofechaHasta);

				if (consultasBusqueda == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.consultaService.findAllLikeConsultaCount(
						filterConsulta, false, cofechaDesde, cofechaHasta);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(consultasBusqueda);
				return data;
			} else {
				pagination = new Pagination();
				pagination.setSort("COFECHA");
				pagination.setAscDsc(Y41aConstantes.ORDENACION_DESC);

				List<ConsultaBusqueda> consultasBusqueda = this.consultaService
						.findAllLikeConsulta(filterConsulta, pagination, false,
								cofechaDesde, cofechaHasta);
				if (consultasBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return consultasBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param consulta
	 *            Consulta
	 * @param response
	 *            HttpServletResponse
	 * @return Consulta
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Consulta edit(@RequestBody Consulta consulta, HttpServletResponse response) {
		try {
			Consulta consultaAux = this.consultaService.update(consulta);
			logger.info("Entity correctly inserted!");
			return consultaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'respuesta'.
	 * 
	 * @param consultaRespuestaConsulta
	 *            ConsultaRespuestaConsulta
	 * @param response
	 *            HttpServletResponse
	 * @return Consulta
	 */
	@RequestMapping(value = "/respuesta", method = RequestMethod.PUT)
	public @ResponseBody
	Respuesta editRespuestaConsulta(
			@RequestBody ConsultaRespuestaConsulta consultaRespuestaConsulta,
			HttpServletResponse response) {
		try {
			// mapeo del objeto que llega del formulario (consultaDetalle) todo
			// plano, al objeto real (consulta)

			// CONSULTA_________________________________________________________
			Consulta consulta = new Consulta();

			// id consulta
			consulta.setCocodigo(consultaRespuestaConsulta.getCocodigo());
			// nº consulta
			Organismo organismo = new Organismo();
			organismo.setCodOrg(consultaRespuestaConsulta.getCodOrg());
			consulta.setOrganismo(organismo);
			consulta.setConranrg(consultaRespuestaConsulta.getConranrg());
			consulta.setConrreg(consultaRespuestaConsulta.getConrreg());
			// cofecha Date
			consulta.setCofecha(consultaRespuestaConsulta.getCofecha());
			// texto consulta
			consulta.setCotexto(consultaRespuestaConsulta.getCotexto());

			// RESPUESTA________________________________________________
			Respuesta respuesta = new Respuesta();

			TipoRespuesta tipoRespuesta = new TipoRespuesta();
			tipoRespuesta.setP8codigo(consultaRespuestaConsulta.getP8codigo());
			respuesta.setTipoRespuesta(tipoRespuesta);
			respuesta.setP9feresp(consultaRespuestaConsulta.getP9feresp());
			respuesta.setP9teres(consultaRespuestaConsulta.getP9teres());
			respuesta.setP9feanot(new Date());
			respuesta.setP9nufiladj(new BigDecimal(0));
			respuesta.setP9inemlusu(Y41aConstantes.VALOR_NO);
			respuesta.setConsulta(consulta);

			Respuesta respAux = this.consultaService
					.responderConsulta(respuesta);
			logger.info("Entity correctly inserted!");
			return respAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'respuestaEmail'.
	 * 
	 * @param consultaRespuestaEmail
	 *            ConsultaRespuestaEmail
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * 
	 * @return Consulta
	 */
	@RequestMapping(value = "/respuestaEmail", method = RequestMethod.PUT)
	public @ResponseBody
	Respuesta editRespuestaEmail(
			@RequestBody ConsultaRespuestaEmail consultaRespuestaEmail,
			HttpServletResponse response, HttpServletRequest request) {
		try {
			// mapeo del objeto que llega del formulario (consultaDetalle) todo
			// plano, al objeto real (consulta)

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			// CONSULTA_________________________________________________
			Consulta consulta = new Consulta();

			consulta.setCocodigo(consultaRespuestaEmail.getCocodigo());
			consulta.setCocoemco(consultaRespuestaEmail.getCocoemco());
			consulta.setCensoMonitor(censoMonitor);
			Organismo organismo = new Organismo();
			organismo.setCodOrg(consultaRespuestaEmail.getCodOrg());
			consulta.setOrganismo(organismo);
			consulta.setConranrg(consultaRespuestaEmail.getConranrg());
			consulta.setConrreg(consultaRespuestaEmail.getConrreg());
			consulta.setCofecha(consultaRespuestaEmail.getCofecha());
			consulta.setCotexto(consultaRespuestaEmail.getCotexto());

			// RESPUESTA________________________________________________
			Respuesta respuesta = new Respuesta();
			TipoRespuesta tipoRespuesta = new TipoRespuesta();
			tipoRespuesta
					.setP8codigo(Y41aConstantes.TIPO_RESPUESTA_CONSULTA_EMAIL);
			respuesta.setTipoRespuesta(tipoRespuesta);
			respuesta.setP9feresp(consultaRespuestaEmail.getP9feresp());
			respuesta.setP9teres(consultaRespuestaEmail.getP9teres());
			respuesta.setP9feanot(new Date());
			respuesta.setP9nufiladj(new BigDecimal(0));
			respuesta.setP9inemlusu(Y41aConstantes.VALOR_SI);
			respuesta.setConsulta(consulta);

			Respuesta respAux = this.consultaService.emailConsulta(consulta,
					respuesta, censoMonitor);
			logger.info("Entity correctly inserted!");
			return respAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'editConsulta'.
	 * 
	 * @param consultaDetalle
	 *            ConsultaDetalle
	 * @param response
	 *            HttpServletResponse
	 * @return Consulta
	 */
	@RequestMapping(value = "/modificacion", method = RequestMethod.PUT)
	public @ResponseBody
	Consulta editConsulta(@RequestBody ConsultaDetalle consultaDetalle,
			HttpServletResponse response) {
		try {
			// mapeo del objeto que llega del formulario (consultaDetalle) todo
			// plano, al objeto real (consulta)

			// CONSULTA_________________________________________________________
			Consulta consulta = new Consulta();

			// estado
			if ((consultaDetalle.getCoextranjero())
					.equalsIgnoreCase(Y41aConstantes.NO)) {

				consulta.setNoraPaisId(null);
				consulta.setNombrePais(null);
				consulta.setNoraProvinciaId(consultaDetalle.getProvinciaId());
				consulta.setNombreProvincia(consultaDetalle
						.getNombreProvincia());
				consulta.setNoraMunicipioId(consultaDetalle.getMunicipioId());
				consulta.setNombreMunicipio(consultaDetalle
						.getNombreMunicipio());
				consulta.setNoraLocalidadId(consultaDetalle.getLocalidadId());
				consulta.setNombreLocalidad(consultaDetalle
						.getNombreLocalidad());
				consulta.setNoraCalleId(consultaDetalle.getCalleId());
				consulta.setNombreCalle(consultaDetalle.getCalleId_label());
				consulta.setNoraCpId(consultaDetalle.getCpId());
				consulta.setNombreCp(consultaDetalle.getNombreCp());
				consulta.setNoraPortalId(consultaDetalle.getPortalId());
				consulta.setNombrePortal(consultaDetalle.getNombrePortal());
				consulta.setNombrePiso(consultaDetalle.getNombrePiso());
			} else {
				consulta.setNoraPaisId(consultaDetalle.getNoraPaisId());
				consulta.setNombrePais(consultaDetalle.getNombrePais());
				consulta.setNoraProvinciaId(null);
				consulta.setNombreProvincia(null);
				consulta.setNoraMunicipioId(null);
				consulta.setNombreMunicipio(null);
				consulta.setNoraLocalidadId(null);
				consulta.setNombreLocalidad(null);
				consulta.setNoraCalleId(null);
				consulta.setNombreCalle(null);
				consulta.setNoraPortalId(null);
				consulta.setNombrePortal(null);
				consulta.setNombrePiso(null);
			}

			// id consulta
			consulta.setCocodigo(consultaDetalle.getCocodigo());
			// nº consulta
			Organismo organismo = new Organismo();
			organismo.setCodOrg(consultaDetalle.getCodOrg());
			consulta.setOrganismo(organismo);
			consulta.setConranrg(consultaDetalle.getConranrg());
			consulta.setConrreg(consultaDetalle.getConrreg());
			// fecha

			// cofecha Date
			consulta.setCofecha(consultaDetalle.getCofecha());
			// cofecha consumidor = cofecha + hora llegada(cofechacons)
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			String strCofechaconshora = consultaDetalle.getCofechaconshora();

			if (Y41aUtils.isFilled(strCofechaconshora)) {
				String strDateCofecha = Y41aUtils.parseDateToString(
						consultaDetalle.getCofecha(), idioma);
				String strFechaconhora = strDateCofecha + " "
						+ strCofechaconshora;

				Date dateFechaconhora = null;

				if (Y41aConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					dateFechaconhora = Y41aUtils.formatearStringToDateFormato(
							strFechaconhora,
							Y41aConstantes.FORMATO_FECHAHORA_ES);
				} else if (Y41aConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					dateFechaconhora = Y41aUtils.formatearStringToDateFormato(
							strFechaconhora,
							Y41aConstantes.FORMATO_FECHAHORA_EU);
				}
				consulta.setCofechaconsumidor(dateFechaconhora);
			}

			consulta.setCohora(consultaDetalle.getCohora());

			// monitor
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(consultaDetalle.getMocodigo());
			consulta.setCensoMonitor(censoMonitor);
			// forma presentacion
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(consultaDetalle.getTfpcodigo());
			consulta.setFormaPresentacion(formaPresentacion);
			// texto consulta
			consulta.setCotexto(consultaDetalle.getCotexto());
			// producto/servicio
			Producto producto = new Producto();
			producto.setPscodigo(consultaDetalle.getPscodigo());
			consulta.setProducto(producto);
			// motivo
			Motivo motivo = new Motivo();
			motivo.setTircodigo(consultaDetalle.getTircodigo());
			consulta.setMotivo(motivo);

			// persona consumidora
			// nombre
			consulta.setConoco(consultaDetalle.getConoco());
			// edad
			RangoEdad rangoEdad = new RangoEdad();
			rangoEdad.setRancod(consultaDetalle.getRancod());
			consulta.setRangoEdad(rangoEdad);
			// sexo
			consulta.setCocosx(consultaDetalle.getCocosx());
			// email
			consulta.setCocoemco(consultaDetalle.getCocoemco());
			// tlfno1
			consulta.setConrtelco(consultaDetalle.getConrtelco());
			// fax - tlfno2
			consulta.setConrfaxco(consultaDetalle.getConrfaxco());

			// cp
			consulta.setNoraCpId(consultaDetalle.getCpId());
			consulta.setNombreCp(consultaDetalle.getNombreCp());
			// piso
			consulta.setNombrePiso(consultaDetalle.getNombrePiso());

			// "direccion_nocapv"
			consulta.setDireccion_nocapv(consultaDetalle.getDireccion_nocapv());

			// "coextranjero"
			consulta.setCoextranjero(consultaDetalle.getCoextranjero());

			// coinl37 y coinl21
			consulta.setCoinl37(consultaDetalle.getCoinl37());
			consulta.setCoinl21(consultaDetalle.getCoinl21());

			// RESPUESTA________________________________________________
			Respuesta respuesta = new Respuesta();

			TipoRespuesta tipoRespuesta = new TipoRespuesta();
			tipoRespuesta.setP8codigo(consultaDetalle.getP8codigo());
			respuesta.setTipoRespuesta(tipoRespuesta);
			respuesta.setP9feresp(consultaDetalle.getP9feresp());
			respuesta.setP9teres(consultaDetalle.getP9teres());
			respuesta.setP9feanot(new Date());
			respuesta.setP9nufiladj(new BigDecimal(0));
			respuesta.setP9inemlusu(Y41aConstantes.VALOR_NO);

			Consulta consultaAux = this.consultaService.updateConsulta(
					consulta, respuesta);
			logger.info("Entity correctly inserted!");
			return consultaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param consulta
	 *            Consulta
	 * @return Consulta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Consulta add(@RequestBody Consulta consulta) {
		try {
			Consulta consultaAux = this.consultaService.add(consulta);
			logger.info("Entity correctly inserted!");
			return consultaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'addConsulta'.
	 * 
	 * @param consultaDetalle
	 *            ConsultaDetalle
	 * 
	 * @return Consulta
	 */
	@RequestMapping(value = "/alta", method = RequestMethod.POST)
	public @ResponseBody
	Consulta addConsulta(@RequestBody ConsultaDetalle consultaDetalle) {
		try {
			// mapeo del objeto que llega del formulario (consultaDetalle) todo
			// plano, al objeto real (consulta)

			// CONSULTA_________________________________________________________
			Consulta consulta = new Consulta();

			// estado
			if ((consultaDetalle.getCoextranjero())
					.equalsIgnoreCase(Y41aConstantes.NO)) {

				consulta.setNoraPaisId(null);
				consulta.setNombrePais(null);
				consulta.setNoraProvinciaId(consultaDetalle.getProvinciaId());
				consulta.setNombreProvincia(consultaDetalle
						.getNombreProvincia());
				consulta.setNoraMunicipioId(consultaDetalle.getMunicipioId());
				consulta.setNombreMunicipio(consultaDetalle
						.getNombreMunicipio());
				consulta.setNoraLocalidadId(consultaDetalle.getLocalidadId());
				consulta.setNombreLocalidad(consultaDetalle
						.getNombreLocalidad());
				consulta.setNoraCalleId(consultaDetalle.getCalleId());
				consulta.setNombreCalle(consultaDetalle.getCalleId_label());
				consulta.setNoraCpId(consultaDetalle.getCpId());
				consulta.setNombreCp(consultaDetalle.getNombreCp());
				consulta.setNoraPortalId(consultaDetalle.getPortalId());
				consulta.setNombrePortal(consultaDetalle.getNombrePortal());
				consulta.setNombrePiso(consultaDetalle.getNombrePiso());
			} else {
				consulta.setNoraPaisId(consultaDetalle.getNoraPaisId());
				consulta.setNombrePais(consultaDetalle.getNombrePais());
				consulta.setNoraProvinciaId(null);
				consulta.setNombreProvincia(null);
				consulta.setNoraMunicipioId(null);
				consulta.setNombreMunicipio(null);
				consulta.setNoraLocalidadId(null);
				consulta.setNombreLocalidad(null);
				consulta.setNoraCalleId(null);
				consulta.setNombreCalle(null);
				consulta.setNoraPortalId(null);
				consulta.setNombrePortal(null);
				consulta.setNombrePiso(null);
			}

			// nº consulta
			Organismo organismo = new Organismo();
			organismo.setCodOrg(consultaDetalle.getCodOrg());
			consulta.setOrganismo(organismo);
			consulta.setConranrg(consultaDetalle.getConranrg());
			consulta.setConrreg(consultaDetalle.getConrreg());
			// fecha

			// cofecha Date
			consulta.setCofecha(consultaDetalle.getCofecha());

			// cofecha consumidor = cofecha + hora llegada(cofechacons)
			Locale locale = LocaleContextHolder.getLocale();
			String idioma = locale.getLanguage();

			String strCofechaconshora = consultaDetalle.getCofechaconshora();

			if (Y41aUtils.isFilled(strCofechaconshora)) {
				String strDateCofecha = Y41aUtils.parseDateToString(
						consultaDetalle.getCofecha(), idioma);
				String strFechaconhora = strDateCofecha + " "
						+ strCofechaconshora;

				Date dateFechaconhora = null;

				if (Y41aConstantes.CASTELLANO.equalsIgnoreCase(idioma)) {
					dateFechaconhora = Y41aUtils.formatearStringToDateFormato(
							strFechaconhora,
							Y41aConstantes.FORMATO_FECHAHORA_ES);
				} else if (Y41aConstantes.EUSKERA.equalsIgnoreCase(idioma)) {
					dateFechaconhora = Y41aUtils.formatearStringToDateFormato(
							strFechaconhora,
							Y41aConstantes.FORMATO_FECHAHORA_EU);
				}
				consulta.setCofechaconsumidor(dateFechaconhora);
			}

			consulta.setCohora(consultaDetalle.getCohora());

			// monitor
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(consultaDetalle.getMocodigo());
			consulta.setCensoMonitor(censoMonitor);
			// forma presentacion
			FormaPresentacion formaPresentacion = new FormaPresentacion();
			formaPresentacion.setTfpcodigo(consultaDetalle.getTfpcodigo());
			consulta.setFormaPresentacion(formaPresentacion);
			// texto consulta
			consulta.setCotexto(consultaDetalle.getCotexto());
			// producto/servicio
			Producto producto = new Producto();
			producto.setPscodigo(consultaDetalle.getPscodigo());
			consulta.setProducto(producto);
			// motivo
			Motivo motivo = new Motivo();
			motivo.setTircodigo(consultaDetalle.getTircodigo());
			consulta.setMotivo(motivo);

			// persona consumidora
			// nombre
			consulta.setConoco(consultaDetalle.getConoco());
			// edad
			RangoEdad rangoEdad = new RangoEdad();
			rangoEdad.setRancod(consultaDetalle.getRancod());
			consulta.setRangoEdad(rangoEdad);
			// sexo
			consulta.setCocosx(consultaDetalle.getCocosx());
			// email
			consulta.setCocoemco(consultaDetalle.getCocoemco());
			// tlfno1
			consulta.setConrtelco(consultaDetalle.getConrtelco());
			// fax - tlfno2
			consulta.setConrfaxco(consultaDetalle.getConrfaxco());

			// NORA
			// cp
			consulta.setNoraCpId(consultaDetalle.getCpId());
			consulta.setNombreCp(consultaDetalle.getNombreCp());

			// "direccion_nocapv"
			consulta.setDireccion_nocapv(consultaDetalle.getDireccion_nocapv());

			// "coextranjero"
			consulta.setCoextranjero(consultaDetalle.getCoextranjero());

			// RESPUESTA________________________________________________
			Respuesta respuesta = new Respuesta();

			TipoRespuesta tipoRespuesta = new TipoRespuesta();
			tipoRespuesta.setP8codigo(consultaDetalle.getP8codigo());
			respuesta.setTipoRespuesta(tipoRespuesta);
			respuesta.setP9feresp(consultaDetalle.getP9feresp());
			respuesta.setP9teres(consultaDetalle.getP9teres());
			respuesta.setP9feanot(new Date());
			respuesta.setP9nufiladj(new BigDecimal(0));
			respuesta.setP9inemlusu(Y41aConstantes.VALOR_NO);

			Consulta consultaAux = this.consultaService.addConsulta(consulta,
					respuesta);
			logger.info("Entity correctly inserted!");
			return consultaAux;
		} catch (Exception e) {
			e.printStackTrace();
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param cocodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{cocodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String cocodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Consulta consulta = new Consulta();
			consulta.setCocodigo(cocodigo);
			this.consultaService.remove(consulta);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + cocodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param consultaIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> consultaIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Consulta> consultaList = new ArrayList<Consulta>();
		try {
			for (ArrayList<String> consultaId : consultaIds) {
				Iterator<String> iterator = consultaId.iterator();
				Consulta consulta = new Consulta();
				consulta.setCocodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				consultaList.add(consulta);
			}
			this.consultaService.removeMultiple(consultaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getConsultaService'.
	 * 
	 * @return ConsultaService
	 */
	protected ConsultaService getConsultaService() {
		return this.consultaService;
	}

	/**
	 * Method 'setConsultaService'.
	 * 
	 * @param consultaService
	 *            ConsultaService
	 * @return
	 */
	public void setConsultaService(ConsultaService consultaService) {
		this.consultaService = consultaService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}

	/**
	 * Exporta a una tabla Excel el resultado de la búsqueda
	 * 
	 * @param cocodigo
	 * @param motivoTircodigo_
	 * @param tircodigo_
	 * @param productoPscodigo_
	 * @param rangoEdadRancod_
	 * @param formaPresentacionTfpcodigo_
	 * @param organismoCodOrg
	 * @param censoMonitorMocodigo_
	 * @param cofecha
	 * @param cocosx_
	 * @param conran
	 * @param cocose
	 * @param cotexto_
	 * @param conrreg
	 * @param conoco_
	 * @param conodirco
	 * @param conrcpco
	 * @param cocoloco
	 * @param conoloco
	 * @param conomuco
	 * @param cocopvco
	 * @param cocopaco
	 * @param conrtelco
	 * @param conrfaxco
	 * @param cocoemco
	 * @param coferes
	 * @param coinreenv
	 * @param coteresp
	 * @param cocotfpr
	 * @param coinl37_
	 * @param conranrg
	 * @param cocopro
	 * @param cohdcodigo
	 * @param cohora
	 * @param cofechaconsumidor
	 * @param noraPaisId_
	 * @param nombrePais
	 * @param provinciaId_
	 * @param nombreProvincia
	 * @param municipioId_
	 * @param nombreMunicipio
	 * @param localidadId_
	 * @param nombreLocalidad
	 * @param noraCalleId
	 * @param nombreCalle
	 * @param noraCpId
	 * @param nombreCp
	 * @param noraPortalId
	 * @param nombrePortal
	 * @param direccion_nocapv_
	 * @param coextranjero_
	 * @param coestado_
	 * @param coinl21_
	 * @param cosituacion_
	 * @param nombrePiso
	 * @param cofechaDesde_
	 *            rango inferior de fechas
	 * @param cofechaHasta_
	 *            rango superior de fechas
	 * @param request
	 *            HttpServletRequest petición HTTP
	 * @param response
	 *            HttpServletResponse respuesta HTTP
	 */
	@RequestMapping(value = "/excel", method = RequestMethod.GET)
	public void getAllConsultaExcel(
			@RequestParam(value = "cocodigo", required = false) String cocodigo,
			@RequestParam(value = "motivoTircodigo", required = false) String motivoTircodigo_,
			@RequestParam(value = "tircodigo", required = false) String tircodigo_,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo_,
			@RequestParam(value = "rangoEdadRancod", required = false) String rangoEdadRancod_,
			@RequestParam(value = "formaPresentacionTfpcodigo", required = false) String formaPresentacionTfpcodigo_,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			@RequestParam(value = "censoMonitorMocodigo", required = false) String censoMonitorMocodigo_,
			@RequestParam(value = "cofecha", required = false) Date cofecha,
			@RequestParam(value = "cocosx", required = false) String cocosx_,
			@RequestParam(value = "conran", required = false) String conran,
			@RequestParam(value = "cocose", required = false) String cocose,
			@RequestParam(value = "cotexto", required = false) String cotexto_,
			@RequestParam(value = "conrreg", required = false) Integer conrreg,
			@RequestParam(value = "conoco", required = false) String conoco_,
			@RequestParam(value = "conodirco", required = false) String conodirco,
			@RequestParam(value = "conrcpco", required = false) String conrcpco,
			@RequestParam(value = "cocoloco", required = false) String cocoloco,
			@RequestParam(value = "conoloco", required = false) String conoloco,
			@RequestParam(value = "conomuco", required = false) String conomuco,
			@RequestParam(value = "cocopvco", required = false) String cocopvco,
			@RequestParam(value = "cocopaco", required = false) String cocopaco,
			@RequestParam(value = "conrtelco", required = false) String conrtelco,
			@RequestParam(value = "conrfaxco", required = false) String conrfaxco,
			@RequestParam(value = "cocoemco", required = false) String cocoemco,
			@RequestParam(value = "coferes", required = false) Date coferes,
			@RequestParam(value = "coinreenv", required = false) String coinreenv,
			@RequestParam(value = "coteresp", required = false) String coteresp,
			@RequestParam(value = "cocotfpr", required = false) String cocotfpr,
			@RequestParam(value = "coinl37", required = false) String coinl37_,
			@RequestParam(value = "conranrg", required = false) Long conranrg,
			@RequestParam(value = "cocopro", required = false) String cocopro,
			@RequestParam(value = "cohdcodigo", required = false) String cohdcodigo,
			@RequestParam(value = "cohora", required = false) String cohora,
			@RequestParam(value = "cofechaconsumidor", required = false) Date cofechaconsumidor,
			@RequestParam(value = "noraPaisId", required = false) String noraPaisId_,
			@RequestParam(value = "nombrePais", required = false) String nombrePais,
			@RequestParam(value = "provinciaId", required = false) String provinciaId_,
			@RequestParam(value = "nombreProvincia", required = false) String nombreProvincia,
			@RequestParam(value = "municipioId", required = false) String municipioId_,
			@RequestParam(value = "nombreMunicipio", required = false) String nombreMunicipio,
			@RequestParam(value = "localidadId", required = false) String localidadId_,
			@RequestParam(value = "nombreLocalidad", required = false) String nombreLocalidad,
			@RequestParam(value = "noraCalleId", required = false) String noraCalleId,
			@RequestParam(value = "nombreCalle", required = false) String nombreCalle,
			@RequestParam(value = "noraCpId", required = false) String noraCpId,
			@RequestParam(value = "nombreCp", required = false) String nombreCp,
			@RequestParam(value = "noraPortalId", required = false) String noraPortalId,
			@RequestParam(value = "nombrePortal", required = false) String nombrePortal,
			@RequestParam(value = "direccion_nocapv", required = false) String direccion_nocapv_,
			@RequestParam(value = "coextranjero", required = false) String coextranjero_,
			@RequestParam(value = "coestado", required = false) String coestado_,
			@RequestParam(value = "coinl21", required = false) String coinl21_,
			@RequestParam(value = "cosituacion", required = false) String cosituacion_,
			@RequestParam(value = "nombrePiso", required = false) String nombrePiso,
			@RequestParam(value = "cofechaDesde", required = false) String cofechaDesde_,
			@RequestParam(value = "cofechaHasta", required = false) String cofechaHasta_,
			HttpServletRequest request, HttpServletResponse response) {
		try {
			// parseo de fechas
			Locale locale = LocaleContextHolder.getLocale();
			Date cofechaDesde = Y41aUtils.parseDate(cofechaDesde_, locale);
			Date cofechaHasta = Y41aUtils.parseDate(cofechaHasta_, locale);

			// control de los campos susceptibles de llegar a "" desde el filtro
			String cosituacion = ("".equals(cosituacion_)) ? null
					: cosituacion_;
			String censoMonitorMocodigo = ("".equals(censoMonitorMocodigo_)) ? null
					: censoMonitorMocodigo_;
			String formaPresentacionTfpcodigo = (""
					.equals(formaPresentacionTfpcodigo_)) ? null
					: formaPresentacionTfpcodigo_;
			String cotexto = ("".equals(cotexto_)) ? null : cotexto_;
			String conoco = ("".equals(conoco_)) ? null : conoco_;
			String coextranjero = null;
			String coestado = null;
			String noraPaisId = null;
			String provinciaId = null;
			String municipioId = null;
			String localidadId = null;
			String direccion_nocapv = null;

			if (Y41aConstantes.NORA_LOCALIZACION_TODOS.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = null;
			} else if (Y41aConstantes.NORA_LOCALIZACION_EXTRANJERO
					.equals(coextranjero_)) {
				coextranjero = Y41aConstantes.VALOR_SI;
				noraPaisId = ("".equals(noraPaisId_)) ? null : noraPaisId_;
				coestado = null;
				provinciaId = null;
				municipioId = null;
				localidadId = null;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null
						: direccion_nocapv_;

			} else if (Y41aConstantes.NORA_LOCALIZACION_ESTADO
					.equals(coextranjero_)) {
				coextranjero = null;
				noraPaisId = null;
				coestado = Y41aConstantes.VALOR_SI;
				provinciaId = ("".equals(provinciaId_)) ? null : provinciaId_;
				municipioId = ("".equals(municipioId_)) ? null : municipioId_;
				localidadId = ("".equals(localidadId_)) ? null : localidadId_;
				direccion_nocapv = ("".equals(direccion_nocapv_)) ? null
						: direccion_nocapv_;
			}
			String rangoEdadRancod = ("".equals(rangoEdadRancod_)) ? null
					: rangoEdadRancod_;
			String cocosx = ("".equals(cocosx_)) ? null : cocosx_;

			String productoPscodigo = ("".equals(productoPscodigo_)) ? null
					: productoPscodigo_;

			String motivoTircodigo = "";
			if (tircodigo_ != "" && tircodigo_ != null) {
				motivoTircodigo = ("".equals(tircodigo_)) ? null : tircodigo_;
			} else {
				motivoTircodigo = ("".equals(motivoTircodigo_)) ? null
						: motivoTircodigo_;

			}

			// control checks
			String coinl21 = ("on".equals(coinl21_)) ? Y41aConstantes.VALOR_SI
					: null;
			String coinl37 = ("on".equals(coinl37_)) ? Y41aConstantes.VALOR_SI
					: null;

			// Filtro
			Consulta filterConsulta = new Consulta(cocodigo, new Motivo(
					motivoTircodigo, null, null, null), new Producto(
					productoPscodigo, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null), new RangoEdad(rangoEdadRancod, null,
					null, null), new FormaPresentacion(
					formaPresentacionTfpcodigo, null, null, null, null, null,
					null), new Organismo(organismoCodOrg, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null), new CensoMonitor(censoMonitorMocodigo, null, null,
					null, null, null, null, null, null, null, null, null),
					cofecha, cocosx, conran, cocose, cotexto, conrreg, conoco,
					conodirco, conrcpco, cocoloco, conoloco, conomuco,
					cocopvco, cocopaco, conrtelco, conrfaxco, cocoemco,
					coferes, coinreenv, coteresp, cocotfpr, coinl37, conranrg,
					cocopro, cohdcodigo, cohora, cofechaconsumidor, noraPaisId,
					nombrePais, provinciaId, nombreProvincia, municipioId,
					nombreMunicipio, localidadId, nombreLocalidad, noraCalleId,
					nombreCalle, noraCpId, nombreCp, noraPortalId,
					nombrePortal, coinl21, cosituacion, nombrePiso,
					direccion_nocapv, coextranjero, coestado, null, null);

			Date fechaHoy = new Date();
			String fechaActual = Y41aUtils.formatearDateToString(fechaHoy,
					"yyyyMMdd");

			response.setCharacterEncoding("ISO-8859-1");
			response.setHeader("Cache-Control", "no-cache");
			response.setContentType("application/vnd.ms-excel");
			String nombre = Y41aConstantes.EXCEL_BUSQUEDA_CONSULTAS
					+ fechaActual + ".xls";
			response.setHeader("Content-Disposition", "attachment; filename=\""
					+ Y41aStringUtils.unescapeHTML(nombre, 0) + "\"");

			String xslString = this.y41aExcelGeneratorService
					.getConsultasExcel(filterConsulta, cofechaDesde,
							cofechaHasta);

			PrintWriter out = response.getWriter();
			out.println(xslString);
			out.flush();
			out.close();
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}
}
