package com.ejie.y41a.control;

import java.sql.Blob;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.rowset.serial.SerialBlob;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Comunicacion;
import com.ejie.y41a.model.ComunicacionFile;
import com.ejie.y41a.service.ComunicacionFileService;

/**
 * * ComunicacionFileController generated by UDA, 22-feb-2012 17:30:45.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/comunicacionfile")
public class ComunicacionFileController {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunicacionFileController.class);

	@Autowired()
	private ComunicacionFileService comunicacionFileService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("comunicacionfile", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param m3cofile
	 *            Long
	 * @return String
	 */
	@RequestMapping(value = "/{m3cofile}", method = RequestMethod.GET)
	public @ResponseBody()
	ComunicacionFile getById(@PathVariable() Long m3cofile) {
		try {
			ComunicacionFile comunicacionFile = new ComunicacionFile();
			comunicacionFile.setM3cofile(m3cofile);
			comunicacionFile = this.comunicacionFileService
					.find(comunicacionFile);
			if (comunicacionFile == null) {
				throw new Exception(m3cofile.toString());
			}
			return comunicacionFile;
		} catch (Exception e) {
			throw new ResourceNotFoundException(m3cofile.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param m3cofile
	 *            Long
	 * @param comunicacionM4cocomu
	 *            Integer
	 * @param m3nofile
	 *            String
	 * @param m3sizefile
	 *            Integer
	 * @param m3tedesfile
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "m3cofile", required = false) Long m3cofile,
			@RequestParam(value = "comunicacionM4cocomu", required = false) Long comunicacionM4cocomu,
			@RequestParam(value = "m3nofile", required = false) String m3nofile,
			@RequestParam(value = "m3sizefile", required = false) Integer m3sizefile,
			@RequestParam(value = "m3tedesfile", required = false) String m3tedesfile,
			HttpServletRequest request) {
		try {
			ComunicacionFile filterComunicacionFile = new ComunicacionFile(
					m3cofile, m3nofile, null, m3sizefile, m3tedesfile, null,
					new Comunicacion(comunicacionM4cocomu, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<ComunicacionFile> comunicacionFiles = this.comunicacionFileService
						.findAll(filterComunicacionFile, pagination);

				if (comunicacionFiles == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterComunicacionFile, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(comunicacionFiles);
				return data;
			} else {
				List<ComunicacionFile> comunicacionFiles = this.comunicacionFileService
						.findAll(filterComunicacionFile, pagination);
				if (comunicacionFiles == null) {
					throw new Exception("No data Found.");
				}
				return comunicacionFiles;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterComunicacionFile
	 *            ComunicacionFile
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@RequestParam(value = "comunicacionFile", required = false) ComunicacionFile filterComunicacionFile,
			HttpServletRequest request) {
		try {
			return comunicacionFileService
					.findAllCount(filterComunicacionFile != null ? filterComunicacionFile
							: new ComunicacionFile());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param comunicacionFile
	 *            ComunicacionFile
	 * @param response
	 *            HttpServletResponse
	 * @return ComunicacionFile
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	ComunicacionFile edit(@RequestBody ComunicacionFile comunicacionFile,
			HttpServletResponse response) {
		try {
			ComunicacionFile comunicacionFileAux = this.comunicacionFileService
					.update(comunicacionFile);
			logger.info("Entity correctly inserted!");
			return comunicacionFileAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param comunicacionFile
	 *            ComunicacionFile
	 * @return ComunicacionFile
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	ComunicacionFile add(@RequestBody ComunicacionFile comunicacionFile) {
		try {
			ComunicacionFile comunicacionFileAux = this.comunicacionFileService
					.add(comunicacionFile);
			logger.info("Entity correctly inserted!");
			return comunicacionFileAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param m3cofile
	 *            Long
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{m3cofile}", method = RequestMethod.DELETE)
	public void remove(@PathVariable Long m3cofile, HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			ComunicacionFile comunicacionFile = new ComunicacionFile();
			comunicacionFile.setM3cofile(m3cofile);
			this.comunicacionFileService.remove(comunicacionFile);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + m3cofile);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param comunicacionFileIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> comunicacionFileIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<ComunicacionFile> comunicacionFileList = new ArrayList<ComunicacionFile>();
		try {
			for (ArrayList<String> comunicacionFileId : comunicacionFileIds) {
				Iterator<String> iterator = comunicacionFileId.iterator();
				ComunicacionFile comunicacionFile = new ComunicacionFile();
				comunicacionFile.setM3cofile(ObjectConversionManager.convert(
						iterator.next(), Long.class));
				comunicacionFileList.add(comunicacionFile);
			}
			this.comunicacionFileService.removeMultiple(comunicacionFileList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param file
	 *            MultipartFile
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return List<Map<String, Object>>
	 */

	@RequestMapping(value = "subidaEnvio", method = RequestMethod.POST)
	public @ResponseBody()
	List<Map<String, Object>> add(
			@RequestParam(value = "files[]", required = false) MultipartFile file,
			HttpServletResponse response, HttpServletRequest request) {

		try {

			long codigoComunicacion = 0;
			if (request.getParameter("codigoComunicacion") != null) {
				codigoComunicacion = Long.parseLong(request
						.getParameter("codigoComunicacion"));
			}

			// ENVIO FILE

			Comunicacion com = new Comunicacion();
			com.setM4cocomu(codigoComunicacion);

			ComunicacionFile comfile = new ComunicacionFile();

			Blob blob = new SerialBlob(file.getBytes());
			comfile.setM3datafile(blob);
			comfile.setM3contenttypefile(file.getContentType());
			comfile.setM3nofile(file.getOriginalFilename().replace(" ", "_"));
			comfile.setM3sizefile((int) file.getSize());
			comfile.setM3tedesfile("");
			comfile.setComunicacion(com);

			ComunicacionFile comFileAux = this.comunicacionFileService
					.add(comfile);

			logger.info("Entity correctly inserted!" + comFileAux.getM3cofile());

			Long cofile = comFileAux.getM3cofile();
			String strCofile = Long.toString(cofile);

			List<Map<String, Object>> filesMetaInfo = new ArrayList<Map<String, Object>>();
			filesMetaInfo.add(this.getFileReturnMap(file, strCofile));
			return filesMetaInfo;

		} catch (Exception e) {

			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'getByIdDocumentoComunicacionDetalle'.
	 * 
	 * @param m3cofile
	 *            Long
	 * @param response
	 *            HttpServletResponse
	 */
	@RequestMapping(value = "/detalle/{m3cofile}", method = RequestMethod.GET)
	public @ResponseBody()
	void getByIdDocumentoConsultaDetalle(@PathVariable() Long m3cofile,
			HttpServletResponse response) {
		try {

			ComunicacionFile comunicacionFile = new ComunicacionFile();
			comunicacionFile.setM3cofile(m3cofile);
			comunicacionFile = this.comunicacionFileService
					.find(comunicacionFile);
			if (comunicacionFile == null) {
				throw new Exception(m3cofile.toString());
			}

			Blob contenido = comunicacionFile.getM3datafile();
			byte[] bContenido = contenido.getBytes(1, (int) contenido.length());

			// Cambiamos el objeto Response para visualizar el contenido del
			// archivo
			response.setHeader("Content-Disposition", "attachment; filename="
					+ comunicacionFile.getM3nofile() + "");
			response.setContentType(comunicacionFile.getM3contenttypefile());
			response.setContentLength(comunicacionFile.getM3sizefile());
			response.getOutputStream().write(bContenido);

			// Vaciamos el stream
			response.getOutputStream().flush();

			// return documentoConsultaDetalle;
		} catch (Exception e) {
			throw new ResourceNotFoundException(m3cofile.toString());
		}
	}

	/**
	 * 
	 * @param file
	 *            MultipartFile
	 * @param strCofile
	 *            String
	 * @return mapa
	 */
	private Map<String, Object> getFileReturnMap(MultipartFile file,
			String strCofile) {
		Map<String, Object> mapaRetorno = new HashMap<String, Object>();
		mapaRetorno.put("url", "/y41aVistaWar/comunicacionfile/detalle/"
				+ strCofile + "?R01HNoPortal=true");
		mapaRetorno.put("name", file.getOriginalFilename().replace(" ", "_"));
		mapaRetorno.put("type", file.getContentType());
		mapaRetorno.put("size", file.getSize());
		mapaRetorno.put("delete_url", "/y41aVistaWar/comunicacionfile/"
				+ strCofile + "?R01HNoPortal=true");
		mapaRetorno.put("delete_type", "DELETE");
		return mapaRetorno;
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getComunicacionFileService'.
	 * 
	 * @return ComunicacionFileService
	 */
	protected ComunicacionFileService getComunicacionFileService() {
		return this.comunicacionFileService;
	}

	/**
	 * Method 'setComunicacionFileService'.
	 * 
	 * @param comunicacionFileService
	 *            ComunicacionFileService
	 * @return
	 */
	public void setComunicacionFileService(
			ComunicacionFileService comunicacionFileService) {
		this.comunicacionFileService = comunicacionFileService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
