package com.ejie.y41a.control;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.model.Comunicacion;
import com.ejie.y41a.model.ComunicacionBusqueda;
import com.ejie.y41a.model.ComunicacionDetalle;
import com.ejie.y41a.model.ComunicacionFile;
import com.ejie.y41a.model.DestComunicacion;
import com.ejie.y41a.model.Envio;
import com.ejie.y41a.model.Item;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.model.TipoComunicacion;
import com.ejie.y41a.service.ComunicacionFileService;
import com.ejie.y41a.service.ComunicacionService;
import com.ejie.y41a.service.DestComunicacionService;
import com.ejie.y41a.service.ItemService;
import com.ejie.y41a.utils.Y41aUtils;

/**
 * * ComunicacionController generated by UDA, 22-feb-2012 17:30:45.
 * 
 *  
 */

@Controller()
@RequestMapping(value = "/comunicacion")
public class ComunicacionController {

	private static final Logger logger = LoggerFactory
			.getLogger(ComunicacionController.class);

	@Autowired()
	private ComunicacionService comunicacionService;

	@Autowired()
	private ComunicacionFileService comunicacionFileService;

	@Autowired()
	private DestComunicacionService destComunicacionService;

	@Autowired()
	private ItemService itemService;

	@Autowired()
	private Properties appConfiguration;

	/**
	 * Muestra busqueda de envios Method 'getCreateFormEnvios'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintEnvios", method = RequestMethod.GET)
	public ModelAndView getCreateFormEnvios(Model model) {

		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("com_envios", "model", model);
	}

	/**
	 * Muestra busqueda de recepciones Method 'getCreateFormRecepciones'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maintRecepciones", method = RequestMethod.GET)
	public ModelAndView getCreateFormRecepciones(Model model) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("com_recepciones", "model", model);
	}

	/**
	 * Alta de comunicaciones. Method getCreateFormEnviosAltaModal
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            Request
	 * @return String
	 */
	@RequestMapping(value = "maintAltaComunicacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormEnviosAltaModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));

		HttpSession httpSession = request.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

		ComunicacionDetalle commDetalle = new ComunicacionDetalle();
		Locale locale = LocaleContextHolder.getLocale();

		int responder = 0;
		if (request.getParameter("Responder") != null) {
			responder = 1;
		}
		if (request.getParameter("m4cocomu") != null) {
			Comunicacion comunicacion = new Comunicacion();
			comunicacion.setM4cocomu(Long.parseLong(request
					.getParameter("m4cocomu")));
			Comunicacion comAux = this.comunicacionService.find(comunicacion);
			if (Y41aConstantes.CASTELLANO.equals(locale.getLanguage())) {
				commDetalle.setM5destinatarios(comAux.getOrganismo()
						.getNombreEs());
			} else {
				commDetalle.setM5destinatarios(comAux.getOrganismo()
						.getNombreEu());
			}
			String orgId = comAux.getOrganismo().getCodOrg();

			commDetalle.setM5destinatarios(orgId + "@#@"
					+ commDetalle.getM5destinatarios());

		}
		model.addAttribute("responder", responder);
		model.addAttribute("responderComm", commDetalle);
		model.addAttribute("censoMonitor", censoMonitor);

		return new ModelAndView("com_envios_AltaModal", "model", model);
	}

	/**
	 * Alta de comunicaciones. Method getCreateFormEnviosAltaModal
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            Request
	 * @return String
	 */
	@RequestMapping(value = "maintAdjuntosComunicacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormEnviosAdjuntosModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));

		Comunicacion comunicacion = new Comunicacion();
		comunicacion.setM4cocomu(new Long(0));
		if (request.getParameter("m4cocomu") != null) {
			comunicacion.setM4cocomu(Long.parseLong(request
					.getParameter("m4cocomu")));
		}
		Comunicacion comAux = this.comunicacionService.find(comunicacion);

		model.addAttribute("comunicacion", comAux);

		return new ModelAndView("com_envios_AdjuntosModal", "model", model);
	}

	/**
	 * Detalle de comunicaciones. Method getCreateFormEnviosDetalleModal
	 * 
	 * @param model
	 *            Model
	 * @param request
	 *            Request
	 * @return String
	 */
	@RequestMapping(value = "maintDetalleComunicacion", method = RequestMethod.GET)
	public ModelAndView getCreateFormEnviosDetalleModal(Model model,
			HttpServletRequest request) {
		model.addAttribute("defaultLanguage",
				this.appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				this.appConfiguration.get("y41aVistaWar.default.layout"));

		Comunicacion comunicacion = new Comunicacion();
		comunicacion.setM4cocomu(new Long(0));
		if (request.getParameter("m4cocomu") != null) {
			comunicacion.setM4cocomu(Long.parseLong(request
					.getParameter("m4cocomu")));
		}

		Comunicacion comAux = this.comunicacionService.find(comunicacion);
		ComunicacionFile commFile = new ComunicacionFile();
		commFile.setComunicacion(comunicacion);
		List<ComunicacionFile> comFileAux = this.comunicacionFileService
				.findAll(commFile, null);
		if (comFileAux != null) {
			List<ComunicacionFile> comFileScreen = new ArrayList<ComunicacionFile>();
			for (ComunicacionFile file : comFileAux) {
				file.setM3datafile(null);
				comFileScreen.add(file);

			}
			comAux.setComunicacionFiles(comFileScreen);
		}
		int responder = 0;
		if (request.getParameter("Responder") != null) {
			DestComunicacion destcomunicacion = new DestComunicacion();
			destcomunicacion.setComunicacion(comunicacion);
			HttpSession httpSession = request.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			destcomunicacion.setOrganismo(censoMonitor.getOrganismo());
			destcomunicacion.setM5feleido(new Date());

			this.destComunicacionService.update(destcomunicacion);

			responder = 1;

			// marcar como leido la comunicación enviada desde Y42B
			if (comAux != null && comAux.getM4envioid() != null
					&& !comAux.getM4envioid().equals("")) {
				Item item = new Item();
				item.setEnvio(new Envio());
				item.setItemRef(censoMonitor.getOrganismo().getEntidadId());
				item.getEnvio().setEnvioId(comAux.getM4envioid());

				item = this.itemService.find(item);
				if (item != null) {
					Date fechaMailingRecepcion = new Date();
					item.setFechaMailingRecepcion(fechaMailingRecepcion);

					this.itemService.update(item);
				}
			}
		}
		model.addAttribute("responder", responder);
		model.addAttribute("comunicacion", comAux);

		return new ModelAndView("com_envios_DetalleModal", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param m4cocomu
	 *            Long
	 * @return String
	 */
	@RequestMapping(value = "/{m4cocomu}", method = RequestMethod.GET)
	public @ResponseBody()
	Comunicacion getById(@PathVariable() Long m4cocomu) {
		try {
			Comunicacion comunicacion = new Comunicacion();
			comunicacion.setM4cocomu(m4cocomu);
			comunicacion = this.comunicacionService.find(comunicacion);
			if (comunicacion == null) {
				throw new Exception(m4cocomu.toString());
			}
			return comunicacion;
		} catch (Exception e) {
			throw new ResourceNotFoundException(m4cocomu.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param m4cocomu
	 *            Long
	 * @param tipoComunicacionM6codigo
	 *            Integer
	 * @param m4cocoor
	 *            String
	 * @param m4feenv
	 *            Date
	 * @param m4fecad
	 *            Date
	 * @param m4noremi
	 *            String
	 * @param m4tesubject
	 *            String
	 * @param m4tecomu
	 *            String
	 * @param m4nudest
	 *            Long
	 * @param m4nufiladj
	 *            Long
	 * @param m4incomact
	 *            Integer
	 * @param m4incombl
	 *            Integer
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody()
	Object getAll(
			@RequestParam(value = "m4cocomu", required = false) Long m4cocomu,
			@RequestParam(value = "tipoComunicacionM6codigo", required = false) Integer tipoComunicacionM6codigo,
			@RequestParam(value = "m4cocoor", required = false) String m4cocoor,
			@RequestParam(value = "m4feenv", required = false) Date m4feenv,
			@RequestParam(value = "m4fecad", required = false) Date m4fecad,
			@RequestParam(value = "m4noremi", required = false) String m4noremi,
			@RequestParam(value = "m4tesubject", required = false) String m4tesubject,
			@RequestParam(value = "m4tecomu", required = false) String m4tecomu,
			@RequestParam(value = "m4nudest", required = false) Long m4nudest,
			@RequestParam(value = "m4nufiladj", required = false) Long m4nufiladj,
			@RequestParam(value = "m4incomact", required = false) Integer m4incomact,
			@RequestParam(value = "m4incombl", required = false) Integer m4incombl,
			HttpServletRequest request) {
		try {
			Comunicacion filterComunicacion = new Comunicacion(m4cocomu,
					new Organismo(m4cocoor, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null), m4feenv, m4fecad,
					m4noremi, m4tesubject, m4tecomu, m4nudest, m4nufiladj,
					m4incomact, m4incombl, new TipoComunicacion(
							tipoComunicacionM6codigo, null, null, null, null,
							null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Comunicacion> comunicacions = this.comunicacionService
						.findAll(filterComunicacion, pagination);

				if (comunicacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterComunicacion, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(comunicacions);
				return data;
			} else {
				List<Comunicacion> comunicacions = this.comunicacionService
						.findAll(filterComunicacion, pagination);
				if (comunicacions == null) {
					throw new Exception("No data Found.");
				}
				return comunicacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllEnvios'.
	 * 
	 * @param m4cocomu
	 *            Long
	 * @param categoriaId
	 *            Integer
	 * @param m4tesubject
	 *            String
	 * @param OrganismoCode
	 *            Integer
	 * @param fechaDesde_
	 *            String
	 * @param fechaHasta_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/searchEnvios", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllEnvios(
			@RequestParam(value = "id", required = false) Long m4cocomu,
			@RequestParam(value = "y41aEnviosCategoria_", required = false) Integer categoriaId,
			@RequestParam(value = "y41aEnviosParaOrganismoCode_", required = false) String OrganismoCode,
			@RequestParam(value = "asunto_", required = false) String m4tesubject,
			@RequestParam(value = "fechaDesde_", required = false) String fechaDesde_,
			@RequestParam(value = "fechaHasta_", required = false) String fechaHasta_,
			HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

		String m4cocoor = censoMonitor.getOrganismo().getCodOrg();

		// parseo de fechas
		Locale locale = LocaleContextHolder.getLocale();

		try {
			Date dtfechaDesde = Y41aUtils.parseDate(fechaDesde_, locale);
			Date dtfechaHasta = Y41aUtils.parseDate(fechaHasta_, locale);

			String organismoDestino = null;
			if (OrganismoCode != null && OrganismoCode.length() > 0) {
				organismoDestino = OrganismoCode;
			}
			Comunicacion filterComunicacion = new Comunicacion(m4cocomu,
					new Organismo(m4cocoor, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null), null, null, null,
					m4tesubject, null, null, null, null, null,
					new TipoComunicacion(categoriaId, null, null, null, null,
							null, null, null));
			Pagination pagination = null;

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<ComunicacionBusqueda> comunicacions = this.comunicacionService
						.findAllLikeComunicacionEnvio(filterComunicacion,
								pagination, false, organismoDestino,
								dtfechaDesde, dtfechaHasta);

				if (comunicacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.comunicacionService
						.findAllLikeComunicacionEnvioCount(filterComunicacion,
								false, organismoDestino, dtfechaDesde,
								dtfechaHasta);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(comunicacions);
				return data;
			} else {
				List<ComunicacionBusqueda> comunicacions = this.comunicacionService
						.findAllLikeComunicacionEnvio(filterComunicacion,
								pagination, false, organismoDestino,
								dtfechaDesde, dtfechaHasta);

				if (comunicacions == null) {
					throw new Exception("No data Found.");
				}
				return comunicacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllRecepciones'.
	 * 
	 * @param m4cocomu
	 *            Long
	 * @param categoriaId
	 *            Integer
	 * @param m4tesubject
	 *            String
	 * @param OrganismoCode
	 *            Integer
	 * @param remitente
	 *            String
	 * @param fechaDesde_
	 *            String
	 * @param fechaHasta_
	 *            String
	 * @param leidas_
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/searchRecepciones", method = RequestMethod.GET)
	public @ResponseBody()
	Object getAllRecepciones(
			@RequestParam(value = "id_", required = false) Long m4cocomu,
			@RequestParam(value = "y41aRecepcionesCategoriaId_", required = false) Integer categoriaId,
			@RequestParam(value = "codOrg_", required = false) String OrganismoCode,
			@RequestParam(value = "asunto_", required = false) String m4tesubject,
			@RequestParam(value = "remitente_", required = false) String remitente,
			@RequestParam(value = "fechaDesde_", required = false) String fechaDesde_,
			@RequestParam(value = "fechaHasta_", required = false) String fechaHasta_,
			@RequestParam(value = "leidas_", required = false) String leidas_,
			HttpServletRequest request) {

		HttpServletRequest httpRequest = (HttpServletRequest) request;
		HttpSession httpSession = httpRequest.getSession(false);
		CensoMonitor censoMonitor = (CensoMonitor) httpSession
				.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

		String m4cocoor = censoMonitor.getOrganismo().getCodOrg();
		String orgCod = null;
		if (OrganismoCode != null && OrganismoCode.length() > 0) {
			orgCod = OrganismoCode;
		}

		// parseo de fechas
		Locale locale = LocaleContextHolder.getLocale();

		try {
			Date dtfechaDesde = Y41aUtils.parseDate(fechaDesde_, locale);
			Date dtfechaHasta = Y41aUtils.parseDate(fechaHasta_, locale);

			Comunicacion filterComunicacion = new Comunicacion(m4cocomu,
					new Organismo(orgCod, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null), null, null, null,
					m4tesubject, null, null, null, null, null,
					new TipoComunicacion(categoriaId, null, null, null, null,
							null, null, null));

			if (Y41aConstantes.COMUNICACION_LEIDA.equals(leidas_)) {
				filterComunicacion
						.setIndicadorLeidos(Y41aConstantes.COMUNICACION_LEIDA);
			} else if (Y41aConstantes.COMUNICACION_NO_LEIDA.equals(leidas_)) {
				filterComunicacion
						.setIndicadorLeidos(Y41aConstantes.COMUNICACION_NO_LEIDA);
			} else if ("T".equals(leidas_)) {
				filterComunicacion.setIndicadorLeidos(null);
			}

			if (remitente != null && !"".equals(remitente)) {
				filterComunicacion.setM4noremi(remitente);
			}

			Pagination pagination = null;

			String codOrgDestino = m4cocoor;

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));

				List<ComunicacionBusqueda> comunicacions = this.comunicacionService
						.findAllLikeComunicacionRecepcion(filterComunicacion,
								pagination, false, codOrgDestino, dtfechaDesde,
								dtfechaHasta);

				if (comunicacions == null) {
					throw new Exception("No data Found.");
				}

				Long total = this.comunicacionService
						.findAllLikeComunicacionRecepcionCount(
								filterComunicacion, false, codOrgDestino,
								dtfechaDesde, dtfechaHasta);

				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(comunicacions);
				return data;
			} else {
				pagination = new Pagination();
				pagination.setSort("M4FEENV");
				pagination.setAscDsc(Y41aConstantes.ORDENACION_DESC);

				List<ComunicacionBusqueda> comunicacions = this.comunicacionService
						.findAllLikeComunicacionRecepcion(filterComunicacion,
								pagination, false, codOrgDestino, dtfechaDesde,
								dtfechaHasta);

				if (comunicacions == null) {
					throw new Exception("No data Found.");
				}
				return comunicacions;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterComunicacion
	 *            Comunicacion
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody()
	Long getAllCount(
			@RequestParam(value = "comunicacion", required = false) Comunicacion filterComunicacion,
			HttpServletRequest request) {
		try {
			return this.comunicacionService
					.findAllCount(filterComunicacion != null ? filterComunicacion
							: new Comunicacion());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @param response
	 *            HttpServletResponse
	 * @return Comunicacion
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody()
	Comunicacion edit(@RequestBody() Comunicacion comunicacion,
			HttpServletResponse response) {
		try {
			Comunicacion comunicacionAux = this.comunicacionService
					.update(comunicacion);
			logger.info("Entity correctly inserted!");
			return comunicacionAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param comunicacion
	 *            Comunicacion
	 * @return Comunicacion
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody()
	Comunicacion add(@RequestBody() Comunicacion comunicacion) {
		try {

			Comunicacion comunicacionAux = this.comunicacionService
					.add(comunicacion);
			logger.info("Entity correctly inserted!");
			return comunicacionAux;

		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param comunicacionDetalle
	 *            Comunicacion
	 * @param request
	 *            request
	 * @return Comunicacion
	 */
	@RequestMapping(value = "/nuevo", method = RequestMethod.POST)
	public @ResponseBody()
	Comunicacion addComunicacion(
			@RequestBody() ComunicacionDetalle comunicacionDetalle,
			HttpServletRequest request) {
		try {

			HttpServletRequest httpRequest = (HttpServletRequest) request;
			HttpSession httpSession = httpRequest.getSession(false);
			CensoMonitor censoMonitor = (CensoMonitor) httpSession
					.getAttribute(Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			String m4cocoor = censoMonitor.getOrganismo().getCodOrg();
			String remitente = censoMonitor.getMonombre();

			Long numDestinatarios = new Long(1);
			Long numAdjuntos = new Long(0);

			Comunicacion comunicacion = new Comunicacion();
			Organismo organismo = new Organismo(m4cocoor, null, censoMonitor
					.getOrganismo().getNombreEs(), censoMonitor.getOrganismo()
					.getNombreEu(), null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null, null, null, null, null, null, null,
					null, null, null, null);

			TipoComunicacion tipoComunicacion = new TipoComunicacion(
					comunicacionDetalle.getM6codigo(), null, null, null, null,
					null, null, null);

			comunicacion.setOrganismo(organismo);
			comunicacion.setTipoComunicacion(tipoComunicacion);
			comunicacion.setM4tesubject(comunicacionDetalle.getM4tesubject());
			comunicacion.setM4tecomu(comunicacionDetalle.getM4tecomu());
			comunicacion.setM4noremi(remitente);

			// Evita problemas con las fechas desde hasta
			Locale locale = LocaleContextHolder.getLocale();
			Date today = new Date();
			Date todayWithZeroTime = Y41aUtils.parseDate(today, locale);
			comunicacion.setM4feenv(todayWithZeroTime);
			comunicacion.setM4fecad(todayWithZeroTime);
			comunicacion.setM4nudest(numDestinatarios);
			comunicacion.setM4nufiladj(numAdjuntos);
			comunicacion.setM4incomact(0);
			comunicacion.setM4incombl(0);

			String[] arrCodOrg = null;
			if (comunicacionDetalle.getM5destinatarios() != null) {
				arrCodOrg = comunicacionDetalle.getM5destinatarios().split(",");
			}

			List<DestComunicacion> destComunicacions = new ArrayList<DestComunicacion>();
			DestComunicacion dest = null;
			Organismo destOrganismo = null;
			String cod_organismo = "";

			for (int i = 0; i < arrCodOrg.length; i++) {
				if (arrCodOrg[i] != null && !(arrCodOrg[i].equals(""))) {

					// Recupera key de cod_organismo )max. 6 caracteres
					cod_organismo = arrCodOrg[i];
					// cod_organismo = cod_organismo.substring(
					// cod_organismo.lastIndexOf("_") + 1,
					// cod_organismo.length());

					dest = new DestComunicacion();
					destOrganismo = new Organismo();
					destOrganismo.setCodOrg(cod_organismo);
					dest.setOrganismo(destOrganismo);
					dest.setComunicacion(comunicacion);

					destComunicacions.add(dest);
				}

			}

			comunicacion.setDestComunicacions(destComunicacions);

			Comunicacion comunicacionAux = this.comunicacionService
					.addComunicacion(comunicacion);
			logger.info("Entity correctly inserted!");
			return comunicacionAux;

		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param m4cocomu
	 *            Long
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{m4cocomu}", method = RequestMethod.DELETE)
	public void remove(@PathVariable() Long m4cocomu,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Comunicacion comunicacion = new Comunicacion();
			comunicacion.setM4cocomu(m4cocomu);
			this.comunicacionService.remove(comunicacion);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + m4cocomu);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param comunicacionIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody() ArrayList<ArrayList<String>> comunicacionIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Comunicacion> comunicacionList = new ArrayList<Comunicacion>();
		try {
			for (ArrayList<String> comunicacionId : comunicacionIds) {
				Iterator<String> iterator = comunicacionId.iterator();
				Comunicacion comunicacion = new Comunicacion();
				comunicacion.setM4cocomu(ObjectConversionManager.convert(
						iterator.next(), Long.class));
				comunicacionList.add(comunicacion);
			}
			this.comunicacionService.removeMultiple(comunicacionList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler()
	public @ResponseBody()
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getComunicacionService'.
	 * 
	 * @return ComunicacionService
	 */
	protected ComunicacionService getComunicacionService() {
		return this.comunicacionService;
	}

	/**
	 * Method 'setComunicacionService'.
	 * 
	 * @param comunicacionService
	 *            ComunicacionService
	 * @return
	 */
	public void setComunicacionService(ComunicacionService comunicacionService) {
		this.comunicacionService = comunicacionService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return this.appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
