package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Pais;
import com.ejie.y41a.service.ComautService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Comaut;

/**
 *  * ComautController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/comaut")

public class ComautController  {

	private static final Logger logger = LoggerFactory.getLogger(ComautController.class);

	@Autowired
	private ComautService comautService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("comaut", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  cacodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{cacodigo}", method = RequestMethod.GET)
	public @ResponseBody Comaut getById(@PathVariable String cacodigo) {
		try{
            Comaut comaut = new Comaut();
			comaut.setCacodigo(cacodigo);
            comaut = this.comautService.find(comaut);
            if (comaut == null) {
                throw new Exception(cacodigo.toString());
            }
            return comaut;
		}catch (Exception e){
		    throw new ResourceNotFoundException(cacodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  cacodigo String
	 *@param	  paisPacodigo String
	 *@param	  canombre String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "cacodigo", required = false) String cacodigo,
	@RequestParam(value = "paisPacodigo", required = false) String paisPacodigo,
	@RequestParam(value = "canombre", required = false) String canombre,
			HttpServletRequest request) {
			try{
				Comaut filterComaut = new Comaut(cacodigo, canombre, new Pais(paisPacodigo, null, null, null, null, null));
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<Comaut> comauts =  this.comautService.findAll(filterComaut, pagination);

     			    if (comauts == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterComaut, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(comauts);
				    return data;
				}else{
				    List<Comaut> comauts =  this.comautService.findAll(filterComaut, pagination);
					if (comauts == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return comauts;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterComaut Comaut 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "comaut", required = false) Comaut  filterComaut, HttpServletRequest request) {
	    try {
			return comautService
					.findAllCount(filterComaut != null ? filterComaut
							: new Comaut ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param comaut Comaut 
	 * @param response HttpServletResponse
	 * @return Comaut
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody Comaut edit(@RequestBody Comaut comaut, HttpServletResponse response) {		
		try {
            Comaut comautAux  = this.comautService.update(comaut);
			logger.info("Entity correctly inserted!");
            return comautAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param comaut Comaut 
	 * @return Comaut
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody Comaut add(@RequestBody Comaut comaut) {		
        try {
            Comaut comautAux = this.comautService.add(comaut);
            logger.info("Entity correctly inserted!");
        	return comautAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  cacodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{cacodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String cacodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            Comaut comaut = new Comaut();
            comaut.setCacodigo(cacodigo);
            this.comautService.remove(comaut);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  cacodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  comautIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> comautIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<Comaut> comautList = new ArrayList<Comaut>();
        try{		    
            for (ArrayList<String> comautId:comautIds) {
			    Iterator<String> iterator = comautId.iterator();
				    Comaut comaut = new Comaut();
			        comaut.setCacodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    comautList.add(comaut);
		    }
            this.comautService.removeMultiple(comautList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getComautService'.
	 *
	 * @return ComautService
	 */
	protected ComautService getComautService() {
		return this.comautService;
	}

	/**
	 * Method 'setComautService'.
	 *
	 * @param comautService  ComautService
	 * @return
	 */
	public void setComautService(ComautService comautService) {
		this.comautService = comautService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
