package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Organismo;
import com.ejie.y41a.service.CensoMonitorService;
import com.ejie.y41a.utils.exception.Y41aUDAErrorManager;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.ejie.y41a.constantes.Y41aConstantes;
import com.ejie.y41a.model.CensoMonitor;
import com.ejie.y41a.utils.exception.Y41aUDAException;

/**
 * * CensoMonitorController generated by UDA, 01-feb-2012 17:10:42.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/censomonitor")
public class CensoMonitorController {

	private static final Logger logger = LoggerFactory
			.getLogger(CensoMonitorController.class);

	@Autowired
	private CensoMonitorService censoMonitorService;

	@Autowired
	private Properties appConfiguration;

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	@Autowired
	private Y41aUDAErrorManager errorManager;

	/**
	 * Method 'udaExceptionHandle'.
	 * 
	 * @param e
	 *            Y41aUDAException
	 * @param request
	 *            HttpServletRequest
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@ExceptionHandler(Y41aUDAException.class)
	public @ResponseBody
	void udaExceptionHandle(Y41aUDAException e, HttpServletRequest request,
			HttpServletResponse response) {

		response.setStatus(HttpServletResponse.SC_CONFLICT);
		Writer w = null;

		try {
			w = response.getWriter();
			w.write(errorManager.process(e, request));
			w.flush();
		} catch (IOException e1) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/*
	 * --------------- Tratamiento de errores comun para los proyectos UDA.
	 * --------------------------------------------------------------------
	 */

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("censomonitor", "model", model);
	}

	/**
	 * Method 'getCreateFormAlta'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "alta", method = RequestMethod.GET)
	public ModelAndView getCreateFormAlta(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("alta_modal", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param mocodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{mocodigo}", method = RequestMethod.GET)
	public @ResponseBody
	CensoMonitor getById(@PathVariable String mocodigo) {
		try {
			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(mocodigo);
			censoMonitor = this.censoMonitorService.find(censoMonitor);
			if (censoMonitor == null) {
				throw new Exception(mocodigo.toString());
			}
			return censoMonitor;
		} catch (Exception e) {
			throw new ResourceNotFoundException(mocodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param organismoCodOrg
	 *            String
	 * @param monombre
	 *            String
	 * @param mocoem
	 *            String
	 * @param mousu
	 *            String
	 * @param moclave
	 *            String
	 * @param mofecbaja
	 *            Date
	 * @param moadmin
	 *            String
	 * @param moprimera
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "mocodigo", required = false) String mocodigo,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			@RequestParam(value = "monombre", required = false) String monombre,
			@RequestParam(value = "mocoem", required = false) String mocoem,
			@RequestParam(value = "mousu", required = false) String mousu,
			@RequestParam(value = "moclave", required = false) String moclave,
			@RequestParam(value = "mofecbaja", required = false) Date mofecbaja,
			@RequestParam(value = "moadmin", required = false) String moadmin,
			@RequestParam(value = "moprimera", required = false) String moprimera,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(mocodigo,
					monombre, mocoem, mousu, moclave, mofecbaja, moadmin,
					moprimera, new Organismo(organismoCodOrg, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<CensoMonitor> censoMonitors = this.censoMonitorService
						.findAll(filterCensoMonitor, pagination);

				if (censoMonitors == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterCensoMonitor, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(censoMonitors);
				return data;
			} else {
				List<CensoMonitor> censoMonitors = this.censoMonitorService
						.findAll(filterCensoMonitor, pagination);
				if (censoMonitors == null) {
					throw new Exception("No data Found.");
				}
				return censoMonitors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilter'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param organismoCodOrg
	 *            String
	 * @param monombre
	 *            String
	 * @param mocoem
	 *            String
	 * @param mousu
	 *            String
	 * @param moclave
	 *            String
	 * @param mofecbaja
	 *            Date
	 * @param moadmin
	 *            String
	 * @param moprimera
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filter", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllFilter(
			@RequestParam(value = "mocodigo", required = false) String mocodigo,
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			@RequestParam(value = "monombre", required = false) String monombre,
			@RequestParam(value = "mocoem", required = false) String mocoem,
			@RequestParam(value = "mousu", required = false) String mousu,
			@RequestParam(value = "moclave", required = false) String moclave,
			@RequestParam(value = "mofecbaja", required = false) Date mofecbaja,
			@RequestParam(value = "moadmin", required = false) String moadmin,
			@RequestParam(value = "moprimera", required = false) String moprimera,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(mocodigo,
					monombre, mocoem, mousu, moclave, mofecbaja, moadmin,
					moprimera, new Organismo(organismoCodOrg, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<CensoMonitor> censoMonitors = this.censoMonitorService
						.findAllLikeFilter(filterCensoMonitor, pagination,
								false);

				if (censoMonitors == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCountFilter(filterCensoMonitor, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(censoMonitors);
				return data;
			} else {
				List<CensoMonitor> censoMonitors = this.censoMonitorService
						.findAllLikeFilter(filterCensoMonitor, pagination,
								false);
				if (censoMonitors == null) {
					throw new Exception("No data Found.");
				}
				return censoMonitors;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllFilterAltas'.
	 * 
	 * @param organismoCodOrg
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "/filterAltas", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllFilterAltas(
			@RequestParam(value = "organismoCodOrg", required = false) String organismoCodOrg,
			HttpServletRequest request) {
		try {
			CensoMonitor filterCensoMonitor = new CensoMonitor(null, null,
					null, null, null, null, null, null, new Organismo(
							organismoCodOrg, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null));

			List<CensoMonitor> censoMonitors = this.censoMonitorService
					.findAllCensoMonitorAlta(filterCensoMonitor);
			if (censoMonitors == null) {
				throw new Exception("No data Found.");
			}
			return censoMonitors;

		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCountFilter'.
	 * 
	 * @param filterCensoMonitor
	 *            CensoMonitor
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCountFilter(
			@RequestParam(value = "censoMonitor", required = false) CensoMonitor filterCensoMonitor,
			HttpServletRequest request) {
		try {
			return censoMonitorService.findAllLikeCountFilter(
					filterCensoMonitor != null ? filterCensoMonitor
							: new CensoMonitor(), false);
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterCensoMonitor
	 *            CensoMonitor
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "censoMonitor", required = false) CensoMonitor filterCensoMonitor,
			HttpServletRequest request) {
		try {
			return censoMonitorService
					.findAllCount(filterCensoMonitor != null ? filterCensoMonitor
							: new CensoMonitor());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @param response
	 *            HttpServletResponse
	 * @return CensoMonitor
	 */

	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	CensoMonitor edit(
			@RequestParam(value = "codOrg", required = true) String codOrg,
			@RequestBody CensoMonitor censoMonitor, HttpServletResponse response) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);

			if (censoMonitor.getMoadmin() == null) {
				censoMonitor.setMoadmin(Y41aConstantes.VALOR_NO);
			}

			censoMonitor.setOrganismo(organismo);

			CensoMonitor censoMonitorAux = this.censoMonitorService
					.update(censoMonitor);
			logger.info("Entity correctly inserted!");
			return censoMonitorAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	// @RequestMapping(method = RequestMethod.PUT)
	// public @ResponseBody
	// CensoMonitor edit(@RequestBody CensoMonitor censoMonitor,
	// HttpServletResponse response) {
	// try {
	// CensoMonitor censoMonitorAux = this.censoMonitorService
	// .update(censoMonitor);
	// logger.info("Entity correctly inserted!");
	// return censoMonitorAux;
	// } catch (Exception e) {
	// throw new MethodFailureException("Method failed");
	// }
	// }

	/**
	 * Method 'add'.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	/*
	 * @RequestMapping(method = RequestMethod.POST) public @ResponseBody
	 * CensoMonitor add(@RequestBody CensoMonitor censoMonitor) { try {
	 * CensoMonitor censoMonitorAux = this.censoMonitorService
	 * .add(censoMonitor); logger.info("Entity correctly inserted!"); return
	 * censoMonitorAux; } catch (Exception e) { throw new
	 * MethodFailureException("Method failed"); } }
	 */

	/**
	 * Method 'add'.
	 * 
	 * @param censoMonitor
	 *            CensoMonitor
	 * @return CensoMonitor
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	CensoMonitor addMonitor(
			@RequestParam(value = "codOrg", required = true) String codOrg,
			@RequestBody CensoMonitor censoMonitor) {
		try {
			Organismo organismo = new Organismo();
			organismo.setCodOrg(codOrg);

			if (censoMonitor.getMoadmin() == null) {
				censoMonitor.setMoadmin(Y41aConstantes.VALOR_NO);
			}

			censoMonitor.setOrganismo(organismo);

			CensoMonitor censoMonitorAux = this.censoMonitorService
					.add(censoMonitor);
			logger.info("Entity correctly inserted!");
			return censoMonitorAux;
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param mocodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @param request
	 *            HttpServletRequest
	 * @return
	 */
	@RequestMapping(value = "/{mocodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String mocodigo,
			HttpServletResponse response, HttpServletRequest request) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			CensoMonitor censoMonitorConectado = (CensoMonitor) request
					.getSession().getAttribute(
							Y41aConstantes.SESSIONCENSOMONITORCONNECTED);

			String moCodigoConectado = censoMonitorConectado.getMocodigo();
			if (mocodigo.equals(moCodigoConectado)) {
				throw new Y41aUDAException(
						"error.censomonitor.NoDeleteCensoMonitorConnected",
						true, new Exception());
			}

			CensoMonitor censoMonitor = new CensoMonitor();
			censoMonitor.setMocodigo(mocodigo);
			this.censoMonitorService.remove(censoMonitor);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Y41aUDAException e) {
			throw e;
		} catch (Exception e) {
			logger.error("Unable to delete " + mocodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param censoMonitorIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> censoMonitorIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<CensoMonitor> censoMonitorList = new ArrayList<CensoMonitor>();
		try {
			for (ArrayList<String> censoMonitorId : censoMonitorIds) {
				Iterator<String> iterator = censoMonitorId.iterator();
				CensoMonitor censoMonitor = new CensoMonitor();
				censoMonitor.setMocodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				censoMonitorList.add(censoMonitor);
			}
			this.censoMonitorService.removeMultiple(censoMonitorList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getCensoMonitorService'.
	 * 
	 * @return CensoMonitorService
	 */
	protected CensoMonitorService getCensoMonitorService() {
		return this.censoMonitorService;
	}

	/**
	 * Method 'setCensoMonitorService'.
	 * 
	 * @param censoMonitorService
	 *            CensoMonitorService
	 * @return
	 */
	public void setCensoMonitorService(CensoMonitorService censoMonitorService) {
		this.censoMonitorService = censoMonitorService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
