package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Alerta;
import com.ejie.y41a.model.TipAlerta;
import com.ejie.y41a.service.CaracterAlertaService;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.CaracterAlerta;

/**
 *  * CaracterAlertaController generated by UDA, 22-mar-2012 16:48:20.
 *  
 */
 
@Controller
@RequestMapping (value = "/caracteralerta")

public class CaracterAlertaController  {

	private static final Logger logger = LoggerFactory.getLogger(CaracterAlertaController.class);

	@Autowired
	private CaracterAlertaService caracterAlertaService;
	
	@Autowired
	private Properties appConfiguration;
	/**
	 * Method 'getCreateForm'.
	 *
	 * @param model Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("caracteralerta", "model", model);
	}

	/**
	 * Method 'getById'.
	 * @param  crcodigo String
	 * @return String
	 */
	@RequestMapping(value = "/{crcodigo}", method = RequestMethod.GET)
	public @ResponseBody CaracterAlerta getById(@PathVariable String crcodigo) {
		try{
            CaracterAlerta caracterAlerta = new CaracterAlerta();
			caracterAlerta.setCrcodigo(crcodigo);
            caracterAlerta = this.caracterAlertaService.find(caracterAlerta);
            if (caracterAlerta == null) {
                throw new Exception(crcodigo.toString());
            }
            return caracterAlerta;
		}catch (Exception e){
		    throw new ResourceNotFoundException(crcodigo.toString());
		}
	}


	/**
	 * Method 'getAll'.
	 *@param	  crcodigo String
	 *@param	  alertaAlcodigo String
	 *@param	  tipAlertaTcacodigo String
	 *@param	  crcoor String
	 *@param	  crferere Date
	 *@param	  crteinfo String
	 *@param	  crcnactu Integer
	 *@param	  crinprse String
	 * @param request HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody Object getAll(
	@RequestParam(value = "crcodigo", required = false) String crcodigo,
	@RequestParam(value = "alertaAlcodigo", required = false) String alertaAlcodigo,
	@RequestParam(value = "tipAlertaTcacodigo", required = false) String tipAlertaTcacodigo,
	@RequestParam(value = "crcoor", required = false) String crcoor,
	@RequestParam(value = "crferere", required = false) Date crferere,
	@RequestParam(value = "crteinfo", required = false) String crteinfo,
	@RequestParam(value = "crcnactu", required = false) Integer crcnactu,
	@RequestParam(value = "crinprse", required = false) String crinprse,
			HttpServletRequest request) {
			try{
				CaracterAlerta filterCaracterAlerta = new CaracterAlerta(crcodigo, crcoor, crferere, crteinfo, crcnactu, crinprse, new Alerta(alertaAlcodigo, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null), new TipAlerta(tipAlertaTcacodigo, null, null));
                Pagination pagination = null;
			    if (request.getHeader("JQGridModel") != null &&  request.getHeader("JQGridModel").equals("true")) {
				    pagination = new Pagination();
				    pagination.setPage(Long.valueOf(request.getParameter("page")));
				    pagination.setRows(Long.valueOf(request.getParameter("rows")));
				    pagination.setSort(request.getParameter("sidx"));
				    pagination.setAscDsc(request.getParameter("sord"));
                    List<CaracterAlerta> caracterAlertas =  this.caracterAlertaService.findAll(filterCaracterAlerta, pagination);

     			    if (caracterAlertas == null) {
	    	            throw new Exception("No data Found.");
		            }
					
			        Long total =  getAllCount(filterCaracterAlerta, request);
				    JQGridJSONModel data = new JQGridJSONModel();
				    data.setPage(request.getParameter("page"));
				    data.setRecords(total.intValue());
				    data.setTotal(total, pagination.getRows());
				    data.setRows(caracterAlertas);
				    return data;
				}else{
				    List<CaracterAlerta> caracterAlertas =  this.caracterAlertaService.findAll(filterCaracterAlerta, pagination);
					if (caracterAlertas == null) {
	    	            throw new Exception("No data Found.");
		            }
				    return caracterAlertas;
				}
            }catch(Exception e){
			    throw new ResourceNotFoundException("No data Found.");
			}
	}

	/**
	 * Method 'getAllCount'.
	 * @param filterCaracterAlerta CaracterAlerta 
	 * @param request  HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody Long getAllCount(
	@RequestParam(value = "caracterAlerta", required = false) CaracterAlerta  filterCaracterAlerta, HttpServletRequest request) {
	    try {
			return caracterAlertaService
					.findAllCount(filterCaracterAlerta != null ? filterCaracterAlerta
							: new CaracterAlerta ());
		} catch (Exception e) {
			throw new ServiceUnavailableException("Count Service is not responding.");
		}
	}
	
	/**
	 * Method 'edit'.
	 * @param caracterAlerta CaracterAlerta 
	 * @param response HttpServletResponse
	 * @return CaracterAlerta
	 */
	@RequestMapping(method = RequestMethod.PUT)
    public @ResponseBody CaracterAlerta edit(@RequestBody CaracterAlerta caracterAlerta, HttpServletResponse response) {		
		try {
            CaracterAlerta caracterAlertaAux  = this.caracterAlertaService.update(caracterAlerta);
			logger.info("Entity correctly inserted!");
            return caracterAlertaAux;
        } catch(Exception e) {
            throw new MethodFailureException("Method failed");
        }
    }

	/**
	 * Method 'add'.
	 * @param caracterAlerta CaracterAlerta 
	 * @return CaracterAlerta
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody CaracterAlerta add(@RequestBody CaracterAlerta caracterAlerta) {		
        try {
            CaracterAlerta caracterAlertaAux = this.caracterAlertaService.add(caracterAlerta);
            logger.info("Entity correctly inserted!");
        	return caracterAlertaAux;
		} catch(Exception e) {
        	throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * @param  crcodigo  String
	 * @param response  HttpServletResponse
	 * @return 
	 */
	@RequestMapping(value = "/{crcodigo}", method = RequestMethod.DELETE)
    public void remove(
				@PathVariable String crcodigo,
					HttpServletResponse  response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
    	try{
            CaracterAlerta caracterAlerta = new CaracterAlerta();
            caracterAlerta.setCrcodigo(crcodigo);
            this.caracterAlertaService.remove(caracterAlerta);
            response.setStatus(HttpServletResponse.SC_OK);
    	} catch(Exception e) {
    		logger.error("Unable to delete " +  crcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
    		throw new MethodFailureException("Method failed");
    	}
    }
	
	/**
	 * Method 'removeAll'.
	 * @param  caracterAlertaIds  ArrayList
	 * @param response  HttpServletResponse
	 * @return
	 */	
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(@RequestBody ArrayList<ArrayList<String>> caracterAlertaIds,
			HttpServletResponse response) {
        response.setContentType("text/javascript;charset=utf-8");
        response.setHeader("Pragma", "cache");
        response.setHeader("Expires", "0");
        response.setHeader("Cache-Control", "private");
        ArrayList<CaracterAlerta> caracterAlertaList = new ArrayList<CaracterAlerta>();
        try{		    
            for (ArrayList<String> caracterAlertaId:caracterAlertaIds) {
			    Iterator<String> iterator = caracterAlertaId.iterator();
				    CaracterAlerta caracterAlerta = new CaracterAlerta();
			        caracterAlerta.setCrcodigo(ObjectConversionManager.convert(iterator.next(), String.class));
				    caracterAlertaList.add(caracterAlerta);
		    }
            this.caracterAlertaService.removeMultiple(caracterAlertaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch(Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}	

	/**
	 * Method 'handle'.
	 * @param e ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getCaracterAlertaService'.
	 *
	 * @return CaracterAlertaService
	 */
	protected CaracterAlertaService getCaracterAlertaService() {
		return this.caracterAlertaService;
	}

	/**
	 * Method 'setCaracterAlertaService'.
	 *
	 * @param caracterAlertaService  CaracterAlertaService
	 * @return
	 */
	public void setCaracterAlertaService(CaracterAlertaService caracterAlertaService) {
		this.caracterAlertaService = caracterAlertaService;
	}
	
	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration 
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}	
	
