package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.model.Campanha;
import com.ejie.y41a.model.CampanhaProdBusqueda;
import com.ejie.y41a.model.Producto;
import com.ejie.y41a.service.CampanhaProdService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.CampanhaProd;

/**
 * * CampanhaProdController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/campanhaprod")
public class CampanhaProdController {

	private static final Logger logger = LoggerFactory
			.getLogger(CampanhaProdController.class);

	@Autowired
	private CampanhaProdService campanhaProdService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("campanhaprod", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cpcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{cpcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	CampanhaProd getById(@PathVariable String cpcodigo) {
		try {
			CampanhaProd campanhaProd = new CampanhaProd();
			campanhaProd.setCpcodigo(cpcodigo);
			campanhaProd = this.campanhaProdService.find(campanhaProd);
			if (campanhaProd == null) {
				throw new Exception(cpcodigo.toString());
			}
			return campanhaProd;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cpcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param cpcodigo
	 *            String
	 * @param productoPscodigo
	 *            String
	 * @param campanhaCmcodigo
	 *            String
	 * @param cpnops
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "cpcodigo", required = false) String cpcodigo,
			@RequestParam(value = "productoPscodigo", required = false) String productoPscodigo,
			@RequestParam(value = "campanhaCmcodigo", required = false) String campanhaCmcodigo,
			@RequestParam(value = "cpnops", required = false) String cpnops,
			HttpServletRequest request) {
		try {
			CampanhaProd filterCampanhaProd = new CampanhaProd(cpcodigo,
					cpnops, new Producto(productoPscodigo, null, null, null,
							null, null, null, null, null, null, null, null,
							null, null, null, null, null, null, null, null,
							null), new Campanha(campanhaCmcodigo, null, null,
							null, null, null, null, null, null));
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<CampanhaProd> campanhaProds = this.campanhaProdService
						.findAll(filterCampanhaProd, pagination);

				if (campanhaProds == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterCampanhaProd, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(campanhaProds);
				return data;
			} else {
				List<CampanhaProd> campanhaProds = this.campanhaProdService
						.findAll(filterCampanhaProd, pagination);
				if (campanhaProds == null) {
					throw new Exception("No data Found.");
				}
				return campanhaProds;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param cmcodigo
	 *            String
	 * 
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(value = "busquedaProducto", method = RequestMethod.GET)
	public @ResponseBody
	Object getAllProducto(
			@RequestParam(value = "cmcodigo", required = false) String cmcodigo,
			HttpServletRequest request) {
		try {
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(cmcodigo);
			CampanhaProd filterCampanhaProd = new CampanhaProd();
			filterCampanhaProd.setCampanha(campanha);
			Pagination pagination = null;

			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {

				List<CampanhaProdBusqueda> campanhaProdsBusqueda = this.campanhaProdService
						.findAllCampanhaProd(filterCampanhaProd, pagination);

				if (campanhaProdsBusqueda == null) {
					throw new Exception("No data Found.");
				}

				JQGridJSONModel data = new JQGridJSONModel();

				data.setRows(campanhaProdsBusqueda);
				return data;
			} else {
				List<CampanhaProdBusqueda> campanhaProdsBusqueda = this.campanhaProdService
						.findAllCampanhaProd(filterCampanhaProd, pagination);
				if (campanhaProdsBusqueda == null) {
					throw new Exception("No data Found.");
				}
				return campanhaProdsBusqueda;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterCampanhaProd
	 *            CampanhaProd
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "campanhaProd", required = false) CampanhaProd filterCampanhaProd,
			HttpServletRequest request) {
		try {
			return campanhaProdService
					.findAllCount(filterCampanhaProd != null ? filterCampanhaProd
							: new CampanhaProd());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @param response
	 *            HttpServletResponse
	 * @return CampanhaProd
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	CampanhaProd edit(@RequestBody CampanhaProd campanhaProd,
			HttpServletResponse response) {
		try {
			CampanhaProd campanhaProdAux = this.campanhaProdService
					.update(campanhaProd);
			logger.info("Entity correctly inserted!");
			return campanhaProdAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param campanhaProd
	 *            CampanhaProd
	 * @return CampanhaProd
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	CampanhaProd add(@RequestBody CampanhaProd campanhaProd) {
		try {
			CampanhaProd campanhaProdAux = this.campanhaProdService
					.add(campanhaProd);
			logger.info("Entity correctly inserted!");
			return campanhaProdAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param cpcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{cpcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String cpcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			CampanhaProd campanhaProd = new CampanhaProd();
			campanhaProd.setCpcodigo(cpcodigo);
			this.campanhaProdService.remove(campanhaProd);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + cpcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param campanhaProdIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> campanhaProdIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<CampanhaProd> campanhaProdList = new ArrayList<CampanhaProd>();
		try {
			for (ArrayList<String> campanhaProdId : campanhaProdIds) {
				Iterator<String> iterator = campanhaProdId.iterator();
				CampanhaProd campanhaProd = new CampanhaProd();
				campanhaProd.setCpcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				campanhaProdList.add(campanhaProd);
			}
			this.campanhaProdService.removeMultiple(campanhaProdList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getCampanhaProdService'.
	 * 
	 * @return CampanhaProdService
	 */
	protected CampanhaProdService getCampanhaProdService() {
		return this.campanhaProdService;
	}

	/**
	 * Method 'setCampanhaProdService'.
	 * 
	 * @param campanhaProdService
	 *            CampanhaProdService
	 * @return
	 */
	public void setCampanhaProdService(CampanhaProdService campanhaProdService) {
		this.campanhaProdService = campanhaProdService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
