package com.ejie.y41a.control;

import com.ejie.x38.control.exception.ControlException;
import com.ejie.x38.control.exception.MethodFailureException;
import com.ejie.x38.control.exception.ResourceNotFoundException;
import com.ejie.x38.control.exception.ServiceUnavailableException;
import com.ejie.x38.dto.JQGridJSONModel;
import com.ejie.x38.dto.Pagination;
import com.ejie.x38.util.ObjectConversionManager;
import com.ejie.y41a.service.CampanhaService;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.ejie.y41a.model.Campanha;

/**
 * * CampanhaController generated by UDA, 22-mar-2012 16:48:20.
 * 
 *  
 */

@Controller
@RequestMapping(value = "/campanha")
public class CampanhaController {

	private static final Logger logger = LoggerFactory
			.getLogger(CampanhaController.class);

	@Autowired
	private CampanhaService campanhaService;

	@Autowired
	private Properties appConfiguration;

	/**
	 * Method 'getCreateForm'.
	 * 
	 * @param model
	 *            Model
	 * @return String
	 */
	@RequestMapping(value = "maint", method = RequestMethod.GET)
	public ModelAndView getCreateForm(Model model) {
		model.addAttribute("defaultLanguage",
				appConfiguration.get("y41aVistaWar.default.language"));
		model.addAttribute("defaultLayout",
				appConfiguration.get("y41aVistaWar.default.layout"));
		return new ModelAndView("campanha", "model", model);
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/{cmcodigo}", method = RequestMethod.GET)
	public @ResponseBody
	Campanha getById(@PathVariable String cmcodigo) {
		try {
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(cmcodigo);
			campanha = this.campanhaService.find(campanha);
			if (campanha == null) {
				throw new Exception(cmcodigo.toString());
			}
			return campanha;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cmcodigo.toString());
		}
	}

	/**
	 * Method 'getById'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @return String
	 */
	@RequestMapping(value = "/buscarcampania", method = RequestMethod.GET)
	public @ResponseBody
	Campanha getByIdCamapania(
			@RequestParam(value = "cmcodigo", required = true) String cmcodigo) {
		try {
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(cmcodigo);
			campanha = this.campanhaService.find(campanha);
			if (campanha == null) {
				throw new Exception(cmcodigo.toString());
			}
			return campanha;
		} catch (Exception e) {
			throw new ResourceNotFoundException(cmcodigo.toString());
		}
	}

	/**
	 * Method 'getAll'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @param cmnombre
	 *            String
	 * @param cmcops
	 *            String
	 * @param cmnoar
	 *            String
	 * @param cmnops
	 *            String
	 * @param cmcotmo
	 *            String
	 * @param request
	 *            HttpServletRequest
	 * @return String
	 */
	@RequestMapping(method = RequestMethod.GET)
	public @ResponseBody
	Object getAll(
			@RequestParam(value = "cmcodigo", required = false) String cmcodigo,
			@RequestParam(value = "cmnombre", required = false) String cmnombre,
			@RequestParam(value = "cmcops", required = false) String cmcops,
			@RequestParam(value = "cmnoar", required = false) String cmnoar,
			@RequestParam(value = "cmnops", required = false) String cmnops,
			@RequestParam(value = "cmcotmo", required = false) String cmcotmo,
			HttpServletRequest request) {
		try {
			Campanha filterCampanha = new Campanha(cmcodigo, cmnombre, cmcops,
					cmnoar, cmnops, cmcotmo);
			Pagination pagination = null;
			if (request.getHeader("JQGridModel") != null
					&& request.getHeader("JQGridModel").equals("true")) {
				pagination = new Pagination();
				pagination.setPage(Long.valueOf(request.getParameter("page")));
				pagination.setRows(Long.valueOf(request.getParameter("rows")));
				pagination.setSort(request.getParameter("sidx"));
				pagination.setAscDsc(request.getParameter("sord"));
				List<Campanha> campanhas = this.campanhaService.findAll(
						filterCampanha, pagination);

				if (campanhas == null) {
					throw new Exception("No data Found.");
				}

				Long total = getAllCount(filterCampanha, request);
				JQGridJSONModel data = new JQGridJSONModel();
				data.setPage(request.getParameter("page"));
				data.setRecords(total.intValue());
				data.setTotal(total, pagination.getRows());
				data.setRows(campanhas);
				return data;
			} else {
				List<Campanha> campanhas = this.campanhaService.findAll(
						filterCampanha, pagination);
				if (campanhas == null) {
					throw new Exception("No data Found.");
				}
				return campanhas;
			}
		} catch (Exception e) {
			throw new ResourceNotFoundException("No data Found.");
		}
	}

	/**
	 * Method 'getAllCount'.
	 * 
	 * @param filterCampanha
	 *            Campanha
	 * @param request
	 *            HttpServletRequest
	 * @return Long
	 */
	@RequestMapping(value = "/count", method = RequestMethod.GET)
	public @ResponseBody
	Long getAllCount(
			@RequestParam(value = "campanha", required = false) Campanha filterCampanha,
			HttpServletRequest request) {
		try {
			return campanhaService
					.findAllCount(filterCampanha != null ? filterCampanha
							: new Campanha());
		} catch (Exception e) {
			throw new ServiceUnavailableException(
					"Count Service is not responding.");
		}
	}

	/**
	 * Method 'edit'.
	 * 
	 * @param campanha
	 *            Campanha
	 * @param response
	 *            HttpServletResponse
	 * @return Campanha
	 */
	@RequestMapping(method = RequestMethod.PUT)
	public @ResponseBody
	Campanha edit(@RequestBody Campanha campanha, HttpServletResponse response) {
		try {
			Campanha campanhaAux = this.campanhaService.update(campanha);
			logger.info("Entity correctly inserted!");
			return campanhaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'add'.
	 * 
	 * @param campanha
	 *            Campanha
	 * @return Campanha
	 */
	@RequestMapping(method = RequestMethod.POST)
	public @ResponseBody
	Campanha add(@RequestBody Campanha campanha) {
		try {
			Campanha campanhaAux = this.campanhaService.add(campanha);
			logger.info("Entity correctly inserted!");
			return campanhaAux;
		} catch (Exception e) {
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'remove'.
	 * 
	 * @param cmcodigo
	 *            String
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/{cmcodigo}", method = RequestMethod.DELETE)
	public void remove(@PathVariable String cmcodigo,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		try {
			Campanha campanha = new Campanha();
			campanha.setCmcodigo(cmcodigo);
			this.campanhaService.remove(campanha);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			logger.error("Unable to delete " + cmcodigo);
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'removeAll'.
	 * 
	 * @param campanhaIds
	 *            ArrayList
	 * @param response
	 *            HttpServletResponse
	 * @return
	 */
	@RequestMapping(value = "/deleteAll", method = RequestMethod.POST)
	public void removeMultiple(
			@RequestBody ArrayList<ArrayList<String>> campanhaIds,
			HttpServletResponse response) {
		response.setContentType("text/javascript;charset=utf-8");
		response.setHeader("Pragma", "cache");
		response.setHeader("Expires", "0");
		response.setHeader("Cache-Control", "private");
		ArrayList<Campanha> campanhaList = new ArrayList<Campanha>();
		try {
			for (ArrayList<String> campanhaId : campanhaIds) {
				Iterator<String> iterator = campanhaId.iterator();
				Campanha campanha = new Campanha();
				campanha.setCmcodigo(ObjectConversionManager.convert(
						iterator.next(), String.class));
				campanhaList.add(campanha);
			}
			this.campanhaService.removeMultiple(campanhaList);
			response.setStatus(HttpServletResponse.SC_OK);
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_BAD_REQUEST);
			throw new MethodFailureException("Method failed");
		}
	}

	/**
	 * Method 'handle'.
	 * 
	 * @param e
	 *            ControlException
	 * @return String
	 */
	@ExceptionHandler
	public @ResponseBody
	String handle(ControlException e) {
		logger.warn(e.getMessage());
		return e.getMessage();
	}

	/**
	 * Method 'getCampanhaService'.
	 * 
	 * @return CampanhaService
	 */
	protected CampanhaService getCampanhaService() {
		return this.campanhaService;
	}

	/**
	 * Method 'setCampanhaService'.
	 * 
	 * @param campanhaService
	 *            CampanhaService
	 * @return
	 */
	public void setCampanhaService(CampanhaService campanhaService) {
		this.campanhaService = campanhaService;
	}

	/**
	 * Method 'getAppConfiguration'.
	 * 
	 * @return appConfiguration
	 */
	public Properties getAppConfiguration() {
		return appConfiguration;
	}

	/**
	 * Method 'setAppConfiguration'.
	 * 
	 * @param appConfiguration
	 *            Properties
	 * @return
	 */
	public void setAppConfiguration(Properties appConfiguration) {
		this.appConfiguration = appConfiguration;
	}
}
